/*
 * Decompiled with CFR 0.152.
 */
package com.chinamcloud.bigdata.haiheservice.interceptor;

import com.alibaba.fastjson.JSON;
import com.chinamcloud.bigdata.haiheservice.CodeResult;
import com.chinamcloud.bigdata.haiheservice.UserManager;
import com.chinamcloud.bigdata.haiheservice.bean.User;
import com.chinamcloud.bigdata.haiheservice.es.EsConfig;
import com.chinamcloud.bigdata.tenant.bean.ResultDataMedia;
import com.chinamcloud.bigdata.tenant.config.ConfigBean;
import com.chinamcloud.bigdata.tenant.config.Tenant;
import java.io.InputStreamReader;
import java.util.HashMap;
import java.util.Properties;
import javax.servlet.http.Cookie;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.commons.lang3.StringUtils;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.servlet.HandlerInterceptor;
import org.springframework.web.servlet.ModelAndView;

public class LoginInterceptor
implements HandlerInterceptor {
    private static Logger logger = LogManager.getLogger(LoginInterceptor.class);
    private static final String CONF_PATH = "config/Tenant.properties";
    @Autowired
    private UserManager userManager;

    public boolean preHandle(HttpServletRequest request, HttpServletResponse response, Object handler) throws Exception {
        User user;
        String token = request.getParameter("access_token");
        logger.info("token=" + token);
        if (StringUtils.isEmpty((CharSequence)token)) {
            HashMap<String, String> stringStringHashMap1 = new HashMap<String, String>();
            HashMap<String, String> stringStringHashMap2 = new HashMap<String, String>();
            Cookie[] cookies = request.getCookies();
            String id = "";
            String tId = "";
            for (Cookie cookie : cookies) {
                if ("login_chinamcloud_id".equals(cookie.getName())) {
                    id = cookie.getValue();
                }
                if (!"login_chinamcloud_tid".equals(cookie.getName())) continue;
                tId = cookie.getValue();
            }
            stringStringHashMap2.put("login_id", id);
            stringStringHashMap2.put("login_tid", tId);
            stringStringHashMap2.put("auth_key", "");
            stringStringHashMap1.put("SignatureVersion", "1.0");
            stringStringHashMap1.put("Format", "JSON");
            ResultDataMedia resultDataMedia = Tenant.getGroupId(stringStringHashMap1, stringStringHashMap2);
            if (null == resultDataMedia) {
                response.getWriter().write("login_time_out");
                return false;
            }
            token = resultDataMedia.getData().getUser_token();
            String contentType = request.getContentType();
            if (StringUtils.isEmpty((CharSequence)token) || contentType.indexOf("application/json") < 0) {
                response.getWriter().write("params_error");
                return false;
            }
        }
        if ((user = this.userManager.gerUserInfo(token)) == null) {
            response.setContentType("application/json");
            response.getWriter().write(JSON.toJSONString((Object)CodeResult.failedResultByMsgSource("token_error")));
            return false;
        }
        request.setAttribute("user", (Object)user);
        return true;
    }

    public void postHandle(HttpServletRequest request, HttpServletResponse response, Object handler, ModelAndView modelAndView) throws Exception {
    }

    public void afterCompletion(HttpServletRequest request, HttpServletResponse response, Object handler, Exception ex) throws Exception {
    }

    static {
        Properties properties = new Properties();
        try {
            properties.load(new InputStreamReader(EsConfig.class.getClassLoader().getResourceAsStream(CONF_PATH), "UTF-8"));
        }
        catch (Exception e) {
            logger.error("\u52a0\u8f7d\u914d\u7f6e\u6587\u4ef6\u5931\u8d25!", (Throwable)e);
            System.exit(0);
        }
        ConfigBean.ACCESSKEYID = properties.getProperty("ACCESSKEYID");
        ConfigBean.ACCESSKEYSECRET = properties.getProperty("ACCESSKEYSECRET");
        ConfigBean.SERVICEKEY = properties.getProperty("SERVICEKEY");
        ConfigBean.URL = properties.getProperty("URL");
    }
}

