/*
 * Decompiled with CFR 0.152.
 */
package com.chinamcloud.bigdata.haiheservice.parser;

import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONObject;
import com.chinamcloud.bigdata.haiheservice.AliMappingConfig;
import com.chinamcloud.bigdata.haiheservice.bean.HotEvent;
import com.chinamcloud.bigdata.haiheservice.util.JSONUtils;
import com.chinamcloud.bigdata.haiheservice.xz.PageParser;
import com.taobao.kelude.aps.feedback.model.ApsFeedback;
import com.taobao.kelude.aps.feedback.model.SearchResult;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import org.apache.commons.lang3.StringUtils;

public class HotEventDataParser
extends PageParser<HotEvent, SearchResult> {
    private SimpleDateFormat dateFormat2 = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss", Locale.ENGLISH);

    @Override
    protected List<HotEvent> parseRecords(SearchResult result) {
        ArrayList<HotEvent> events = new ArrayList<HotEvent>();
        for (ApsFeedback feedback : result.getRecords()) {
            HotEvent event = new HotEvent();
            event.setId(String.valueOf(feedback.getClusterId()));
            event.setDocId(feedback.getUrlMD5());
            event.setCity(feedback.getCrawlerKeywords());
            event.setCountry(feedback.getCountry());
            event.setCount(feedback.getPointsCount());
            event.setEmotionScore(feedback.getEmotionScore());
            event.setPubTime(this.dateFormat2.format(feedback.getPubTime()));
            event.setProvince(AliMappingConfig.getInstance().findMonitorTopicNameById(feedback.getMonitorTopicId()));
            event.setEmotionTendency(feedback.getEmotionTendency());
            event.setTitle(feedback.getSubject());
            event.setCluster(feedback.getCluster());
            event.setDescription(feedback.getDescription());
            event.setPics(this.parsePics(feedback.getCfs()));
            events.add(event);
        }
        return events;
    }

    private List<String> parsePics(Map<String, String> cfsMap) {
        JSONArray jsonArray;
        String valueStr;
        ArrayList<String> picUrls = new ArrayList<String>();
        if (cfsMap != null && !StringUtils.isEmpty((CharSequence)(valueStr = cfsMap.get("101148"))) && (jsonArray = JSONUtils.parseJSONArray(valueStr)) != null) {
            int jsonArrayLength = jsonArray.size();
            for (int i = 0; i < jsonArrayLength; ++i) {
                JSONObject attachment = jsonArray.getJSONObject(i);
                String picUrl = attachment.getString("url");
                if (StringUtils.isEmpty((CharSequence)picUrl)) continue;
                picUrls.add(picUrl);
            }
        }
        return picUrls;
    }
}

