/*
 * Decompiled with CFR 0.152.
 */
package com.chinamcloud.bigdata.newsanalysis.common.utils;

import com.chinamcloud.bigdata.newsanalysis.common.pojo.PlanInfo;
import java.io.FileReader;
import java.io.IOException;
import java.net.URL;
import java.sql.Connection;
import java.sql.DriverManager;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.ArrayList;
import java.util.List;
import java.util.Properties;
import java.util.Random;

public class JDBCUtils {
    private static String url;
    private static String user;
    private static String password;
    private static String driver;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static boolean execute(String sql, Object ... param) {
        boolean result = true;
        Connection connection = null;
        PreparedStatement preparedStatement = null;
        try {
            connection = JDBCUtils.getConnection();
            connection.setAutoCommit(false);
            preparedStatement = connection.prepareStatement(sql);
            for (int i = 0; i < param.length; ++i) {
                preparedStatement.setObject(i, param[i]);
                preparedStatement.addBatch();
            }
            ResultSet resultSet = preparedStatement.executeQuery();
            connection.commit();
        }
        catch (SQLException e) {
            block8: {
                try {
                    e.printStackTrace();
                    if (connection == null) break block8;
                    try {
                        connection.rollback();
                    }
                    catch (SQLException ex) {
                        ex.printStackTrace();
                        boolean bl = result = false;
                        JDBCUtils.close(preparedStatement, connection);
                        return bl;
                    }
                }
                catch (Throwable throwable) {
                    JDBCUtils.close(preparedStatement, connection);
                    throw throwable;
                }
            }
            result = false;
            JDBCUtils.close(preparedStatement, connection);
        }
        JDBCUtils.close(preparedStatement, connection);
        return result;
    }

    public static Connection getConnection() throws SQLException {
        return DriverManager.getConnection(url, user, password);
    }

    public static void close(PreparedStatement preparedStatement, Connection connection) {
        if (preparedStatement != null) {
            try {
                preparedStatement.close();
            }
            catch (SQLException e) {
                e.printStackTrace();
            }
        }
        if (connection != null) {
            try {
                connection.close();
            }
            catch (SQLException e) {
                e.printStackTrace();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void main111(String[] args) {
        block8: {
            Connection conn = null;
            PreparedStatement pstmt1 = null;
            PreparedStatement pstmt2 = null;
            try {
                conn = JDBCUtils.getConnection();
                conn.setAutoCommit(false);
                String sql1 = "update account set balance = balance - ? where id = ?";
                String sql2 = "update account set balance = balance + ? where id = ?";
                pstmt1 = conn.prepareStatement(sql1);
                pstmt2 = conn.prepareStatement(sql2);
                pstmt1.setDouble(1, 500.0);
                pstmt1.setInt(2, 1);
                pstmt2.setDouble(1, 500.0);
                pstmt2.setInt(2, 2);
                pstmt1.executeUpdate();
                int i = 3 / 0;
                pstmt2.executeUpdate();
                conn.commit();
                JDBCUtils.close(pstmt1, conn);
            }
            catch (Exception e) {
                try {
                    if (conn != null) {
                        conn.rollback();
                    }
                }
                catch (SQLException e1) {
                    e1.printStackTrace();
                }
                e.printStackTrace();
                break block8;
            }
            finally {
                JDBCUtils.close(pstmt1, conn);
                JDBCUtils.close(pstmt2, null);
            }
            JDBCUtils.close(pstmt2, null);
        }
    }

    public static void main(String[] args) {
        Random r = new Random(1L);
        for (int i = 0; i < 5; ++i) {
            int ran1 = r.nextInt(100);
            System.out.println(ran1);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static List<PlanInfo> execute_plan(String sql) {
        PreparedStatement preparedStatement;
        Connection connection;
        ArrayList<PlanInfo> result;
        block7: {
            result = new ArrayList<PlanInfo>();
            connection = null;
            preparedStatement = null;
            try {
                connection = JDBCUtils.getConnection();
                preparedStatement = connection.prepareStatement(sql);
                ResultSet resultSet = preparedStatement.executeQuery();
                if (resultSet == null) break block7;
                while (resultSet.next()) {
                    String plan_id = resultSet.getString("plan_id");
                    String plan_name = resultSet.getString("plan_name");
                    String classify = resultSet.getString("classify");
                    String keywords = resultSet.getString("keywords");
                    String no_keywords = resultSet.getString("no_keywords");
                    result.add(new PlanInfo(new Long(plan_id), plan_name, classify, keywords, no_keywords));
                }
            }
            catch (SQLException e) {
                block8: {
                    try {
                        e.printStackTrace();
                        if (connection == null) break block8;
                        try {
                            connection.rollback();
                        }
                        catch (SQLException ex) {
                            ex.printStackTrace();
                        }
                    }
                    catch (Throwable throwable) {
                        JDBCUtils.close(preparedStatement, connection);
                        throw throwable;
                    }
                }
                JDBCUtils.close(preparedStatement, connection);
            }
        }
        JDBCUtils.close(preparedStatement, connection);
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static Boolean insert(String sql, Object ... param) {
        boolean result = true;
        Connection connection = null;
        PreparedStatement preparedStatement = null;
        try {
            connection = JDBCUtils.getConnection();
            connection.setAutoCommit(false);
            preparedStatement = connection.prepareStatement(sql);
            for (int i = 0; i < param.length; ++i) {
                preparedStatement.setObject(i, param[i]);
                preparedStatement.addBatch();
            }
            preparedStatement.executeBatch();
            connection.commit();
        }
        catch (SQLException e) {
            block8: {
                try {
                    e.printStackTrace();
                    if (connection == null) break block8;
                    try {
                        connection.rollback();
                    }
                    catch (SQLException ex) {
                        ex.printStackTrace();
                        result = false;
                        Boolean bl = result;
                        JDBCUtils.close(preparedStatement, connection);
                        return bl;
                    }
                }
                catch (Throwable throwable) {
                    JDBCUtils.close(preparedStatement, connection);
                    throw throwable;
                }
            }
            result = false;
            JDBCUtils.close(preparedStatement, connection);
        }
        JDBCUtils.close(preparedStatement, connection);
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static Boolean realCntInsert(String sql, Long planIdAndStartDtHour, int planId, int planCnt, int articleSourceInt, int articleEmotionTendency, String articleReprint, int planStartDtHour) {
        boolean result = true;
        Connection connection = null;
        PreparedStatement preparedStatement = null;
        try {
            connection = JDBCUtils.getConnection();
            connection.setAutoCommit(false);
            preparedStatement = connection.prepareStatement(sql);
            preparedStatement.setLong(1, planIdAndStartDtHour);
            preparedStatement.setInt(2, planId);
            preparedStatement.setInt(3, planCnt);
            preparedStatement.setInt(4, articleSourceInt);
            preparedStatement.setInt(5, articleEmotionTendency);
            preparedStatement.setString(6, articleReprint);
            preparedStatement.setInt(7, planStartDtHour);
            preparedStatement.addBatch();
            preparedStatement.executeBatch();
            connection.commit();
        }
        catch (SQLException e) {
            block7: {
                try {
                    e.printStackTrace();
                    if (connection == null) break block7;
                    try {
                        connection.rollback();
                    }
                    catch (SQLException ex) {
                        ex.printStackTrace();
                        result = false;
                        Boolean bl = result;
                        JDBCUtils.close(preparedStatement, connection);
                        return bl;
                    }
                }
                catch (Throwable throwable) {
                    JDBCUtils.close(preparedStatement, connection);
                    throw throwable;
                }
            }
            result = false;
            JDBCUtils.close(preparedStatement, connection);
        }
        JDBCUtils.close(preparedStatement, connection);
        return result;
    }

    public static void close(ResultSet rs, Statement stmt, Connection conn) {
        if (rs != null) {
            try {
                rs.close();
            }
            catch (SQLException e) {
                e.printStackTrace();
            }
        }
        if (stmt != null) {
            try {
                stmt.close();
            }
            catch (SQLException e) {
                e.printStackTrace();
            }
        }
        if (conn != null) {
            try {
                conn.close();
            }
            catch (SQLException e) {
                e.printStackTrace();
            }
        }
    }

    static {
        try {
            Properties pro = new Properties();
            ClassLoader classLoader = JDBCUtils.class.getClassLoader();
            URL res = classLoader.getResource("application.properties");
            String path = res.getPath();
            pro.load(new FileReader(path));
            url = pro.getProperty("spring.datasource.url");
            user = pro.getProperty("spring.datasource.username");
            password = pro.getProperty("spring.datasource.password");
            driver = "com.mysql.jdbc.Driver";
            Class.forName(driver);
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        catch (ClassNotFoundException e) {
            e.printStackTrace();
        }
    }
}

