/*
 * Decompiled with CFR 0.152.
 */
package com.chinamcloud.haihe.backStageManagement.controller;

import com.chinamcloud.haihe.backStageManagement.pojo.Site;
import com.chinamcloud.haihe.backStageManagement.service.UserSiteManageService;
import com.chinamcloud.haihe.common.CodeResult;
import com.chinamcloud.haihe.common.annotation.UserLoginToken;
import com.chinamcloud.haihe.common.controller.BaseController;
import java.util.List;
import java.util.Map;
import java.util.concurrent.atomic.AtomicReference;
import org.apache.commons.lang3.StringUtils;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"/user-site-manage"})
public class UserSiteManageController
extends BaseController {
    private static final Logger log = LogManager.getLogger(UserSiteManageController.class);
    @Autowired
    private UserSiteManageService userSiteManageService;

    @UserLoginToken
    @PostMapping(value={"/operatorSite/{actionType}"}, consumes={"application/json;charset=utf-8"})
    public Object operatorSite(@RequestBody Site site, @PathVariable String actionType) {
        String user_token = this.getUserToken();
        if (site.getType() == null || site.getSites() == null) {
            return CodeResult.failedResultByMsgSource("params_error");
        }
        if (this.decideSites(site.getSites(), site.getType(), actionType).booleanValue()) {
            return CodeResult.failedResultByMsgSource("params_error");
        }
        return this.userSiteManageService.operatorSite(site, user_token, actionType);
    }

    @UserLoginToken
    @PostMapping(value={"/getUserSubscription"}, consumes={"application/json;charset=utf-8"})
    public Object getUserSubscription(@RequestBody Map<String, Object> map) {
        String user_token = "";
        String name = "";
        List type = null;
        try {
            user_token = this.getUserToken();
            type = (List)map.get("type");
            if (type == null || type.isEmpty()) {
                log.error("\u6ca1\u6709\u4f20\u9012type\u6216\u8005\u662f\u83b7\u53d6type\u5931\u8d25\uff01");
                return CodeResult.failedResultByMsgSource("params_error");
            }
            name = (String)map.get("name");
        }
        catch (Exception e) {
            return CodeResult.failedResultByMsgSource("params_error");
        }
        return this.userSiteManageService.getUserSubscription(type, user_token, name);
    }

    @UserLoginToken
    @PostMapping(value={"/getUserSubscriptionSiteHeadNum"}, consumes={"application/json;charset=utf-8"})
    public Object getUserSubscriptionSiteHeadNum(@RequestBody Map<String, List<Integer>> map) {
        String user_token = this.getUserToken();
        List<Integer> type = map.get("type");
        if (type == null || type.isEmpty()) {
            log.error("\u6ca1\u6709\u4f20\u9012type\u6216\u8005\u662f\u83b7\u53d6type\u5931\u8d25\uff01");
            return CodeResult.failedResultByMsgSource("params_error");
        }
        return this.userSiteManageService.getUserSubscriptionSiteHeadNum(type, user_token);
    }

    public Boolean decideSites(List<Site> sites, Integer type, String actionType) {
        AtomicReference<Boolean> temp = new AtomicReference<Boolean>(false);
        sites.forEach(x -> {
            if (StringUtils.isBlank((CharSequence)x.getSiteName()) && "add".contains(actionType) || x.getType() == null || !x.getType().equals(type)) {
                log.error("\u7ad9\u70b9\u540d\u6216\u8005\u7ad9\u70b9\u7c7b\u578b\u9519\u8bef\uff01");
                temp.set(true);
            }
        });
        return temp.get();
    }
}

