/*
 * Decompiled with CFR 0.152.
 */
package com.chinamcloud.haihe.common;

import com.chinamcloud.haihe.common.i18n.MessageSource;
import com.fasterxml.jackson.annotation.JsonInclude;
import java.io.Serializable;

@JsonInclude(value=JsonInclude.Include.NON_NULL)
public class CodeResult<T>
implements Serializable {
    private static final long serialVersionUID = 3638843555945192311L;
    private int code;
    private String msg;
    private T result;

    public String getMsg() {
        return this.msg;
    }

    public void setMsg(String msg) {
        this.msg = msg;
    }

    public int getCode() {
        return this.code;
    }

    public T getResult() {
        return this.result;
    }

    public void setResult(T result) {
        this.result = result;
    }

    public CodeResult() {
    }

    public CodeResult(Code code, T result) {
        this.code = code.getCodeValue();
        this.result = result;
    }

    public CodeResult(Code code, T result, String msg) {
        this.code = code.getCodeValue();
        this.result = result;
        this.msg = msg;
    }

    public CodeResult(Code code, String msg) {
        this.code = code.getCodeValue();
        this.msg = msg;
    }

    public CodeResult(Code code) {
        this.code = code.getCodeValue();
    }

    public static CodeResult failedResult(String msg) {
        return new CodeResult(Code.Failed, msg);
    }

    public static CodeResult result(Code code, String msg) {
        return new CodeResult(code, MessageSource.getMsg(msg));
    }

    public static CodeResult failedResultByMsgSource(String source) {
        return CodeResult.failedResult(MessageSource.getMsg(source));
    }

    public static CodeResult failedResultByMsgSource(String source, String msg) {
        return CodeResult.failedResult(MessageSource.getMsg(source) + msg);
    }

    public static CodeResult successResult(String msg, Object result) {
        return new CodeResult<Object>(Code.Success, result, msg);
    }

    public static CodeResult successResult(String msg) {
        return new CodeResult(Code.Success, MessageSource.getMsg(msg));
    }

    public static CodeResult SUCCESSRESULT(String msg, Object result) {
        return new CodeResult<Object>(Code.SUCCESS, result, msg);
    }

    public static CodeResult SUCCESSRESULT(String msg) {
        return new CodeResult(Code.SUCCESS, MessageSource.getMsg(msg));
    }

    public static CodeResult successResultByMsgSource(String source, Object result) {
        return new CodeResult<Object>(Code.Success, null, MessageSource.getMsg(source));
    }

    public static CodeResult successResult() {
        return CodeResult.successResult(null, null);
    }

    public static enum Code {
        Success(0),
        Failed(1),
        Invalid(1000),
        SuccessWithWarnning(-1),
        LoginTimeOut(2),
        AnalysisRunning(-2),
        SUCCESS(200);

        private final int code;

        private Code(int code) {
            this.code = code;
        }

        public int getCodeValue() {
            return this.code;
        }
    }
}

