/*
 * Decompiled with CFR 0.152.
 */
package com.chinamcloud.haihe.common.cache;

import com.chinamcloud.haihe.common.cache.CacheObj;
import com.chinamcloud.haihe.common.cache.CleanTimeOutThread;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ConcurrentHashMapCacheUtils {
    private static final Logger LOGGER = LoggerFactory.getLogger(ConcurrentHashMapCacheUtils.class);
    private static final Integer CACHE_MAX_NUMBER = 1000;
    private static Integer CURRENT_SIZE = 0;
    static final Long ONE_MINUTE = 600000L;
    private static final Map<String, CacheObj> CACHE_OBJECT_MAP = new ConcurrentHashMap<String, CacheObj>();
    private static final List<String> CACHE_USE_LOG_LIST = new LinkedList<String>();
    private static volatile Boolean CLEAN_THREAD_IS_RUN = false;

    public static void setCache(String cacheKey, Object cacheValue, long cacheTime) {
        Long ttlTime = null;
        if (cacheTime <= 0L) {
            if (cacheTime == -1L) {
                ttlTime = -1L;
            } else {
                return;
            }
        }
        ConcurrentHashMapCacheUtils.checkSize();
        ConcurrentHashMapCacheUtils.saveCacheUseLog(cacheKey);
        CURRENT_SIZE = CURRENT_SIZE + 1;
        if (ttlTime == null) {
            ttlTime = System.currentTimeMillis() + cacheTime;
        }
        CacheObj cacheObj = new CacheObj(cacheValue, ttlTime);
        CACHE_OBJECT_MAP.put(cacheKey, cacheObj);
        LOGGER.info("have set key :" + cacheKey);
    }

    public static void setCache(String cacheKey, Object cacheValue) {
        ConcurrentHashMapCacheUtils.setCache(cacheKey, cacheValue, -1L);
    }

    public static Object getCache(String cacheKey) {
        ConcurrentHashMapCacheUtils.startCleanThread();
        if (ConcurrentHashMapCacheUtils.checkCache(cacheKey)) {
            ConcurrentHashMapCacheUtils.saveCacheUseLog(cacheKey);
            return CACHE_OBJECT_MAP.get(cacheKey).getCacheValue();
        }
        return null;
    }

    public static boolean isExist(String cacheKey) {
        return ConcurrentHashMapCacheUtils.checkCache(cacheKey);
    }

    public static void clear() {
        LOGGER.info("have clean all key !");
        CACHE_OBJECT_MAP.clear();
        CURRENT_SIZE = 0;
    }

    public static void deleteCache(String cacheKey) {
        CacheObj cacheValue = CACHE_OBJECT_MAP.remove(cacheKey);
        if (cacheValue != null) {
            LOGGER.info("have delete key :" + cacheKey);
            CURRENT_SIZE = CURRENT_SIZE - 1;
        }
    }

    private static boolean checkCache(String cacheKey) {
        CacheObj cacheObj = CACHE_OBJECT_MAP.get(cacheKey);
        if (cacheObj == null) {
            return false;
        }
        if (cacheObj.getTtlTime() == -1L) {
            return true;
        }
        if (cacheObj.getTtlTime() < System.currentTimeMillis()) {
            ConcurrentHashMapCacheUtils.deleteCache(cacheKey);
            return false;
        }
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void deleteLRU() {
        LOGGER.info("delete Least recently used run!");
        String cacheKey = null;
        List<String> list = CACHE_USE_LOG_LIST;
        synchronized (list) {
            if (CACHE_USE_LOG_LIST.size() >= CACHE_MAX_NUMBER - 10) {
                cacheKey = CACHE_USE_LOG_LIST.remove(CACHE_USE_LOG_LIST.size() - 1);
            }
        }
        if (cacheKey != null) {
            ConcurrentHashMapCacheUtils.deleteCache(cacheKey);
        }
    }

    static void deleteTimeOut() {
        LOGGER.info("delete time out run!");
        LinkedList<String> deleteKeyList = new LinkedList<String>();
        for (Map.Entry<String, CacheObj> entry : CACHE_OBJECT_MAP.entrySet()) {
            if (entry.getValue().getTtlTime() >= System.currentTimeMillis() || entry.getValue().getTtlTime() == -1L) continue;
            deleteKeyList.add(entry.getKey());
        }
        for (String deleteKey : deleteKeyList) {
            ConcurrentHashMapCacheUtils.deleteCache(deleteKey);
        }
        LOGGER.info("delete cache count is :" + deleteKeyList.size());
    }

    private static void checkSize() {
        if (CURRENT_SIZE >= CACHE_MAX_NUMBER) {
            ConcurrentHashMapCacheUtils.deleteTimeOut();
        }
        if (CURRENT_SIZE >= CACHE_MAX_NUMBER) {
            ConcurrentHashMapCacheUtils.deleteLRU();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static synchronized void saveCacheUseLog(String cacheKey) {
        List<String> list = CACHE_USE_LOG_LIST;
        synchronized (list) {
            CACHE_USE_LOG_LIST.remove(cacheKey);
            CACHE_USE_LOG_LIST.add(0, cacheKey);
        }
    }

    static void setCleanThreadRun() {
        CLEAN_THREAD_IS_RUN = true;
    }

    private static void startCleanThread() {
        if (!CLEAN_THREAD_IS_RUN.booleanValue()) {
            CleanTimeOutThread cleanTimeOutThread = new CleanTimeOutThread();
            Thread thread = new Thread(cleanTimeOutThread);
            thread.setDaemon(true);
            thread.start();
        }
    }
}

