/*
 * Decompiled with CFR 0.152.
 */
package com.chinamcloud.haihe.common.spider;

import com.chinamcloud.haihe.common.spider.element.ContentElement;
import com.chinamcloud.haihe.common.spider.element.SourceElement;
import com.chinamcloud.haihe.common.spider.element.TimeElement;
import com.chinamcloud.haihe.common.spider.element.TitleElement;
import com.chinamcloud.haihe.common.spider.pojo.CountInfo;
import com.chinamcloud.haihe.common.spider.pojo.News;
import com.chinamcloud.haihe.common.spider.utils.ElementUtils;
import com.chinamcloud.haihe.common.spider.utils.TextUtils;
import com.chinamcloud.haihe.common.utils.HttpUtils;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.jsoup.Jsoup;
import org.jsoup.nodes.Document;
import org.jsoup.nodes.Element;
import org.jsoup.nodes.Node;
import org.jsoup.select.Elements;
import us.codecraft.webmagic.downloader.HttpClientDownloader;
import us.codecraft.webmagic.selector.Html;

public class NewsInfoExtractor {
    private static final Logger log = LogManager.getLogger(NewsInfoExtractor.class);
    protected Document doc;
    protected HashMap<Element, CountInfo> infoMap = new HashMap(16);
    protected List<Element> elementList = new ArrayList<Element>(16);

    NewsInfoExtractor(Document doc) {
        this.doc = doc;
    }

    protected void clean() {
        this.doc.select("script,noscript,style,iframe,br").remove();
    }

    protected CountInfo computeInfo(Node node) {
        Element tag = (Element)node;
        Elements children = tag.children();
        if (children == null || children.size() > 0) {
            CountInfo countInfo = new CountInfo();
            for (Node childNode : tag.children()) {
                CountInfo childCountInfo = this.computeInfo(childNode);
                countInfo.setTextCount(countInfo.getTextCount() + childCountInfo.getTextCount());
                countInfo.setLinkTextCount(countInfo.getLinkTextCount() + childCountInfo.getLinkTextCount());
                countInfo.setTagCount(countInfo.getTagCount() + childCountInfo.getTagCount());
                countInfo.setLinkTagCount(countInfo.getLinkTagCount() + childCountInfo.getLinkTagCount());
                countInfo.getLeafList().addAll(childCountInfo.getLeafList());
                countInfo.setDensitySum(countInfo.getDensitySum() + childCountInfo.getDensity());
                countInfo.setPCount(countInfo.getPCount() + childCountInfo.getPCount());
            }
            countInfo.setTagCount(countInfo.getTagCount() + 1);
            String tagName = tag.tagName();
            if (tagName.equals("a")) {
                countInfo.setLinkTextCount(countInfo.getTextCount());
                countInfo.setLinkTagCount(countInfo.getLinkTagCount() + 1);
            } else if (tagName.equals("p")) {
                countInfo.setPCount(countInfo.getPCount() + 1);
            }
            int pureLen = countInfo.getTextCount() - countInfo.getLinkTextCount();
            int len = countInfo.getTagCount() - countInfo.getLinkTagCount();
            if (pureLen == 0 || len == 0) {
                countInfo.setDensity(0.0);
            } else {
                countInfo.setDensity(((double)pureLen + 0.0) / (double)len);
            }
            this.infoMap.put(tag, countInfo);
            this.elementList.add(tag);
            return countInfo;
        }
        CountInfo countInfo = new CountInfo();
        String text = tag.text();
        int len = text.length();
        countInfo.setTextCount(len);
        countInfo.getLeafList().add(len);
        this.elementList.add(tag);
        return countInfo;
    }

    public News getNews() throws Exception {
        Element contentElement;
        News news = new News();
        try {
            this.clean();
            this.computeInfo((Node)this.doc.body());
            contentElement = ContentElement.getContentElement(this.doc, this.infoMap);
            news.setContentElement(contentElement);
            news.setContentXPath(ElementUtils.getXpath(ElementUtils.getMinElement(contentElement), this.doc));
        }
        catch (Exception ex) {
            log.info("news content extraction failed,extraction abort", (Throwable)ex);
            throw new Exception(ex);
        }
        if (this.doc.baseUri() != null) {
            news.setUrl(this.doc.baseUri());
        }
        Element titleElement = null;
        try {
            titleElement = TitleElement.getTitle(contentElement, this.doc, this.elementList);
            if (titleElement != null) {
                news.setTitle(titleElement.text());
                news.setTitleElement(titleElement);
                news.setTitleXPath(ElementUtils.getXpath(titleElement, this.doc));
            }
        }
        catch (Exception ex) {
            log.info("title extraction failed", (Throwable)ex);
        }
        if (titleElement != null) {
            Element notHas = this.isNotHas(contentElement, titleElement);
            news.setContent(notHas.text());
            news.setContentElement(notHas);
            news.setContentXPath(ElementUtils.getXpath(ElementUtils.getMinElement(notHas), this.doc));
        }
        Element timeElement = null;
        try {
            timeElement = TimeElement.getTime(contentElement, titleElement, this.elementList, this.doc);
            if (timeElement != null) {
                news.setTimeXPath(ElementUtils.getXpath(timeElement, this.doc));
                news.setTimeElement(timeElement);
                news.setTime(TimeElement.getTimeFormRegex(timeElement.text()));
            }
        }
        catch (Exception ex) {
            log.info("news time extraction failed", (Throwable)ex);
        }
        Element sourceElement = null;
        try {
            sourceElement = SourceElement.getSource(contentElement, titleElement, timeElement, this.elementList);
            if (sourceElement != null) {
                news.setSourceXPath(ElementUtils.getXpath(sourceElement, this.doc));
                news.setSource(sourceElement.text());
            }
        }
        catch (Exception ex) {
            log.info("news source extraction failed", (Throwable)ex);
        }
        return news;
    }

    protected Element isNotHas(Element p, Element c) {
        Elements children = p.children();
        if (children != null) {
            for (Element child : children) {
                if (Math.abs(1.0 - TextUtils.strSim(child.text(), c.text())) < 0.5 || !(TextUtils.strSim(child.text(), p.text()) > 0.9)) continue;
                p = child;
                return p;
            }
        }
        return p;
    }

    public static News getNewsByDoc(Document doc) throws Exception {
        NewsInfoExtractor ce = new NewsInfoExtractor(doc);
        return ce.getNews();
    }

    public static News getNewsByHtml(String html, String url) throws Exception {
        Document doc = Jsoup.parse((String)html, (String)url);
        return NewsInfoExtractor.getNewsByDoc(doc);
    }

    public static News getNewsByHtml(String html) throws Exception {
        Document doc = Jsoup.parse((String)html);
        return NewsInfoExtractor.getNewsByDoc(doc);
    }

    public static News getNewsByUrl(String url) throws Exception {
        HttpClientDownloader downloader = new HttpClientDownloader();
        Html html = null;
        try {
            html = downloader.download(url);
        }
        catch (Exception e) {
            e.printStackTrace();
            HttpUtils.HttpRequestResult httpRequestResult = HttpUtils.executeGet(url, null, "utf-8");
            if (httpRequestResult != null && httpRequestResult.getStatus().equals((Object)HttpUtils.Status.SUCCESS)) {
                html = new Html(httpRequestResult.getMsg());
            }
            return null;
        }
        return NewsInfoExtractor.getNewsByHtml(html.toString(), url);
    }

    public static void main(String[] args) throws Exception {
        String[] urls;
        for (String url : urls = new String[]{"https://baijiahao.baidu.com/s?id=1660860287770658064"}) {
            new Thread(() -> {
                News news = null;
                try {
                    news = NewsInfoExtractor.getNewsByHtml("<!Doctype html><html xmlns=\"http://www.w3.org/1999/xhtml\"><head><meta charset=\"utf-8\"/><meta name=\"referrer\" content=\"always\"><meta http-equiv=\"X-UA-Compatible\" content=\"IE=edge,chrome=1\"><meta name=\"viewport\" content=\"width=device-width,initial-scale=1.0,minimum-scale=1.0,maximum-scale=1.0,user-scalable=no\"><link rel=\"shortcut icon\" href=\"https://gss0.bdstatic.com/5bd1bjqh_Q23odCf/static/wiseindex/img/favicon64.ico\" type=\"image/x-icon\"><link rel=\"apple-touch-icon-precomposed\" href=\"https://gss0.bdstatic.com/5bd1bjqh_Q23odCf/static/wiseindex/img/screen_icon_new.png\"><title>\u52a9\u529b\u590d\u5de5\u590d\u4ea7 \u8857\u9053\u201c\u4e09\u6b65\u8d70\u201d\u5168\u9762\u63a8\u884c\u201c\u5929\u5e9c\u5065\u5eb7\u7801\u201d</title><link rel=\"stylesheet\" href=\"https://ss0.bdstatic.com/5aV1bjqh_Q23odCf/static/superlanding/css/land_min_pack_adfb465.css\"><meta itemprop=\"dateUpdate\" content=\"2020-03-11 17:42:50\" /></head><body><script >/* eslint-disable */var s_domain = {\"protocol\":\"https:\",\"staticUrl\":\"https://ss0.bdstatic.com/5aV1bjqh_Q23odCf/\",\"base\":\"\",\"baseuri\":\"\",\"passconf\":\"http://passport.baidu.com/ubrwsbas\",\"logout\":\"https://passport.baidu.com/?logout&u=\",\"bs\":\"https://www.baidu.com\",\"sp\":\"http://hi.baidu.com/\",\"ssllist\":{\"a.hiphotos.baidu.com\":\"ss0.baidu.com/94o3dSag_xI4khGko9WTAnF6hhy\",\"b.hiphotos.baidu.com\":\"ss1.baidu.com/9vo3dSag_xI4khGko9WTAnF6hhy\",\"c.hiphotos.baidu.com\":\"ss3.baidu.com/9fo3dSag_xI4khGko9WTAnF6hhy\",\"d.hiphotos.baidu.com\":\"ss0.baidu.com/-Po3dSag_xI4khGko9WTAnF6hhy\",\"e.hiphotos.baidu.com\":\"ss1.baidu.com/-4o3dSag_xI4khGko9WTAnF6hhy\",\"f.hiphotos.baidu.com\":\"ss2.baidu.com/-vo3dSag_xI4khGko9WTAnF6hhy\",\"g.hiphotos.baidu.com\":\"ss3.baidu.com/-fo3dSag_xI4khGko9WTAnF6hhy\",\"h.hiphotos.baidu.com\":\"ss0.baidu.com/7Po3dSag_xI4khGko9WTAnF6hhy\",\"1.su.bdimg.com\":\"ss0.bdstatic.com/k4oZeXSm1A5BphGlnYG\",\"t10.baidu.com\":\"ss0.baidu.com/6ONWsjip0QIZ8tyhnq\",\"t11.baidu.com\":\"ss1.baidu.com/6ONXsjip0QIZ8tyhnq\",\"t12.baidu.com\":\"ss2.baidu.com/6ONYsjip0QIZ8tyhnq\",\"himg.bdimg.com\":\"ss1.bdstatic.com/7Ls0a8Sm1A5BphGlnYG\",\"cdn00.baidu-img.cn\":\"ss0.bdstatic.com/9bA1vGba2gU2pMbfm9GUKT-w\",\"cdn01.baidu-img.cn\":\"ss0.bdstatic.com/9bA1vGfa2gU2pMbfm9GUKT-w\"}};var s_session = {\"ssid\":\"0\",\"logid\":\"\",\"sid\":\"30972_1460_21086_30840_31130_30824_30717\",\"nid\":\"9585265044867075487\",\"qid\":\"\"};var s_advert = {\"isBjh\":\"1\",\"contentUrl\":\"http://baijiahao.baidu.com/s?id=1660860287770658064\",\"contentPlatformId\":\"3\",\"contentType\":\"1\",\"pvid\":\"7173b19a7e8b3495\",\"time\":\"2020-03-23 19:21:52\",\"contentAccType\":\"1\",\"ctk\":\"2a8f75a15911a2e6\",\"contentAccId\":\"JQtabpWSiGIEYRY5B\",\"ctk_b\":\"6ad2f78ebc3a1de9\",\"logid\":\"1312692620\",\"dtime\":\"1584962512\",\"grade\":\"2\",\"createTimeAccLevel\":\"4\"};</script><script>/* eslint-disable */var bds={se:{},su:{urdata:[],urSendClick:function(){},urStatic:\"https://ss.bdimg.com\"},util:{},use:{},comm:{domain:\"\",ubsurl:\"\",tn:\"\",queryEnc:\"\",queryId:\"\",inter:\"\",sugHost:\"\",query:\"\",qid:\"\",cid:\"\",sid:\"\",stoken:\"\",serverTime:\"\",user:\"\",username:\"\",loginAction:[],useFavo:\"\",pinyin:\"\",favoOn:\"\",curResultNum:\"0\",rightResultExist:false,protectNum:0,zxlNum:0,pageNum:1,pageSize:10,ishome:1,newindex:1}};var name,navigate,al_arr=[];var selfOpen=window.open;eval(\"var open = selfOpen;\");var isIE=navigator.userAgent.indexOf(\"MSIE\")!=-1&&!window.opera;var E=bds.ecom={};bds.se.mon={loadedItems:[],load:function(){},srvt:-1};try{bds.se.mon.srvt=parseInt(document.cookie.match(new RegExp(\"(^| )BDSVRTM=([^;]*)(;|$)\"))[2]);document.cookie=\"BDSVRTM=;expires=Sat, 01 Jan 2000 00:00:00 GMT\"}catch(e){}var bdUser=bds.comm.user?bds.comm.user:null,bdQuery=bds.comm.query,bdUseFavo=bds.comm.useFavo,bdFavoOn=bds.comm.favoOn,bdCid=bds.comm.cid,bdSid=bds.comm.sid,bdServerTime=bds.comm.serverTime,bdQid=bds.comm.queryId,bdstoken=bds.comm.stoken,login_success=[];</script><div id=\"detail-page\"><div class=\"line-shadow\"></div><div class=\"item-wrap\"><div id=\"header_wrap\" class=\"header_wrap\"><div class=\"header_content\"><div class=\"header_logo\"><a href=\"https://www.baidu.com\" id=\"result_logo\" data-clklog=\"tid:139;cst:2;logInfo:head_logo;\" data-extralog=\"rid:;pos:;extra:;isBaiJiaHao:1;login:0;\" data-rid=\"head_0\"><img src=\"https://ss0.bdstatic.com/5aV1bjqh_Q23odCf/static/superlanding/img/logo_top.png\" alt=\"\u5230\u767e\u5ea6\u9996\u9875\" title=\"\u5230\u767e\u5ea6\u9996\u9875\"></a></div><div class=\"header_menu\" data-rid=\"header_menu\"><a href=\"https://www.baidu.com\" class=\"index\" data-clklog=\"tid:142;cst:2;logInfo:head_menu\" data-extralog=\"rid:;pos:;extra:;isBaiJiaHao:1;login:0;type:backindex\" data-rid=\"head_1\">\u767e\u5ea6\u9996\u9875</a><span class=\"line\"></span><div id=\"userBlock\"><a href=\"https://passport.baidu.com/v2/?login&tpl=mn&u=http://www.baidu.com\" class=\"login\" data-clklog=\"tid:142;cst:2;logInfo:head_menu;\" data-extralog=\"rid:;pos:;extra:;isBaiJiaHao:1;login:0;type:login\" data-rid=\"head_2\">\u767b\u5f55</a><a href=\"http://i.baidu.com/\" id=\"usrname\" class=\"usrname\" data-clklog=\"tid:142;cst:2;logInfo:head_menu;\" data-extralog=\"rid:;pos:;extra:;isBaiJiaHao:1;login:0;type:usrname;\" data-rid=\"head_2\"><span id=\"nametxt\"></span><div id=\"user_menu\" data-showlog=\"tid:131;cst:1;logInfo:usrmenu;\" data-extralog=\"rid:;pos:;extra:;isBaiJiaHao:1;login:0;\" class=\"s-isindex-wrap s-user-set-menu menu-top\" style=\"display: none;\"><div><a href=\"http://i.baidu.com/center\" target=\"_blank\" data-tid=\"1000\" data-clklog=\"tid:146;cst:2;logInfo:usrmenu;\" data-extralog=\"rid:;pos:1;extra:;isBaiJiaHao:1;login:0;type:center;\" data-rid=\"usr_menu_1\">\u4e2a\u4eba\u4e2d\u5fc3</a><a href=\"http://passport.baidu.com/\" data-tid=\"1001\" target=\"_blank\" data-clklog=\"tid:146;cst:2;logInfo:usrmenu;\" data-extralog=\"rid:;pos:2;extra:;isBaiJiaHao:1;login:0;type:passport;\" data-rid=\"usr_menu_2\">\u5e10\u53f7\u8bbe\u7f6e</a><a class=\"s-feedback\" style=\"overflow:hidden\" href=\"#\" onclick=\"return false;\" data-clklog=\"tid:146;cst:2;logInfo:usrmenu;\" data-extralog=\"rid:;pos:3;extra:;isBaiJiaHao:1;login:0;type:feedback;\" data-rid=\"header_menu_3\">\u610f\u89c1\u53cd\u9988</a><a class=\"quit\" style=\"overflow:hidden\" href=\"https://passport.baidu.com/?logout&u=https://www.baidu.com\" data-clklog=\"tid:146;cst:2;logInfo:usrmenu;\" data-extralog=\"rid:;pos:4;extra:;isBaiJiaHao:1;login:0;type:quit;\" data-rid=\"usr_menu_4\">\u9000\u51fa</a></div><span class=\"menu-arrow\"><em></em></span></div></div></div></div></div></div><div class=\"title_border\"><div class=\"anci_header_content\"><div class=\"article-title\"><h2>\u52a9\u529b\u590d\u5de5\u590d\u4ea7 \u8857\u9053\u201c\u4e09\u6b65\u8d70\u201d\u5168\u9762\u63a8\u884c\u201c\u5929\u5e9c\u5065\u5eb7\u7801\u201d</h2></div><div class=\"article-desc clearfix\"><div class=\"author-icon\"><img src=\"https://timg01.bdimg.com/timg?pacompress=&amp;imgtype=0&amp;sec=1439619614&amp;autorotate=1&amp;di=7d7742278f21071a2213e9d87b58f881&amp;quality=90&amp;size=b200_200&amp;src=http%3A%2F%2Fpic.rmb.bdstatic.com%2F275331d45c42142365ab94b8a320015b.png\"><i class=\"author-vip author-vip-2\"></i></div><div class=\"author-txt\"><p class=\"author-name\">\u5c01\u9762\u65b0\u95fb</p><div class=\"article-source article-source-bjh\"><span class=\"date\">\u53d1\u5e03\u65f6\u95f4\uff1a03-11</span><span class=\"time\">17:42</span><span class=\"account-authentication\">\u5c01\u9762\u65b0\u95fb\u5b98\u65b9\u5e10\u53f7</span></div></div></div></div></div><div id=\"content-container\" class=\"content-container clearfix\" data-showlog=\"tid:126;cst:1;logInfo:landing;\" data-extralog=\"flow:2;st:news;rid:9585265044867075487;pos:0;extra:;source:1;isBaijiahao:1;login:0;appId:1577667706397024;\" data-ratio=\"1\" data-rid=\"page\"><div id=\"left-container\" class=\"left-container\"><div class=\"item-wrap\"><div class=\"article \" id=\"article\" data-islow-browser=\"0\"><div class=\"article-content\"><div class=\"img-container\"><img class=\"large\" data-loadfunc=0 src=\"https://pics2.baidu.com/feed/c8ea15ce36d3d539f002602c5e32bf56342ab059.png?token=bbdae190ff20426f17f804dcb48d91f5&amp;s=56E59A5646032CE8082B9AB50300501D\" data-loaded=0 /></div><p><span class=\"bjh-p\">\u8fd1\u65e5\uff0c\u4e3a\u5efa\u7acb\u7edf\u4e00\u7684\u75ab\u60c5\u9632\u63a7\u4fe1\u606f\u5e73\u53f0\uff0c\u63d0\u5347\u590d\u5de5\u590d\u4ea7\u590d\u8015\u590d\u5e02\u9632\u63a7\u6570\u636e\u652f\u6491\uff0c\u6210\u90fd\u5e02\u5f00\u53d1\u201c\u5929\u5e9c\u5065\u5eb7\u901a\u201d\u5c0f\u7a0b\u5e8f\uff0c\u6c47\u805a\u5404\u533a\u57df\u4fe1\u606f\uff0c\u63d0\u5021\u516c\u5171\u573a\u6240\u51ed\u7801\u51fa\u5165\uff0c\u66f4\u7cbe\u51c6\u6709\u6548\u5f00\u5c55\u75ab\u60c5\u9632\u63a7\u30023\u670811\u65e5\uff0c\u8bb0\u8005\u4e86\u89e3\u5230\uff0c\u9ad8\u65b0\u533a\u4e39\u666f\u8857\u9053\u529e\u534f\u540c\u8f96\u533a\u6d3e\u51fa\u6240\u201c\u4e09\u6b65\u8d70\u201d\u5168\u9762\u94fa\u5f00\u201c\u5929\u5e9c\u5065\u5eb7\u7801\u201d\u63a8\u884c\u5de5\u4f5c\u3002</span></p><p><span class=\"bjh-p\">\u636e\u6089\uff0c\u8857\u9053\u9996\u5148\u662f\u201c\u5ba3\u4f20\u52a8\u5458\u201d\u505a\u597d\u8857\u6751\u5e72\u90e8\u57f9\u8bad\u3002\u7ec4\u7ec7\u8857\u6751\u5e72\u90e8\u53ca\u6c11\u751f\u529e\u5de5\u4f5c\u7ec4\u4eba\u545820\u4f59\u4eba\u53c2\u52a0\u57f9\u8bad\u4f1a\u8bae\uff0c\u7531\u6d3e\u51fa\u6240\u6559\u5bfc\u5458\u4e3b\u8bb2\u4f7f\u7528\u63a8\u884c\u8981\u6c42\u53ca\u5177\u4f53\u64cd\u4f5c\u65b9\u6cd5\uff0c\u5404\u6751\uff08\u793e\u533a\uff09\u7ec4\u7ec7\u5f00\u5c55\u76f8\u5e94\u57f9\u8bad\u52a8\u5458\u4f1a18\u573a\uff0c\u63d0\u9ad8\u5e72\u90e8\u53ca\u5fd7\u613f\u8005\u4e1a\u52a1\u6c34\u5e73\u3002</span></p><div class=\"img-container\"><img class=\"large\" data-loadfunc=0 src=\"https://pics4.baidu.com/feed/9e3df8dcd100baa143314a32e036ee14c9fc2ec2.jpeg?token=9a9a28aad7a0ba3cb97b5bcb21278a3e&amp;s=9FF66D854C932ED00A9D089603001002\" data-loaded=0 /></div><p><span class=\"bjh-p\">\u201c\u5168\u9762\u8986\u76d6\u201d\u5165\u6237\u6307\u5bfc\u626b\u7801\u767b\u8bb0\u3002\u8857\u9053\u5404\u6751\uff08\u793e\u533a\uff09\u5b89\u6392\u843d\u5b9e\u4e13\u4eba\u8d1f\u8d23\uff0c\u4ee5\u6751\u5e72\u90e8\uff0b\u7f51\u683c\u5458\u4e3a\u4e3b\u8981\u529b\u91cf\uff0c\u51fa\u52a870\u4f59\u4eba\u6df1\u5165\u5f00\u5c55\u5165\u6237\u6307\u5bfc\uff0c\u5ba3\u4f20\u201c\u5929\u5e9c\u5065\u5eb7\u7801\u201d\u5e94\u7528\u8303\u56f4\u7b49\uff0c\u5e2e\u52a9\u7fa4\u4f17\u5f00\u5c55\u4fe1\u606f\u767b\u8bb0\u3002</span></p><p><span class=\"bjh-p\">\u201c\u628a\u63e1\u91cd\u70b9\u201d\u5b9a\u70b9\u5b9a\u5458\u63d0\u4f9b\u670d\u52a1\u3002\u628a\u7262\u793e\u533a\u3001\u5c0f\u533a\u3001\u5de5\u5730\u3001\u5546\u8d85\u3001\u5e02\u573a\u7b49\u91cd\u70b9\u533a\u57df\uff0c\u7ec4\u7ec7\u4eba\u5458\u5b9a\u70b9\u5f00\u8bbe\u201c\u5929\u5e9c\u5065\u5eb7\u7801\u201d\u5ba3\u4f20\u53ca\u670d\u52a1\u70b9\u4f4d5\u4e2a\uff0c\u5e2e\u52a9\u7fa4\u4f17\u548c\u4f01\u4e1a\u5de5\u4eba\u53ca\u65f6\u767b\u8bb0\u3001\u719f\u7ec3\u4f7f\u7528\u3002</span></p><p><span class=\"bjh-p\">\u622a\u81f3\u76ee\u524d\uff0c\u4e39\u666f\u8857\u90534000\u4f59\u4eba\u542f\u7528\u201c\u5065\u5eb7\u7801\u201d\uff0c\u5df2\u5728\u5e02\u573a\u3001\u5546\u8d85\u3001\u5c0f\u533a\u3001\u5de5\u5730\u3001\u529e\u516c\u533a\u7b49\u533a\u57df\u63a8\u884c\u201c\u5929\u5e9c\u5065\u5eb7\u7801\u201d\u4f7f\u7528\u3002</span></p><p><span class=\"bjh-p\">\u534e\u897f\u793e\u533a\u62a5\u8bb0\u8005 \u51af\u6d55 \u56fe\u636e\u8857\u9053</span></p></div><audio height=\"0\" width=\"0\" id=\"musicAudio\" data-play-index><source></source></audio></div></div><div class=\"item-wrap\"><div class=\"search-diversion\" data-showlog=\"tid:840;cst:1;logInfo:related_search;\" data-extralog=\"itemNum:3;\" data-rid=\"search-diversion\"><h2>\u76f8\u5173\u641c\u7d22</h2><ul><li data-clklog=\"tid:841;cst:2;logInfo:related_search;\" data-extralog=\"pos:0;\"><a href=\"https://www.baidu.com/s?word=%E6%9D%91%E5%B9%B2%E9%83%A8%E6%9C%89%E5%93%AA%E4%BA%9B%E8%81%8C%E4%BD%8D&amp;rsv_dl=0_feed_brs_0&amp;rsf=38389790596006196_1\">\u6751\u5e72\u90e8\u6709\u54ea\u4e9b\u804c\u4f4d</a></li><li data-clklog=\"tid:841;cst:2;logInfo:related_search;\" data-extralog=\"pos:1;\"><a href=\"https://www.baidu.com/s?word=%E6%88%90%E9%83%BD%E5%B8%82%E9%AB%98%E6%96%B0%E5%8C%BA&amp;rsv_dl=0_feed_brs_1&amp;rsf=38389790596006196_1\">\u6210\u90fd\u5e02\u9ad8\u65b0\u533a</a></li><li data-clklog=\"tid:841;cst:2;logInfo:related_search;\" data-extralog=\"pos:2;\"><a href=\"https://www.baidu.com/s?word=%E5%B7%A5%E7%A8%8B%E5%A4%8D%E5%B7%A5&amp;rsv_dl=0_feed_brs_2&amp;rsf=38389790596006196_1\">\u5de5\u7a0b\u590d\u5de5</a></li></ul></div></div></div><div id=\"right-container\" class=\"right-container\"><div class=\"item-wrap\"><div class=\"recent-article\" data-pos=\"\"><h2>\u4f5c\u8005\u6700\u65b0\u6587\u7ae0</h><ul><li data-showlog=\"tid:135;cst:1;logInfo:recent_article;\" data-extralog=\"rid:;pos:0;extra:;isBaiJiaHao:1;login:0;\"  data-rid=\"recent_article_0\"><h3 class=\"item-title\"><a href=\"https://mbd.baidu.com/newspage/data/landingsuper?context=%7B%22nid%22%3A%22news_9507215060885569809%22%7D&amp;n_type=1&amp;p_from=3\" data-clklog=\"tid:147;cst:2;logInfo:recent_article;\" data-extralog=\"rid:;pos:0;extra:;isBaiJiaHao:1;login:0;\" target=\"_blank\">\u8424\u706b\u98de\u821e\u6ea2\u6d41\u5149 \u56db\u5ddd\u9752\u795e\u8424\u706b\u866b\u89c2\u8d4f\u5b63\u6765\u4e86</a></h3><div class=\"item-desc hide\"><span class=\"info-date\">03-23</span><span class=\"info-time\">19:07</span></div></li><li data-showlog=\"tid:135;cst:1;logInfo:recent_article;\" data-extralog=\"rid:;pos:1;extra:;isBaiJiaHao:1;login:0;\"  data-rid=\"recent_article_1\"><h3 class=\"item-title\"><a href=\"https://mbd.baidu.com/newspage/data/landingsuper?context=%7B%22nid%22%3A%22news_9532894412633078651%22%7D&amp;n_type=1&amp;p_from=3\" data-clklog=\"tid:147;cst:2;logInfo:recent_article;\" data-extralog=\"rid:;pos:1;extra:;isBaiJiaHao:1;login:0;\" target=\"_blank\">\u5f52\u56fd\u8def\u6108\u8270\u96be\uff01\u5168\u7403\u591a\u4e2a\u4e2d\u8f6c\u5730\u673a\u573a\u5ba3\u5e03\u201c\u7981\u6b62\u8fc7\u5883\u201d</a></h3><div class=\"item-desc hide\"><span class=\"info-date\">03-23</span><span class=\"info-time\">19:02</span></div></li><li data-showlog=\"tid:135;cst:1;logInfo:recent_article;\" data-extralog=\"rid:;pos:2;extra:;isBaiJiaHao:1;login:0;\"  data-rid=\"recent_article_2\"><h3 class=\"item-title\"><a href=\"https://mbd.baidu.com/newspage/data/landingsuper?context=%7B%22nid%22%3A%22sv_2646813752822465461%22%7D&amp;n_type=1&amp;p_from=3\" data-clklog=\"tid:147;cst:2;logInfo:recent_article;\" data-extralog=\"rid:;pos:2;extra:;isBaiJiaHao:1;login:0;\" target=\"_blank\">30\u79d2\uff5c\u8d8a\u8fc7\u51ac\u5929 \u6b66\u5927\u6a31\u82b1\u5f00\u4e86</a></h3><div class=\"item-desc hide\"><span class=\"info-date\">03-23</span><span class=\"info-time\">19:02</span></div></li></ul></div></div><div class=\"item-wrap\"><div class=\"related-news\"><div class=\"news-content \"><h2>\u76f8\u5173\u6587\u7ae0</h2><ul><li data-showlog=\"tid:136;cst:1;logInfo:related_news;\" data-extralog=\"flow:2;rid:;pos:0;extra:;isBaiJiaHao:1;login:0;\"  data-rid=\"related_news_0\"><div class=\"item-content clearfix\"><div class=\"news-info\"><div class=\"news-title\"><h3><a class=\"upgrade\" data-clklog=\"tid:148;cst:2;logInfo:related_news;\" data-extralog=\"rid:;pos:0;extra:;isBaiJiaHao:1;login:0;type:'title'\"  href=\"https://mbd.baidu.com/newspage/data/landingsuper?context=%7B%22nid%22%3A%22news_9763568735306834233%22%7D&amp;n_type=1&amp;p_from=4\" target=\"_blank\">\u5929\u5e9c\u65b0\u533a\u201c\u5206\u914d\u201d\u5de5\u4f5c\uff0c500000\u4eba\u5728\u7ebf\u201c\u62a2\u201d</a></h3></div></div><div class=\"news-pic\"><a class=\"upgrade\" data-clklog=\"tid:148;cst:2;logInfo:related_news;\" data-extralog=\"rid:;pos:1;extra:;isBaiJiaHao:1;login:0;type:'img'\" href=\"https://mbd.baidu.com/newspage/data/landingsuper?context=%7B%22nid%22%3A%22news_9763568735306834233%22%7D&amp;n_type=1&amp;p_from=4\" target=\"_blank\"><img src=\"https://ss1.baidu.com/6ONXsjip0QIZ8tyhnq/it/u=3042431983,3388580198&amp;fm=173&amp;app=49&amp;f=JPEG?w=312&amp;h=208&amp;s=A0731A9870397D887CDE9543030060F9\"></a></div></div></li><li data-showlog=\"tid:136;cst:1;logInfo:related_news;\" data-extralog=\"flow:2;rid:;pos:1;extra:;isBaiJiaHao:1;login:0;\"  data-rid=\"related_news_1\"><div class=\"item-content clearfix\"><div class=\"news-info\"><div class=\"news-title\"><h3><a class=\"upgrade\" data-clklog=\"tid:148;cst:2;logInfo:related_news;\" data-extralog=\"rid:;pos:1;extra:;isBaiJiaHao:1;login:0;type:'title'\"  href=\"https://mbd.baidu.com/newspage/data/landingsuper?context=%7B%22nid%22%3A%22news_10136031279865952502%22%7D&amp;n_type=1&amp;p_from=4\" target=\"_blank\">\u56db\u5ddd\u5929\u5e9c\u65b0\u533a\u643a80\u591a\u5bb6\u4f01\u4e1a\u7ebf\u4e0a\u201c\u62db\u8d24\u201d \u8d8537\u4e07\u4eba\u89c2\u770b\u4eba\u6c11\u7f51\u76f4\u64ad</a></h3></div></div><div class=\"news-pic\"><a class=\"upgrade\" data-clklog=\"tid:148;cst:2;logInfo:related_news;\" data-extralog=\"rid:;pos:2;extra:;isBaiJiaHao:1;login:0;type:'img'\" href=\"https://mbd.baidu.com/newspage/data/landingsuper?context=%7B%22nid%22%3A%22news_10136031279865952502%22%7D&amp;n_type=1&amp;p_from=4\" target=\"_blank\"><img src=\"https://ss1.baidu.com/6ONXsjip0QIZ8tyhnq/it/u=4224771526,2012118204&amp;fm=173&amp;app=49&amp;f=JPEG?w=312&amp;h=208&amp;s=AB73CA143E2E4409525274500300F0B9\"></a></div></div></li><li data-showlog=\"tid:136;cst:1;logInfo:related_news;\" data-extralog=\"flow:2;rid:;pos:2;extra:;isBaiJiaHao:1;login:0;\"  data-rid=\"related_news_2\"><div class=\"item-content clearfix\"><div class=\"news-info\"><div class=\"news-title\"><h3><a class=\"upgrade\" data-clklog=\"tid:148;cst:2;logInfo:related_news;\" data-extralog=\"rid:;pos:2;extra:;isBaiJiaHao:1;login:0;type:'title'\"  href=\"https://mbd.baidu.com/newspage/data/landingsuper?context=%7B%22nid%22%3A%22news_10162355903332882807%22%7D&amp;n_type=1&amp;p_from=4\" target=\"_blank\">\u5065\u5eb7\u7801\u2014\u2014\u201c\u7801\u201d\u4e0a\u51fa\u884c\u3001\u201c\u7801\u201d\u4e0a\u590d\u5de5</a></h3></div></div><div class=\"news-pic\"><a class=\"upgrade\" data-clklog=\"tid:148;cst:2;logInfo:related_news;\" data-extralog=\"rid:;pos:3;extra:;isBaiJiaHao:1;login:0;type:'img'\" href=\"https://mbd.baidu.com/newspage/data/landingsuper?context=%7B%22nid%22%3A%22news_10162355903332882807%22%7D&amp;n_type=1&amp;p_from=4\" target=\"_blank\"><img src=\"https://ss0.baidu.com/6ONWsjip0QIZ8tyhnq/it/u=1013107479,2487419295&amp;fm=173&amp;app=49&amp;f=JPEG?w=312&amp;h=208&amp;s=BAB24F85C2204F1F9C9C2CC90300E012\"></a></div></div></li><li data-showlog=\"tid:136;cst:1;logInfo:related_news;\" data-extralog=\"flow:2;rid:;pos:3;extra:;isBaiJiaHao:1;login:0;\"  data-rid=\"related_news_3\"><div class=\"item-content clearfix\"><div class=\"news-info\"><div class=\"news-title\"><h3><a class=\"upgrade\" data-clklog=\"tid:148;cst:2;logInfo:related_news;\" data-extralog=\"rid:;pos:3;extra:;isBaiJiaHao:1;login:0;type:'title'\"  href=\"https://mbd.baidu.com/newspage/data/landingsuper?context=%7B%22nid%22%3A%22news_8901113776991633679%22%7D&amp;n_type=1&amp;p_from=4\" target=\"_blank\">\u82b1\u5f00\u5929\u5e9c \u7f8e\u4e3d\u56db\u5ddd\u4e28\u76d8\u6d3b\u6797\u76d8\u9662\u843d \u6751\u6c11\u8fd4\u4e61\u521b\u4e1a\u8ba9\u5bb6\u4e61\u53d8\u5f97\u66f4\u7f8e\u597d</a></h3></div></div><div class=\"news-pic\"><a class=\"upgrade\" data-clklog=\"tid:148;cst:2;logInfo:related_news;\" data-extralog=\"rid:;pos:4;extra:;isBaiJiaHao:1;login:0;type:'img'\" href=\"https://mbd.baidu.com/newspage/data/landingsuper?context=%7B%22nid%22%3A%22news_8901113776991633679%22%7D&amp;n_type=1&amp;p_from=4\" target=\"_blank\"><img src=\"https://ss1.baidu.com/6ONXsjip0QIZ8tyhnq/it/u=4254167779,174601959&amp;fm=173&amp;app=49&amp;f=JPEG?w=312&amp;h=208&amp;s=E8A205D144500FCE2294AC1E03008050\"></a></div></div></li><li data-showlog=\"tid:136;cst:1;logInfo:related_news;\" data-extralog=\"flow:2;rid:;pos:4;extra:;isBaiJiaHao:1;login:0;\"  data-rid=\"related_news_4\"><div class=\"item-content clearfix\"><div class=\"news-info\"><div class=\"news-title\"><h3><a class=\"upgrade\" data-clklog=\"tid:148;cst:2;logInfo:related_news;\" data-extralog=\"rid:;pos:4;extra:;isBaiJiaHao:1;login:0;type:'title'\"  href=\"https://mbd.baidu.com/newspage/data/landingsuper?context=%7B%22nid%22%3A%22news_9720376808986148522%22%7D&amp;n_type=1&amp;p_from=4\" target=\"_blank\">\u6797\u57ce\u7f51\u683c\uff1a\u5927\u529b\u63a8\u5e7f\u201c\u5065\u5eb7\u7801\u201d  \u5c45\u6c11\u5b9e\u73b0\u201c\u4eae\u7801\u201d\u51fa\u884c</a></h3></div></div><div class=\"news-pic\"><a class=\"upgrade\" data-clklog=\"tid:148;cst:2;logInfo:related_news;\" data-extralog=\"rid:;pos:5;extra:;isBaiJiaHao:1;login:0;type:'img'\" href=\"https://mbd.baidu.com/newspage/data/landingsuper?context=%7B%22nid%22%3A%22news_9720376808986148522%22%7D&amp;n_type=1&amp;p_from=4\" target=\"_blank\"><img src=\"https://ss2.baidu.com/6ONYsjip0QIZ8tyhnq/it/u=1518496949,4268957274&amp;fm=173&amp;app=49&amp;f=JPEG?w=312&amp;h=208&amp;s=43A223E56E5000DE8AA622B003005006\"></a></div></div></li></ul></div></div><div id=\"relateAd\" ad-id=\"relate-js\" class=\"wangmeng-ad\" data-showlog=\"tid:369;cst:1;logInfo:adsjs;\" data-clklog=\"tid:370;cst:2;logInfo:adsjs;\" data-extralog=\"rid:;pos:5;extra:;baijiahao:1;login:0;\"></div></div></div></div><div id=\"bottom-container\" class=\"bottom-container \"><div class=\"copy-right\"><div class=\"baidu-info\"><a class=\"sethome\" href=\"//www.baidu.com/cache/sethelp/index.html\" target=\"_blank\"><span>\u8bbe\u4e3a\u9996\u9875</span></a><span class=\"copyright-text\"><span>&#169;&nbsp;Baidu&nbsp;</span><a href=\"//www.baidu.com/duty/\" target=\"_blank\">\u4f7f\u7528\u767e\u5ea6\u524d\u5fc5\u8bfb</a>&nbsp;<a href=\"http://jianyi.baidu.com\" target=\"_blank\">\u610f\u89c1\u53cd\u9988</a>&nbsp;<span>\u4eacICP\u8bc1030173\u53f7&nbsp;</span><img width=13 height=16 src=\"https://ss0.bdstatic.com/5aV1bjqh_Q23odCf/static/superman/img/copy_rignt_24.png\" /></span></div><div class=\"recordcode\"><a href=\"http://www.beian.gov.cn/portal/registerSystemInfo?recordcode=11000002000001\"  target=\"_blank\"><i></i>\u4eac\u516c\u7f51\u5b89\u590711000002000001\u53f7</a></div></div><div class=\"back-to-top\" data-showlog=\"tid:133;cst:1;logInfo:back_to_top;\" data-clklog=\"tid:138;cst:2;logInfo:back_to_top;\" data-extralog=\"rid:;pos:;extra:;isBaiJiaHao:1;login:0;\" data-rid=\"back_to_top\"><div class=\"icon-text\"><span>\u8fd4\u56de\u9876\u90e8</span></div><div class=\"icon-arrow\"><span></span></div></div></div></div><script type=\"text/javascript\">window.onload = function () {var contentContainer = document.getElementById('content-container');var bottomContainer = document.getElementById('bottom-container');var rightContainer = document.getElementById('right-container');var minContentHeight = window.innerHeight - bottomContainer.offsetHeight;if (contentContainer.offsetHeight < minContentHeight) {contentContainer.style.height = minContentHeight + 'px';bottomContainer.className += ' fixed';}if (rightContainer.children.length === 0) {rightContainer.style.width = parseInt(rightContainer.offsetWidth + 1, 10) + 'px';}};</script><script type=\"text/javascript\" src=\"https://ss0.bdstatic.com/5aV1bjqh_Q23odCf/static/superlanding/js/lib/jquery_0affbc1.js\"></script><script type=\"text/javascript\" src=\"https://ss0.bdstatic.com/5aV1bjqh_Q23odCf/static/superlanding/js/land_min_pack_8e22d87.js\"></script><script type=\"text/javascript\" src=\"https://ss0.bdstatic.com/5aV1bjqh_Q23odCf/static/superlanding/js/article/index_bd58962.js\"></script></body></html>");
                    System.out.println(news.getUrl());
                    System.out.println(news.getTitleXPath() + "-----" + news.getTitle());
                    System.out.println(news.getTimeXPath() + "-----" + news.getTime());
                    System.out.println(news.getContentXPath() + "-----" + news.getContent());
                    System.out.println(news.getSourceXPath() + "-----" + news.getSource());
                }
                catch (Exception e) {
                    e.printStackTrace();
                    System.out.println("\u5f02\u5e38\uff01");
                }
                try {
                    Thread.sleep(10000L);
                }
                catch (InterruptedException e) {
                    e.printStackTrace();
                }
            }).start();
        }
    }
}

