/*
 * Decompiled with CFR 0.152.
 */
package com.chinamcloud.haihe.common.spider.element;

import com.chinamcloud.haihe.common.spider.utils.ElementUtils;
import java.util.List;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.apache.commons.lang3.StringUtils;
import org.jsoup.nodes.Document;
import org.jsoup.nodes.Element;

public class TimeElement {
    public static Element getTime(Element contentElement, Element titleElement, List<Element> elementList, Document doc) throws Exception {
        if (contentElement == null) {
            return TimeElement.getTime(contentElement, doc);
        }
        Element timeElement = null;
        Integer contentIndex = elementList.indexOf(contentElement);
        int titleIndex = 0;
        if (titleElement != null) {
            titleIndex = elementList.indexOf(titleElement);
            if (titleIndex == -1) {
                titleIndex = elementList.indexOf(titleElement.parent());
            }
            titleIndex = titleIndex == -1 ? 0 : titleIndex;
        }
        Integer contentChildren = ElementUtils.getChildNum(contentElement);
        List<Element> elements = null;
        if (titleIndex < contentIndex) {
            elements = titleIndex < contentIndex - contentChildren ? elementList.subList(titleIndex, contentIndex - contentChildren + 5) : elementList.subList(titleIndex, contentIndex);
        }
        if (elements != null) {
            timeElement = TimeElement.getTimeFromNewsAndElements(elements);
        }
        if (timeElement != null) {
            return timeElement;
        }
        elements = elementList.subList(contentIndex, contentChildren + contentIndex + 10);
        if (elements != null) {
            timeElement = TimeElement.getTimeFromNewsAndElements(elements);
        }
        if (timeElement == null) {
            return TimeElement.getTime(contentElement, doc);
        }
        return timeElement;
    }

    public static Element getTime(Element contentElement, Document doc) throws Exception {
        int i;
        String regex = "([1-2][0-9]{3})[^0-9]{1,5}?([0-1]?[0-9])[^0-9]{1,5}?([0-9]{1,2})[^0-9]{1,5}?([0-2]?[1-9])[^0-9]{1,5}?([0-9]{1,2})[^0-9]{1,5}?([0-9]{1,2})";
        Pattern pattern = Pattern.compile(regex);
        Element current = contentElement;
        for (i = 0; i < 2; ++i) {
            Element parent;
            if (current == null || current == doc.body() || (parent = current.parent()) == null) continue;
            current = parent;
        }
        for (i = 0; i < 6 && current != null; ++i) {
            String currentHtml = current.outerHtml();
            Matcher matcher = pattern.matcher(currentHtml);
            if (matcher.find()) {
                return current;
            }
            if (current == doc.body()) continue;
            current = current.parent();
        }
        try {
            return TimeElement.getDate(contentElement, doc);
        }
        catch (Exception ex) {
            throw new Exception("time not found");
        }
    }

    public static Element getDate(Element contentElement, Document doc) throws Exception {
        int i;
        String regex = "([1-2][0-9]{3})[^0-9]{1,5}?([0-1]?[0-9])[^0-9]{1,5}?([0-9]{1,2})";
        Pattern pattern = Pattern.compile(regex);
        Element current = contentElement;
        for (i = 0; i < 2; ++i) {
            Element parent;
            if (current == null || current == doc.body() || (parent = current.parent()) == null) continue;
            current = parent;
        }
        for (i = 0; i < 6 && current != null; ++i) {
            String currentHtml = current.outerHtml();
            Matcher matcher = pattern.matcher(currentHtml);
            if (matcher.find()) {
                return current;
            }
            if (current == doc.body()) continue;
            current = current.parent();
        }
        throw new Exception("date not found");
    }

    public static Element getTimeFromNewsAndElements(List<Element> elements) {
        for (Element element : elements) {
            String time = TimeElement.getTimeFormRegex(element.ownText());
            if (!StringUtils.isNotBlank((CharSequence)time)) continue;
            return element;
        }
        return null;
    }

    public static String getTimeFormRegex(String text) {
        String[] regex = new String[]{"([1-2][0-9]{3})[^0-9]{1,5}?([0-1]?[0-9])[^0-9]{1,5}?([0-9]{1,2})[^0-9]{1,5}?([0-2]?[0-9])[^0-9]{1,5}?([0-9]{1,2})[^0-9]{1,5}?([0-9]{1,2})", "([1-2][0-9]{3})[^0-9]{1,5}?([0-1]?[0-9])[^0-9]{1,5}?([0-9]{1,2})[^0-9]{1,5}?([0-2][0-9])[^0-9]{1,5}?([0-9]{1,2})", "([1-2][0-9]{3})[^0-9]{1,5}?([0-1]?[0-9])[^0-9]{1,5}?([0-9]{1,2})[^0-9]{1,5}?([0-3][0-9])", "([1-2][0-9]{3})[^0-9]{1,5}?([0-1]?[0-9])[^0-9]{1,5}?([0-9]{1,2})", "([0-9]{1,2})[^0-9]{1,5}?([0-9]{1,2})[^0-9]{1,5}?([0-3][0-9])[^0-9]{1,5}?([0-9]{1,2})[^0-9]{1,5}?([0-9]{1,2})", "([0-9]{1,2})[^0-9]{1,5}?([0-9]{1,2})[^0-9]{1,5}?([0-3][0-9])[^0-9]{1,5}?([0-9]{1,2})", "([0-9]{1,2})[^0-9]{1,5}?([0-9]{1,2})"};
        String[] timeStr = new String[]{"yyyy-MM-dd HH:mm:ss", "yyyy-MM-dd HH:mm", "yyyy-MM-dd HH", "yyyy-MM-dd", "MM-dd HH:mm:ss", "MM-dd HH:mm", "MM-dd"};
        for (int i = 0; regex.length > i; ++i) {
            Pattern pattern = Pattern.compile(regex[i]);
            Matcher matcher = pattern.matcher(text);
            if (!matcher.find()) continue;
            String group = matcher.group();
            return group;
        }
        return "";
    }
}

