/*
 * Decompiled with CFR 0.152.
 */
package com.chinamcloud.haihe.common.spider.element;

import com.chinamcloud.haihe.common.spider.utils.ElementUtils;
import com.chinamcloud.haihe.common.spider.utils.TextUtils;
import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.regex.Pattern;
import org.apache.commons.lang3.StringUtils;
import org.jsoup.nodes.Document;
import org.jsoup.nodes.Element;
import org.jsoup.nodes.Node;
import org.jsoup.select.Elements;
import org.jsoup.select.NodeVisitor;

public class TitleElement {
    public static Element getTitle(final Element contentElement, Document doc, List<Element> elementList) throws Exception {
        Elements titles;
        final ArrayList<Element> titleList = new ArrayList<Element>(16);
        final ArrayList<Double> titleSim = new ArrayList<Double>(16);
        final AtomicInteger contentIndex = new AtomicInteger();
        final String metaTitle = doc.title().trim();
        Element titleEl = doc.getElementsByTag("title").first();
        if (!metaTitle.isEmpty()) {
            doc.body().traverse(new NodeVisitor(){

                public void head(Node node, int i) {
                    if (node instanceof Element) {
                        Element tag = (Element)node;
                        if (tag == contentElement) {
                            contentIndex.set(titleList.size());
                            return;
                        }
                        String tagName = tag.tagName();
                        if (Pattern.matches("h[1-6]", tagName)) {
                            String title = tag.ownText().trim();
                            double sim = TextUtils.strSim(title, metaTitle);
                            titleSim.add(sim);
                            titleList.add(tag);
                        }
                    }
                }

                public void tail(Node node, int i) {
                }
            });
            int index = contentIndex.get();
            int titleSimSize = titleSim.size();
            index = Math.min(index + 5, titleSimSize);
            if (index > 0) {
                double maxScore = 0.0;
                int maxIndex = -1;
                for (int i = 0; i < index; ++i) {
                    double score = (double)(i + 1) * (Double)titleSim.get(i);
                    if (!(score > maxScore)) continue;
                    maxScore = score;
                    maxIndex = i;
                }
                if (maxIndex != -1) {
                    return (Element)titleList.get(maxIndex);
                }
            }
        }
        int contentIndexOf = elementList.indexOf(contentElement);
        int titleIndexOf = elementList.indexOf(titleEl);
        Elements children = contentElement.children();
        Integer contentChildren = ElementUtils.getChildNum(contentElement);
        int temp = contentIndexOf - contentChildren;
        titleSim.clear();
        titleList.clear();
        List<Element> elementListValue = elementList.subList(temp > 50 ? temp - 50 : Math.max(titleIndexOf, 0), contentIndexOf);
        for (Element element : elementListValue) {
            double sim;
            String title = element.text().trim();
            if (StringUtils.isBlank((CharSequence)title) || !((sim = TextUtils.strSim(title, metaTitle)) > 0.5)) continue;
            titleSim.add(sim);
            titleList.add(element);
        }
        int index = titleList.size();
        if (index > 0) {
            double maxScore = 0.0;
            int maxIndex = -1;
            for (int i = 0; i < index; ++i) {
                double score = (double)(i + 1) * (Double)titleSim.get(i);
                if (!(Math.abs(1.0 - score) < Math.abs(1.0 - maxScore))) continue;
                maxScore = score;
                maxIndex = i;
            }
            if (maxIndex != -1) {
                return (Element)titleList.get(maxIndex);
            }
        }
        if ((titles = doc.body().select("*[id^=title],*[id$=title],*[class^=title],*[class$=title],*[id^=subject],*[id$=subject],*[class^=subject],*[class$=subject]")).size() > 0) {
            double max = 0.0;
            Element titleTarger = null;
            for (Element title : titles) {
                Elements titlesChild = title.children();
                if (titlesChild != null) {
                    for (Element element : titlesChild) {
                        String tagName = element.tagName();
                        if (Pattern.matches("h[1-6]", tagName)) {
                            return element;
                        }
                        double sim = TextUtils.strSim(element.text(), contentElement.text());
                        if (!(sim > max)) continue;
                        max = sim;
                        titleTarger = element;
                    }
                }
                if (max > 0.0) {
                    return titleTarger;
                }
                if (title.text().length() <= 5 || title.text().length() >= 40) continue;
                return title;
            }
        }
        return titleEl;
    }
}

