/*
 * Decompiled with CFR 0.152.
 */
package com.chinamcloud.haihe.common.spider.match;

import com.chinamcloud.haihe.backStageManagement.pojo.AppSpiderModel;
import com.chinamcloud.haihe.common.utils.HtmlUtils;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.concurrent.Future;
import org.apache.commons.lang3.StringUtils;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.springframework.scheduling.annotation.Async;
import org.springframework.scheduling.annotation.AsyncResult;
import org.springframework.stereotype.Component;

@Component
public class AppMatch {
    private static final Logger log = LogManager.getLogger(AppMatch.class);
    private static final List<String> exclude = new ArrayList<String>(4);

    @Async
    public Future<Integer> getDataByType(String htmlStr, String placeholder, AppSpiderModel referModel, Map<String, Object> map, String type) {
        int failedNum = 0;
        String typeName = "";
        switch (type) {
            case "reprint": {
                typeName = "\u6765\u6e90";
                break;
            }
            case "pubTime": {
                typeName = "\u53d1\u5e03\u65f6\u95f4";
                break;
            }
            case "description": {
                typeName = "\u5185\u5bb9";
                break;
            }
            case "subject": {
                typeName = "\u6807\u9898";
                break;
            }
            case "pics": {
                typeName = "\u56fe\u7247";
                break;
            }
            case "digest": {
                typeName = "\u6458\u8981";
                break;
            }
            case "refererUrl": {
                typeName = "\u539f\u6587\u5730\u5740";
                break;
            }
            case "video": {
                typeName = "\u89c6\u9891\u5730\u5740";
                break;
            }
            case "cover": {
                typeName = "\u5934\u56fe";
                break;
            }
        }
        log.info(typeName + "   \u5f00\u59cb\u5339\u914d\uff01\uff01\uff01\uff01\uff01\uff01\uff01");
        ArrayList<Object> targetList = new ArrayList<Object>();
        if (StringUtils.isNotBlank((CharSequence)placeholder)) {
            HtmlUtils.getDataByJson(htmlStr, placeholder, targetList);
        }
        if (referModel != null) {
            HtmlUtils.getDataByModel(htmlStr, referModel, targetList);
        }
        if (targetList.isEmpty() || targetList.get(0) == null) {
            if (!exclude.contains(type) || !targetList.isEmpty() && targetList.get(0) == null) {
                map.put("msg", "\u83b7\u53d6" + typeName + "\u5931\u8d25\uff01");
                ++failedNum;
            }
        } else {
            map.put(type, targetList);
        }
        return new AsyncResult((Object)(failedNum > 0 ? 1 : 0));
    }

    static {
        exclude.add("pics");
        exclude.add("video");
        exclude.add("cover");
        exclude.add("digest");
    }
}

