/*
 * Decompiled with CFR 0.152.
 */
package com.chinamcloud.haihe.common.spider.pojo;

import java.util.ArrayList;
import java.util.HashMap;
import org.jsoup.nodes.Element;

public class CountInfo {
    int textCount = 0;
    int linkTextCount = 0;
    int tagCount = 0;
    int linkTagCount = 0;
    double density = 0.0;
    double densitySum = 0.0;
    double score = 0.0;
    int pCount = 0;
    ArrayList<Integer> leafList = new ArrayList();

    public static double computeScore(Element tag, HashMap<Element, CountInfo> infoMap) {
        CountInfo countInfo = infoMap.get(tag);
        double var = Math.sqrt(CountInfo.computeVar(countInfo.getLeafList()) + 1.0);
        double score = Math.log(var) * countInfo.getDensitySum() * Math.log(countInfo.getTextCount() - countInfo.getLinkTextCount() + 1) * Math.log10(countInfo.getPCount() + 2);
        return score;
    }

    public static double computeVar(ArrayList<Integer> data) {
        if (data.size() == 0) {
            return 0.0;
        }
        if (data.size() == 1) {
            return data.get(0) / 2;
        }
        double sum = 0.0;
        for (Integer i : data) {
            sum += (double)i.intValue();
        }
        double ave = sum / (double)data.size();
        sum = 0.0;
        for (Integer i : data) {
            sum += ((double)i.intValue() - ave) * ((double)i.intValue() - ave);
        }
        return sum /= (double)data.size();
    }

    public int getTextCount() {
        return this.textCount;
    }

    public int getLinkTextCount() {
        return this.linkTextCount;
    }

    public int getTagCount() {
        return this.tagCount;
    }

    public int getLinkTagCount() {
        return this.linkTagCount;
    }

    public double getDensity() {
        return this.density;
    }

    public double getDensitySum() {
        return this.densitySum;
    }

    public double getScore() {
        return this.score;
    }

    public int getPCount() {
        return this.pCount;
    }

    public ArrayList<Integer> getLeafList() {
        return this.leafList;
    }

    public void setTextCount(int textCount) {
        this.textCount = textCount;
    }

    public void setLinkTextCount(int linkTextCount) {
        this.linkTextCount = linkTextCount;
    }

    public void setTagCount(int tagCount) {
        this.tagCount = tagCount;
    }

    public void setLinkTagCount(int linkTagCount) {
        this.linkTagCount = linkTagCount;
    }

    public void setDensity(double density) {
        this.density = density;
    }

    public void setDensitySum(double densitySum) {
        this.densitySum = densitySum;
    }

    public void setScore(double score) {
        this.score = score;
    }

    public void setPCount(int pCount) {
        this.pCount = pCount;
    }

    public void setLeafList(ArrayList<Integer> leafList) {
        this.leafList = leafList;
    }

    public String toString() {
        return "CountInfo(textCount=" + this.getTextCount() + ", linkTextCount=" + this.getLinkTextCount() + ", tagCount=" + this.getTagCount() + ", linkTagCount=" + this.getLinkTagCount() + ", density=" + this.getDensity() + ", densitySum=" + this.getDensitySum() + ", score=" + this.getScore() + ", pCount=" + this.getPCount() + ", leafList=" + this.getLeafList() + ")";
    }
}

