/*
 * Decompiled with CFR 0.152.
 */
package com.chinamcloud.haihe.common.spider.utils;

import com.chinamcloud.haihe.common.spider.utils.TextUtils;
import org.apache.commons.lang3.StringUtils;
import org.jsoup.nodes.Document;
import org.jsoup.nodes.Element;
import org.jsoup.select.Elements;

public class ElementUtils {
    public static Integer getChildNum(Element element) {
        Integer time = 0;
        Elements children = element.children();
        if (children != null) {
            time = time + children.size();
            for (Element child : children) {
                time = time + ElementUtils.getChildNum(child);
            }
        }
        return time;
    }

    public static Element getMinElement(Element element) {
        Elements children = element.children();
        if (children != null) {
            for (Element child : children) {
                if (!(TextUtils.strSim(child.text(), element.text()) > 0.9)) continue;
                return ElementUtils.getMinElement(child);
            }
        }
        return element;
    }

    public static String getXpath(Element element, Document doc) {
        String tagName = element.tagName();
        if (tagName.equals("title")) {
            return null;
        }
        String id = element.id();
        if (StringUtils.isNotBlank((CharSequence)id)) {
            return "//" + tagName + "[@id=\"" + id + "\"]";
        }
        String className = element.className();
        Elements elementsByClass = null;
        if (StringUtils.isNotBlank((CharSequence)className)) {
            elementsByClass = doc.getElementsByClass(className);
        }
        Element parent = element.parent();
        if (elementsByClass == null || elementsByClass.size() > 1) {
            String xpathIndex = ElementUtils.getXpathIndex(parent, element);
            String xPath = ElementUtils.getXpath(parent, doc) + "/" + tagName;
            return xPath + xpathIndex;
        }
        return "//" + tagName + "[@class=\"" + className + "\"]";
    }

    public static String getXpathIndex(Element parent, Element target) {
        Elements elements = parent.children();
        String tagName = target.tagName();
        String className = target.className();
        String id = target.id();
        if (StringUtils.isNotBlank((CharSequence)id)) {
            return "[@id='" + id + "']";
        }
        int num = 0;
        int time = 0;
        int temp = 0;
        int size = elements.size();
        for (int i = 0; i < size; ++i) {
            String class_name;
            Element element = (Element)elements.get(i);
            String tag_name = element.tagName();
            if (StringUtils.isNotBlank((CharSequence)tag_name) && tagName.equals(tag_name)) {
                ++time;
            }
            if (StringUtils.isNotBlank((CharSequence)(class_name = element.className())) && StringUtils.isNotBlank((CharSequence)className) && className.equals(class_name)) {
                ++temp;
            }
            if (!element.equals((Object)target)) continue;
            num = i;
        }
        if (temp > 0) {
            return "[@class='" + className + "']";
        }
        if (time > 1) {
            return "[" + (num + 1) + "]";
        }
        return "";
    }
}

