/*
 * Decompiled with CFR 0.152.
 */
package com.chinamcloud.haihe.common.utils;

import com.chinamcloud.haihe.common.pojo.HotParams;
import com.chinamcloud.haihe.common.utils.SpringUtils;
import com.chinamcloud.haihe.common.utils.TopicKeywordUtils;
import com.chinamcloud.haihe.configService.service.RegionService;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.commons.lang3.StringUtils;

public class HotParamsUtils {
    private static RegionService regionService = SpringUtils.getBean(RegionService.class);

    public static void setKeyWord(HotParams params) {
        List<String> noKeyWords;
        String noKeyWord;
        HotParamsUtils.setRegional(params);
        List<String> keyWords = params.getKeyWords();
        String keyWord = TopicKeywordUtils.buildQueryByObjecttoStirng(keyWords);
        if (StringUtils.isNotBlank((CharSequence)keyWord)) {
            switch (params.getUseKeyWord() == null ? "" : params.getUseKeyWord()) {
                case "description": {
                    params.setDescription(keyWord);
                    break;
                }
                case "subject": 
                case "title": {
                    params.setSubject(keyWord);
                    break;
                }
                case "all": {
                    params.setDescription(keyWord);
                    params.setSubject(keyWord);
                    break;
                }
                default: {
                    params.setDescription(keyWord);
                }
            }
        }
        if (StringUtils.isNotBlank((CharSequence)(noKeyWord = TopicKeywordUtils.buildQueryByObjecttoStirng(noKeyWords = params.getNoKeywords())))) {
            switch (params.getUseKeyWord() == null ? "" : params.getUseKeyWord()) {
                case "description": {
                    params.setNoDescription(noKeyWord);
                    break;
                }
                case "subject": 
                case "title": {
                    params.setNoSubject(noKeyWord);
                    break;
                }
                case "all": {
                    params.setNoDescription(noKeyWord);
                    params.setNoSubject(noKeyWord);
                    break;
                }
                default: {
                    params.setNoDescription(noKeyWord);
                }
            }
        }
    }

    public static void setRegional(HotParams params) {
        List<String> province = params.getProvince();
        List<String> municipality = params.getMunicipality();
        List<String> prefecture = params.getPrefecture();
        List<Integer> regionIds = params.getRegionIds();
        params.setProvince(null);
        params.setMunicipality(null);
        params.setPrefecture(null);
        ArrayList<String> keyWords = new ArrayList<String>(16);
        keyWords.addAll(HotParamsUtils.getTreeByName(province));
        keyWords.addAll(HotParamsUtils.getTreeByName(municipality));
        keyWords.addAll(HotParamsUtils.getTreeByCode(regionIds));
        keyWords.addAll(prefecture == null ? Collections.EMPTY_LIST : prefecture);
        ArrayList<String> result = new ArrayList<String>(16);
        List<String> words = params.getKeyWords();
        if ("description".equalsIgnoreCase(params.getUseKeyWord())) {
            if (words != null) {
                if (keyWords.isEmpty()) {
                    result.addAll(words);
                } else {
                    for (String keyWord : keyWords) {
                        for (String word : words) {
                            result.add(keyWord + "," + word);
                        }
                    }
                }
            } else {
                result.addAll(keyWords);
            }
            params.setKeyWords(result);
        } else {
            String keyWord = TopicKeywordUtils.buildQueryByObjecttoStirng(keyWords);
            if (StringUtils.isNotBlank((CharSequence)keyWord)) {
                params.setDescription(keyWord);
            }
        }
    }

    private static List<String> getTreeByName(List<String> regionals) {
        if (regionals == null) {
            return Collections.EMPTY_LIST;
        }
        ArrayList<String> result = new ArrayList<String>(16);
        for (final String regional : regionals) {
            List<Map<String, Object>> mapList = regionService.getAddr((Map<String, String>)new HashMap<String, String>(){
                private static final long serialVersionUID = -855925909957662846L;
                {
                    this.put("name", regional);
                }
            }, true).getResult();
            if (mapList == null) continue;
            for (Map<String, Object> map : mapList) {
                result.add(map.get("name").toString());
                String code = map.get("code").toString();
                List<Map<String, Object>> trees = regionService.getAddrTree(code, true).getResult();
                if (trees == null) continue;
                for (Map<String, Object> tree : trees) {
                    result.add(tree.get("name").toString());
                }
            }
        }
        return result;
    }

    private static List<String> getTreeByCode(List<Integer> codes) {
        if (codes == null) {
            return Collections.EMPTY_LIST;
        }
        ArrayList<String> result = new ArrayList<String>(16);
        for (final Integer code_val : codes) {
            List<Map<String, Object>> mapList = regionService.getAddr((Map<String, String>)new HashMap<String, String>(){
                private static final long serialVersionUID = -855925909957662846L;
                {
                    this.put("code", code_val.toString());
                }
            }, true).getResult();
            if (mapList == null) continue;
            for (Map<String, Object> map : mapList) {
                result.add(map.get("name").toString());
                String code = map.get("code").toString();
                List<Map<String, Object>> trees = regionService.getAddrTree(code, true).getResult();
                if (trees == null) continue;
                for (Map<String, Object> tree : trees) {
                    result.add(tree.get("name").toString());
                }
            }
        }
        return result;
    }
}

