/*
 * Decompiled with CFR 0.152.
 */
package com.chinamcloud.haihe.common.utils;

import com.alibaba.fastjson.JSON;
import com.chinamcloud.haihe.backStageManagement.pojo.AppSpiderModel;
import com.chinamcloud.haihe.common.utils.HttpUtils;
import com.jayway.jsonpath.Configuration;
import com.jayway.jsonpath.JsonPath;
import com.jayway.jsonpath.Predicate;
import java.text.MessageFormat;
import java.util.Collection;
import java.util.List;
import org.apache.commons.lang3.StringUtils;
import us.codecraft.webmagic.selector.Html;

public class HtmlUtils {
    public static void getDataByXPath(Html html, List<String> xPaths, List<String> targetList) {
        if (xPaths == null) {
            return;
        }
        for (String xPath : xPaths) {
            String pubTimeValue = html.xpath(xPath).toString();
            if (!StringUtils.isNotBlank((CharSequence)pubTimeValue)) continue;
            targetList.add(pubTimeValue);
        }
    }

    public static void getDataListByXPath(Html html, List<String> xPaths, List<String> targetList) {
        if (xPaths == null) {
            return;
        }
        for (String xPath : xPaths) {
            List list = html.xpath(xPath).all();
            targetList.addAll(list);
        }
    }

    public static void getDataByRegex(Html html, List<String> regexs, List<String> targetList) {
        if (regexs == null) {
            return;
        }
        for (String regex : regexs) {
            String pubTimeValue = html.regex(regex, 0).toString();
            if (!StringUtils.isNotBlank((CharSequence)pubTimeValue)) continue;
            targetList.add(pubTimeValue);
        }
    }

    public static void getDataListByRegex(Html html, List<String> regexs, List<String> targetList) {
        if (regexs == null) {
            return;
        }
        for (String regex : regexs) {
            List list = html.regex(regex, 0).all();
            targetList.addAll(list);
        }
    }

    public static void getDataListByJson(String html, String placeholder, List<String> targetList) {
        if (StringUtils.isBlank((CharSequence)placeholder)) {
            return;
        }
        try {
            targetList.addAll((Collection)JsonPath.read((Object)Configuration.defaultConfiguration().jsonProvider().parse(JSON.parseObject((String)html).toJSONString()), (String)placeholder, (Predicate[])new Predicate[0]));
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public static void getDataByJson(String html, String placeholder, List<Object> targetList) {
        if (StringUtils.isNotBlank((CharSequence)placeholder)) {
            Object title = null;
            try {
                title = HtmlUtils.newsProcess(JsonPath.read((Object)Configuration.defaultConfiguration().jsonProvider().parse(JSON.parseObject((String)html).toJSONString()), (String)placeholder, (Predicate[])new Predicate[0]));
            }
            catch (Exception e) {
                e.printStackTrace();
            }
            if (title != null) {
                targetList.add(title.toString());
            }
        }
    }

    public static void getDataByModel(String html, AppSpiderModel referModel, List<Object> targetList) {
        Object refererUrl;
        if (referModel == null) {
            return;
        }
        String timeStamp = System.currentTimeMillis() + "";
        String path = referModel.getPath();
        String model = referModel.getModel();
        String placeholder = referModel.getPlaceholder();
        if (StringUtils.isNotBlank((CharSequence)path) && StringUtils.isNotBlank((CharSequence)model) && StringUtils.isNotBlank((CharSequence)placeholder)) {
            String newsId = HtmlUtils.newsProcess(JsonPath.read((Object)Configuration.defaultConfiguration().jsonProvider().parse(JSON.parseObject((String)html).toJSONString()), (String)placeholder, (Predicate[])new Predicate[0])).toString();
            HttpUtils.HttpRequestResult httpRequestResult = HttpUtils.executeGet(MessageFormat.format(model, newsId, timeStamp), null, "utf-8");
            String jsonResult = httpRequestResult.getMsg();
            String refererUrl2 = (String)JsonPath.parse((String)jsonResult).read(path, new Predicate[0]);
            targetList.add(refererUrl2);
        } else if (StringUtils.isNotBlank((CharSequence)model) && StringUtils.isNotBlank((CharSequence)placeholder)) {
            String newsId = HtmlUtils.newsProcess(JsonPath.read((Object)Configuration.defaultConfiguration().jsonProvider().parse(JSON.parseObject((String)html).toJSONString()), (String)placeholder, (Predicate[])new Predicate[0])).toString();
            String refererUrl3 = MessageFormat.format(model, newsId);
            targetList.add(refererUrl3);
        } else if (StringUtils.isNotBlank((CharSequence)path) && (refererUrl = HtmlUtils.newsProcess(JsonPath.read((Object)Configuration.defaultConfiguration().jsonProvider().parse(JSON.parseObject((String)html).toJSONString()), (String)path, (Predicate[])new Predicate[0]))) != null) {
            targetList.add(refererUrl.toString());
        }
    }

    private static Object newsProcess(Object obj) {
        List list;
        if (obj instanceof List && (list = (List)obj).size() > 0) {
            return list.get(0);
        }
        return obj;
    }
}

