/*
 * Decompiled with CFR 0.152.
 */
package com.chinamcloud.haihe.common.utils;

import com.chinamcloud.haihe.common.Exception.CustomException;
import com.chinamcloud.haihe.common.utils.NumberUtils;
import com.chinamcloud.haihe.common.utils.SpringUtils;
import com.chinamcloud.haihe.configService.mapper.HaiheAreaMapper;
import java.util.List;
import java.util.Map;
import org.apache.commons.lang3.StringUtils;

public class RegionUtils {
    private HaiheAreaMapper haiheAreaMapper = SpringUtils.getBean(HaiheAreaMapper.class);

    public String getLocation(String province, String municipality, String prefecture) {
        boolean provinceBool = StringUtils.isBlank((CharSequence)province);
        province = this.getAddrByCodeOrName(provinceBool, province);
        boolean municipalityBool = StringUtils.isBlank((CharSequence)municipality);
        municipality = this.getAddrByCodeOrName(municipalityBool, municipality);
        boolean prefectureBool = StringUtils.isBlank((CharSequence)prefecture);
        prefecture = this.getAddrByCodeOrName(prefectureBool, prefecture);
        if (!(provinceBool && municipalityBool && prefectureBool)) {
            return (provinceBool ? "" : (municipalityBool && prefectureBool ? province : province + "-")) + (municipalityBool ? "" : (prefectureBool ? municipality : municipality + "-")) + (prefectureBool ? "" : prefecture);
        }
        return null;
    }

    private String getAddrByCodeOrName(Boolean bool, String code) {
        if (!bool.booleanValue()) {
            List<Map<String, Object>> addr = NumberUtils.isNumeric(code) ? this.haiheAreaMapper.getAddr(Integer.valueOf(code), "") : this.haiheAreaMapper.getAddr(null, code);
            if (addr != null && !addr.isEmpty() && addr.get(0) != null && addr.get(0).get("name") != null) {
                return addr.get(0).get("name").toString();
            }
            throw new CustomException("site_address_error");
        }
        return code;
    }
}

