/*
 * Decompiled with CFR 0.152.
 */
package com.chinamcloud.haihe.common.utils;

import java.io.IOException;
import java.io.Reader;
import java.io.StringReader;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.wltea.analyzer.core.IKSegmenter;
import org.wltea.analyzer.core.Lexeme;

public class SimpleSummariserAlgorithm {
    public static String summarise(String input, int numSentences) {
        Map<String, Integer> wordFrequencies = SimpleSummariserAlgorithm.segStr(input);
        Set<String> mostFrequentWords = SimpleSummariserAlgorithm.getMostFrequentWords(100, wordFrequencies).keySet();
        String[] workingSentences = SimpleSummariserAlgorithm.getSentences(input.toLowerCase());
        String[] actualSentences = SimpleSummariserAlgorithm.getSentences(input);
        LinkedHashSet<String> outputSentences = new LinkedHashSet<String>();
        for (String word : mostFrequentWords) {
            for (int i = 0; i < workingSentences.length; ++i) {
                if (workingSentences[i].indexOf(word) >= 0) {
                    outputSentences.add(actualSentences[i]);
                    break;
                }
                if (outputSentences.size() >= numSentences) break;
            }
            if (outputSentences.size() < numSentences) continue;
            break;
        }
        List<String> reorderedOutputSentences = SimpleSummariserAlgorithm.reorderSentences(outputSentences, input);
        StringBuffer result = new StringBuffer("");
        Iterator<String> it = reorderedOutputSentences.iterator();
        while (it.hasNext()) {
            String sentence = it.next();
            result.append(sentence);
            result.append(".");
            if (!it.hasNext()) continue;
            result.append(" ");
        }
        return result.toString();
    }

    private static List<String> reorderSentences(Set<String> outputSentences, final String input) {
        ArrayList<String> result = new ArrayList<String>(outputSentences);
        Collections.sort(result, new Comparator<String>(){

            @Override
            public int compare(String arg0, String arg1) {
                String sentence1 = arg0;
                String sentence2 = arg1;
                int indexOfSentence1 = input.indexOf(sentence1.trim());
                int indexOfSentence2 = input.indexOf(sentence2.trim());
                int result = indexOfSentence1 - indexOfSentence2;
                return result;
            }
        });
        return result;
    }

    public static Map<String, Integer> getMostFrequentWords(int num, Map<String, Integer> words) {
        LinkedHashMap<String, Integer> keywords = new LinkedHashMap<String, Integer>();
        int count = 0;
        ArrayList<Map.Entry<String, Integer>> info = new ArrayList<Map.Entry<String, Integer>>(words.entrySet());
        Collections.sort(info, new Comparator<Map.Entry<String, Integer>>(){

            @Override
            public int compare(Map.Entry<String, Integer> obj1, Map.Entry<String, Integer> obj2) {
                return obj2.getValue() - obj1.getValue();
            }
        });
        for (int j = 0; j < info.size(); ++j) {
            if (((String)((Map.Entry)info.get(j)).getKey()).length() <= 1) continue;
            if (num <= count) break;
            keywords.put((String)((Map.Entry)info.get(j)).getKey(), (Integer)((Map.Entry)info.get(j)).getValue());
            ++count;
        }
        return keywords;
    }

    public static Map<String, Integer> segStr(String content) {
        StringReader input = new StringReader(content);
        IKSegmenter iks = new IKSegmenter((Reader)input, true);
        Lexeme lexeme = null;
        LinkedHashMap<String, Integer> words = new LinkedHashMap<String, Integer>();
        try {
            while ((lexeme = iks.next()) != null) {
                if (words.containsKey(lexeme.getLexemeText())) {
                    words.put(lexeme.getLexemeText(), (Integer)words.get(lexeme.getLexemeText()) + 1);
                    continue;
                }
                words.put(lexeme.getLexemeText(), 1);
            }
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        return words;
    }

    public static String[] getSentences(String input) {
        if (input == null) {
            return new String[0];
        }
        return input.split("(\\.|!|\\?)");
    }

    public static boolean isEmpty(String str) {
        return str == null || "".equals(str);
    }

    public static final String half2Full(String halfStr) {
        if (SimpleSummariserAlgorithm.isEmpty(halfStr)) {
            return halfStr;
        }
        char[] c = halfStr.toCharArray();
        for (int i = 0; i < c.length; ++i) {
            if (c[i] == ' ') {
                c[i] = 12288;
                continue;
            }
            if (c[i] >= '\u007f') continue;
            c[i] = (char)(c[i] + 65248);
        }
        return new String(c);
    }

    public static final String cToe(String str) {
        String[] regs = new String[]{"\uff01", "\uff0c", "\u3002", "\uff1b", "~", "\u300a", "\u300b", "\uff08", "\uff09", "\uff1f", "\u201d", "\uff5b", "\uff5d", "\u201c", "\uff1a", "\u3010", "\u3011", "\u201d", "\u2018", "\u2019", "!", ",", ".", ";", "`", "<", ">", "\\(", "\\)", "\\?", "'", "\\{", "}", "\"", ":", "\\{", "}", "\"", "'", "'"};
        for (int i = 0; i < regs.length / 2; ++i) {
            str = str.replaceAll(regs[i], regs[i + regs.length / 2]);
        }
        return str.replaceAll("\n", "").replaceAll("\r\n", "").replaceAll(" ", "").replaceAll("\u3000", "");
    }

    public static final String removeSymbol(String str) {
        String[] regs = new String[]{"\uff01", "\uff0c", "\u3002", "\uff1b", "~", "\u300a", "\u300b", "\uff08", "\uff09", "\uff1f", "\u201d", "\uff5b", "\uff5d", "\u201c", "\uff1a", "\u3010", "\u3011", "\u201d", "\u2018", "\u2019", "!", ",", ".", ";", "`", "<", ">", "\\(", "\\)", "\\?", "'", "\\{", "}", "\"", ":", "\\{", "}", "\"", "'", "'"};
        for (int i = 0; i < regs.length / 2; ++i) {
            str = str.replaceAll(regs[i], regs[i + regs.length / 2]);
        }
        String regEX = "[\n`~!@#$%^&*()+=|{}':;',\\[\\].<>/?~\uff01@#\uffe5%\u2026\u2026&*\uff08\uff09\u2014\u2014+|{}\u3010\u3011\u2018\uff1b\uff1a\u201d\u201c\u2019\u3002\uff0c \u3001\uff1f]";
        str = str.replaceAll(regEX, "");
        return str.replaceAll("\n", "").replaceAll("\r\n", "").replaceAll(" ", "").replaceAll("\u3000", "");
    }

    public static void main(String[] args) {
        String s = "\u3010\u8bdd\u9898\u3011\u7528\u6237\u6570\u91cf\u589e\u957f\u7f13\u6162\uff0c\u600e\u6837\u7a81\u7834\u521b\u4e1a\u56f0\u5883\uff1f\u3010\u80cc\u666f\u3011\u5c0f\u5f20\u540c\u5b66\u5728\u5c71\u4e1c\u67d0\u5730\u7ea7\u5e02\u505a\u5c0f\u5b66\u751f\u7ed8\u753b\u57f9\u8bad\uff0c\u5e02\u573a\u7ade\u4e89\u6fc0\u70c8\uff0c\u5979\u8bd5\u8fc7\u53bb\u5b66\u6821\u53d1\u4f20\u5355\u7b49\u7b49\u529e\u6cd5\uff0c\u4f46\u6536\u6548\u4e0d\u5927\uff0c\u5f88\u591a\u751f\u6e90\u88ab\u5b66\u6821\u8001\u5e08\u548c\u7ade\u4e89\u5bf9\u624b\u74dc\u5206\u4e86\u3002\u5c0f\u5f20\u540c\u5b66\u7684\u521b\u4e1a\u5206\u6210\u4e24\u90e8\u5206\uff0c\u65e2\u505a\u5c0f\u996d\u684c\uff0c\u53c8\u5728\u505a\u5c0f\u5b66\u751f\u7ed8\u753b\u57f9\u8bad\u548c\u624d\u827a\u57f9\u8bad\u30021\u3001\u5b66\u6821\u5468\u56f4\u6709\u5f88\u591a\u5c0f\u996d\u684c\uff0c\u5927\u5bb6\u90fd\u5728\u5b66\u6821\u95e8\u53e3\u6563\u53d1\u4f20\u5355\uff0c\u4ef7\u683c\u6218\u6b64\u8d77\u5f7c\u4f0f\uff0c\u670d\u52a1\u9879\u76ee\u5927\u540c\u5c0f\u5f02\uff0c\u7ade\u4e89\u5927\uff0c\u5c0f\u5f20\u540c\u5b66\u8d5a\u5230\u4e0d\u4ec0\u4e48\u94b1\uff0c\u600e\u4e48\u6269\u5927\u9879\u76ee\u5229\u6da6\uff1f2\u3001\u5c0f\u5f20\u540c\u5b66\u7ed8\u753b\u5f88\u68d2\uff0c\u5c0f\u5b66\u751f\u624d\u827a\u57f9\u8bad\u53c8\u8d5a\u94b1\uff0c\u4f46\u62db\u751f\u56f0\u96be\uff0c\u6709\u4e9b\u7ade\u4e89\u5bf9\u624b\u975e\u5e38\u5f3a\u608d\uff0c\u516b\u4ed9\u8fc7\u6d77\u5404\u663e\u795e\u901a\uff0c\u4e0d\u53ef\u80fd\u6b63\u9762\u4ea4\u950b\u3002\u800c\u5c0f\u5f20\u540c\u5b66\u6ca1\u6709\u62db\u751f\u7ecf\u9a8c\u3001\u4eba\u624b\u548c\u8d44\u91d1\u90fd\u4e0d\u8db3\u3002\u3010\u95ee\u9898\u30111\u3001\u5982\u4f55\u66f4\u7a33\u5b9a\u6269\u5927\u5c0f\u996d\u684c\u4eba\u6570\uff1f2\u3001\u624d\u827a\u57f9\u8bad\u5982\u4f55\u5feb\u901f\u62db\u751f\u6210\u529f\uff1f\u6709\u6ca1\u6709\u4ec0\u4e48\u6377\u5f84\u53ef\u8d70\uff1f\u3010\u6574\u7406\u8005\u3011\u5fd7\u613f\u8005|\u738b\u535a|\u5546\u4e1a\u6848\u4f8b\u4e0b\u9762\u6211\u4eec\u5c31\u6765\u4e00\u8d77\u770b\u770b\uff0c\u672c\u671f\u6709\u54ea\u51e0\u4f4d\u540c\u5b66\u7684\u7cbe\u5f69\u8ba8\u8bba\u88ab\u9009\u4e2d\u3002\u7528\u6237\u6570\u91cf\u589e\u957f\u7f13\u6162\uff0c\u600e\u6837\u7a81\u7834\u521b\u4e1a\u56f0\u5883\uff1f\u6708\u5149\u503e\u57ce\u4e0a\u53488:48\u7528\u6237\u589e\u957f\u7f13\u6162\u600e\u4e48\u529e\uff1f1\u3001\u5728\u81ea\u5df1\u80fd\u505a\u597d\u670d\u52a1\u7684\u8303\u56f4\u5185\uff0c\u600e\u4e48\u6837\u7684\u589e\u957f\u662f\u81ea\u5df1\u671f\u671b\u7684\u589e\u957f\uff1f2\u3001\u786e\u5b9a\u597d\u589e\u957f\u7684\u9700\u6c42\uff0c\u518d\u5bfb\u627e\u589e\u957f\u7684\u65b9\u5f0f\u30023\u3001\u4e00\u4e2a\u573a\u5730\u505a\u4e09\u9879\u7ecf\u8425\uff0c\u60f3\u8d5a\u94b1\u7684\u5fc3\u60c5\u592a\u8feb\u5207\u4e86\u3002\u76d8\u70b9\u597d\u54ea\u4e9b\u662f\u81ea\u5df1\u7684\u4f18\u52bf\u54ea\u4e9b\u662f\u914d\u5957\u7ecf\u8425\u5218\u5168\u82b1\u4e0a\u53488:50 1\u3001\u5982\u4f55\u66f4\u7a33\u5b9a\u6269\u5927\u5c0f\u996d\u684c\u4eba\u6570\uff1f\u4f5c\u4e3a\u5bb6\u957f\uff0c\u627e\u57f9\u8bad\u673a\u6784\uff0c\u8981\u8003\u8651\u8fdc\u8fd1\uff0c\u8001\u5e08\u4eb2\u6c11\u5426\uff0c\u5bf9\u5b69\u5b50\u662f\u5426\u8db3\u591f\u5173\u5fc3\uff0c\u8db3\u591f\u70ed\u60c5\u3002\u53ef\u4ee5\u7528\u8001\u751f\u5e26\u65b0\u751f\uff0c\u6253\u597d\u6bcf\u5f20\u5b69\u5b50\u7684\u540d\u7247\u30022\u3001\u624d\u827a\u57f9\u8bad\u5982\u4f55\u5feb\u901f\u62db\u751f\u6210\u529f\uff1f\u6709\u6ca1\u6709\u4ec0\u4e48\u6377\u5f84\u53ef\u8d70\uff1f\u627f\u8bfa\u4e0d\u6ee1\u610f\u53ef\u4ee5\u9000\u6b3e\uff0c\u8db3\u591f\u7684\u4f18\u60e0\uff0c\u6bd4\u5982\u53ef\u4ee5\u591a\u770b\u4f1a\u5b69\u5b50\uff0c\u591a\u52a0\u4e9b\u8bfe\u7a0b\uff0c\u6bd5\u7adf\u5bb6\u957f\u4e0a\u73ed\u7684\u591a\u3002\u8ddf\u8001\u673a\u6784\u62a2\u751f\u6e90\uff0c\u53ef\u80fd\u4e0d\u5360\u4f18\u52bf\uff0c\u4e60\u60ef\u4e86\u8001\u673a\u6784\u7684\u5bb6\u957f\uff0c\u4e00\u822c\u4e0d\u613f\u610f\u627f\u62c5\u98ce\u9669\uff0c\u9664\u975e\u65b0\u673a\u6784\u8db3\u591f\u8db3\u591f\u7684\u4e13\u4e1a\uff0c\u8db3\u591f\u4fe1\u8d56\u53ef\u9760\u3002\u5362\u7476\u4e0a\u53489:01 1\u3001\u5f00\u5c55\u3010\u5bfb\u627e\u5c0f\u5c0f\u8bd5\u5403\u5b98\u3011\u6d3b\u52a8\uff0c\u6240\u6709\u7ebf\u4e0a\u62a5\u540d\u4e14\u8f6c\u53d1\u670b\u53cb\u5708\u7684\u5ba2\u6237\u4e2d\u62bd\u53d6N\u540d\u514d\u8d39\u8bd5\u5403\u4e09\u4e2a\u6708\uff08\u83b7\u53d6\u6f5c\u5728\u5ba2\u6237\u540d\u5355\uff0c\u57f9\u517b\u79cd\u5b50\u5ba2\u6237\uff0c\u540e\u7eed\u8ddf\u8e2a\u53e3\u7891\u8425\u9500\uff09\uff1b2\u3001\u3010\u8001\u5ba2\u6237\u9080\u8bf7\u65b0\u5ba2\u6237\u3011\u6bcf\u4eba\u9001\u4e00\u4e2a\u6708\u82b1\u6837\u52a0\u9910\uff08\u5361\u901a\u9910\u5305\u4e4b\u7c7b\u7684\uff0c\u5c0f\u670b\u53cb\u559c\u6b22\u6500\u6bd4\uff0c\u53ef\u4ee5\u7ed9\u4e24\u4e2a\u597d\u670b\u53cb\u62ff\u7740\u5361\u901a\u9910\u5305\u62cd\u7167\u53d1\u5708\uff09\u3002\u5c0f\u670b\u53cb\u4e4b\u95f4\u8001\u5e26\u65b0\u975e\u5e38\u6709\u6548\u3002\u674e\u5b97\u5458\uff08\u5bf0\u5b87\u5546\u8d38\uff09\u4e0a\u53489:31\u8fd9\u4e2a\u95ee\u9898\u7684\u672c\u8d28\u662f\u4e2a\u83b7\u5ba2\u7684\u95ee\u9898\u3002\u83b7\u5ba2\u6e20\u9053\u4e00\u822c\u662f\u7ebf\u4e0b\uff0c\u7ebf\u4e0a\u3002\u7ebf\u4e0b\u662f\u7f51\u5e972\u516c\u91cc\u5185\u53d1\u4f20\u5355\uff0c\u6821\u56ed\u5730\u63a8\uff0c\u5f02\u4e1a\u8054\u76df\uff0c\u6d3b\u52a8\u62c9\u65b0\uff0c\u8f6c\u4ecb\u7ecd\u3002\u7ebf\u4e0a\uff0c\u52a0\u5165\u5e73\u53f0\u83b7\u53d6\u6d41\u91cf\uff08\u5168\u56fd\uff0c\u884c\u4e1a\uff0c\u5730\u65b9\uff09\uff0c\u642d\u5efa\u79c1\u57df\u6d41\u91cf\uff0c\u793e\u7fa4\u88c2\u53d8\uff0c\u65b0\u5a92\u4f53\u63a8\u5e7f\u3002\u6d41\u91cf\u7684\u83b7\u53d6\u662f\u4e00\u4e2a\u7efc\u5408\u7684\u5de5\u4f5c\uff0c\u8981\u6839\u636e\u4f60\u5f53\u5730\u5f53\u65f6\u60c5\u51b5\u8c03\u6574\uff0c\u5728\u540c\u4e1a\u62c9\u65b0\u83b7\u5ba2\u7684\u4e3b\u5f62\u5f0f\u4e2d\uff0c\u627e\u5230\u5dee\u5f02\u5316\uff0c\u4fd7\u79f0\u6d41\u91cf\u6d3c\u5730\uff0c\u5c0f\u89c4\u6a21\u5c1d\u8bd5\uff0c\u5982\u679c\u6548\u679c\u597d\uff0c\u5168\u529b\u4e00\u535a\u3002\u6d3b\u7740\u4e0a\u534810:15\u5728\u4e00\u4e2a\u5404\u65b9\u9762\u90fd\u4e0d\u5360\u4f18\u52bf\u7684\u7ade\u4e89\u73af\u5883\u4e2d\uff0c\u552f\u4e00\u80fd\u8ba9\u4f60\u6d3b\u4e0b\u53bb\u7684\u529e\u6cd5\uff0c\u5c31\u662f\u771f\u529f\u592b\uff0c\u7528\u65f6\u95f4\u78e8\uff0c\u4e0d\u8981\u60f3\u505a\u8d5a\u5feb\u94b1\uff0c\u5f97\u5229\u7528\u81ea\u5df1\u7684\u4f18\u52bf\uff0c\uff08\u6bd4\u5982\u8bf4\u4f60\u753b\u753b\u5f97\u597d\uff09\u57f9\u517b\u51e0\u4e2a\u4f18\u79c0\u7684\u5b66\u5458\u51fa\u6765\uff0c\u5f62\u6210\u53e3\u7891\u4f20\u64ad\uff0c\u8fd9\u6837\u524d\u671f\u80af\u5b9a\u6162\u4e5f\u8d5a\u4e0d\u5230\u94b1\u3002\u4f46\u662f\u540e\u671f\u6548\u679c\u5e94\u8be5\u4f1a\u597d\u3002\u6240\u8c13\u7684\u7ed3\u786c\u5be8\uff0c\u6253\u5446\u6218\u3002\u5dee\u4e0d\u591a\u5c31\u8fd9\u6837\u5427\u3002\u9f99\u6f6d\u661f\u8dc3[\u8868\u60c5]\u2014\u2014[\u8868\u60c5]\u4e0b\u53489:08\u4eca\u5929\u7684\u56de\u7b54\u53ef\u80fd\u542c\u8d77\u6765\u6bd4\u8f83\u523a\u8033\uff0c\u5148\u8bf4\u58f0\u62b1\u6b491.\u6da6\u603b\u6709\u53e5\u8bdd\u8bf4\u201c\u4f60\u966a\u4f60\u5ba2\u6237\u559d\u4e0b\u53bb\u7684\u90a3\u4e9b\u9152\uff0c\u90fd\u662f\u4f60\u56e0\u4e3a\u505a\u4ea7\u54c1\u7684\u65f6\u5019\u6ca1\u6709\u6d41\u8fc7\u90a3\u4e9b\u6c57\u201d\uff0c\u6362\u53e5\u8bdd\u8bf4\uff0c\u3010\u8bdd\u9898\u3011\u7528\u6237\u6570\u91cf\u589e\u957f\u7f13\u6162\uff0c\u600e\u6837\u7a81\u7834\u521b\u4e1a\u56f0\u5883\uff1f\u3010\u80cc\u666f\u3011\u5c0f\u5f20\u540c\u5b66\u5728\u5c71\u4e1c\u67d0\u5730\u7ea7\u5e02\u505a\u5c0f\u5b66\u751f\u7ed8\u753b\u57f9\u8bad\uff0c\u5e02\u573a\u7ade\u4e89\u6fc0\u70c8\uff0c\u5979\u8bd5\u8fc7\u53bb\u5b66\u6821\u53d1\u4f20\u5355\u7b49\u7b49\u529e\u6cd5\uff0c\u4f46\u6536\u6548\u4e0d\u5927\uff0c\u5f88\u591a\u751f\u6e90\u88ab\u5b66\u6821\u8001\u5e08\u548c\u7ade\u4e89\u5bf9\u624b\u74dc\u5206\u4e86\u3002\u5c0f\u5f20\u540c\u5b66\u7684\u521b\u4e1a\u5206\u6210\u4e24\u90e8\u5206\uff0c\u65e2\u505a\u5c0f\u996d\u684c\uff0c\u53c8\u5728\u505a\u5c0f\u5b66\u751f\u7ed8\u753b\u57f9\u8bad\u548c\u624d\u827a\u57f9\u8bad\u30021\u3001\u5b66\u6821\u5468\u56f4\u6709\u5f88\u591a\u5c0f\u996d\u684c\uff0c\u5927\u5bb6\u90fd\u5728\u5b66\u6821\u95e8\u53e3\u6563\u53d1\u4f20\u5355\uff0c\u4ef7\u683c\u6218\u6b64\u8d77\u5f7c\u4f0f\uff0c\u670d\u52a1\u9879\u76ee\u5927\u540c\u5c0f\u5f02\uff0c\u7ade\u4e89\u5927\uff0c\u5c0f\u5f20\u540c\u5b66\u8d5a\u5230\u4e0d\u4ec0\u4e48\u94b1\uff0c\u600e\u4e48\u6269\u5927\u9879\u76ee\u5229\u6da6\uff1f2\u3001\u5c0f\u5f20\u540c\u5b66\u7ed8\u753b\u5f88\u68d2\uff0c\u5c0f\u5b66\u751f\u624d\u827a\u57f9\u8bad\u53c8\u8d5a\u94b1\uff0c\u4f46\u62db\u751f\u56f0\u96be\uff0c\u6709\u4e9b\u7ade\u4e89\u5bf9\u624b\u975e\u5e38\u5f3a\u608d\uff0c\u516b\u4ed9\u8fc7\u6d77\u5404\u663e\u795e\u901a\uff0c\u4e0d\u53ef\u80fd\u6b63\u9762\u4ea4\u950b\u3002\u800c\u5c0f\u5f20\u540c\u5b66\u6ca1\u6709\u62db\u751f\u7ecf\u9a8c\u3001\u4eba\u624b\u548c\u8d44\u91d1\u90fd\u4e0d\u8db3\u3002\u3010\u95ee\u9898\u30111\u3001\u5982\u4f55\u66f4\u7a33\u5b9a\u6269\u5927\u5c0f\u996d\u684c\u4eba\u6570\uff1f2\u3001\u624d\u827a\u57f9\u8bad\u5982\u4f55\u5feb\u901f\u62db\u751f\u6210\u529f\uff1f\u6709\u6ca1\u6709\u4ec0\u4e48\u6377\u5f84\u53ef\u8d70\uff1f\u3010\u6574\u7406\u8005\u3011\u5fd7\u613f\u8005|\u738b\u535a|\u5546\u4e1a\u6848\u4f8b\u4e0b\u9762\u6211\u4eec\u5c31\u6765\u4e00\u8d77\u770b\u770b\uff0c\u672c\u671f\u6709\u54ea\u51e0\u4f4d\u540c\u5b66\u7684\u7cbe\u5f69\u8ba8\u8bba\u88ab\u9009\u4e2d\u3002\u7528\u6237\u6570\u91cf\u589e\u957f\u7f13\u6162\uff0c\u600e\u6837\u7a81\u7834\u521b\u4e1a\u56f0\u5883\uff1f\u6708\u5149\u503e\u57ce\u4e0a\u53488:48\u7528\u6237\u589e\u957f\u7f13\u6162\u600e\u4e48\u529e\uff1f1\u3001\u5728\u81ea\u5df1\u80fd\u505a\u597d\u670d\u52a1\u7684\u8303\u56f4\u5185\uff0c\u600e\u4e48\u6837\u7684\u589e\u957f\u662f\u81ea\u5df1\u671f\u671b\u7684\u589e\u957f\uff1f2\u3001\u786e\u5b9a\u597d\u589e\u957f\u7684\u9700\u6c42\uff0c\u518d\u5bfb\u627e\u589e\u957f\u7684\u65b9\u5f0f\u30023\u3001\u4e00\u4e2a\u573a\u5730\u505a\u4e09\u9879\u7ecf\u8425\uff0c\u60f3\u8d5a\u94b1\u7684\u5fc3\u60c5\u592a\u8feb\u5207\u4e86\u3002\u76d8\u70b9\u597d\u54ea\u4e9b\u662f\u81ea\u5df1\u7684\u4f18\u52bf\u54ea\u4e9b\u662f\u914d\u5957\u7ecf\u8425\u5218\u5168\u82b1\u4e0a\u53488:50 1\u3001\u5982\u4f55\u66f4\u7a33\u5b9a\u6269\u5927\u5c0f\u996d\u684c\u4eba\u6570\uff1f\u4f5c\u4e3a\u5bb6\u957f\uff0c\u627e\u57f9\u8bad\u673a\u6784\uff0c\u8981\u8003\u8651\u8fdc\u8fd1\uff0c\u8001\u5e08\u4eb2\u6c11\u5426\uff0c\u5bf9\u5b69\u5b50\u662f\u5426\u8db3\u591f\u5173\u5fc3\uff0c\u8db3\u591f\u70ed\u60c5\u3002\u53ef\u4ee5\u7528\u8001\u751f\u5e26\u65b0\u751f\uff0c\u6253\u597d\u6bcf\u5f20\u5b69\u5b50\u7684\u540d\u7247\u30022\u3001\u624d\u827a\u57f9\u8bad\u5982\u4f55\u5feb\u901f\u62db\u751f\u6210\u529f\uff1f\u6709\u6ca1\u6709\u4ec0\u4e48\u6377\u5f84\u53ef\u8d70\uff1f\u627f\u8bfa\u4e0d\u6ee1\u610f\u53ef\u4ee5\u9000\u6b3e\uff0c\u8db3\u591f\u7684\u4f18\u60e0\uff0c\u6bd4\u5982\u53ef\u4ee5\u591a\u770b\u4f1a\u5b69\u5b50\uff0c\u591a\u52a0\u4e9b\u8bfe\u7a0b\uff0c\u6bd5\u7adf\u5bb6\u957f\u4e0a\u73ed\u7684\u591a\u3002\u8ddf\u8001\u673a\u6784\u62a2\u751f\u6e90\uff0c\u53ef\u80fd\u4e0d\u5360\u4f18\u52bf\uff0c\u4e60\u60ef\u4e86\u8001\u673a\u6784\u7684\u5bb6\u957f\uff0c\u4e00\u822c\u4e0d\u613f\u610f\u627f\u62c5\u98ce\u9669\uff0c\u9664\u975e\u65b0\u673a\u6784\u8db3\u591f\u8db3\u591f\u7684\u4e13\u4e1a\uff0c\u8db3\u591f\u4fe1\u8d56\u53ef\u9760\u3002\u5362\u7476\u4e0a\u53489:01 1\u3001\u5f00\u5c55\u3010\u5bfb\u627e\u5c0f\u5c0f\u8bd5\u5403\u5b98\u3011\u6d3b\u52a8\uff0c\u6240\u6709\u7ebf\u4e0a\u62a5\u540d\u4e14\u8f6c\u53d1\u670b\u53cb\u5708\u7684\u5ba2\u6237\u4e2d\u62bd\u53d6N\u540d\u514d\u8d39\u8bd5\u5403\u4e09\u4e2a\u6708\uff08\u83b7\u53d6\u6f5c\u5728\u5ba2\u6237\u540d\u5355\uff0c\u57f9\u517b\u79cd\u5b50\u5ba2\u6237\uff0c\u540e\u7eed\u8ddf\u8e2a\u53e3\u7891\u8425\u9500\uff09\uff1b2\u3001\u3010\u8001\u5ba2\u6237\u9080\u8bf7\u65b0\u5ba2\u6237\u3011\u6bcf\u4eba\u9001\u4e00\u4e2a\u6708\u82b1\u6837\u52a0\u9910\uff08\u5361\u901a\u9910\u5305\u4e4b\u7c7b\u7684\uff0c\u5c0f\u670b\u53cb\u559c\u6b22\u6500\u6bd4\uff0c\u53ef\u4ee5\u7ed9\u4e24\u4e2a\u597d\u670b\u53cb\u62ff\u7740\u5361\u901a\u9910\u5305\u62cd\u7167\u53d1\u5708\uff09\u3002\u5c0f\u670b\u53cb\u4e4b\u95f4\u8001\u5e26\u65b0\u975e\u5e38\u6709\u6548\u3002\u674e\u5b97\u5458\uff08\u5bf0\u5b87\u5546\u8d38\uff09\u4e0a\u53489:31\u8fd9\u4e2a\u95ee\u9898\u7684\u672c\u8d28\u662f\u4e2a\u83b7\u5ba2\u7684\u95ee\u9898\u3002\u83b7\u5ba2\u6e20\u9053\u4e00\u822c\u662f\u7ebf\u4e0b\uff0c\u7ebf\u4e0a\u3002\u7ebf\u4e0b\u662f\u7f51\u5e972\u516c\u91cc\u5185\u53d1\u4f20\u5355\uff0c\u6821\u56ed\u5730\u63a8\uff0c\u5f02\u4e1a\u8054\u76df\uff0c\u6d3b\u52a8\u62c9\u65b0\uff0c\u8f6c\u4ecb\u7ecd\u3002\u7ebf\u4e0a\uff0c\u52a0\u5165\u5e73\u53f0\u83b7\u53d6\u6d41\u91cf\uff08\u5168\u56fd\uff0c\u884c\u4e1a\uff0c\u5730\u65b9\uff09\uff0c\u642d\u5efa\u79c1\u57df\u6d41\u91cf\uff0c\u793e\u7fa4\u88c2\u53d8\uff0c\u65b0\u5a92\u4f53\u63a8\u5e7f\u3002\u6d41\u91cf\u7684\u83b7\u53d6\u662f\u4e00\u4e2a\u7efc\u5408\u7684\u5de5\u4f5c\uff0c\u8981\u6839\u636e\u4f60\u5f53\u5730\u5f53\u65f6\u60c5\u51b5\u8c03\u6574\uff0c\u5728\u540c\u4e1a\u62c9\u65b0\u83b7\u5ba2\u7684\u4e3b\u5f62\u5f0f\u4e2d\uff0c\u627e\u5230\u5dee\u5f02\u5316\uff0c\u4fd7\u79f0\u6d41\u91cf\u6d3c\u5730\uff0c\u5c0f\u89c4\u6a21\u5c1d\u8bd5\uff0c\u5982\u679c\u6548\u679c\u597d\uff0c\u5168\u529b\u4e00\u535a\u3002\u6d3b\u7740\u4e0a\u534810:15\u5728\u4e00\u4e2a\u5404\u65b9\u9762\u90fd\u4e0d\u5360\u4f18\u52bf\u7684\u7ade\u4e89\u73af\u5883\u4e2d\uff0c\u552f\u4e00\u80fd\u8ba9\u4f60\u6d3b\u4e0b\u53bb\u7684\u529e\u6cd5\uff0c\u5c31\u662f\u771f\u529f\u592b\uff0c\u7528\u65f6\u95f4\u78e8\uff0c\u4e0d\u8981\u60f3\u505a\u8d5a\u5feb\u94b1\uff0c\u5f97\u5229\u7528\u81ea\u5df1\u7684\u4f18\u52bf\uff0c\uff08\u6bd4\u5982\u8bf4\u4f60\u753b\u753b\u5f97\u597d\uff09\u57f9\u517b\u51e0\u4e2a\u4f18\u79c0\u7684\u5b66\u5458\u51fa\u6765\uff0c\u5f62\u6210\u53e3\u7891\u4f20\u64ad\uff0c\u8fd9\u6837\u524d\u671f\u80af\u5b9a\u6162\u4e5f\u8d5a\u4e0d\u5230\u94b1\u3002\u4f46\u662f\u540e\u671f\u6548\u679c\u5e94\u8be5\u4f1a\u597d\u3002\u6240\u8c13\u7684\u7ed3\u786c\u5be8\uff0c\u6253\u5446\u6218\u3002\u5dee\u4e0d\u591a\u5c31\u8fd9\u6837\u5427\u3002\u9f99\u6f6d\u661f\u8dc3[\u8868\u60c5]\u2014\u2014[\u8868\u60c5]\u4e0b\u53489:08\u4eca\u5929\u7684\u56de\u7b54\u53ef\u80fd\u542c\u8d77\u6765\u6bd4\u8f83\u523a\u8033\uff0c\u5148\u8bf4\u58f0\u62b1\u6b491.\u6da6\u603b\u6709\u53e5\u8bdd\u8bf4\u201c\u4f60\u966a\u4f60\u5ba2\u6237\u559d\u4e0b\u53bb\u7684\u90a3\u4e9b\u9152\uff0c\u90fd\u662f\u4f60\u56e0\u4e3a\u505a\u4ea7\u54c1\u7684\u65f6\u5019\u6ca1\u6709\u6d41\u8fc7\u90a3\u4e9b\u6c57\u201d\uff0c\u6362\u53e5\u8bdd\u8bf4\uff0c\u5c31\u662f\u5728\u7528\u6218\u672f\u4e0a\u7684\u52e4\u594b\u6765\u63a9\u76d6\u6218\u7565\u4e0a\u7684\u61d2\u60f0\u3002\u9996\u5148\uff0c\u6211\u60f3\u5bf9\u4e8e\u4e94\u5546\u7684\u5b66\u5458\uff0c\u4e0d\u7ba1\u662f\u521b\u4e1a\u8fd8\u662f\u8bf4\u505a\u5546\u4e1a\uff0c\u8981\u6c42\u8d77\u7801\u8981\u9ad8\u4e00\u70b9\u5427\u3002\u6240\u4ee5\uff0c\u6211\u60f3\u63d0\u51e0\u4e2a\u95ee\u9898\uff1a\u5c0f\u996d\u684c\u7684\u7528\u6237\u662f\u8c01\uff1f\u8fd9\u4e9b\u7ed9\u7528\u6237\u7684\u6838\u5fc3\u9700\u6c42\u662f\u4ec0\u4e48\uff1f\u5c0f\u5f20\u7684\u5c0f\u996d\u684c\u80fd\u63d0\u4f9b\u4ec0\u4e48\uff1f\u5728\u6ee1\u8db3\u7528\u6237\u6838\u5fc3\u9700\u6c42\u65b9\u9762\uff0c\u6709\u4ec0\u4e48\u4f18\u52bf\uff1f\u6ca1\u56de\u7b54\u6e05\u695a\u8fd9\u51e0\u4e2a\u95ee\u9898\u4e4b\u524d\uff0c\u4efb\u4f55\u6d3b\u52a8\u4e0d\u8981\u505a\uff0c\u4efb\u4f55\u6d3b\u52a8\u4e0d\u8981\u505a\uff0c\u4efb\u4f55\u6d3b\u52a8\u4e0d\u8981\u505a\uff0c\u975e\u5e38\u91cd\u8981\uff0c\u5c31\u7b97\u662f\u770b\u8d77\u6765\u518d\u6709\u6548\u7684\u6d3b\u52a8\u90fd\u4e0d\u8981\u505a\uff0c\u5c24\u5176\u662f\u4f18\u60e0\u7c7b\u7684\u3002\u505a\u4e86\u5c31\u662f\u996e\u9e29\u6b62\u6e34\uff0c\u90fd\u662f\u540c\u4e00\u884c\u4e1a\u7684\uff0c\u79bb\u5f97\u4e5f\u4e0d\u8fdc\uff0c\u9664\u975e\u662f\u80fd\u5f62\u6210\u62a4\u57ce\u6cb3\uff0c\u5426\u5219\uff0c\u4efb\u4f55\u6d3b\u52a8\u90fd\u6ca1\u6709\u79d8\u5bc6\uff0c\u4f60\u505a\u4e86\u5982\u679c\u6ca1\u6548\u679c\u5c31\u662f\u767d\u8d39\u529b\uff0c\u5982\u679c\u6709\u6548\u679c\u5176\u4ed6\u4eba\u7acb\u9a6c\u5c31\u4f1a\u8ddf\u8fdb\u3002\u4e00\u5207\u53c8\u56de\u5230\u539f\u6765\u7684\u72b6\u6001\uff0c\u4f46\u6bcf\u4e2a\u5c0f\u996d\u684c\u7ecf\u8425\u8005\u7684\u5de5\u4f5c\u91cf\u5374\u589e\u52a0\u4e86\uff0c\u56e0\u4e3a\u8c01\u90fd\u4e0d\u6562\u505c\u3002\u6240\u4ee5\uff0c\u5148\u89e3\u51b3\u4e0a\u9762\u7684\u56db\u4e2a\u95ee\u9898\uff0c\u89e3\u51b3\u5b8c\u4e86\u4ee5\u540e\uff0c\u5176\u4ed6\u65b9\u6cd5\u90fd\u662f\u9526\u4e0a\u6dfb\u82b1\u30022.\u8fd8\u662f\u4e00\u4e2a\u5f88\u96be\u4ee5\u63a5\u53d7\u7684\u4e8b\uff0c\u4ece\u201c\u5c0f\u5f20\u540c\u5b66\u7ed8\u753b\u5f88\u68d2\u201d\u8fd9\u4e00\u53e5\u53ef\u4ee5\u53d1\u73b0\uff0c\u4e0d\u7ba1\u662f\u9898\u4e3b\u8fd8\u662f\u5c0f\u5f20\u90fd\u5bf9\u884c\u4e1a\u7f3a\u4e4f\u4e00\u4e2a\u6e05\u695a\u7684\u8ba4\u8bc6\u3002\u201c\u7ed8\u753b\u5f88\u68d2\u201d\u4e0d\u662f\u7ade\u4e89\u529b\uff0c\u201c\u7ed8\u753b\u6c34\u5e73\u8fdc\u8fdc\u8d85\u8fc7\u5176\u4ed6\u5bb6\u201d\u624d\u662f\uff0c\u201c\u6559\u5b66\u6c34\u5e73\u8fdc\u8fdc\u8d85\u8fc7\u5176\u4ed6\u5bb6\u201d\u624d\u662f\u3002\u201c\u7ed8\u753b\u5f88\u68d2\u201d\u662f\u5fc5\u9700\u7684\u70b9\uff0c\u800c\u4e0d\u662f\u53ef\u4ee5\u4f5c\u4e3a\u6bd4\u8f83\u4f18\u52bf\u7684\u70b9\u3002\u6da6\u603b\u5b9e\u6218\u7bc7\u91cc\u7b2c96\u8282\u300a\u4ea7\u54c1\u5316\uff1a\u4f60\u662f\u8eab\u6000\u7edd\u6280\u7684\u4e00\u7ec4\u80fd\u529b\uff0c\u8fd8\u662f\u7528\u6237\u754c\u9762\u53cb\u597d\u7684\u4ea7\u54c1\u300b\u662f\u6700\u597d\u7684\u836f\uff0c\u62db\u751f\u6ca1\u6709\u6377\u5f84\uff0c\u6700\u8d77\u7801\u662f\u6ca1\u6709\u5b89\u5168\u7684\u6377\u5f84\u3002\u513f\u7ae5\u57f9\u8bad\u6700\u7279\u6b8a\u7684\u70b9\u5728\u4e8e\uff0c\u638f\u94b1\u7684\u4eba\u4e0d\u662f\u8981\u4e0a\u8bfe\u7684\u5b69\u5b50\uff0c\u800c\u662f\u5bb6\u957f\u3002\u800c\u963b\u6b62\u5bb6\u957f\u638f\u94b1\u7684\u6700\u5927\u963b\u788d\uff0c\u5c31\u662f\u4fe1\u4efb\u6216\u8005\u8bf4\u4fe1\u606f\u7684\u4e0d\u5bf9\u79f0\u3002\u800c\u514b\u670d\u8fd9\u4e2a\u4e0d\u5bf9\u79f0\u7684\u6700\u597d\u529e\u6cd5\uff0c\u5c31\u662f\u9ad8\u5ea6\u4ea7\u54c1\u5316\u7684\u8bfe\u7a0b\u7684\u5c55\u793a\u3002\u60f3\u60f3\u6da6\u603b\u4e94\u5546\u662f\u600e\u4e48\u4e00\u6b65\u6b65\u6253\u78e8\u51fa\u6765\u7684\uff0c\u8fd9\u5c31\u662f\u6a21\u677f\u3002\u89e6\u624b\u53ef\u5f97\u7684\u4e1c\u897f\u6c38\u8fdc\u6bd4\u865a\u65e0\u7f25\u7f08\u7684\u627f\u8bfa\u66f4\u8ba9\u4eba\u4fe1\u4efb\uff0c\u4e00\u672c\u62cd\u5728\u5bb6\u957f\u9762\u524d\u539a\u539a\u7684\u6559\u6848\u4e5f\u4e00\u5b9a\u4f1a\u6bd4\u7a7a\u53e3\u7684\u8bb8\u8bfa\u66f4\u52a0\u8ba9\u4eba\u5b89\u5fc3\u3002\u5982\u679c\u80fd\u591f\u52a0\u4e0a\u4e4b\u524d\u5b66\u5458\u7684\u5c55\u793a\u4ee5\u53ca\u5b8c\u5907\u7684\u5b66\u5458\u6863\u6848\u8fd9\u4e9b\u4e1c\u897f\uff0c\u8f6c\u5316\u7387\u4e0a\u7684\u4f18\u52bf\u5c31\u5df2\u7ecf\u4e0d\u662f\u4efb\u4f55\u6d41\u91cf\u4e0a\u7684\u6377\u5f84\u80fd\u6218\u80dc\u7684\u4e86\u3002\u5343\u94a7\u77f3\u4e0a\u4e07\u4ede\u5c71\uff0c\u8fd9\u5c31\u662f\u6211\u8f88\u4e94\u5546\u4eba\u7684\u82df\u4e14\u7ea2\u5229\u3002\u5143\u5b9e\u4e0b\u534810:15\u5dee\u5f02\u5316\u3002\u5c0f\u996d\u684c\u6bd4\u4ef7\u683c\u4e0d\u662f\u6b63\u9053\uff0c\u6bd4\u8425\u517b\u6bd4\u54c1\u8d28\u624d\u662f\u6b63\u9053\u3002\u7f8e\u672f\u62db\u751f\u548c\u5176\u4ed6\u57f9\u8bad\u4e00\u6837\uff0c\u9760\u53e3\u7891\u3002\u4f60\u57f9\u517b\u51e0\u4e2a\u4f18\u79c0\u5b66\u751f\u6bd4\u4ec0\u4e48\u5e7f\u544a\u90fd\u5f3a\u3002\u518d\u8bf4\u5dee\u5f02\u5316\u3002\u5982\u679c\u6d88\u8d39\u80fd\u529b\u591f\uff0c\u5c31\u521b\u9020\u827a\u672f\u6c1b\u56f4\uff0c\u5403\u827a\u672f\u9910\uff1b\u5982\u679c\u6d88\u8d39\u80fd\u529b\u4e0d\u591f\uff0c\u5c31\u624e\u5b9e\u505a\u6559\u80b2\uff0c\u597d\u5b66\u751f\u6210\u5c31\u597d\u8001\u5e08\uff01\u3010\u8bdd\u9898\u3011\u7528\u6237\u6570\u91cf\u589e\u957f\u7f13\u6162\uff0c\u600e\u6837\u7a81\u7834\u521b\u4e1a\u56f0\u5883\uff1f\u3010\u80cc\u666f\u3011\u5c0f\u5f20\u540c\u5b66\u5728\u5c71\u4e1c\u67d0\u5730\u7ea7\u5e02\u505a\u5c0f\u5b66\u751f\u7ed8\u753b\u57f9\u8bad\uff0c\u5e02\u573a\u7ade\u4e89\u6fc0\u70c8\uff0c\u5979\u8bd5\u8fc7\u53bb\u5b66\u6821\u53d1\u4f20\u5355\u7b49\u7b49\u529e\u6cd5\uff0c\u4f46\u6536\u6548\u4e0d\u5927\uff0c\u5f88\u591a\u751f\u6e90\u88ab\u5b66\u6821\u8001\u5e08\u548c\u7ade\u4e89\u5bf9\u624b\u74dc\u5206\u4e86\u3002\u5c0f\u5f20\u540c\u5b66\u7684\u521b\u4e1a\u5206\u6210\u4e24\u90e8\u5206\uff0c\u65e2\u505a\u5c0f\u996d\u684c\uff0c\u53c8\u5728\u505a\u5c0f\u5b66\u751f\u7ed8\u753b\u57f9\u8bad\u548c\u624d\u827a\u57f9\u8bad\u30021\u3001\u5b66\u6821\u5468\u56f4\u6709\u5f88\u591a\u5c0f\u996d\u684c\uff0c\u5927\u5bb6\u90fd\u5728\u5b66\u6821\u95e8\u53e3\u6563\u53d1\u4f20\u5355\uff0c\u4ef7\u683c\u6218\u6b64\u8d77\u5f7c\u4f0f\uff0c\u670d\u52a1\u9879\u76ee\u5927\u540c\u5c0f\u5f02\uff0c\u7ade\u4e89\u5927\uff0c\u5c0f\u5f20\u540c\u5b66\u8d5a\u5230\u4e0d\u4ec0\u4e48\u94b1\uff0c\u600e\u4e48\u6269\u5927\u9879\u76ee\u5229\u6da6\uff1f2\u3001\u5c0f\u5f20\u540c\u5b66\u7ed8\u753b\u5f88\u68d2\uff0c\u5c0f\u5b66\u751f\u624d\u827a\u57f9\u8bad\u53c8\u8d5a\u94b1\uff0c\u4f46\u62db\u751f\u56f0\u96be\uff0c\u6709\u4e9b\u7ade\u4e89\u5bf9\u624b\u975e\u5e38\u5f3a\u608d\uff0c\u516b\u4ed9\u8fc7\u6d77\u5404\u663e\u795e\u901a\uff0c\u4e0d\u53ef\u80fd\u6b63\u9762\u4ea4\u950b\u3002\u800c\u5c0f\u5f20\u540c\u5b66\u6ca1\u6709\u62db\u751f\u7ecf\u9a8c\u3001\u4eba\u624b\u548c\u8d44\u91d1\u90fd\u4e0d\u8db3\u3002\u3010\u95ee\u9898\u30111\u3001\u5982\u4f55\u66f4\u7a33\u5b9a\u6269\u5927\u5c0f\u996d\u684c\u4eba\u6570\uff1f2\u3001\u624d\u827a\u57f9\u8bad\u5982\u4f55\u5feb\u901f\u62db\u751f\u6210\u529f\uff1f\u6709\u6ca1\u6709\u4ec0\u4e48\u6377\u5f84\u53ef\u8d70\uff1f\u3010\u6574\u7406\u8005\u3011\u5fd7\u613f\u8005|\u738b\u535a|\u5546\u4e1a\u6848\u4f8b\u4e0b\u9762\u6211\u4eec\u5c31\u6765\u4e00\u8d77\u770b\u770b\uff0c\u672c\u671f\u6709\u54ea\u51e0\u4f4d\u540c\u5b66\u7684\u7cbe\u5f69\u8ba8\u8bba\u88ab\u9009\u4e2d\u3002\u7528\u6237\u6570\u91cf\u589e\u957f\u7f13\u6162\uff0c\u600e\u6837\u7a81\u7834\u521b\u4e1a\u56f0\u5883\uff1f\u6708\u5149\u503e\u57ce\u4e0a\u53488:48\u7528\u6237\u589e\u957f\u7f13\u6162\u600e\u4e48\u529e\uff1f1\u3001\u5728\u81ea\u5df1\u80fd\u505a\u597d\u670d\u52a1\u7684\u8303\u56f4\u5185\uff0c\u600e\u4e48\u6837\u7684\u589e\u957f\u662f\u81ea\u5df1\u671f\u671b\u7684\u589e\u957f\uff1f2\u3001\u786e\u5b9a\u597d\u589e\u957f\u7684\u9700\u6c42\uff0c\u518d\u5bfb\u627e\u589e\u957f\u7684\u65b9\u5f0f\u30023\u3001\u4e00\u4e2a\u573a\u5730\u505a\u4e09\u9879\u7ecf\u8425\uff0c\u60f3\u8d5a\u94b1\u7684\u5fc3\u60c5\u592a\u8feb\u5207\u4e86\u3002\u76d8\u70b9\u597d\u54ea\u4e9b\u662f\u81ea\u5df1\u7684\u4f18\u52bf\u54ea\u4e9b\u662f\u914d\u5957\u7ecf\u8425\u5218\u5168\u82b1\u4e0a\u53488:50 1\u3001\u5982\u4f55\u66f4\u7a33\u5b9a\u6269\u5927\u5c0f\u996d\u684c\u4eba\u6570\uff1f\u4f5c\u4e3a\u5bb6\u957f\uff0c\u627e\u57f9\u8bad\u673a\u6784\uff0c\u8981\u8003\u8651\u8fdc\u8fd1\uff0c\u8001\u5e08\u4eb2\u6c11\u5426\uff0c\u5bf9\u5b69\u5b50\u662f\u5426\u8db3\u591f\u5173\u5fc3\uff0c\u8db3\u591f\u70ed\u60c5\u3002\u53ef\u4ee5\u7528\u8001\u751f\u5e26\u65b0\u751f\uff0c\u6253\u597d\u6bcf\u5f20\u5b69\u5b50\u7684\u540d\u7247\u30022\u3001\u624d\u827a\u57f9\u8bad\u5982\u4f55\u5feb\u901f\u62db\u751f\u6210\u529f\uff1f\u6709\u6ca1\u6709\u4ec0\u4e48\u6377\u5f84\u53ef\u8d70\uff1f\u627f\u8bfa\u4e0d\u6ee1\u610f\u53ef\u4ee5\u9000\u6b3e\uff0c\u8db3\u591f\u7684\u4f18\u60e0\uff0c\u6bd4\u5982\u53ef\u4ee5\u591a\u770b\u4f1a\u5b69\u5b50\uff0c\u591a\u52a0\u4e9b\u8bfe\u7a0b\uff0c\u6bd5\u7adf\u5bb6\u957f\u4e0a\u73ed\u7684\u591a\u3002\u8ddf\u8001\u673a\u6784\u62a2\u751f\u6e90\uff0c\u53ef\u80fd\u4e0d\u5360\u4f18\u52bf\uff0c\u4e60\u60ef\u4e86\u8001\u673a\u6784\u7684\u5bb6\u957f\uff0c\u4e00\u822c\u4e0d\u613f\u610f\u627f\u62c5\u98ce\u9669\uff0c\u9664\u975e\u65b0\u673a\u6784\u8db3\u591f\u8db3\u591f\u7684\u4e13\u4e1a\uff0c\u8db3\u591f\u4fe1\u8d56\u53ef\u9760\u3002\u5362\u7476\u4e0a\u53489:01 1\u3001\u5f00\u5c55\u3010\u5bfb\u627e\u5c0f\u5c0f\u8bd5\u5403\u5b98\u3011\u6d3b\u52a8\uff0c\u6240\u6709\u7ebf\u4e0a\u62a5\u540d\u4e14\u8f6c\u53d1\u670b\u53cb\u5708\u7684\u5ba2\u6237\u4e2d\u62bd\u53d6N\u540d\u514d\u8d39\u8bd5\u5403\u4e09\u4e2a\u6708\uff08\u83b7\u53d6\u6f5c\u5728\u5ba2\u6237\u540d\u5355\uff0c\u57f9\u517b\u79cd\u5b50\u5ba2\u6237\uff0c\u540e\u7eed\u8ddf\u8e2a\u53e3\u7891\u8425\u9500\uff09\uff1b2\u3001\u3010\u8001\u5ba2\u6237\u9080\u8bf7\u65b0\u5ba2\u6237\u3011\u6bcf\u4eba\u9001\u4e00\u4e2a\u6708\u82b1\u6837\u52a0\u9910\uff08\u5361\u901a\u9910\u5305\u4e4b\u7c7b\u7684\uff0c\u5c0f\u670b\u53cb\u559c\u6b22\u6500\u6bd4\uff0c\u53ef\u4ee5\u7ed9\u4e24\u4e2a\u597d\u670b\u53cb\u62ff\u7740\u5361\u901a\u9910\u5305\u62cd\u7167\u53d1\u5708\uff09\u3002\u5c0f\u670b\u53cb\u4e4b\u95f4\u8001\u5e26\u65b0\u975e\u5e38\u6709\u6548\u3002\u674e\u5b97\u5458\uff08\u5bf0\u5b87\u5546\u8d38\uff09\u4e0a\u53489:31\u8fd9\u4e2a\u95ee\u9898\u7684\u672c\u8d28\u662f\u4e2a\u83b7\u5ba2\u7684\u95ee\u9898\u3002\u83b7\u5ba2\u6e20\u9053\u4e00\u822c\u662f\u7ebf\u4e0b\uff0c\u7ebf\u4e0a\u3002\u7ebf\u4e0b\u662f\u7f51\u5e972\u516c\u91cc\u5185\u53d1\u4f20\u5355\uff0c\u6821\u56ed\u5730\u63a8\uff0c\u5f02\u4e1a\u8054\u76df\uff0c\u6d3b\u52a8\u62c9\u65b0\uff0c\u8f6c\u4ecb\u7ecd\u3002\u7ebf\u4e0a\uff0c\u52a0\u5165\u5e73\u53f0\u83b7\u53d6\u6d41\u91cf\uff08\u5168\u56fd\uff0c\u884c\u4e1a\uff0c\u5730\u65b9\uff09\uff0c\u642d\u5efa\u79c1\u57df\u6d41\u91cf\uff0c\u793e\u7fa4\u88c2\u53d8\uff0c\u65b0\u5a92\u4f53\u63a8\u5e7f\u3002\u6d41\u91cf\u7684\u83b7\u53d6\u662f\u4e00\u4e2a\u7efc\u5408\u7684\u5de5\u4f5c\uff0c\u8981\u6839\u636e\u4f60\u5f53\u5730\u5f53\u65f6\u60c5\u51b5\u8c03\u6574\uff0c\u5728\u540c\u4e1a\u62c9\u65b0\u83b7\u5ba2\u7684\u4e3b\u5f62\u5f0f\u4e2d\uff0c\u627e\u5230\u5dee\u5f02\u5316\uff0c\u4fd7\u79f0\u6d41\u91cf\u6d3c\u5730\uff0c\u5c0f\u89c4\u6a21\u5c1d\u8bd5\uff0c\u5982\u679c\u6548\u679c\u597d\uff0c\u5168\u529b\u4e00\u535a\u3002\u6d3b\u7740\u4e0a\u534810:15\u5728\u4e00\u4e2a\u5404\u65b9\u9762\u90fd\u4e0d\u5360\u4f18\u52bf\u7684\u7ade\u4e89\u73af\u5883\u4e2d\uff0c\u552f\u4e00\u80fd\u8ba9\u4f60\u6d3b\u4e0b\u53bb\u7684\u529e\u6cd5\uff0c\u5c31\u662f\u771f\u529f\u592b\uff0c\u7528\u65f6\u95f4\u78e8\uff0c\u4e0d\u8981\u60f3\u505a\u8d5a\u5feb\u94b1\uff0c\u5f97\u5229\u7528\u81ea\u5df1\u7684\u4f18\u52bf\uff0c\uff08\u6bd4\u5982\u8bf4\u4f60\u753b\u753b\u5f97\u597d\uff09\u57f9\u517b\u51e0\u4e2a\u4f18\u79c0\u7684\u5b66\u5458\u51fa\u6765\uff0c\u5f62\u6210\u53e3\u7891\u4f20\u64ad\uff0c\u8fd9\u6837\u524d\u671f\u80af\u5b9a\u6162\u4e5f\u8d5a\u4e0d\u5230\u94b1\u3002\u4f46\u662f\u540e\u671f\u6548\u679c\u5e94\u8be5\u4f1a\u597d\u3002\u6240\u8c13\u7684\u7ed3\u786c\u5be8\uff0c\u6253\u5446\u6218\u3002\u5dee\u4e0d\u591a\u5c31\u8fd9\u6837\u5427\u3002\u9f99\u6f6d\u661f\u8dc3[\u8868\u60c5]\u2014\u2014[\u8868\u60c5]\u4e0b\u53489:08\u4eca\u5929\u7684\u56de\u7b54\u53ef\u80fd\u542c\u8d77\u6765\u6bd4\u8f83\u523a\u8033\uff0c\u5148\u8bf4\u58f0\u62b1\u6b491.\u6da6\u603b\u6709\u53e5\u8bdd\u8bf4\u201c\u4f60\u966a\u4f60\u5ba2\u6237\u559d\u4e0b\u53bb\u7684\u90a3\u4e9b\u9152\uff0c\u90fd\u662f\u4f60\u56e0\u4e3a\u505a\u4ea7\u54c1\u7684\u65f6\u5019\u6ca1\u6709\u6d41\u8fc7\u90a3\u4e9b\u6c57\u201d\uff0c\u6362\u53e5\u8bdd\u8bf4\uff0c\u5c31\u662f\u5728\u7528\u6218\u672f\u4e0a\u7684\u52e4\u594b\u6765\u63a9\u76d6\u6218\u7565\u4e0a\u7684\u61d2\u60f0\u3002\u9996\u5148\uff0c\u6211\u60f3\u5bf9\u4e8e\u4e94\u5546\u7684\u5b66\u5458\uff0c\u4e0d\u7ba1\u662f\u521b\u4e1a\u8fd8\u662f\u8bf4\u505a\u5546\u4e1a\uff0c\u8981\u6c42\u8d77\u7801\u8981\u9ad8\u4e00\u70b9\u5427\u3002\u6240\u4ee5\uff0c\u6211\u60f3\u63d0\u51e0\u4e2a\u95ee\u9898\uff1a\u5c0f\u996d\u684c\u7684\u7528\u6237\u662f\u8c01\uff1f\u8fd9\u4e9b\u7ed9\u7528\u6237\u7684\u6838\u5fc3\u9700\u6c42\u662f\u4ec0\u4e48\uff1f\u5c0f\u5f20\u7684\u5c0f\u996d\u684c\u80fd\u63d0\u4f9b\u4ec0\u4e48\uff1f\u5728\u6ee1\u8db3\u7528\u6237\u6838\u5fc3\u9700\u6c42\u65b9\u9762\uff0c\u6709\u4ec0\u4e48\u4f18\u52bf\uff1f\u6ca1\u56de\u7b54\u6e05\u695a\u8fd9\u51e0\u4e2a\u95ee\u9898\u4e4b\u524d\uff0c\u4efb\u4f55\u6d3b\u52a8\u4e0d\u8981\u505a\uff0c\u4efb\u4f55\u6d3b\u52a8\u4e0d\u8981\u505a\uff0c\u4efb\u4f55\u6d3b\u52a8\u4e0d\u8981\u505a\uff0c\u975e\u5e38\u91cd\u8981\uff0c\u5c31\u7b97\u662f\u770b\u8d77\u6765\u518d\u6709\u6548\u7684\u6d3b\u52a8\u90fd\u4e0d\u8981\u505a\uff0c\u5c24\u5176\u662f\u4f18\u60e0\u7c7b\u7684\u3002\u505a\u4e86\u5c31\u662f\u996e\u9e29\u6b62\u6e34\uff0c\u90fd\u662f\u540c\u4e00\u884c\u4e1a\u7684\uff0c\u79bb\u5f97\u4e5f\u4e0d\u8fdc\uff0c\u9664\u975e\u662f\u80fd\u5f62\u6210\u62a4\u57ce\u6cb3\uff0c\u5426\u5219\uff0c\u4efb\u4f55\u6d3b\u52a8\u90fd\u6ca1\u6709\u79d8\u5bc6\uff0c\u4f60\u505a\u4e86\u5982\u679c\u6ca1\u6548\u679c\u5c31\u662f\u767d\u8d39\u529b\uff0c\u5982\u679c\u6709\u6548\u679c\u5176\u4ed6\u4eba\u7acb\u9a6c\u5c31\u4f1a\u8ddf\u8fdb\u3002\u4e00\u5207\u53c8\u56de\u5230\u539f\u6765\u7684\u72b6\u6001\uff0c\u4f46\u6bcf\u4e2a\u5c0f\u996d\u684c\u7ecf\u8425\u8005\u7684\u5de5\u4f5c\u91cf\u5374\u589e\u52a0\u4e86\uff0c\u56e0\u4e3a\u8c01\u90fd\u4e0d\u6562\u505c\u3002\u6240\u4ee5\uff0c\u5148\u89e3\u51b3\u4e0a\u9762\u7684\u56db\u4e2a\u95ee\u9898\uff0c\u89e3\u51b3\u5b8c\u4e86\u4ee5\u540e\uff0c\u5176\u4ed6\u65b9\u6cd5\u90fd\u662f\u9526\u4e0a\u6dfb\u82b1\u30022.\u8fd8\u662f\u4e00\u4e2a\u5f88\u96be\u4ee5\u63a5\u53d7\u7684\u4e8b\uff0c\u4ece\u201c\u5c0f\u5f20\u540c\u5b66\u7ed8\u753b\u5f88\u68d2\u201d\u8fd9\u4e00\u53e5\u53ef\u4ee5\u53d1\u73b0\uff0c\u4e0d\u7ba1\u662f\u9898\u4e3b\u8fd8\u662f\u5c0f\u5f20\u90fd\u5bf9\u884c\u4e1a\u7f3a\u4e4f\u4e00\u4e2a\u6e05\u695a\u7684\u8ba4\u8bc6\u3002\u201c\u7ed8\u753b\u5f88\u68d2\u201d\u4e0d\u662f\u7ade\u4e89\u529b\uff0c\u201c\u7ed8\u753b\u6c34\u5e73\u8fdc\u8fdc\u8d85\u8fc7\u5176\u4ed6\u5bb6\u201d\u624d\u662f\uff0c\u201c\u6559\u5b66\u6c34\u5e73\u8fdc\u8fdc\u8d85\u8fc7\u5176\u4ed6\u5bb6\u201d\u624d\u662f\u3002\u201c\u7ed8\u753b\u5f88\u68d2\u201d\u662f\u5fc5\u9700\u7684\u70b9\uff0c\u800c\u4e0d\u662f\u53ef\u4ee5\u4f5c\u4e3a\u6bd4\u8f83\u4f18\u52bf\u7684\u70b9\u3002\u6da6\u603b\u5b9e\u6218\u7bc7\u91cc\u7b2c96\u8282\u300a\u4ea7\u54c1\u5316\uff1a\u4f60\u662f\u8eab\u6000\u7edd\u6280\u7684\u4e00\u7ec4\u80fd\u529b\uff0c\u8fd8\u662f\u7528\u6237\u754c\u9762\u53cb\u597d\u7684\u4ea7\u54c1\u300b\u662f\u6700\u597d\u7684\u836f\uff0c\u62db\u751f\u6ca1\u6709\u6377\u5f84\uff0c\u6700\u8d77\u7801\u662f\u6ca1\u6709\u5b89\u5168\u7684\u6377\u5f84\u3002\u513f\u7ae5\u57f9\u8bad\u6700\u7279\u6b8a\u7684\u70b9\u5728\u4e8e\uff0c\u638f\u94b1\u7684\u4eba\u4e0d\u662f\u8981\u4e0a\u8bfe\u7684\u5b69\u5b50\uff0c\u800c\u662f\u5bb6\u957f\u3002\u800c\u963b\u6b62\u5bb6\u957f\u638f\u94b1\u7684\u6700\u5927\u963b\u788d\uff0c\u5c31\u662f\u4fe1\u4efb\u6216\u8005\u8bf4\u4fe1\u606f\u7684\u4e0d\u5bf9\u79f0\u3002\u800c\u514b\u670d\u8fd9\u4e2a\u4e0d\u5bf9\u79f0\u7684\u6700\u597d\u529e\u6cd5\uff0c\u5c31\u662f\u9ad8\u5ea6\u4ea7\u54c1\u5316\u7684\u8bfe\u7a0b\u7684\u5c55\u793a\u3002\u60f3\u60f3\u6da6\u603b\u4e94\u5546\u662f\u600e\u4e48\u4e00\u6b65\u6b65\u6253\u78e8\u51fa\u6765\u7684\uff0c\u8fd9\u5c31\u662f\u6a21\u677f\u3002\u89e6\u624b\u53ef\u5f97\u7684\u4e1c\u897f\u6c38\u8fdc\u6bd4\u865a\u65e0\u7f25\u7f08\u7684\u627f\u8bfa\u66f4\u8ba9\u4eba\u4fe1\u4efb\uff0c\u4e00\u672c\u62cd\u5728\u5bb6\u957f\u9762\u524d\u539a\u539a\u7684\u6559\u6848\u4e5f\u4e00\u5b9a\u4f1a\u6bd4\u7a7a\u53e3\u7684\u8bb8\u8bfa\u66f4\u52a0\u8ba9\u4eba\u5b89\u5fc3\u3002\u5982\u679c\u80fd\u591f\u52a0\u4e0a\u4e4b\u524d\u5b66\u5458\u7684\u5c55\u793a\u4ee5\u53ca\u5b8c\u5907\u7684\u5b66\u5458\u6863\u6848\u8fd9\u4e9b\u4e1c\u897f\uff0c\u8f6c\u5316\u7387\u4e0a\u7684\u4f18\u52bf\u5c31\u5df2\u7ecf\u4e0d\u662f\u4efb\u4f55\u6d41\u91cf\u4e0a\u7684\u6377\u5f84\u80fd\u6218\u80dc\u7684\u4e86\u3002\u5343\u94a7\u77f3\u4e0a\u4e07\u4ede\u5c71\uff0c\u8fd9\u5c31\u662f\u6211\u8f88\u4e94\u5546\u4eba\u7684\u82df\u4e14\u7ea2\u5229\u3002\u5143\u5b9e\u4e0b\u534810:15\u5dee\u5f02\u5316\u3002\u5c0f\u996d\u684c\u6bd4\u4ef7\u683c\u4e0d\u662f\u6b63\u9053\uff0c\u6bd4\u8425\u517b\u6bd4\u54c1\u8d28\u624d\u662f\u6b63\u9053\u3002\u7f8e\u672f\u62db\u751f\u548c\u5176\u4ed6\u57f9\u8bad\u4e00\u6837\uff0c\u9760\u53e3\u7891\u3002\u4f60\u57f9\u517b\u51e0\u4e2a\u4f18\u79c0\u5b66\u751f\u6bd4\u4ec0\u4e48\u5e7f\u544a\u90fd\u5f3a\u3002\u518d\u8bf4\u5dee\u5f02\u5316\u3002\u5982\u679c\u6d88\u8d39\u80fd\u529b\u591f\uff0c\u5c31\u521b\u9020\u827a\u672f\u6c1b\u56f4\uff0c\u5403\u827a\u672f\u9910\uff1b\u5982\u679c\u6d88\u8d39\u80fd\u529b\u4e0d\u591f\uff0c\u5c31\u624e\u5b9e\u505a\u6559\u80b2\uff0c\u597d\u5b66\u751f\u6210\u5c31\u597d\u8001\u5e08\uff01\u3010\u8bdd\u9898\u3011\u7528\u6237\u6570\u91cf\u589e\u957f\u7f13\u6162\uff0c\u600e\u6837\u7a81\u7834\u521b\u4e1a\u56f0\u5883\uff1f\u3010\u80cc\u666f\u3011\u5c0f\u5f20\u540c\u5b66\u5728\u5c71\u4e1c\u67d0\u5730\u7ea7\u5e02\u505a\u5c0f\u5b66\u751f\u7ed8\u753b\u57f9\u8bad\uff0c\u5e02\u573a\u7ade\u4e89\u6fc0\u70c8\uff0c\u5979\u8bd5\u8fc7\u53bb\u5b66\u6821\u53d1\u4f20\u5355\u7b49\u7b49\u529e\u6cd5\uff0c\u4f46\u6536\u6548\u4e0d\u5927\uff0c\u5f88\u591a\u751f\u6e90\u88ab\u5b66\u6821\u8001\u5e08\u548c\u7ade\u4e89\u5bf9\u624b\u74dc\u5206\u4e86\u3002\u5c0f\u5f20\u540c\u5b66\u7684\u521b\u4e1a\u5206\u6210\u4e24\u90e8\u5206\uff0c\u65e2\u505a\u5c0f\u996d\u684c\uff0c\u53c8\u5728\u505a\u5c0f\u5b66\u751f\u7ed8\u753b\u57f9\u8bad\u548c\u624d\u827a\u57f9\u8bad\u30021\u3001\u5b66\u6821\u5468\u56f4\u6709\u5f88\u591a\u5c0f\u996d\u684c\uff0c\u5927\u5bb6\u90fd\u5728\u5b66\u6821\u95e8\u53e3\u6563\u53d1\u4f20\u5355\uff0c\u4ef7\u683c\u6218\u6b64\u8d77\u5f7c\u4f0f\uff0c\u670d\u52a1\u9879\u76ee\u5927\u540c\u5c0f\u5f02\uff0c\u7ade\u4e89\u5927\uff0c\u5c0f\u5f20\u540c\u5b66\u8d5a\u5230\u4e0d\u4ec0\u4e48\u94b1\uff0c\u600e\u4e48\u6269\u5927\u9879\u76ee\u5229\u6da6\uff1f2\u3001\u5c0f\u5f20\u540c\u5b66\u7ed8\u753b\u5f88\u68d2\uff0c\u5c0f\u5b66\u751f\u624d\u827a\u57f9\u8bad\u53c8\u8d5a\u94b1\uff0c\u4f46\u62db\u751f\u56f0\u96be\uff0c\u6709\u4e9b\u7ade\u4e89\u5bf9\u624b\u975e\u5e38\u5f3a\u608d\uff0c\u516b\u4ed9\u8fc7\u6d77\u5404\u663e\u795e\u901a\uff0c\u4e0d\u53ef\u80fd\u6b63\u9762\u4ea4\u950b\u3002\u800c\u5c0f\u5f20\u540c\u5b66\u6ca1\u6709\u62db\u751f\u7ecf\u9a8c\u3001\u4eba\u624b\u548c\u8d44\u91d1\u90fd\u4e0d\u8db3\u3002\u3010\u95ee\u9898\u30111\u3001\u5982\u4f55\u66f4\u7a33\u5b9a\u6269\u5927\u5c0f\u996d\u684c\u4eba\u6570\uff1f2\u3001\u624d\u827a\u57f9\u8bad\u5982\u4f55\u5feb\u901f\u62db\u751f\u6210\u529f\uff1f\u6709\u6ca1\u6709\u4ec0\u4e48\u6377\u5f84\u53ef\u8d70\uff1f\u3010\u6574\u7406\u8005\u3011\u5fd7\u613f\u8005|\u738b\u535a|\u5546\u4e1a\u6848\u4f8b\u4e0b\u9762\u6211\u4eec\u5c31\u6765\u4e00\u8d77\u770b\u770b\uff0c\u672c\u671f\u6709\u54ea\u51e0\u4f4d\u540c\u5b66\u7684\u7cbe\u5f69\u8ba8\u8bba\u88ab\u9009\u4e2d\u3002\u7528\u6237\u6570\u91cf\u589e\u957f\u7f13\u6162\uff0c\u600e\u6837\u7a81\u7834\u521b\u4e1a\u56f0\u5883\uff1f\u6708\u5149\u503e\u57ce\u4e0a\u53488:48\u7528\u6237\u589e\u957f\u7f13\u6162\u600e\u4e48\u529e\uff1f1\u3001\u5728\u81ea\u5df1\u80fd\u505a\u597d\u670d\u52a1\u7684\u8303\u56f4\u5185\uff0c\u600e\u4e48\u6837\u7684\u589e\u957f\u662f\u81ea\u5df1\u671f\u671b\u7684\u589e\u957f\uff1f2\u3001\u786e\u5b9a\u597d\u589e\u957f\u7684\u9700\u6c42\uff0c\u518d\u5bfb\u627e\u589e\u957f\u7684\u65b9\u5f0f\u30023\u3001\u4e00\u4e2a\u573a\u5730\u505a\u4e09\u9879\u7ecf\u8425\uff0c\u60f3\u8d5a\u94b1\u7684\u5fc3\u60c5\u592a\u8feb\u5207\u4e86\u3002\u76d8\u70b9\u597d\u54ea\u4e9b\u662f\u81ea\u5df1\u7684\u4f18\u52bf\u54ea\u4e9b\u662f\u914d\u5957\u7ecf\u8425\u5218\u5168\u82b1\u4e0a\u53488:50 1\u3001\u5982\u4f55\u66f4\u7a33\u5b9a\u6269\u5927\u5c0f\u996d\u684c\u4eba\u6570\uff1f\u4f5c\u4e3a\u5bb6\u957f\uff0c\u627e\u57f9\u8bad\u673a\u6784\uff0c\u8981\u8003\u8651\u8fdc\u8fd1\uff0c\u8001\u5e08\u4eb2\u6c11\u5426\uff0c\u5bf9\u5b69\u5b50\u662f\u5426\u8db3\u591f\u5173\u5fc3\uff0c\u8db3\u591f\u70ed\u60c5\u3002\u53ef\u4ee5\u7528\u8001\u751f\u5e26\u65b0\u751f\uff0c\u6253\u597d\u6bcf\u5f20\u5b69\u5b50\u7684\u540d\u7247\u30022\u3001\u624d\u827a\u57f9\u8bad\u5982\u4f55\u5feb\u901f\u62db\u751f\u6210\u529f\uff1f\u6709\u6ca1\u6709\u4ec0\u4e48\u6377\u5f84\u53ef\u8d70\uff1f\u627f\u8bfa\u4e0d\u6ee1\u610f\u53ef\u4ee5\u9000\u6b3e\uff0c\u8db3\u591f\u7684\u4f18\u60e0\uff0c\u6bd4\u5982\u53ef\u4ee5\u591a\u770b\u4f1a\u5b69\u5b50\uff0c\u591a\u52a0\u4e9b\u8bfe\u7a0b\uff0c\u6bd5\u7adf\u5bb6\u957f\u4e0a\u73ed\u7684\u591a\u3002\u8ddf\u8001\u673a\u6784\u62a2\u751f\u6e90\uff0c\u53ef\u80fd\u4e0d\u5360\u4f18\u52bf\uff0c\u4e60\u60ef\u4e86\u8001\u673a\u6784\u7684\u5bb6\u957f\uff0c\u4e00\u822c\u4e0d\u613f\u610f\u627f\u62c5\u98ce\u9669\uff0c\u9664\u975e\u65b0\u673a\u6784\u8db3\u591f\u8db3\u591f\u7684\u4e13\u4e1a\uff0c\u8db3\u591f\u4fe1\u8d56\u53ef\u9760\u3002\u5362\u7476\u4e0a\u53489:01 1\u3001\u5f00\u5c55\u3010\u5bfb\u627e\u5c0f\u5c0f\u8bd5\u5403\u5b98\u3011\u6d3b\u52a8\uff0c\u6240\u6709\u7ebf\u4e0a\u62a5\u540d\u4e14\u8f6c\u53d1\u670b\u53cb\u5708\u7684\u5ba2\u6237\u4e2d\u62bd\u53d6N\u540d\u514d\u8d39\u8bd5\u5403\u4e09\u4e2a\u6708\uff08\u83b7\u53d6\u6f5c\u5728\u5ba2\u6237\u540d\u5355\uff0c\u57f9\u517b\u79cd\u5b50\u5ba2\u6237\uff0c\u540e\u7eed\u8ddf\u8e2a\u53e3\u7891\u8425\u9500\uff09\uff1b2\u3001\u3010\u8001\u5ba2\u6237\u9080\u8bf7\u65b0\u5ba2\u6237\u3011\u6bcf\u4eba\u9001\u4e00\u4e2a\u6708\u82b1\u6837\u52a0\u9910\uff08\u5361\u901a\u9910\u5305\u4e4b\u7c7b\u7684\uff0c\u5c0f\u670b\u53cb\u559c\u6b22\u6500\u6bd4\uff0c\u53ef\u4ee5\u7ed9\u4e24\u4e2a\u597d\u670b\u53cb\u62ff\u7740\u5361\u901a\u9910\u5305\u62cd\u7167\u53d1\u5708\uff09\u3002\u5c0f\u670b\u53cb\u4e4b\u95f4\u8001\u5e26\u65b0\u975e\u5e38\u6709\u6548\u3002\u674e\u5b97\u5458\uff08\u5bf0\u5b87\u5546\u8d38\uff09\u4e0a\u53489:31\u8fd9\u4e2a\u95ee\u9898\u7684\u672c\u8d28\u662f\u4e2a\u83b7\u5ba2\u7684\u95ee\u9898\u3002\u83b7\u5ba2\u6e20\u9053\u4e00\u822c\u662f\u7ebf\u4e0b\uff0c\u7ebf\u4e0a\u3002\u7ebf\u4e0b\u662f\u7f51\u5e972\u516c\u91cc\u5185\u53d1\u4f20\u5355\uff0c\u6821\u56ed\u5730\u63a8\uff0c\u5f02\u4e1a\u8054\u76df\uff0c\u6d3b\u52a8\u62c9\u65b0\uff0c\u8f6c\u4ecb\u7ecd\u3002\u7ebf\u4e0a\uff0c\u52a0\u5165\u5e73\u53f0\u83b7\u53d6\u6d41\u91cf\uff08\u5168\u56fd\uff0c\u884c\u4e1a\uff0c\u5730\u65b9\uff09\uff0c\u642d\u5efa\u79c1\u57df\u6d41\u91cf\uff0c\u793e\u7fa4\u88c2\u53d8\uff0c\u65b0\u5a92\u4f53\u63a8\u5e7f\u3002\u6d41\u91cf\u7684\u83b7\u53d6\u662f\u4e00\u4e2a\u7efc\u5408\u7684\u5de5\u4f5c\uff0c\u8981\u6839\u636e\u4f60\u5f53\u5730\u5f53\u65f6\u60c5\u51b5\u8c03\u6574\uff0c\u5728\u540c\u4e1a\u62c9\u65b0\u83b7\u5ba2\u7684\u4e3b\u5f62\u5f0f\u4e2d\uff0c\u627e\u5230\u5dee\u5f02\u5316\uff0c\u4fd7\u79f0\u6d41\u91cf\u6d3c\u5730\uff0c\u5c0f\u89c4\u6a21\u5c1d\u8bd5\uff0c\u5982\u679c\u6548\u679c\u597d\uff0c\u5168\u529b\u4e00\u535a\u3002\u6d3b\u7740\u4e0a\u534810:15\u5728\u4e00\u4e2a\u5404\u65b9\u9762\u90fd\u4e0d\u5360\u4f18\u52bf\u7684\u7ade\u4e89\u73af\u5883\u4e2d\uff0c\u552f\u4e00\u80fd\u8ba9\u4f60\u6d3b\u4e0b\u53bb\u7684\u529e\u6cd5\uff0c\u5c31\u662f\u771f\u529f\u592b\uff0c\u7528\u65f6\u95f4\u78e8\uff0c\u4e0d\u8981\u60f3\u505a\u8d5a\u5feb\u94b1\uff0c\u5f97\u5229\u7528\u81ea\u5df1\u7684\u4f18\u52bf\uff0c\uff08\u6bd4\u5982\u8bf4\u4f60\u753b\u753b\u5f97\u597d\uff09\u57f9\u517b\u51e0\u4e2a\u4f18\u79c0\u7684\u5b66\u5458\u51fa\u6765\uff0c\u5f62\u6210\u53e3\u7891\u4f20\u64ad\uff0c\u8fd9\u6837\u524d\u671f\u80af\u5b9a\u6162\u4e5f\u8d5a\u4e0d\u5230\u94b1\u3002\u4f46\u662f\u540e\u671f\u6548\u679c\u5e94\u8be5\u4f1a\u597d\u3002\u6240\u8c13\u7684\u7ed3\u786c\u5be8\uff0c\u6253\u5446\u6218\u3002\u5dee\u4e0d\u591a\u5c31\u8fd9\u6837\u5427\u3002\u9f99\u6f6d\u661f\u8dc3[\u8868\u60c5]\u2014\u2014[\u8868\u60c5]\u4e0b\u53489:08\u4eca\u5929\u7684\u56de\u7b54\u53ef\u80fd\u542c\u8d77\u6765\u6bd4\u8f83\u523a\u8033\uff0c\u5148\u8bf4\u58f0\u62b1\u6b491.\u6da6\u603b\u6709\u53e5\u8bdd\u8bf4\u201c\u4f60\u966a\u4f60\u5ba2\u6237\u559d\u4e0b\u53bb\u7684\u90a3\u4e9b\u9152\uff0c\u90fd\u662f\u4f60\u56e0\u4e3a\u505a\u4ea7\u54c1\u7684\u65f6\u5019\u6ca1\u6709\u6d41\u8fc7\u90a3\u4e9b\u6c57\u201d\uff0c\u6362\u53e5\u8bdd\u8bf4\uff0c\u5c31\u662f\u5728\u7528\u6218\u672f\u4e0a\u7684\u52e4\u594b\u6765\u63a9\u76d6\u6218\u7565\u4e0a\u7684\u61d2\u60f0\u3002\u9996\u5148\uff0c\u6211\u60f3\u5bf9\u4e8e\u4e94\u5546\u7684\u5b66\u5458\uff0c\u4e0d\u7ba1\u662f\u521b\u4e1a\u8fd8\u662f\u8bf4\u505a\u5546\u4e1a\uff0c\u8981\u6c42\u8d77\u7801\u8981\u9ad8\u4e00\u70b9\u5427\u3002\u6240\u4ee5\uff0c\u6211\u60f3\u63d0\u51e0\u4e2a\u95ee\u9898\uff1a\u5c0f\u996d\u684c\u7684\u7528\u6237\u662f\u8c01\uff1f\u8fd9\u4e9b\u7ed9\u7528\u6237\u7684\u6838\u5fc3\u9700\u6c42\u662f\u4ec0\u4e48\uff1f\u5c0f\u5f20\u7684\u5c0f\u996d\u684c\u80fd\u63d0\u4f9b\u4ec0\u4e48\uff1f\u5728\u6ee1\u8db3\u7528\u6237\u6838\u5fc3\u9700\u6c42\u65b9\u9762\uff0c\u6709\u4ec0\u4e48\u4f18\u52bf\uff1f\u6ca1\u56de\u7b54\u6e05\u695a\u8fd9\u51e0\u4e2a\u95ee\u9898\u4e4b\u524d\uff0c\u4efb\u4f55\u6d3b\u52a8\u4e0d\u8981\u505a\uff0c\u4efb\u4f55\u6d3b\u52a8\u4e0d\u8981\u505a\uff0c\u4efb\u4f55\u6d3b\u52a8\u4e0d\u8981\u505a\uff0c\u975e\u5e38\u91cd\u8981\uff0c\u5c31\u7b97\u662f\u770b\u8d77\u6765\u518d\u6709\u6548\u7684\u6d3b\u52a8\u90fd\u4e0d\u8981\u505a\uff0c\u5c24\u5176\u662f\u4f18\u60e0\u7c7b\u7684\u3002\u505a\u4e86\u5c31\u662f\u996e\u9e29\u6b62\u6e34\uff0c\u90fd\u662f\u540c\u4e00\u884c\u4e1a\u7684\uff0c\u79bb\u5f97\u4e5f\u4e0d\u8fdc\uff0c\u9664\u975e\u662f\u80fd\u5f62\u6210\u62a4\u57ce\u6cb3\uff0c\u5426\u5219\uff0c\u4efb\u4f55\u6d3b\u52a8\u90fd\u6ca1\u6709\u79d8\u5bc6\uff0c\u4f60\u505a\u4e86\u5982\u679c\u6ca1\u6548\u679c\u5c31\u662f\u767d\u8d39\u529b\uff0c\u5982\u679c\u6709\u6548\u679c\u5176\u4ed6\u4eba\u7acb\u9a6c\u5c31\u4f1a\u8ddf\u8fdb\u3002\u4e00\u5207\u53c8\u56de\u5230\u539f\u6765\u7684\u72b6\u6001\uff0c\u4f46\u6bcf\u4e2a\u5c0f\u996d\u684c\u7ecf\u8425\u8005\u7684\u5de5\u4f5c\u91cf\u5374\u589e\u52a0\u4e86\uff0c\u56e0\u4e3a\u8c01\u90fd\u4e0d\u6562\u505c\u3002\u6240\u4ee5\uff0c\u5148\u89e3\u51b3\u4e0a\u9762\u7684\u56db\u4e2a\u95ee\u9898\uff0c\u89e3\u51b3\u5b8c\u4e86\u4ee5\u540e\uff0c\u5176\u4ed6\u65b9\u6cd5\u90fd\u662f\u9526\u4e0a\u6dfb\u82b1\u30022.\u8fd8\u662f\u4e00\u4e2a\u5f88\u96be\u4ee5\u63a5\u53d7\u7684\u4e8b\uff0c\u4ece\u201c\u5c0f\u5f20\u540c\u5b66\u7ed8\u753b\u5f88\u68d2\u201d\u8fd9\u4e00\u53e5\u53ef\u4ee5\u53d1\u73b0\uff0c\u4e0d\u7ba1\u662f\u9898\u4e3b\u8fd8\u662f\u5c0f\u5f20\u90fd\u5bf9\u884c\u4e1a\u7f3a\u4e4f\u4e00\u4e2a\u6e05\u695a\u7684\u8ba4\u8bc6\u3002\u201c\u7ed8\u753b\u5f88\u68d2\u201d\u4e0d\u662f\u7ade\u4e89\u529b\uff0c\u201c\u7ed8\u753b\u6c34\u5e73\u8fdc\u8fdc\u8d85\u8fc7\u5176\u4ed6\u5bb6\u201d\u624d\u662f\uff0c\u201c\u6559\u5b66\u6c34\u5e73\u8fdc\u8fdc\u8d85\u8fc7\u5176\u4ed6\u5bb6\u201d\u624d\u662f\u3002\u201c\u7ed8\u753b\u5f88\u68d2\u201d\u662f\u5fc5\u9700\u7684\u70b9\uff0c\u800c\u4e0d\u662f\u53ef\u4ee5\u4f5c\u4e3a\u6bd4\u8f83\u4f18\u52bf\u7684\u70b9\u3002\u6da6\u603b\u5b9e\u6218\u7bc7\u91cc\u7b2c96\u8282\u300a\u4ea7\u54c1\u5316\uff1a\u4f60\u662f\u8eab\u6000\u7edd\u6280\u7684\u4e00\u7ec4\u80fd\u529b\uff0c\u8fd8\u662f\u7528\u6237\u754c\u9762\u53cb\u597d\u7684\u4ea7\u54c1\u300b\u662f\u6700\u597d\u7684\u836f\uff0c\u62db\u751f\u6ca1\u6709\u6377\u5f84\uff0c\u6700\u8d77\u7801\u662f\u6ca1\u6709\u5b89\u5168\u7684\u6377\u5f84\u3002\u513f\u7ae5\u57f9\u8bad\u6700\u7279\u6b8a\u7684\u70b9\u5728\u4e8e\uff0c\u638f\u94b1\u7684\u4eba\u4e0d\u662f\u8981\u4e0a\u8bfe\u7684\u5b69\u5b50\uff0c\u800c\u662f\u5bb6\u957f\u3002\u800c\u963b\u6b62\u5bb6\u957f\u638f\u94b1\u7684\u6700\u5927\u963b\u788d\uff0c\u5c31\u662f\u4fe1\u4efb\u6216\u8005\u8bf4\u4fe1\u606f\u7684\u4e0d\u5bf9\u79f0\u3002\u800c\u514b\u670d\u8fd9\u4e2a\u4e0d\u5bf9\u79f0\u7684\u6700\u597d\u529e\u6cd5\uff0c\u5c31\u662f\u9ad8\u5ea6\u4ea7\u54c1\u5316\u7684\u8bfe\u7a0b\u7684\u5c55\u793a\u3002\u60f3\u60f3\u6da6\u603b\u4e94\u5546\u662f\u600e\u4e48\u4e00\u6b65\u6b65\u6253\u78e8\u51fa\u6765\u7684\uff0c\u8fd9\u5c31\u662f\u6a21\u677f\u3002\u89e6\u624b\u53ef\u5f97\u7684\u4e1c\u897f\u6c38\u8fdc\u6bd4\u865a\u65e0\u7f25\u7f08\u7684\u627f\u8bfa\u66f4\u8ba9\u4eba\u4fe1\u4efb\uff0c\u4e00\u672c\u62cd\u5728\u5bb6\u957f\u9762\u524d\u539a\u539a\u7684\u6559\u6848\u4e5f\u4e00\u5b9a\u4f1a\u6bd4\u7a7a\u53e3\u7684\u8bb8\u8bfa\u66f4\u52a0\u8ba9\u4eba\u5b89\u5fc3\u3002\u5982\u679c\u80fd\u591f\u52a0\u4e0a\u4e4b\u524d\u5b66\u5458\u7684\u5c55\u793a\u4ee5\u53ca\u5b8c\u5907\u7684\u5b66\u5458\u6863\u6848\u8fd9\u4e9b\u4e1c\u897f\uff0c\u8f6c\u5316\u7387\u4e0a\u7684\u4f18\u52bf\u5c31\u5df2\u7ecf\u4e0d\u662f\u4efb\u4f55\u6d41\u91cf\u4e0a\u7684\u6377\u5f84\u80fd\u6218\u80dc\u7684\u4e86\u3002\u5343\u94a7\u77f3\u4e0a\u4e07\u4ede\u5c71\uff0c\u8fd9\u5c31\u662f\u6211\u8f88\u4e94\u5546\u4eba\u7684\u82df\u4e14\u7ea2\u5229\u3002\u5143\u5b9e\u4e0b\u534810:15\u5dee\u5f02\u5316\u3002\u5c0f\u996d\u684c\u6bd4\u4ef7\u683c\u4e0d\u662f\u6b63\u9053\uff0c\u6bd4\u8425\u517b\u6bd4\u54c1\u8d28\u624d\u662f\u6b63\u9053\u3002\u7f8e\u672f\u62db\u751f\u548c\u5176\u4ed6\u57f9\u8bad\u4e00\u6837\uff0c\u9760\u53e3\u7891\u3002\u4f60\u57f9\u517b\u51e0\u4e2a\u4f18\u79c0\u5b66\u751f\u6bd4\u4ec0\u4e48\u5e7f\u544a\u90fd\u5f3a\u3002\u518d\u8bf4\u5dee\u5f02\u5316\u3002\u5982\u679c\u6d88\u8d39\u80fd\u529b\u591f\uff0c\u5c31\u521b\u9020\u827a\u672f\u6c1b\u56f4\uff0c\u5403\u827a\u672f\u9910\uff1b\u5982\u679c\u6d88\u8d39\u80fd\u529b\u4e0d\u591f\uff0c\u5c31\u624e\u5b9e\u505a\u6559\u80b2\uff0c\u597d\u5b66\u751f\u6210\u5c31\u597d\u8001\u5e08\uff01\u5c31\u662f\u5728\u7528\u6218\u672f\u4e0a\u7684\u52e4\u594b\u6765\u63a9\u76d6\u6218\u7565\u4e0a\u7684\u61d2\u60f0\u3002\u9996\u5148\uff0c\u6211\u60f3\u5bf9\u4e8e\u4e94\u5546\u7684\u5b66\u5458\uff0c\u4e0d\u7ba1\u662f\u521b\u4e1a\u8fd8\u662f\u8bf4\u505a\u5546\u4e1a\uff0c\u8981\u6c42\u8d77\u7801\u8981\u9ad8\u4e00\u70b9\u5427\u3002\u6240\u4ee5\uff0c\u6211\u60f3\u63d0\u51e0\u4e2a\u95ee\u9898\uff1a\u5c0f\u996d\u684c\u7684\u7528\u6237\u662f\u8c01\uff1f\u8fd9\u4e9b\u7ed9\u7528\u6237\u7684\u6838\u5fc3\u9700\u6c42\u662f\u4ec0\u4e48\uff1f\u5c0f\u5f20\u7684\u5c0f\u996d\u684c\u80fd\u63d0\u4f9b\u4ec0\u4e48\uff1f\u5728\u6ee1\u8db3\u7528\u6237\u6838\u5fc3\u9700\u6c42\u65b9\u9762\uff0c\u6709\u4ec0\u4e48\u4f18\u52bf\uff1f\u6ca1\u56de\u7b54\u6e05\u695a\u8fd9\u51e0\u4e2a\u95ee\u9898\u4e4b\u524d\uff0c\u4efb\u4f55\u6d3b\u52a8\u4e0d\u8981\u505a\uff0c\u4efb\u4f55\u6d3b\u52a8\u4e0d\u8981\u505a\uff0c\u4efb\u4f55\u6d3b\u52a8\u4e0d\u8981\u505a\uff0c\u975e\u5e38\u91cd\u8981\uff0c\u5c31\u7b97\u662f\u770b\u8d77\u6765\u518d\u6709\u6548\u7684\u6d3b\u52a8\u90fd\u4e0d\u8981\u505a\uff0c\u5c24\u5176\u662f\u4f18\u60e0\u7c7b\u7684\u3002\u505a\u4e86\u5c31\u662f\u996e\u9e29\u6b62\u6e34\uff0c\u90fd\u662f\u540c\u4e00\u884c\u4e1a\u7684\uff0c\u79bb\u5f97\u4e5f\u4e0d\u8fdc\uff0c\u9664\u975e\u662f\u80fd\u5f62\u6210\u62a4\u57ce\u6cb3\uff0c\u5426\u5219\uff0c\u4efb\u4f55\u6d3b\u52a8\u90fd\u6ca1\u6709\u79d8\u5bc6\uff0c\u4f60\u505a\u4e86\u5982\u679c\u6ca1\u6548\u679c\u5c31\u662f\u767d\u8d39\u529b\uff0c\u5982\u679c\u6709\u6548\u679c\u5176\u4ed6\u4eba\u7acb\u9a6c\u5c31\u4f1a\u8ddf\u8fdb\u3002\u4e00\u5207\u53c8\u56de\u5230\u539f\u6765\u7684\u72b6\u6001\uff0c\u4f46\u6bcf\u4e2a\u5c0f\u996d\u684c\u7ecf\u8425\u8005\u7684\u5de5\u4f5c\u91cf\u5374\u589e\u52a0\u4e86\uff0c\u56e0\u4e3a\u8c01\u90fd\u4e0d\u6562\u505c\u3002\u6240\u4ee5\uff0c\u5148\u89e3\u51b3\u4e0a\u9762\u7684\u56db\u4e2a\u95ee\u9898\uff0c\u89e3\u51b3\u5b8c\u4e86\u4ee5\u540e\uff0c\u5176\u4ed6\u65b9\u6cd5\u90fd\u662f\u9526\u4e0a\u6dfb\u82b1\u30022.\u8fd8\u662f\u4e00\u4e2a\u5f88\u96be\u4ee5\u63a5\u53d7\u7684\u4e8b\uff0c\u4ece\u201c\u5c0f\u5f20\u540c\u5b66\u7ed8\u753b\u5f88\u68d2\u201d\u8fd9\u4e00\u53e5\u53ef\u4ee5\u53d1\u73b0\uff0c\u4e0d\u7ba1\u662f\u9898\u4e3b\u8fd8\u662f\u5c0f\u5f20\u90fd\u5bf9\u884c\u4e1a\u7f3a\u4e4f\u4e00\u4e2a\u6e05\u695a\u7684\u8ba4\u8bc6\u3002\u201c\u7ed8\u753b\u5f88\u68d2\u201d\u4e0d\u662f\u7ade\u4e89\u529b\uff0c\u201c\u7ed8\u753b\u6c34\u5e73\u8fdc\u8fdc\u8d85\u8fc7\u5176\u4ed6\u5bb6\u201d\u624d\u662f\uff0c\u201c\u6559\u5b66\u6c34\u5e73\u8fdc\u8fdc\u8d85\u8fc7\u5176\u4ed6\u5bb6\u201d\u624d\u662f\u3002\u201c\u7ed8\u753b\u5f88\u68d2\u201d\u662f\u5fc5\u9700\u7684\u70b9\uff0c\u800c\u4e0d\u662f\u53ef\u4ee5\u4f5c\u4e3a\u6bd4\u8f83\u4f18\u52bf\u7684\u70b9\u3002\u6da6\u603b\u5b9e\u6218\u7bc7\u91cc\u7b2c96\u8282\u300a\u4ea7\u54c1\u5316\uff1a\u4f60\u662f\u8eab\u6000\u7edd\u6280\u7684\u4e00\u7ec4\u80fd\u529b\uff0c\u8fd8\u662f\u7528\u6237\u754c\u9762\u53cb\u597d\u7684\u4ea7\u54c1\u300b\u662f\u6700\u597d\u7684\u836f\uff0c\u62db\u751f\u6ca1\u6709\u6377\u5f84\uff0c\u6700\u8d77\u7801\u662f\u6ca1\u6709\u5b89\u5168\u7684\u6377\u5f84\u3002\u513f\u7ae5\u57f9\u8bad\u6700\u7279\u6b8a\u7684\u70b9\u5728\u4e8e\uff0c\u638f\u94b1\u7684\u4eba\u4e0d\u662f\u8981\u4e0a\u8bfe\u7684\u5b69\u5b50\uff0c\u800c\u662f\u5bb6\u957f\u3002\u800c\u963b\u6b62\u5bb6\u957f\u638f\u94b1\u7684\u6700\u5927\u963b\u788d\uff0c\u5c31\u662f\u4fe1\u4efb\u6216\u8005\u8bf4\u4fe1\u606f\u7684\u4e0d\u5bf9\u79f0\u3002\u800c\u514b\u670d\u8fd9\u4e2a\u4e0d\u5bf9\u79f0\u7684\u6700\u597d\u529e\u6cd5\uff0c\u5c31\u662f\u9ad8\u5ea6\u4ea7\u54c1\u5316\u7684\u8bfe\u7a0b\u7684\u5c55\u793a\u3002\u60f3\u60f3\u6da6\u603b\u4e94\u5546\u662f\u600e\u4e48\u4e00\u6b65\u6b65\u6253\u78e8\u51fa\u6765\u7684\uff0c\u8fd9\u5c31\u662f\u6a21\u677f\u3002\u89e6\u624b\u53ef\u5f97\u7684\u4e1c\u897f\u6c38\u8fdc\u6bd4\u865a\u65e0\u7f25\u7f08\u7684\u627f\u8bfa\u66f4\u8ba9\u4eba\u4fe1\u4efb\uff0c\u4e00\u672c\u62cd\u5728\u5bb6\u957f\u9762\u524d\u539a\u539a\u7684\u6559\u6848\u4e5f\u4e00\u5b9a\u4f1a\u6bd4\u7a7a\u53e3\u7684\u8bb8\u8bfa\u66f4\u52a0\u8ba9\u4eba\u5b89\u5fc3\u3002\u5982\u679c\u80fd\u591f\u52a0\u4e0a\u4e4b\u524d\u5b66\u5458\u7684\u5c55\u793a\u4ee5\u53ca\u5b8c\u5907\u7684\u5b66\u5458\u6863\u6848\u8fd9\u4e9b\u4e1c\u897f\uff0c\u8f6c\u5316\u7387\u4e0a\u7684\u4f18\u52bf\u5c31\u5df2\u7ecf\u4e0d\u662f\u4efb\u4f55\u6d41\u91cf\u4e0a\u7684\u6377\u5f84\u80fd\u6218\u80dc\u7684\u4e86\u3002\u5343\u94a7\u77f3\u4e0a\u4e07\u4ede\u5c71\uff0c\u8fd9\u5c31\u662f\u6211\u8f88\u4e94\u5546\u4eba\u7684\u82df\u4e14\u7ea2\u5229\u3002\u5143\u5b9e\u4e0b\u534810:15\u5dee\u5f02\u5316\u3002\u5c0f\u996d\u684c\u6bd4\u4ef7\u683c\u4e0d\u662f\u6b63\u9053\uff0c\u6bd4\u8425\u517b\u6bd4\u54c1\u8d28\u624d\u662f\u6b63\u9053\u3002\u7f8e\u672f\u62db\u751f\u548c\u5176\u4ed6\u57f9\u8bad\u4e00\u6837\uff0c\u9760\u53e3\u7891\u3002\u4f60\u57f9\u517b\u51e0\u4e2a\u4f18\u79c0\u5b66\u751f\u6bd4\u4ec0\u4e48\u5e7f\u544a\u90fd\u5f3a\u3002\u518d\u8bf4\u5dee\u5f02\u5316\u3002\u5982\u679c\u6d88\u8d39\u80fd\u529b\u591f\uff0c\u5c31\u521b\u9020\u827a\u672f\u6c1b\u56f4\uff0c\u5403\u827a\u672f\u9910\uff1b\u5982\u679c\u6d88\u8d39\u80fd\u529b\u4e0d\u591f\uff0c\u5c31\u624e\u5b9e\u505a\u6559\u80b2\uff0c\u597d\u5b66\u751f\u6210\u5c31\u597d\u8001\u5e08\uff01";
        String summarise = SimpleSummariserAlgorithm.summarise(SimpleSummariserAlgorithm.cToe(s), 1);
        if (summarise.length() > 55) {
            summarise = summarise.substring(0, 95) + "...";
        }
        System.out.println(summarise);
    }
}

