/*
 * Decompiled with CFR 0.152.
 */
package com.chinamcloud.haihe.common.utils;

import com.chinamcloud.haihe.common.utils.ValidateUtil;
import java.io.IOException;
import java.io.PrintWriter;
import java.io.StringWriter;
import java.math.BigDecimal;
import java.net.InetAddress;
import java.net.NetworkInterface;
import java.net.SocketException;
import java.net.URISyntaxException;
import java.net.UnknownHostException;
import java.text.SimpleDateFormat;
import java.util.Calendar;
import java.util.Date;
import java.util.Enumeration;
import java.util.Objects;
import java.util.Random;

public class ToolUtil
extends ValidateUtil {
    public static final int SALT_LENGTH = 6;

    public static String getRandomString(int length) {
        String base = "abcdefghijklmnopqrstuvwxyz0123456789";
        Random random = new Random();
        StringBuffer sb = new StringBuffer();
        for (int i = 0; i < length; ++i) {
            int number = random.nextInt(base.length());
            sb.append(base.charAt(number));
        }
        return sb.toString();
    }

    public static String removeWhiteSpace(String value) {
        if (ToolUtil.isEmpty(value)) {
            return "";
        }
        return value.replaceAll("\\s*", "");
    }

    public static String getCreateTimeBefore(int seconds) {
        long currentTimeInMillis = Calendar.getInstance().getTimeInMillis();
        Date date = new Date(currentTimeInMillis - (long)(seconds * 1000));
        SimpleDateFormat sdf = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");
        return sdf.format(date);
    }

    public static String getExceptionMsg(Throwable e) {
        StringWriter sw = new StringWriter();
        try {
            e.printStackTrace(new PrintWriter(sw));
        }
        finally {
            try {
                sw.close();
            }
            catch (IOException e1) {
                e1.printStackTrace();
            }
        }
        return sw.getBuffer().toString().replaceAll("\\$", "T");
    }

    public static String getIP() {
        try {
            StringBuilder IFCONFIG = new StringBuilder();
            Enumeration<NetworkInterface> en = NetworkInterface.getNetworkInterfaces();
            while (en.hasMoreElements()) {
                NetworkInterface intf = en.nextElement();
                Enumeration<InetAddress> enumIpAddr = intf.getInetAddresses();
                while (enumIpAddr.hasMoreElements()) {
                    InetAddress inetAddress = enumIpAddr.nextElement();
                    if (inetAddress.isLoopbackAddress() || inetAddress.isLinkLocalAddress() || !inetAddress.isSiteLocalAddress()) continue;
                    IFCONFIG.append(inetAddress.getHostAddress().toString()).append("\n");
                }
            }
            return IFCONFIG.toString();
        }
        catch (SocketException ex) {
            ex.printStackTrace();
            try {
                return InetAddress.getLocalHost().getHostAddress();
            }
            catch (UnknownHostException e) {
                e.printStackTrace();
                return null;
            }
        }
    }

    public static Boolean isWinOs() {
        String os = System.getProperty("os.name");
        if (os.toLowerCase().startsWith("win")) {
            return true;
        }
        return false;
    }

    public static String getTempPath() {
        return System.getProperty("java.io.tmpdir");
    }

    public static Integer toInt(Object val) {
        if (val instanceof Double) {
            BigDecimal bigDecimal = new BigDecimal((Double)val);
            return bigDecimal.intValue();
        }
        return Integer.valueOf(val.toString());
    }

    public static boolean isNum(Object obj) {
        try {
            Integer.parseInt(obj.toString());
        }
        catch (Exception e) {
            return false;
        }
        return true;
    }

    public static String getWebRootPath(String filePath) {
        try {
            String path = Objects.requireNonNull(ToolUtil.class.getClassLoader().getResource("")).toURI().getPath();
            path = path.replace("/WEB-INF/classes/", "");
            path = path.replace("/target/classes/", "");
            path = path.replace("file:/", "");
            if (ToolUtil.isEmpty(filePath)) {
                return path;
            }
            return path + "/" + filePath;
        }
        catch (URISyntaxException e) {
            throw new RuntimeException(e);
        }
    }

    public static String getFileSuffix(String fileWholeName) {
        if (ToolUtil.isEmpty(fileWholeName)) {
            return "none";
        }
        int lastIndexOf = fileWholeName.lastIndexOf(".");
        return fileWholeName.substring(lastIndexOf + 1);
    }

    public static int countStr(String str1, String str2) {
        int counter = 0;
        if (!str1.contains(str2)) {
            return 0;
        }
        if (str1.contains(str2)) {
            ++counter;
            return counter += ToolUtil.countStr(str1.substring(str1.indexOf(str2) + str2.length()), str2);
        }
        return 0;
    }
}

