/*
 * Decompiled with CFR 0.152.
 */
package com.chinamcloud.haihe.common.utils;

import com.chinamcloud.haihe.common.bean.KeyWords;
import java.util.List;
import java.util.stream.Collectors;
import org.apache.commons.lang3.StringUtils;

public class TopicKeywordUtils {
    public static List<KeyWords> parseTopicKeyWords(List<String> keywords) {
        return keywords.stream().filter(x -> x.trim().length() > 0).map(x -> {
            KeyWords words = new KeyWords();
            words.setKeyWord(x.trim().replaceAll("\\s{2}", " "));
            return words;
        }).collect(Collectors.toList());
    }

    public static String buildQueryByStr(List<String> keyWords) {
        if (keyWords.size() > 0) {
            List list = keyWords.stream().map(x -> x.replaceAll("\\s", " AND ")).collect(Collectors.toList());
            return StringUtils.join(list, (String)" OR ");
        }
        return "";
    }

    public static String buildQueryByStr(String keywords) {
        return keywords.replace(" ", "AND").replaceAll(",", "OR");
    }

    public static String buildQueryByObject(List<KeyWords> keyWords) {
        if (keyWords.size() > 0) {
            List list = keyWords.stream().map(x -> x.getKeyWord().replaceAll("\\s", " AND ")).collect(Collectors.toList());
            return StringUtils.join(list, (String)" OR ");
        }
        return "";
    }

    public static String buildQueryByObjecttoStirng(List<String> keyWords) {
        if (keyWords == null) {
            return "";
        }
        if (keyWords.size() > 0) {
            List list = keyWords.stream().map(x -> x.replaceAll(",", " AND ").replaceAll("\uff0c", " AND ")).collect(Collectors.toList());
            return StringUtils.join(list, (String)" OR ");
        }
        return "";
    }

    public static String appendQuery(String str, String str2, boolean add) {
        return str + " " + (add ? " AND " : " OR ") + " " + str2;
    }

    public static int clcTopicKeyWords(List<String> keywords) {
        int count = 0;
        for (String keyword : keywords) {
            if (!StringUtils.isNotBlank((CharSequence)keyword)) continue;
            count += keyword.split(" ").length;
        }
        return count;
    }
}

