/*
 * Decompiled with CFR 0.152.
 */
package com.chinamcloud.haihe.common.xz;

import com.chinamcloud.haihe.common.utils.ConfigureUtils;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileReader;
import java.util.ArrayList;
import java.util.List;
import org.apache.commons.lang3.StringUtils;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class AliDataFilterManager {
    private static final Logger log = LogManager.getLogger(AliDataFilterManager.class);
    private static final AliDataFilterManager manager = new AliDataFilterManager();
    private final List<String> contentFilterStrList = new ArrayList<String>();
    private final List<String> districtFilterStrList = new ArrayList<String>();

    public static AliDataFilterManager getInstance() {
        return manager;
    }

    public static synchronized void init() {
        manager.initFilter();
    }

    private AliDataFilterManager() {
    }

    private List<String> fileReader(String filePath) {
        File file;
        ArrayList<String> list = new ArrayList<String>(16);
        if (!StringUtils.isEmpty((CharSequence)filePath) && (file = new File(filePath)).exists()) {
            try (FileReader reader = new FileReader(file);
                 BufferedReader bufferedReader = new BufferedReader(reader);){
                String temp = null;
                while ((temp = bufferedReader.readLine()) != null) {
                    list.add(temp);
                }
            }
            catch (Exception e) {
                log.error("fileReader error", (Throwable)e);
            }
        }
        return list;
    }

    public List<String> getContentFilterStrList() {
        return this.contentFilterStrList;
    }

    public List<String> getDistrictFilterStrList() {
        return this.districtFilterStrList;
    }

    private void initContentFilter() {
        this.contentFilterStrList.addAll(this.fileReader(ConfigureUtils.class.getResource("/").getPath() + File.separator + "config" + File.separator + "contentfilter.txt"));
        log.info("loaded contentfilter.txt size=" + this.contentFilterStrList.size());
    }

    private void initDistrictfilter() {
        this.districtFilterStrList.addAll(this.fileReader(ConfigureUtils.class.getResource("/").getPath() + File.separator + "config" + File.separator + "districtfilter.txt"));
        log.info("loaded districtfilter.txt size=" + this.districtFilterStrList.size());
    }

    private void initFilter() {
        this.initContentFilter();
        this.initDistrictfilter();
    }
}

