/*
 * Decompiled with CFR 0.152.
 */
package com.chinamcloud.haihe.configService.controller;

import com.chinamcloud.haihe.configService.service.RegionService;
import java.util.Map;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.CrossOrigin;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"/region-service"})
@CrossOrigin
public class RegionController {
    @Autowired
    private RegionService regionService;

    @GetMapping(value={"/getAddrTree/{provinceCode}"}, consumes={"application/json;charset=utf-8"})
    public Object getAddrTree(@PathVariable String provinceCode) {
        return this.regionService.getAddrTree(provinceCode, new Boolean[0]);
    }

    @GetMapping(value={"/getProvinces"}, consumes={"application/json;charset=utf-8"})
    public Object getProvinces() {
        return this.regionService.getProvinces(new Boolean[0]);
    }

    @PostMapping(value={"/getAddr"}, consumes={"application/json;charset=utf-8"})
    public Object getAddr(@RequestBody Map<String, String> map) {
        return this.regionService.getAddr(map, new Boolean[0]);
    }

    @GetMapping(value={"/clearRegion"}, consumes={"application/json;charset=utf-8"})
    public Object clearRegion(@RequestParam(value="code", required=false) String code) {
        return this.regionService.clearRegion(code);
    }
}

