/*
 * Decompiled with CFR 0.152.
 */
package com.chinamcloud.haihe.configService.service;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONObject;
import com.chinamcloud.haihe.common.CodeResult;
import com.chinamcloud.haihe.common.Exception.CustomException;
import com.chinamcloud.haihe.configService.entity.DataConfig;
import com.chinamcloud.haihe.configService.mapper.DataConfigMapper;
import com.chinamcloud.haihe.configService.mapper.UserDataConfigMapper;
import com.chinamcloud.haihe.newservice.analysis.bean.PlanInfoBean;
import com.chinamcloud.haihe.newservice.analysis.mapper.EventInfoMapper;
import com.chinamcloud.haihe.newservice.collect.bean.UserCollectArticle;
import com.chinamcloud.haihe.newservice.collect.bean.UserCollectArticlePageParam;
import com.chinamcloud.haihe.newservice.collect.mapper.UserCollectArticleMapper;
import com.fasterxml.jackson.core.JsonPointer;
import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.node.ArrayNode;
import com.fasterxml.jackson.databind.node.ObjectNode;
import com.jayway.jsonpath.DocumentContext;
import com.jayway.jsonpath.JsonPath;
import com.jayway.jsonpath.Predicate;
import java.util.List;
import java.util.Map;
import org.apache.commons.lang3.StringUtils;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class UserDataConfigService {
    private static final Logger log = LogManager.getLogger(UserDataConfigService.class);
    private static ObjectMapper mapper = new ObjectMapper();
    @Autowired
    private UserDataConfigMapper userDataConfigMapper;
    @Autowired
    private DataConfigMapper dataconfigMapper;
    @Autowired
    private EventInfoMapper planMapper;
    @Autowired
    private UserCollectArticleMapper userCollectArticleMapper;

    public Object getDataConfig(String tenantId, String dpCode, String dpId) {
        if (StringUtils.isBlank((CharSequence)tenantId) || StringUtils.isBlank((CharSequence)dpCode) || StringUtils.isBlank((CharSequence)dpId)) {
            return CodeResult.failedResultByMsgSource("params_error");
        }
        DataConfig dataConfig = this.selectByPrimaryKey(tenantId, dpCode, dpId);
        if (dataConfig == null || StringUtils.isBlank((CharSequence)dataConfig.getData())) {
            log.error("get_data_failed");
            return CodeResult.failedResultByMsgSource("get_data_failed");
        }
        return new CodeResult<Object>(CodeResult.Code.Success, JSON.parse((String)dataConfig.getData()));
    }

    public DataConfig selectByPrimaryKey(String tenantId, String dpCode, String dpId) {
        DataConfig selectByPrimaryKey = this.userDataConfigMapper.selectByPrimaryKey(tenantId, dpCode, dpId);
        if (selectByPrimaryKey == null) {
            selectByPrimaryKey = this.dataconfigMapper.selectByPrimaryKey("default", dpCode, "1");
        }
        return selectByPrimaryKey;
    }

    public Object updateConfig(String tenantId, String dpCode, String dpId, String code, String name, String type, String delAll) {
        if (StringUtils.isBlank((CharSequence)code) || StringUtils.isBlank((CharSequence)name) || StringUtils.isBlank((CharSequence)type)) {
            return CodeResult.failedResultByMsgSource("params_error");
        }
        Long codeInt = Long.parseLong(code);
        Object obj = this.getDataConfig(tenantId, dpCode, dpId);
        CodeResult codeResult = (CodeResult)obj;
        if (CodeResult.Code.Success.getCodeValue() != codeResult.getCode()) {
            return obj;
        }
        String resultMsg = "success";
        CodeResult.Code resultCode = CodeResult.Code.SUCCESS;
        try {
            Object result = codeResult.getResult();
            JsonPath jsonPath_delete = JsonPath.compile((String)("$.*[?(@.code == " + codeInt + ")]"), (Predicate[])new Predicate[0]);
            DocumentContext document = JsonPath.parse(result);
            List type_Obj = (List)document.read(JsonPath.compile((String)("$.*[?(@.code == " + codeInt + ")].type"), (Predicate[])new Predicate[0]));
            List read_name = (List)document.read(JsonPath.compile((String)("$.*[?(@.name == '" + name + "')]"), (Predicate[])new Predicate[0]));
            if (type_Obj == null || type_Obj.isEmpty() || type_Obj != null && !type_Obj.isEmpty() && type_Obj.get(0).toString().equals("custom")) {
                JsonPath jsonPath_update;
                List read = (List)document.read(jsonPath_delete);
                if ("delete".equals(type)) {
                    try {
                        this.exitData(tenantId, dpCode, delAll, code);
                    }
                    catch (CustomException e) {
                        log.error("update_failedmsg:{}", (Object)e.getMsg());
                        return CodeResult.failedResult(type + " config msg fail, msg :" + e.getMsg());
                    }
                    document.delete(jsonPath_delete);
                } else if ("add".equals(type)) {
                    if (read_name == null || read_name.isEmpty()) {
                        if (read == null || read.size() == 0) {
                            JSONObject json = new JSONObject();
                            json.put("code", (Object)codeInt);
                            json.put("name", (Object)name);
                            json.put("type", (Object)"custom");
                            document.add(JsonPath.compile((String)"$.*", (Predicate[])new Predicate[0]), (Object)json);
                        } else {
                            jsonPath_update = JsonPath.compile((String)("$.*[?(@.code == " + codeInt + ")].name"), (Predicate[])new Predicate[0]);
                            document.set(jsonPath_update, (Object)name);
                            resultMsg = "config_exists_overwrite_data";
                        }
                    } else {
                        resultMsg = "config_name_exists";
                        resultCode = CodeResult.Code.Failed;
                    }
                } else if (read == null || read.size() == 0) {
                    resultMsg = "config_not_exists";
                    resultCode = CodeResult.Code.Failed;
                } else if (read_name == null || read_name.isEmpty()) {
                    jsonPath_update = JsonPath.compile((String)("$.*[?(@.code == " + codeInt + ")].name"), (Predicate[])new Predicate[0]);
                    document.set(jsonPath_update, (Object)name);
                } else {
                    resultMsg = "config_name_exists";
                    resultCode = CodeResult.Code.Failed;
                }
            } else {
                resultMsg = "config_cannot_modified";
                resultCode = CodeResult.Code.Failed;
            }
            DataConfig dataConfig = new DataConfig();
            dataConfig.setId(dpId);
            dataConfig.setTenantId(tenantId);
            dataConfig.setCode(dpCode);
            dataConfig.setData(JSON.toJSONString(result));
            DataConfig selectByPrimaryKey = this.userDataConfigMapper.selectByPrimaryKey(tenantId, dpCode, dpId);
            if (selectByPrimaryKey == null || StringUtils.isBlank((CharSequence)selectByPrimaryKey.getTenantId())) {
                this.userDataConfigMapper.insert(dataConfig);
            } else {
                this.userDataConfigMapper.updateConfig(dataConfig);
            }
        }
        catch (Exception e) {
            log.error("update_failedmsg:{}", (Object)e.getMessage());
            return CodeResult.failedResult(type + " config msg fail, msg :" + e.getMessage());
        }
        return CodeResult.result(resultCode, resultMsg);
    }

    public Boolean exitData(String tenantId, String dpCode, String delAll, String code) {
        switch (dpCode) {
            case "event_info_classify": {
                List<PlanInfoBean> planInfoBeans = null;
                try {
                    if (delAll.equals("1")) {
                        this.planMapper.deletePlan(new PlanInfoBean(tenantId, null, null, code, null, null));
                    }
                    planInfoBeans = this.planMapper.selectPlanListByPlanId(new PlanInfoBean(tenantId, null, null, code, null, null));
                }
                catch (Exception e) {
                    throw new CustomException("\u67e5\u8be2\u6570\u636e\u5e93\u5f02\u5e38");
                }
                if (planInfoBeans.isEmpty()) break;
                if (delAll.equals("1")) {
                    throw new CustomException("\u8be5\u6570\u636e\u5220\u9664\u5931\u8d25");
                }
                throw new CustomException("\u8be5\u6570\u636e\u6b63\u5728\u4f7f\u7528");
            }
            case "user_collect_classify": {
                List<UserCollectArticle> userCollectArticles = null;
                try {
                    if (delAll.equals("1")) {
                        this.userCollectArticleMapper.deleteByPrimaryKey(new UserCollectArticlePageParam(tenantId, Long.valueOf(code)));
                    }
                    userCollectArticles = this.userCollectArticleMapper.selectByUserCollectArticle(new UserCollectArticlePageParam(tenantId, Long.valueOf(code)));
                }
                catch (Exception e) {
                    throw new CustomException("\u67e5\u8be2\u6570\u636e\u5e93\u5f02\u5e38");
                }
                if (userCollectArticles.isEmpty()) break;
                if (delAll.equals("1")) {
                    throw new CustomException("\u8be5\u6570\u636e\u5220\u9664\u5931\u8d25");
                }
                throw new CustomException("\u8be5\u6570\u636e\u6b63\u5728\u4f7f\u7528");
            }
        }
        return true;
    }

    public static void setJsonPointerValue(ObjectNode node, JsonPointer pointer, JsonNode value) {
        JsonPointer parentPointer = pointer.head();
        JsonNode parentNode = node.at(parentPointer);
        String fieldName = pointer.last().toString().substring(1);
        if (parentNode.isMissingNode() || parentNode.isNull()) {
            parentNode = StringUtils.isNumeric((CharSequence)fieldName) ? mapper.createArrayNode() : mapper.createObjectNode();
            UserDataConfigService.setJsonPointerValue(node, parentPointer, parentNode);
        }
        if (parentNode.isArray()) {
            assert (parentNode instanceof ArrayNode);
            ArrayNode arrayNode = (ArrayNode)parentNode;
            int index = Integer.parseInt(fieldName);
            for (int i = arrayNode.size(); i <= index; ++i) {
                arrayNode.addNull();
            }
            arrayNode.set(index, value);
        } else if (parentNode.isObject()) {
            ((ObjectNode)parentNode).set(fieldName, value);
        } else {
            throw new IllegalArgumentException("`" + fieldName + "` can't be set for parent node `" + parentPointer + "` because parent is not a container but " + parentNode.getNodeType().name());
        }
    }

    public static void main(String[] args) {
        String json = "{\n    \"classify\":[\n        {\n            \"code\":0,\n            \"name\":\"\u6211\u7684\u6536\u85cf\",\n            \"type\":\"default\"\n        },\n        {\n            \"code\":1,\n            \"name\":\"\u6211\u7684\u6536\u85cf\",\n            \"type\":\"default\"\n        }\n    ]\n}";
        DocumentContext context = JsonPath.parse((String)json);
        List read = (List)context.read(JsonPath.compile((String)"$.classify[*]", (Predicate[])new Predicate[0]));
        for (Map map : read) {
            if (!String.valueOf(map.get("code")).contains("0")) continue;
            System.out.println((String)map.get("name"));
        }
        System.out.println(read);
    }
}

