/*
 * Decompiled with CFR 0.152.
 */
package com.chinamcloud.haihe.es.agg;

import com.chinamcloud.haihe.es.agg.IEsBuildAgg;
import com.chinamcloud.haihe.es.config.EsFeedbackQuery;
import com.chinamcloud.haihe.es.pojo.EsBuilderPos;
import java.util.ArrayList;
import java.util.List;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.elasticsearch.search.aggregations.AbstractAggregationBuilder;
import org.elasticsearch.search.aggregations.AggregationBuilder;
import org.elasticsearch.search.aggregations.AggregationBuilders;
import org.elasticsearch.search.aggregations.bucket.histogram.HistogramAggregationBuilder;
import org.elasticsearch.search.aggregations.bucket.terms.TermsAggregationBuilder;
import org.elasticsearch.search.sort.SortOrder;

public class EsBuildTopicStatisticAgg
implements IEsBuildAgg {
    private static final Logger log = LogManager.getLogger(EsBuildTopicStatisticAgg.class);

    @Override
    public List<AggregationBuilder> buildAgg(EsFeedbackQuery query) {
        double interval = 8.64E7;
        Integer size = EsBuilderPos.getFacetPos(query);
        Integer facetMincount = query.getFacetMincount();
        AbstractAggregationBuilder histogram = ((HistogramAggregationBuilder)((HistogramAggregationBuilder)((HistogramAggregationBuilder)AggregationBuilders.histogram((String)"histogram").field("pubTimeStr")).interval(interval).subAggregation((AggregationBuilder)AggregationBuilders.sum((String)"emotionscore").field("emotionScore"))).subAggregation((AggregationBuilder)AggregationBuilders.cardinality((String)"tbnickname").field("tbNickname.keyword"))).subAggregation((AggregationBuilder)AggregationBuilders.terms((String)"source").field("source"));
        TermsAggregationBuilder agg = (TermsAggregationBuilder)((TermsAggregationBuilder)((TermsAggregationBuilder)AggregationBuilders.terms((String)"agg").field("cluster.keyword")).size(size.intValue()).minDocCount((long)facetMincount.intValue()).subAggregation((AggregationBuilder)AggregationBuilders.topHits((String)"top").sort("pubTime", SortOrder.DESC))).subAggregation((AggregationBuilder)histogram);
        ArrayList<AggregationBuilder> aggs = new ArrayList<AggregationBuilder>();
        aggs.add((AggregationBuilder)agg);
        return aggs;
    }
}

