/*
 * Decompiled with CFR 0.152.
 */
package com.chinamcloud.haihe.es.config;

import com.chinamcloud.haihe.es.config.EsConfig;
import java.net.InetAddress;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.elasticsearch.client.transport.TransportClient;
import org.elasticsearch.common.settings.Settings;
import org.elasticsearch.common.transport.InetSocketTransportAddress;
import org.elasticsearch.common.transport.TransportAddress;
import org.elasticsearch.xpack.client.PreBuiltXPackTransportClient;

public class EsClientFactory {
    private static final Logger log = LogManager.getLogger(EsClientFactory.class);

    public static TransportClient getClient() {
        PreBuiltXPackTransportClient client = null;
        EsConfig conf = EsConfig.getConf();
        try {
            String[] hosts;
            Settings settings = Settings.builder().put("cluster.name", conf.getClusterName()).put("xpack.security.transport.ssl.enabled", false).put("xpack.security.user", conf.getUserPwd()).build();
            client = new PreBuiltXPackTransportClient(settings, new Class[0]);
            for (String s : hosts = conf.getEsHost().split(",")) {
                client.addTransportAddress((TransportAddress)new InetSocketTransportAddress(InetAddress.getByName(s), conf.getEsPort()));
            }
        }
        catch (Exception e) {
            log.error("es boot failed");
            throw new RuntimeException(e);
        }
        log.info("es start success");
        return client;
    }
}

