/*
 * Decompiled with CFR 0.152.
 */
package com.chinamcloud.haihe.es.controller;

import com.chinamcloud.haihe.common.CodeResult;
import com.chinamcloud.haihe.common.afterprocessor.IAfterProcessor;
import com.chinamcloud.haihe.common.bean.Page;
import com.chinamcloud.haihe.common.bean.Trend;
import com.chinamcloud.haihe.common.i18n.MessageSource;
import com.chinamcloud.haihe.common.pojo.HotParams;
import com.chinamcloud.haihe.common.pojo.SimpleNews;
import com.chinamcloud.haihe.common.utils.DateUtils;
import com.chinamcloud.haihe.es.agg.EsBuildEventStatisticAgg;
import com.chinamcloud.haihe.es.agg.EsHotTopicAgg;
import com.chinamcloud.haihe.es.bean.EventStatisticResult;
import com.chinamcloud.haihe.es.bean.HotEventStatistic;
import com.chinamcloud.haihe.es.bean.HotTopicStatistic;
import com.chinamcloud.haihe.es.factory.EsNewsCacheDecoratorPattern;
import com.chinamcloud.haihe.es.parser.SimpleNewsParser;
import com.chinamcloud.haihe.es.processor.ParamsEsFeedBackQueryProcessor;
import com.chinamcloud.haihe.es.result.EsPagedResult;
import com.chinamcloud.haihe.es.result.EsSearchResult;
import com.chinamcloud.haihe.es.result.EsTotalScaleByTimeProcessor;
import com.chinamcloud.haihe.es.result.EsTotalScaleProcessor;
import com.chinamcloud.haihe.es.service.EsNewsDataService;
import com.chinamcloud.haihe.es.utils.TimeEnum;
import com.chinamcloud.haihe.es.utils.ToolUtils;
import java.text.NumberFormat;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.apache.commons.lang3.StringUtils;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.elasticsearch.search.sort.SortOrder;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Controller;

@Controller
public class EsExclusiveController {
    private static final Logger log = LogManager.getLogger(EsExclusiveController.class);
    @Autowired
    private EsNewsDataService esNewsDataService;
    @Autowired
    private EsNewsCacheDecoratorPattern esNewsCacheDecoratorPattern;

    public Object getAlikeList(HotParams<Page<SimpleNews>, EsPagedResult<EsSearchResult>> params) {
        if (params == null || params.getRefererUrl() == null && !params.getRefererUrl().isEmpty() && StringUtils.isBlank((CharSequence)params.getCluster()) && StringUtils.isBlank((CharSequence)params.getSubject())) {
            return CodeResult.failedResultByMsgSource("params_error");
        }
        return this.esNewsCacheDecoratorPattern.execute("getAlikeList", params.clone(), () -> {
            CodeResult<2> listMap = null;
            Page<SimpleNews> queryHotNewsSearch = null;
            try {
                queryHotNewsSearch = this.esNewsDataService.queryHotEvent(params);
                if (queryHotNewsSearch == null) {
                    return CodeResult.failedResultByMsgSource("get_data_failed");
                }
                final List<SimpleNews> records = queryHotNewsSearch.getRecords();
                if (records == null || records.isEmpty()) {
                    return new CodeResult<List>(CodeResult.Code.Success, Collections.EMPTY_LIST);
                }
                final HashSet clusterIds = new HashSet(16);
                records.stream().filter(x -> x.getClusterId() != null).forEach(x -> clusterIds.add(x.getClusterId()));
                Page<SimpleNews> simpleNewsPage = null;
                if (!clusterIds.isEmpty()) {
                    HotParams hotParams = new HotParams();
                    hotParams.setIndex(params.getIndex());
                    hotParams.setSize(1000);
                    hotParams.setClusterId((List<Long>)new ArrayList<Long>(){
                        {
                            this.addAll(clusterIds);
                        }
                    });
                    hotParams.setEsResultProcessor(params.getEsResultProcessor());
                    hotParams.setParser(new SimpleNewsParser(SimpleNewsParser.TYPE.ALIKE));
                    simpleNewsPage = this.esNewsDataService.queryHotEvent(hotParams);
                }
                IAfterProcessor<?, ?> afterProcessor = params.getAfterProcessor();
                List simpleNewsList = null;
                if (simpleNewsPage != null) {
                    simpleNewsList = simpleNewsPage.getRecords();
                }
                if (simpleNewsList == null) {
                    simpleNewsList = new ArrayList();
                }
                HashMap<String, List<SimpleNews>> map = new HashMap<String, List<SimpleNews>>();
                map.put("Original", records);
                map.put("similar", simpleNewsList);
                listMap = afterProcessor != null ? (CodeResult<2>)afterProcessor.process(map) : new CodeResult<2>(CodeResult.Code.Success, new ArrayList<Map>(){
                    {
                        for (final SimpleNews record : records) {
                            this.add(new HashMap<String, Object>(){
                                {
                                    this.put("data", record);
                                    this.put("nodes", new HashMap<String, Object>(){
                                        {
                                            this.put("name", record.getParentSource());
                                            this.put("time", record.getPubTime());
                                            this.put("title", record.getTitle());
                                        }
                                    });
                                    this.put("links", new ArrayList());
                                    this.put("media", 1);
                                    this.put("books", 1);
                                }
                            });
                        }
                    }
                });
                return listMap;
            }
            catch (IllegalArgumentException e) {
                log.error((Object)e);
                return CodeResult.failedResultByMsgSource("params_error");
            }
            catch (ParamsEsFeedBackQueryProcessor.ConfigMappingNoDataException e) {
                log.error((Object)e);
                return CodeResult.successResult(null, Collections.emptyList());
            }
            catch (Exception e) {
                log.error((Object)e);
                return CodeResult.failedResultByMsgSource("server_error");
            }
        }, null);
    }

    public Object totalScale(HotParams params) {
        return this.esNewsCacheDecoratorPattern.execute("totalScale", params.clone(), () -> {
            TimeEnum timeEnum = TimeEnum.DAY;
            try {
                Map<String, Long> map;
                Trend<Map<String, Long>> mapTrend;
                EventStatisticResult eventStatisticResult = new EventStatisticResult();
                HotEventStatistic hotEventStatistic = this.esNewsDataService.totalScale(params);
                List<Date> dateList = DateUtils.GetTime(-1, true, "week");
                params.setFromDt(dateList.get(0));
                params.setToDt(dateList.get(1));
                params.setEsResultProcessor(new EsTotalScaleByTimeProcessor(timeEnum));
                params.setIEsBuildAgg(new EsBuildEventStatisticAgg((Map<String, String>)new HashMap<String, String>(){
                    {
                        this.put("source", "terms");
                        this.put("url_MD5", "cardinality");
                    }
                }, timeEnum));
                HotEventStatistic hotEventStatisticByTime = this.esNewsDataService.totalScale(params);
                List<Trend<Long>> topic_count = hotEventStatistic.getTopic_count();
                List<Trend<Long>> media_cover = hotEventStatistic.getMedia_cover();
                List<Trend<Double>> emotion_value = hotEventStatistic.getEmotion_value();
                List<Trend<Long>> doc_count = hotEventStatistic.getDoc_count();
                List<Trend<Map<String, Long>>> emotion_tendency_value = hotEventStatistic.getEmotion_tendency_value();
                List<Trend<Long>> tody_doc = hotEventStatisticByTime.getDoc_count();
                NumberFormat nf = NumberFormat.getNumberInstance();
                nf.setMaximumFractionDigits(2);
                List<Trend<Map<String, Long>>> source_value = hotEventStatisticByTime.getSource_value();
                if (topic_count != null && !topic_count.isEmpty()) {
                    eventStatisticResult.setTopicTotal(topic_count.get(0).getValue());
                }
                if (media_cover != null && !media_cover.isEmpty()) {
                    eventStatisticResult.setMediaCoverTotal(media_cover.get(0).getValue());
                }
                if (emotion_value != null && !emotion_value.isEmpty()) {
                    eventStatisticResult.setEmotionAvg(new Double(nf.format(emotion_value.get(0).getValue())));
                }
                if (doc_count != null && !doc_count.isEmpty()) {
                    eventStatisticResult.setDocTotal(doc_count.get(0).getValue());
                }
                if (source_value != null && !source_value.isEmpty()) {
                    Double sum = 0.0;
                    for (Trend<Map<String, Long>> mapTrend2 : source_value) {
                        Map<String, Long> map2 = mapTrend2.getValue();
                        if (map2.isEmpty()) continue;
                        sum = sum + ToolUtils.HeatCalculation(map2, (Integer)60);
                    }
                    eventStatisticResult.setHeat(new Double(nf.format(sum / (double)source_value.size())));
                }
                if (tody_doc != null && !tody_doc.isEmpty()) {
                    eventStatisticResult.setTodayDoc(tody_doc.get(tody_doc.size() - 1).getValue());
                }
                if (emotion_tendency_value != null && !emotion_tendency_value.isEmpty() && (mapTrend = emotion_tendency_value.get(0)) != null && (map = mapTrend.getValue()) != null) {
                    for (Map.Entry<String, Long> stringLongEntry : map.entrySet()) {
                        if ("1".contains(stringLongEntry.getKey())) {
                            eventStatisticResult.setEmotionPositive(stringLongEntry.getValue());
                        }
                        if ("0".contains(stringLongEntry.getKey())) {
                            eventStatisticResult.setEmotionNeutrality(stringLongEntry.getValue());
                        }
                        if (!"-1".contains(stringLongEntry.getKey())) continue;
                        eventStatisticResult.setEmotionNegative(stringLongEntry.getValue());
                    }
                }
                return new CodeResult<EventStatisticResult>(CodeResult.Code.Success, eventStatisticResult);
            }
            catch (IllegalArgumentException e) {
                log.error((Object)e);
                return CodeResult.failedResultByMsgSource("params_error");
            }
            catch (ParamsEsFeedBackQueryProcessor.ConfigMappingNoDataException e) {
                log.error((Object)e);
                return CodeResult.successResult(null, Collections.emptyList());
            }
            catch (Exception e) {
                log.error((Object)e);
                return CodeResult.failedResultByMsgSource("server_error");
            }
        }, null);
    }

    public Object searchNews(HotParams<Page<SimpleNews>, EsPagedResult<EsSearchResult>> params) {
        return this.esNewsCacheDecoratorPattern.execute("searchNews", params.clone(), () -> {
            Page<SimpleNews> queryHotNewsSearch = null;
            try {
                if (params.getDuplicate().booleanValue()) {
                    params.setFacetField("cluster");
                    Integer size = params.getSize();
                    params.setFacetLimit((size == null ? 10 : size) * params.getPage());
                    params.setIEsBuildAgg(new EsHotTopicAgg(SortOrder.DESC, null));
                    queryHotNewsSearch = this.esNewsDataService.clusterAndArticle(params);
                } else {
                    queryHotNewsSearch = this.esNewsDataService.queryHotEvent(params);
                }
                IAfterProcessor<?, ?> afterProcessor = params.getAfterProcessor();
                if (queryHotNewsSearch == null) {
                    return CodeResult.failedResultByMsgSource("get_data_failed");
                }
                CodeResult<Page<SimpleNews>> result = null;
                result = afterProcessor != null ? (CodeResult<Page<SimpleNews>>)afterProcessor.process(queryHotNewsSearch) : new CodeResult<Page<SimpleNews>>(CodeResult.Code.Success, queryHotNewsSearch);
                return result;
            }
            catch (IllegalArgumentException e) {
                log.error((Object)e);
                return CodeResult.failedResultByMsgSource("params_error");
            }
            catch (ParamsEsFeedBackQueryProcessor.ConfigMappingNoDataException e) {
                log.error((Object)e);
                return CodeResult.successResult(null, Collections.emptyList());
            }
            catch (Exception e) {
                log.error((Object)e);
                return CodeResult.failedResultByMsgSource("server_error");
            }
        }, 21600);
    }

    public Object profile(HotParams params, List<String> type) {
        return this.esNewsCacheDecoratorPattern.execute("profile" + type.toString(), params.clone(), () -> {
            HashMap<String, Integer> map = new HashMap<String, Integer>();
            Iterator iterator = type.iterator();
            while (iterator.hasNext()) {
                String typeName;
                switch (typeName = (String)iterator.next()) {
                    case "total": {
                        Integer integer;
                        params.setDay(null);
                        params.setFromDt(null);
                        params.setToDt(null);
                        try {
                            integer = this.esNewsDataService.statisticNews(params);
                            map.put("total", integer);
                        }
                        catch (Exception e) {
                            e.printStackTrace();
                        }
                        break;
                    }
                    case "negative": {
                        Integer integer;
                        params.setEmotionTendency("-1");
                        try {
                            integer = this.esNewsDataService.statisticNews(params);
                            map.put("negative", integer);
                        }
                        catch (Exception e) {
                            e.printStackTrace();
                        }
                        params.setEmotionTendency(null);
                        break;
                    }
                    case "extreme": {
                        Integer integer;
                        params.setEmotionUpper(-90);
                        params.setEmotionLower(-99);
                        try {
                            integer = this.esNewsDataService.statisticNews(params);
                            map.put("extreme", integer);
                        }
                        catch (Exception e) {
                            e.printStackTrace();
                        }
                        params.setEmotionUpper(null);
                        params.setEmotionLower(null);
                        break;
                    }
                    case "today": {
                        List<Date> dateList = DateUtils.GetTodayTime();
                        params.setFromDt(dateList.get(0));
                        params.setToDt(dateList.get(1));
                        try {
                            Integer integer = this.esNewsDataService.statisticNews(params);
                            map.put("today", integer);
                        }
                        catch (Exception e) {
                            e.printStackTrace();
                        }
                        break;
                    }
                    case "allTotal": {
                        HotParams allParams = new HotParams();
                        allParams.setIndex(params.getIndex());
                        allParams.setEsResultProcessor(params.getEsResultProcessor());
                        try {
                            Integer integer = this.esNewsDataService.statisticNews(allParams);
                            map.put("allTotal", integer);
                        }
                        catch (Exception e) {
                            e.printStackTrace();
                        }
                        break;
                    }
                }
            }
            return CodeResult.SUCCESSRESULT("success", map);
        }, 43200);
    }

    public Object getGrade(HotParams params, Integer emotionUpper, Integer emotionLower) {
        return this.esNewsCacheDecoratorPattern.execute("getGrade" + emotionUpper + emotionLower, params.clone(), () -> {
            HashMap<String, Long> map = new HashMap<String, Long>(3);
            try {
                HotEventStatistic hotEventStatistic = this.esNewsDataService.totalScale(params);
                params.setEsResultProcessor(new EsTotalScaleProcessor());
                params.setIEsBuildAgg(new EsBuildEventStatisticAgg((Map<String, String>)new HashMap<String, String>(){
                    {
                        this.put("url_MD5", "cardinality");
                    }
                }));
                params.setEmotionUpper(emotionUpper);
                params.setEmotionLower(emotionLower);
                HotEventStatistic hotEventStatisticByTime = this.esNewsDataService.totalScale(params);
                List<Trend<Long>> media_cover = hotEventStatistic.getMedia_cover();
                List<Trend<Long>> doc_count = hotEventStatistic.getDoc_count();
                List<Trend<Long>> emotion_value = hotEventStatisticByTime.getDoc_count();
                if (media_cover != null && !media_cover.isEmpty()) {
                    map.put("media_num", media_cover.get(0).getValue());
                }
                if (doc_count != null && !doc_count.isEmpty()) {
                    map.put("doc_num", doc_count.get(0).getValue());
                }
                if (emotion_value != null && !emotion_value.isEmpty()) {
                    map.put("emotion", emotion_value.get(0).getValue());
                }
                return new CodeResult(CodeResult.Code.Success, map);
            }
            catch (IllegalArgumentException e) {
                log.error((Object)e);
                return CodeResult.failedResultByMsgSource("params_error");
            }
            catch (ParamsEsFeedBackQueryProcessor.ConfigMappingNoDataException e) {
                log.error((Object)e);
                return CodeResult.successResult(null, Collections.emptyList());
            }
            catch (Exception e) {
                log.error((Object)e);
                return CodeResult.failedResultByMsgSource("server_error");
            }
        }, 7200);
    }

    public Object hotTopic(HotParams<Page<SimpleNews>, EsPagedResult<EsSearchResult>> params) {
        if (params == null || StringUtils.isBlank((CharSequence)params.getFacetField())) {
            return CodeResult.failedResultByMsgSource("params_error");
        }
        return this.esNewsCacheDecoratorPattern.execute("hotTopic", params.clone(), () -> {
            try {
                List<HotTopicStatistic> topic = this.esNewsDataService.topic(params);
                IAfterProcessor<?, ?> afterProcessor = params.getAfterProcessor();
                if (afterProcessor != null) {
                    for (HotTopicStatistic hotTopicStatistic : topic) {
                        afterProcessor.process(hotTopicStatistic);
                    }
                }
                return new CodeResult<List<HotTopicStatistic>>(CodeResult.Code.SUCCESS, topic);
            }
            catch (NumberFormatException e) {
                return new CodeResult(CodeResult.Code.Failed, MessageSource.getMsg("params_error"));
            }
            catch (ParamsEsFeedBackQueryProcessor.ConfigMappingNoDataException e) {
                return new CodeResult<List>(CodeResult.Code.Success, Collections.EMPTY_LIST);
            }
            catch (Exception e) {
                return new CodeResult(CodeResult.Code.Failed, e.getMessage());
            }
        }, 43200);
    }
}

