/*
 * Decompiled with CFR 0.152.
 */
package com.chinamcloud.haihe.es.controller;

import com.alibaba.fastjson.JSONObject;
import com.chinamcloud.haihe.common.CodeResult;
import com.chinamcloud.haihe.common.afterprocessor.IAfterProcessor;
import com.chinamcloud.haihe.common.bean.FacetResult;
import com.chinamcloud.haihe.common.bean.Page;
import com.chinamcloud.haihe.common.bean.Trend;
import com.chinamcloud.haihe.common.i18n.MessageSource;
import com.chinamcloud.haihe.common.pojo.DetailNews;
import com.chinamcloud.haihe.common.pojo.HotParams;
import com.chinamcloud.haihe.common.pojo.SimpleNews;
import com.chinamcloud.haihe.common.pojo.TableNews;
import com.chinamcloud.haihe.es.agg.EsHotTopicAgg;
import com.chinamcloud.haihe.es.bean.EsApsFacetField;
import com.chinamcloud.haihe.es.bean.EventStatisticResult;
import com.chinamcloud.haihe.es.bean.HotEventStatistic;
import com.chinamcloud.haihe.es.factory.EsNewsCacheDecoratorPattern;
import com.chinamcloud.haihe.es.processor.ParamsEsFeedBackQueryProcessor;
import com.chinamcloud.haihe.es.result.EsFacetResult;
import com.chinamcloud.haihe.es.result.EsPagedResult;
import com.chinamcloud.haihe.es.result.EsSearchResult;
import com.chinamcloud.haihe.es.service.EsNewsDataService;
import com.chinamcloud.spider.model.NewsEntity;
import java.text.NumberFormat;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.commons.lang3.StringUtils;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.elasticsearch.search.sort.SortOrder;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Controller;

@Controller
public class EsNewsDataController {
    private static final Logger log = LogManager.getLogger(EsNewsDataController.class);
    @Autowired
    private EsNewsDataService esNewsDataService;
    @Autowired
    private EsNewsCacheDecoratorPattern esNewsCacheDecoratorPattern;

    public CodeResult<Page<SimpleNews>> getNewsList(HotParams<Page<SimpleNews>, EsPagedResult<EsSearchResult>> params) {
        return this.esNewsCacheDecoratorPattern.execute("getNewsList", params.clone(), () -> {
            Page<SimpleNews> queryHotNewsSearch = null;
            try {
                if (params.getDuplicate().booleanValue()) {
                    params.setFacetField("cluster");
                    Integer size = params.getSize();
                    params.setFacetLimit((size == null ? 10 : size) * params.getPage());
                    params.setIEsBuildAgg(new EsHotTopicAgg(SortOrder.DESC, null));
                    queryHotNewsSearch = this.esNewsDataService.clusterAndArticle(params);
                } else {
                    queryHotNewsSearch = this.esNewsDataService.queryHotEvent(params);
                }
                IAfterProcessor<?, ?> afterProcessor = params.getAfterProcessor();
                if (queryHotNewsSearch == null) {
                    return CodeResult.failedResultByMsgSource("get_data_failed");
                }
                CodeResult<Page<SimpleNews>> result = null;
                result = afterProcessor != null ? (CodeResult<Page<SimpleNews>>)afterProcessor.process(queryHotNewsSearch) : new CodeResult<Page<SimpleNews>>(CodeResult.Code.Success, queryHotNewsSearch);
                return result;
            }
            catch (IllegalArgumentException e) {
                log.error((Object)e);
                return CodeResult.failedResultByMsgSource("params_error");
            }
            catch (ParamsEsFeedBackQueryProcessor.ConfigMappingNoDataException e) {
                log.error((Object)e);
                return CodeResult.successResult(null, Collections.emptyList());
            }
            catch (Exception e) {
                log.error((Object)e);
                return CodeResult.failedResultByMsgSource("server_error");
            }
        }, 21600);
    }

    public CodeResult<List<Map<String, Object>>> cluster(HotParams<List<FacetResult>, EsFacetResult<List<EsApsFacetField>>> params) {
        if (params == null || StringUtils.isBlank((CharSequence)params.getFacetField())) {
            return CodeResult.failedResultByMsgSource("params_error");
        }
        return this.esNewsCacheDecoratorPattern.execute("cluster", params.clone(), () -> {
            try {
                List<FacetResult> result = this.esNewsDataService.cluster(params);
                IAfterProcessor<?, ?> afterProcessor = params.getAfterProcessor();
                CodeResult process = null;
                if (afterProcessor != null) {
                    process = (CodeResult)afterProcessor.process(result);
                }
                return process;
            }
            catch (NumberFormatException e) {
                return new CodeResult(CodeResult.Code.Failed, MessageSource.getMsg("params_error"));
            }
            catch (ParamsEsFeedBackQueryProcessor.ConfigMappingNoDataException e) {
                return new CodeResult<List>(CodeResult.Code.Success, Collections.EMPTY_LIST);
            }
            catch (Exception e) {
                return new CodeResult(CodeResult.Code.Failed, e.getMessage());
            }
        }, null);
    }

    public Object getEntity(HttpServletRequest request) {
        HotParams params = (HotParams)request.getAttribute("params");
        Page<SimpleNews> entity = null;
        int MAX_ENTITY_SIZE = 10;
        JSONObject JSONEntity = new JSONObject(true);
        JSONObject result = new JSONObject();
        try {
            List<NewsEntity> titleEntity;
            List<NewsEntity> timeEntity;
            List<NewsEntity> organizationEntity;
            List<NewsEntity> regionEntity;
            List<NewsEntity> personEntity;
            entity = this.esNewsDataService.queryHotEvent(params);
            List<SimpleNews> records = entity.getRecords();
            if (records == null || records.size() == 0) {
                return new CodeResult<JSONObject>(CodeResult.Code.Success, result, "\u6570\u636e\u4e3a\u7a7a!");
            }
            DetailNews news = (DetailNews)records.get(0);
            List<String> summaryKeywordList = news.getSummaryKeywordList();
            if (summaryKeywordList != null && summaryKeywordList.size() > 0) {
                JSONObject json = new JSONObject();
                summaryKeywordList.stream().forEach(x -> json.put(x.trim(), (Object)0));
                JSONEntity.put("\u5173\u952e\u5b57", (Object)json);
            }
            if ((personEntity = news.getPersonEntity()) != null && personEntity.size() > 0) {
                JSONObject json = new JSONObject();
                if (personEntity.size() > 10) {
                    personEntity.sort((o1, o2) -> o2.getEntityNumber().toString().compareTo(o1.getEntityNumber().toString()));
                }
                personEntity.stream().forEach(x -> json.put(x.getEntityName(), x.getEntityNumber()));
                JSONEntity.put("\u4eba\u7269\u5b9e\u4f53", (Object)json);
            }
            if ((regionEntity = news.getRegionEntity()) != null && regionEntity.size() > 0) {
                JSONObject json = new JSONObject();
                if (regionEntity.size() > 10) {
                    regionEntity.sort((o1, o2) -> o2.getEntityNumber().toString().compareTo(o1.getEntityNumber().toString()));
                }
                regionEntity.stream().forEach(x -> json.put(x.getEntityName(), x.getEntityNumber()));
                JSONEntity.put("\u5730\u57df\u5b9e\u4f53", (Object)json);
            }
            if ((organizationEntity = news.getOrganizationEntity()) != null && organizationEntity.size() > 0) {
                JSONObject json = new JSONObject();
                if (organizationEntity.size() > 10) {
                    organizationEntity.sort((o1, o2) -> o2.getEntityNumber().toString().compareTo(o1.getEntityNumber().toString()));
                }
                organizationEntity.stream().forEach(x -> json.put(x.getEntityName(), x.getEntityNumber()));
                JSONEntity.put("\u673a\u6784\u5b9e\u4f53", (Object)json);
            }
            if ((timeEntity = news.getTimeEntity()) != null && timeEntity.size() > 0) {
                JSONObject json = new JSONObject();
                if (timeEntity.size() > 10) {
                    timeEntity.sort((o1, o2) -> o2.getEntityNumber().toString().compareTo(o1.getEntityNumber().toString()));
                }
                timeEntity.stream().forEach(x -> json.put(x.getEntityName(), x.getEntityNumber()));
                JSONEntity.put("\u65f6\u95f4\u5b9e\u4f53", (Object)json);
            }
            if ((titleEntity = news.getTitleEntity()) != null && titleEntity.size() > 0) {
                JSONObject json = new JSONObject();
                if (titleEntity.size() > 10) {
                    titleEntity.sort((o1, o2) -> o2.getEntityNumber().toString().compareTo(o1.getEntityNumber().toString()));
                }
                titleEntity.forEach(x -> json.put(x.getEntityName(), x.getEntityNumber()));
                JSONEntity.put("\u804c\u52a1\u5b9e\u4f53", (Object)json);
            }
            result.put("entity", (Object)JSONEntity);
            result.put("docId", (Object)params.getDocId());
        }
        catch (IllegalArgumentException e) {
            log.error((Object)e);
            return CodeResult.failedResultByMsgSource("params_error");
        }
        catch (ParamsEsFeedBackQueryProcessor.ConfigMappingNoDataException e) {
            log.error((Object)e);
            return CodeResult.successResult(null, Collections.emptyList());
        }
        catch (Exception e) {
            log.error((Object)e);
            return CodeResult.failedResultByMsgSource("server_error");
        }
        return new CodeResult<JSONObject>(CodeResult.Code.Success, result, "\u6210\u529f");
    }

    public Object exportNews(HotParams<List<TableNews>, EsPagedResult<EsSearchResult>> params, final HttpServletResponse response) {
        try {
            final List<TableNews> tableData = this.esNewsDataService.exportNews(params);
            IAfterProcessor<?, ?> afterProcessor = params.getAfterProcessor();
            CodeResult result = null;
            Boolean bool = true;
            if (afterProcessor != null) {
                bool = (Boolean)afterProcessor.process(new HashMap<String, Object>(){
                    {
                        this.put("tableData", tableData);
                        this.put("response", response);
                    }
                });
            }
            result = bool != false ? new CodeResult(CodeResult.Code.SUCCESS, "derived_success") : new CodeResult(CodeResult.Code.Failed, "derived_failed");
            return result;
        }
        catch (IllegalArgumentException e) {
            log.error((Object)e);
            return CodeResult.failedResultByMsgSource("params_error");
        }
        catch (ParamsEsFeedBackQueryProcessor.ConfigMappingNoDataException e) {
            log.error((Object)e);
            return CodeResult.successResult(null, Collections.emptyList());
        }
        catch (Exception e) {
            log.error((Object)e);
            return CodeResult.failedResultByMsgSource("server_error");
        }
    }

    public Object statisticNews(HotParams params) {
        return this.esNewsCacheDecoratorPattern.execute("statisticNews", params.clone(), () -> {
            try {
                Integer integer = this.esNewsDataService.statisticNews(params);
                CodeResult result = null;
                HashMap<String, Integer> map = new HashMap<String, Integer>(3);
                if (integer != null) {
                    map.put("newsValue", integer);
                    result = CodeResult.SUCCESSRESULT("success", map);
                } else {
                    result = new CodeResult(CodeResult.Code.Failed, "failed");
                }
                return result;
            }
            catch (IllegalArgumentException e) {
                log.error((Object)e);
                return CodeResult.failedResultByMsgSource("params_error");
            }
            catch (ParamsEsFeedBackQueryProcessor.ConfigMappingNoDataException e) {
                log.error((Object)e);
                return CodeResult.successResult(null, Collections.emptyList());
            }
            catch (Exception e) {
                log.error((Object)e);
                return CodeResult.failedResultByMsgSource("server_error");
            }
        }, null);
    }

    public Object totalScale(HotParams params) {
        return this.esNewsCacheDecoratorPattern.execute("statisticNews", params.clone(), () -> {
            try {
                Map<String, Long> map;
                Trend<Map<String, Long>> mapTrend;
                EventStatisticResult eventStatisticResult = new EventStatisticResult();
                HotEventStatistic hotEventStatistic = this.esNewsDataService.totalScale(params);
                List<Trend<Long>> topic_count = hotEventStatistic.getTopic_count();
                List<Trend<Long>> media_cover = hotEventStatistic.getMedia_cover();
                List<Trend<Double>> emotion_value = hotEventStatistic.getEmotion_value();
                List<Trend<Long>> doc_count = hotEventStatistic.getDoc_count();
                List<Trend<Map<String, Long>>> emotion_tendency_value = hotEventStatistic.getEmotion_tendency_value();
                NumberFormat nf = NumberFormat.getNumberInstance();
                nf.setMaximumFractionDigits(2);
                if (topic_count != null && !topic_count.isEmpty()) {
                    eventStatisticResult.setTopicTotal(topic_count.get(0).getValue());
                }
                if (media_cover != null && !media_cover.isEmpty()) {
                    eventStatisticResult.setMediaCoverTotal(media_cover.get(0).getValue());
                }
                if (emotion_value != null && !emotion_value.isEmpty()) {
                    eventStatisticResult.setEmotionAvg(new Double(nf.format(emotion_value.get(0).getValue())));
                }
                if (doc_count != null && !doc_count.isEmpty()) {
                    eventStatisticResult.setDocTotal(doc_count.get(0).getValue());
                }
                if (emotion_tendency_value != null && !emotion_tendency_value.isEmpty() && (mapTrend = emotion_tendency_value.get(0)) != null && (map = mapTrend.getValue()) != null) {
                    for (Map.Entry<String, Long> stringLongEntry : map.entrySet()) {
                        if ("1".contains(stringLongEntry.getKey())) {
                            eventStatisticResult.setEmotionPositive(stringLongEntry.getValue());
                        }
                        if ("0".contains(stringLongEntry.getKey())) {
                            eventStatisticResult.setEmotionNeutrality(stringLongEntry.getValue());
                        }
                        if (!"-1".contains(stringLongEntry.getKey())) continue;
                        eventStatisticResult.setEmotionNegative(stringLongEntry.getValue());
                    }
                }
                return CodeResult.SUCCESSRESULT("success", eventStatisticResult);
            }
            catch (IllegalArgumentException e) {
                log.error((Object)e);
                return CodeResult.failedResultByMsgSource("params_error");
            }
            catch (ParamsEsFeedBackQueryProcessor.ConfigMappingNoDataException e) {
                log.error((Object)e);
                return CodeResult.successResult(null, Collections.emptyList());
            }
            catch (Exception e) {
                log.error((Object)e);
                return CodeResult.failedResultByMsgSource("server_error");
            }
        }, null);
    }

    public Object trend(HotParams<HotEventStatistic, EsFacetResult<HotEventStatistic>> params) {
        return this.esNewsCacheDecoratorPattern.execute("trend", params.clone(), () -> {
            try {
                HotEventStatistic hotEventStatistic = this.esNewsDataService.totalScale(params);
                IAfterProcessor<?, ?> afterProcessor = params.getAfterProcessor();
                CodeResult<Object> result = null;
                if (afterProcessor != null) {
                    result = (CodeResult<HotEventStatistic>)afterProcessor.process(hotEventStatistic);
                }
                if (result == null) {
                    result = hotEventStatistic == null ? new CodeResult<HotEventStatistic>(CodeResult.Code.Success, hotEventStatistic) : new CodeResult(CodeResult.Code.Success, Collections.emptyList());
                }
                return result;
            }
            catch (IllegalArgumentException e) {
                log.error((Object)e);
                return CodeResult.failedResultByMsgSource("params_error");
            }
            catch (ParamsEsFeedBackQueryProcessor.ConfigMappingNoDataException e) {
                log.error((Object)e);
                return CodeResult.successResult(null, Collections.emptyList());
            }
            catch (Exception e) {
                log.error((Object)e);
                return CodeResult.failedResultByMsgSource("server_error");
            }
        }, null);
    }

    public Object hotTopic(HotParams<Page<SimpleNews>, EsPagedResult<EsSearchResult>> params) {
        if (params == null || StringUtils.isBlank((CharSequence)params.getFacetField())) {
            return CodeResult.failedResultByMsgSource("params_error");
        }
        return this.esNewsCacheDecoratorPattern.execute("hotTopic", params.clone(), () -> {
            try {
                params.setNonEmptyField("subject");
                params.setNoSubject("\u56fe\u7247\u65b0\u95fb AND \u5e7f\u544a AND \u62a5\u5934 AND \u62db\u6807\u516c\u544a AND \u65e0\u6807\u9898 AND \u4e00\u53e5\u8bdd\u65b0\u95fb");
                Page<SimpleNews> result = this.esNewsDataService.clusterAndArticle(params);
                IAfterProcessor<?, ?> afterProcessor = params.getAfterProcessor();
                CodeResult process = null;
                if (afterProcessor != null) {
                    process = (CodeResult)afterProcessor.process(result);
                }
                return process;
            }
            catch (NumberFormatException e) {
                return new CodeResult(CodeResult.Code.Failed, MessageSource.getMsg("params_error"));
            }
            catch (ParamsEsFeedBackQueryProcessor.ConfigMappingNoDataException e) {
                return new CodeResult<List>(CodeResult.Code.Success, Collections.EMPTY_LIST);
            }
            catch (Exception e) {
                return new CodeResult(CodeResult.Code.Failed, e.getMessage());
            }
        }, 43200);
    }

    public static void main(String[] args) {
        ArrayList<NewsEntity> titleEntity = new ArrayList<NewsEntity>();
        NewsEntity newsEntity = new NewsEntity();
        newsEntity.setEntityName("1");
        newsEntity.setEntityNumber((Object)1);
        NewsEntity newsEntity2 = new NewsEntity();
        newsEntity2.setEntityName("2");
        newsEntity2.setEntityNumber((Object)3);
        NewsEntity newsEntity3 = new NewsEntity();
        newsEntity3.setEntityName("3");
        newsEntity3.setEntityNumber((Object)2);
        titleEntity.add(newsEntity);
        titleEntity.add(newsEntity2);
        titleEntity.add(newsEntity3);
        titleEntity.sort((o1, o2) -> o2.getEntityNumber().toString().compareTo(o1.getEntityNumber().toString()));
        for (NewsEntity entity : titleEntity) {
            System.out.println(entity);
        }
    }
}

