/*
 * Decompiled with CFR 0.152.
 */
package com.chinamcloud.haihe.es.factory;

import com.chinamcloud.haihe.common.CodeResult;
import com.chinamcloud.haihe.common.cache.ConcurrentHashMapCacheUtils;
import com.chinamcloud.haihe.common.cache.RedisUtil;
import com.chinamcloud.haihe.common.pojo.HotParams;
import com.chinamcloud.haihe.common.utils.DateUtils;
import com.chinamcloud.haihe.es.factory.EsNewsCache;
import com.google.gson.Gson;
import java.util.Date;
import java.util.List;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.scheduling.concurrent.ThreadPoolTaskExecutor;
import org.springframework.stereotype.Component;

@Component
public class EsNewsCacheDecoratorPattern {
    private static final Logger log = LogManager.getLogger(EsNewsCacheDecoratorPattern.class);
    private final ThreadPoolTaskExecutor threadPoolTaskExecutor;
    private static final Gson gson = new Gson();
    private final RedisUtil redisUtil;
    private final Integer LONGTIME = 604800;
    private final Integer TEMPTIME = 600;

    @Autowired
    public EsNewsCacheDecoratorPattern(ThreadPoolTaskExecutor threadPoolTaskExecutor, RedisUtil redisUtil) {
        this.threadPoolTaskExecutor = threadPoolTaskExecutor;
        this.redisUtil = redisUtil;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public CodeResult execute(String method, HotParams params, EsNewsCache esNewsCache, Integer longTime) {
        if (longTime == null || longTime < 0) {
            longTime = this.LONGTIME;
        }
        Integer finalLongTime = longTime;
        Date fromDt = params.getFromDt();
        Date toDt = params.getToDt();
        Date fromCrawlerDt = params.getFromCrawlerDt();
        Date toCrawlerDt = params.getToCrawlerDt();
        params.setFromDt(DateUtils.getYMD(fromDt));
        params.setToDt(DateUtils.getYMD(toDt));
        params.setFromCrawlerDt(DateUtils.getYMD(fromCrawlerDt));
        params.setToCrawlerDt(DateUtils.getYMD(toCrawlerDt));
        String key = method + gson.toJson((Object)params).replaceAll(":", "|@|");
        log.info(key);
        CodeResult obj = this.redisUtil.getObj(key, CodeResult.class);
        if (obj != null) {
            EsNewsCacheDecoratorPattern esNewsCacheDecoratorPattern = this;
            synchronized (esNewsCacheDecoratorPattern) {
                Object obj_temp = ConcurrentHashMapCacheUtils.getCache(key + "temp");
                if (obj_temp == null) {
                    this.threadPoolTaskExecutor.execute(() -> {
                        CodeResult func = esNewsCache.func();
                        if (func != null && func.getCode() != 1) {
                            Object result = func.getResult();
                            if (result == null) {
                                return;
                            }
                            if (result instanceof List && ((List)result).isEmpty()) {
                                return;
                            }
                            this.redisUtil.saveObj(func, finalLongTime, key);
                        }
                    });
                    ConcurrentHashMapCacheUtils.setCache(key + "temp", 1, this.TEMPTIME * 1000);
                }
                return obj;
            }
        }
        CodeResult func = esNewsCache.func();
        if (func != null && func.getCode() != 1) {
            Object result = func.getResult();
            if (result == null) {
                return func;
            }
            if (result instanceof List && ((List)result).isEmpty()) {
                return func;
            }
            this.redisUtil.saveObj(func, longTime, key);
        }
        return func;
    }
}

