/*
 * Decompiled with CFR 0.152.
 */
package com.chinamcloud.haihe.es.parser;

import com.chinamcloud.haihe.backStageManagement.mapper.SiteQueryMapper;
import com.chinamcloud.haihe.backStageManagement.pojo.Site;
import com.chinamcloud.haihe.common.bean.NewsInfo;
import com.chinamcloud.haihe.common.bean.Page;
import com.chinamcloud.haihe.common.pojo.DetailNews;
import com.chinamcloud.haihe.common.pojo.SimpleNews;
import com.chinamcloud.haihe.common.utils.SpringUtils;
import com.chinamcloud.haihe.common.utils.UrlUtils;
import com.chinamcloud.haihe.es.parser.BaseParser;
import com.chinamcloud.haihe.es.result.EsPagedResult;
import com.chinamcloud.haihe.es.result.EsSearchResult;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashSet;
import java.util.List;
import org.apache.commons.lang3.StringUtils;

public class SimpleNewsParser
implements BaseParser<Page<SimpleNews>, EsPagedResult<EsSearchResult>> {
    private SiteQueryMapper siteQueryMapper;
    private String code = "1";

    public SimpleNewsParser() {
    }

    public SimpleNewsParser(TYPE type) {
        this.code = type.getCodeValue();
        if (this.code.contains("4")) {
            this.siteQueryMapper = SpringUtils.getBean(SiteQueryMapper.class);
        }
    }

    public SimpleNewsParser(String type) {
        this.code = type;
    }

    @Override
    public Page<SimpleNews> parseRecords(EsPagedResult<EsSearchResult> result) {
        ArrayList<DetailNews> news = new ArrayList<DetailNews>(((EsSearchResult)result.getResult()).getRecords().size());
        SimpleDateFormat format = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");
        for (NewsInfo apsFeedback : ((EsSearchResult)result.getResult()).getRecords()) {
            DetailNews detailNews = new DetailNews();
            if (this.code.contains("0")) {
                Long createdAt;
                Long pubTime = apsFeedback.getPubTime();
                if (pubTime == null) {
                    if (apsFeedback.getPubTimeStr() != null) {
                        detailNews.setPubTime(format.format(apsFeedback.getPubTimeStr()));
                    }
                } else {
                    String time = format.format(new Date(pubTime));
                    detailNews.setPubTime(time);
                }
                if ((createdAt = apsFeedback.getCreatedAt()) != null) {
                    String time = format.format(new Date(createdAt));
                    detailNews.setCreatedAtStr(time);
                }
                detailNews.setEmotionScore(apsFeedback.getEmotionScore());
                detailNews.setReadNumber(apsFeedback.getReadNumber());
                detailNews.setLikeNumber(apsFeedback.getLikeNumber());
                detailNews.setForwardNumber(apsFeedback.getForwardNumber());
                detailNews.setCommentNumber(apsFeedback.getCommentNumber());
                detailNews.setHot(apsFeedback.getHot());
            }
            if (this.code.contains("1")) {
                String classify;
                List videos;
                block30: {
                    detailNews.setDocId(apsFeedback.getId() + "");
                    detailNews.setTitle(apsFeedback.getSubject());
                    detailNews.setUrl(apsFeedback.getRefererUrl());
                    detailNews.setSource(apsFeedback.getSource());
                    detailNews.setSourceId(apsFeedback.getSourceId());
                    detailNews.setReprint(apsFeedback.getReprint());
                    if (StringUtils.isNotBlank((CharSequence)apsFeedback.getSiteName())) {
                        detailNews.setSiteName(apsFeedback.getSiteName());
                    } else {
                        detailNews.setSiteName(apsFeedback.getTbNickname());
                    }
                    detailNews.setClusterId(apsFeedback.getClusterId());
                    detailNews.setParentSource(apsFeedback.getParentSource());
                    if (apsFeedback.getIsOriginal() == null) {
                        try {
                            if (StringUtils.isBlank((CharSequence)apsFeedback.getReprint()) || StringUtils.isNotBlank((CharSequence)apsFeedback.getReprint()) && (apsFeedback.getReprint().contains(apsFeedback.getParentSource()) || apsFeedback.getParentSource().contains(apsFeedback.getReprint()))) {
                                detailNews.setIsOriginal(1);
                                break block30;
                            }
                            detailNews.setIsOriginal(-1);
                        }
                        catch (Exception e) {
                            detailNews.setIsOriginal(-1);
                        }
                    } else {
                        if (apsFeedback.getIsOriginal() <= 0) {
                            detailNews.setIsOriginal(-1);
                        }
                        if (apsFeedback.getIsOriginal() > 0) {
                            detailNews.setIsOriginal(1);
                        }
                    }
                }
                detailNews.setDigest(apsFeedback.getDigest());
                detailNews.setEmotionTendency(apsFeedback.getEmotionTendency());
                List pics = apsFeedback.getPics();
                if (null != pics) {
                    HashSet<String> editPic = new HashSet<String>(pics.size());
                    for (int i = 0; i < pics.size(); ++i) {
                        String pic = (String)pics.get(i);
                        if (!pic.contains("http")) {
                            pic = UrlUtils.canonicalizeUrl(pic, apsFeedback.getRefererUrl());
                        }
                        if (i == 0) {
                            detailNews.setPic_url(pic);
                        }
                        editPic.add(pic);
                    }
                    detailNews.setPics(new ArrayList<String>(editPic));
                }
                if ((videos = apsFeedback.getVideos()) != null && !videos.isEmpty()) {
                    detailNews.setVideos(videos);
                }
                if (StringUtils.isNotBlank((CharSequence)(classify = apsFeedback.getClassify()))) {
                    detailNews.setClassify(classify);
                } else {
                    detailNews.setClassify("\u5176\u4ed6");
                }
                detailNews.setCover(apsFeedback.getCover());
            }
            if (this.code.contains("2")) {
                String description = apsFeedback.getDescription();
                if (StringUtils.isNotBlank((CharSequence)description)) {
                    description = description.replace("`n`", "").replace("[[+_+]]", "").replace("nbsp;", "").trim();
                }
                detailNews.setDescription(description);
                String htmlDescription = apsFeedback.getHtmlDescription();
                if (StringUtils.isEmpty((CharSequence)htmlDescription)) {
                    detailNews.setHtmlDescription(description);
                } else {
                    detailNews.setHtmlDescription(htmlDescription);
                }
            }
            if (this.code.contains("3")) {
                detailNews.setOrganizationEntity(apsFeedback.getOrganizationEntity());
                detailNews.setOtherEntity(apsFeedback.getOtherEntity());
                detailNews.setPersonEntity(apsFeedback.getPersonEntity());
                detailNews.setRegionEntity(apsFeedback.getRegionEntity());
                detailNews.setTimeEntity(apsFeedback.getTimeEntity());
                detailNews.setTitleEntity(apsFeedback.getTitleEntity());
                detailNews.setSummaryKeywordList(apsFeedback.getSummaryKeywordList());
            }
            if (this.code.contains("4")) {
                Site site = this.siteQueryMapper.getSiteById(apsFeedback.getSourceId());
                detailNews.setSite(site);
            }
            if (this.code.contains("5")) {
                detailNews.setCluster(apsFeedback.getCluster());
                detailNews.setClusterId(apsFeedback.getClusterId());
            }
            news.add(detailNews);
        }
        Page<SimpleNews> pager = new Page<SimpleNews>(news);
        pager.setTotalCount(result.getTotalCount());
        pager.setPageSize(result.getPageSize());
        pager.setTotalPages(result.getTotalPages());
        return pager;
    }

    public static enum TYPE {
        BASE("01"),
        DETAIL("012"),
        ENTITY("0123"),
        SITE("0124"),
        TOPIC("05"),
        ALIKE("015");

        private String code;

        private TYPE(String code) {
            this.code = code;
        }

        public String getCodeValue() {
            return this.code;
        }
    }
}

