/*
 * Decompiled with CFR 0.152.
 */
package com.chinamcloud.haihe.es.pojo;

import com.chinamcloud.haihe.common.utils.DateUtils;
import com.chinamcloud.haihe.es.config.EsFeedbackQuery;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import org.apache.commons.lang3.StringUtils;
import org.apache.lucene.search.join.ScoreMode;
import org.elasticsearch.index.query.BoolQueryBuilder;
import org.elasticsearch.index.query.MatchPhraseQueryBuilder;
import org.elasticsearch.index.query.MatchQueryBuilder;
import org.elasticsearch.index.query.Operator;
import org.elasticsearch.index.query.QueryBuilder;
import org.elasticsearch.index.query.QueryBuilders;
import org.elasticsearch.index.query.RangeQueryBuilder;

public class EsBuildQuery {
    public static QueryBuilder getQuery(EsFeedbackQuery feedbackQuery) {
        BoolQueryBuilder query = QueryBuilders.boolQuery();
        EsBuildQuery.setDescription(query, feedbackQuery);
        EsBuildQuery.setNoDescription(query, feedbackQuery);
        EsBuildQuery.setFilterBuilder(query, feedbackQuery);
        EsBuildQuery.setOrganizationEntity(query, feedbackQuery);
        EsBuildQuery.setPersonEntity(query, feedbackQuery);
        EsBuildQuery.setRegionEntity(query, feedbackQuery);
        EsBuildQuery.setTitleEntity(query, feedbackQuery);
        EsBuildQuery.setSummaryKeywordList(query, feedbackQuery);
        return query;
    }

    protected static void setFilterBuilder(BoolQueryBuilder query, EsFeedbackQuery feedbackQuery) {
        BoolQueryBuilder filter = QueryBuilders.boolQuery();
        EsBuildQuery.setId(filter, feedbackQuery);
        EsBuildQuery.setSourceId(filter, feedbackQuery);
        EsBuildQuery.setRefererUrl(query, feedbackQuery);
        EsBuildQuery.setSource(filter, feedbackQuery);
        EsBuildQuery.setClusterId(filter, feedbackQuery);
        EsBuildQuery.setCluster(filter, feedbackQuery);
        EsBuildQuery.setPubtime(filter, feedbackQuery);
        EsBuildQuery.setCrawlertime(filter, feedbackQuery);
        EsBuildQuery.setContentShouldContains(filter, feedbackQuery);
        EsBuildQuery.setSubject(filter, feedbackQuery);
        EsBuildQuery.setNoSubject(filter, feedbackQuery);
        EsBuildQuery.setTbNickname(filter, feedbackQuery);
        EsBuildQuery.settLayoutIndex(filter, feedbackQuery);
        EsBuildQuery.setEmotionTendency(filter, feedbackQuery);
        EsBuildQuery.setEmotionScore(filter, feedbackQuery);
        EsBuildQuery.setEmptyField(filter, feedbackQuery);
        EsBuildQuery.setNonEmptyField(filter, feedbackQuery);
        EsBuildQuery.setEntityList(filter, feedbackQuery);
        EsBuildQuery.setClassify(filter, feedbackQuery);
        EsBuildQuery.setCity(filter, feedbackQuery);
        EsBuildQuery.setLevel(filter, feedbackQuery);
        EsBuildQuery.setPid(filter, feedbackQuery);
        EsBuildQuery.setIsOriginal(filter, feedbackQuery);
        EsBuildQuery.setWordsNum(filter, feedbackQuery);
        EsBuildQuery.setProvince(filter, feedbackQuery);
        EsBuildQuery.setMunicipality(filter, feedbackQuery);
        EsBuildQuery.setPrefecture(filter, feedbackQuery);
        EsBuildQuery.setSummaryPhrase(filter, feedbackQuery);
        if (filter.hasClauses()) {
            query.filter((QueryBuilder)filter);
        }
    }

    protected static void setEmptyField(BoolQueryBuilder boolQuery, EsFeedbackQuery feedbackQuery) {
        List<String> emptyField = feedbackQuery.getEmptyField();
        if (emptyField != null) {
            for (String field : emptyField) {
                boolQuery.mustNot((QueryBuilder)QueryBuilders.existsQuery((String)field));
            }
        }
    }

    protected static void setNonEmptyField(BoolQueryBuilder boolQuery, EsFeedbackQuery feedbackQuery) {
        List<String> nonEmptyField = feedbackQuery.getNonEmptyField();
        if (nonEmptyField != null) {
            for (String field : nonEmptyField) {
                boolQuery.must((QueryBuilder)QueryBuilders.existsQuery((String)field));
                boolQuery.mustNot((QueryBuilder)QueryBuilders.termsQuery((String)field, (String[])new String[]{""}));
            }
        }
    }

    protected static void setRefererUrl(BoolQueryBuilder boolQuery, EsFeedbackQuery feedbackQuery) {
        List<String> refererUrl = feedbackQuery.getRefererUrl();
        if (refererUrl != null && refererUrl.size() > 0) {
            boolQuery.must((QueryBuilder)QueryBuilders.termsQuery((String)"refererUrl", refererUrl));
        }
    }

    protected static void setDescription(BoolQueryBuilder boolQuery, EsFeedbackQuery feedbackQuery) {
        String description = feedbackQuery.getDescription();
        BoolQueryBuilder boolQueryBuilder = QueryBuilders.boolQuery();
        if (!StringUtils.isEmpty((CharSequence)description)) {
            String[] groups;
            for (String group : groups = description.split("OR")) {
                String[] keywords;
                BoolQueryBuilder boolmatch = QueryBuilders.boolQuery();
                for (String keyword : keywords = group.split("AND")) {
                    MatchPhraseQueryBuilder tmp = QueryBuilders.matchPhraseQuery((String)"description", (Object)keyword.trim()).analyzer("ik_smart");
                    boolmatch.must((QueryBuilder)tmp);
                }
                boolQueryBuilder.should((QueryBuilder)boolmatch);
            }
            boolQuery.must((QueryBuilder)boolQueryBuilder);
        }
    }

    protected static void setNoDescription(BoolQueryBuilder boolQuery, EsFeedbackQuery feedbackQuery) {
        String noDescription = feedbackQuery.getNoDescription();
        BoolQueryBuilder boolQueryBuilder = QueryBuilders.boolQuery();
        if (!StringUtils.isEmpty((CharSequence)noDescription)) {
            String[] groups;
            for (String group : groups = noDescription.split("OR")) {
                String[] keywords;
                BoolQueryBuilder boolmatch = QueryBuilders.boolQuery();
                for (String keyword : keywords = group.split("AND")) {
                    boolmatch.mustNot((QueryBuilder)QueryBuilders.wildcardQuery((String)"description", (String)("*" + keyword.trim() + "*")));
                }
                boolQueryBuilder.should((QueryBuilder)boolmatch);
            }
            boolQuery.must((QueryBuilder)boolQueryBuilder);
        }
    }

    protected static void setContentShouldContains(BoolQueryBuilder boolQuery, EsFeedbackQuery feedbackQuery) {
        String contentShouldContain = feedbackQuery.getContentShouldContain();
        BoolQueryBuilder boolQueryBuilder = QueryBuilders.boolQuery();
        if (contentShouldContain != null) {
            boolQueryBuilder.should((QueryBuilder)QueryBuilders.matchPhraseQuery((String)"description", (Object)contentShouldContain));
            boolQueryBuilder.should((QueryBuilder)QueryBuilders.matchPhraseQuery((String)"subject", (Object)contentShouldContain));
            boolQueryBuilder.should((QueryBuilder)QueryBuilders.matchPhraseQuery((String)"cluster", (Object)contentShouldContain));
            boolQuery.must((QueryBuilder)boolQueryBuilder);
        }
    }

    protected static void setSubject(BoolQueryBuilder boolQuery, EsFeedbackQuery feedbackQuery) {
        String subject = feedbackQuery.getSubject();
        BoolQueryBuilder boolQueryBuilder = QueryBuilders.boolQuery();
        if (subject != null) {
            String[] groups;
            for (String group : groups = subject.split("OR")) {
                String[] keywords;
                BoolQueryBuilder boolmatch = QueryBuilders.boolQuery();
                for (String keyword : keywords = group.split("AND")) {
                    MatchQueryBuilder tmp = QueryBuilders.matchQuery((String)"subject", (Object)keyword.trim());
                    tmp.operator(Operator.AND);
                    boolmatch.must((QueryBuilder)tmp);
                }
                boolQueryBuilder.should((QueryBuilder)boolmatch);
            }
            boolQuery.must((QueryBuilder)boolQueryBuilder);
        }
    }

    protected static void setNoSubject(BoolQueryBuilder boolQuery, EsFeedbackQuery feedbackQuery) {
        String noSubject = feedbackQuery.getNoSubject();
        BoolQueryBuilder boolQueryBuilder = QueryBuilders.boolQuery();
        if (noSubject != null) {
            String[] groups;
            for (String group : groups = noSubject.split("OR")) {
                String[] keywords;
                BoolQueryBuilder boolmatch = QueryBuilders.boolQuery();
                for (String keyword : keywords = group.split("AND")) {
                    MatchQueryBuilder tmp = QueryBuilders.matchQuery((String)"subject", (Object)keyword.trim());
                    tmp.operator(Operator.AND);
                    boolmatch.mustNot((QueryBuilder)tmp);
                }
                boolQueryBuilder.should((QueryBuilder)boolmatch);
            }
            boolQuery.must((QueryBuilder)boolQueryBuilder);
        }
    }

    protected static void setId(BoolQueryBuilder boolQuery, EsFeedbackQuery feedbackQuery) {
        String id = feedbackQuery.getId();
        Set<String> ids = feedbackQuery.getIds();
        if (ids == null) {
            ids = new HashSet<String>();
        }
        if (id != null) {
            ids.add(id);
        }
        if (!ids.isEmpty()) {
            ArrayList<String> objects = new ArrayList<String>();
            objects.addAll(ids);
            boolQuery.must((QueryBuilder)QueryBuilders.termsQuery((String)"id", objects));
        }
    }

    protected static void setSource(BoolQueryBuilder boolQuery, EsFeedbackQuery feedbackQuery) {
        String source;
        List<String> sources = feedbackQuery.getSources();
        if (sources != null && sources.size() > 0 && !(source = sources.get(0)).equals("all")) {
            boolQuery.must((QueryBuilder)QueryBuilders.termsQuery((String)"source", sources));
        }
    }

    protected static void setSourceId(BoolQueryBuilder boolQuery, EsFeedbackQuery feedbackQuery) {
        List<Integer> sourceIds = feedbackQuery.getSourceIds();
        if (sourceIds != null && sourceIds.size() > 0) {
            boolQuery.must((QueryBuilder)QueryBuilders.termsQuery((String)"sourceId", sourceIds));
        }
    }

    protected static void setClusterId(BoolQueryBuilder boolQuery, EsFeedbackQuery feedbackQuery) {
        List<Long> clusterId = feedbackQuery.getClusterId();
        if (clusterId != null && clusterId.size() > 0) {
            boolQuery.must((QueryBuilder)QueryBuilders.termsQuery((String)"clusterId", clusterId));
        }
    }

    protected static void setCluster(BoolQueryBuilder boolQuery, EsFeedbackQuery feedbackQuery) {
        String cluster = feedbackQuery.getCluster();
        if (cluster != null) {
            boolQuery.must((QueryBuilder)QueryBuilders.termQuery((String)"cluster.keyword", (String)cluster));
        }
    }

    protected static void setPubtime(BoolQueryBuilder boolQuery, EsFeedbackQuery feedbackQuery) {
        Date from = DateUtils.string2date(feedbackQuery.getPubTimeBegin());
        Date to = DateUtils.string2date(feedbackQuery.getPubTimeEnd());
        if (from != null && to != null) {
            boolQuery.must((QueryBuilder)QueryBuilders.rangeQuery((String)"pubTime").from((Object)from.getTime()).to((Object)to.getTime()));
        }
    }

    protected static void setCrawlertime(BoolQueryBuilder boolQuery, EsFeedbackQuery feedbackQuery) {
        Date from = DateUtils.string2date(feedbackQuery.getCreatedAtBegin());
        Date to = DateUtils.string2date(feedbackQuery.getCreatedAtEnd());
        if (from != null && to != null) {
            boolQuery.must((QueryBuilder)QueryBuilders.rangeQuery((String)"createdAt").from((Object)from.getTime()).to((Object)to.getTime()));
        }
    }

    protected static void setTbNickname(BoolQueryBuilder boolQuery, EsFeedbackQuery feedbackQuery) {
        List<String> tbNicknames = feedbackQuery.getTbNicknames();
        if (tbNicknames != null && !tbNicknames.isEmpty()) {
            for (int i = 0; i < tbNicknames.size(); ++i) {
                String tbNickname;
                if (i > 5 || (tbNickname = tbNicknames.get(i)).length() > 15) continue;
                boolQuery.must((QueryBuilder)QueryBuilders.wildcardQuery((String)"tbNickname.keyword", (String)("*" + tbNickname + "*")));
            }
        }
    }

    protected static void settLayoutIndex(BoolQueryBuilder boolQuery, EsFeedbackQuery feedbackQuery) {
        List<Integer> layoutIndex = feedbackQuery.getLayoutIndex();
        if (layoutIndex != null && !layoutIndex.isEmpty()) {
            boolQuery.must((QueryBuilder)QueryBuilders.termsQuery((String)"layoutIndex", layoutIndex));
        }
    }

    protected static void setEmotionTendency(BoolQueryBuilder boolQuery, EsFeedbackQuery feedbackQuery) {
        Integer emotionTendency = feedbackQuery.getEmotionTendency();
        if (emotionTendency != null) {
            boolQuery.must((QueryBuilder)QueryBuilders.termQuery((String)"emotionTendency", (Object)emotionTendency));
        }
    }

    protected static void setEmotionScore(BoolQueryBuilder boolQuery, EsFeedbackQuery feedbackQuery) {
        Integer emotionScoreUpper = feedbackQuery.getEmotionScoreUpper();
        Integer emotionScoreLower = feedbackQuery.getEmotionScoreLower();
        if (emotionScoreUpper != null || emotionScoreLower != null) {
            RangeQueryBuilder rangeQuery = QueryBuilders.rangeQuery((String)"emotionScore");
            if (emotionScoreUpper != null) {
                rangeQuery.lte((Object)emotionScoreUpper);
            }
            if (emotionScoreLower != null) {
                rangeQuery.gte((Object)emotionScoreLower);
            }
            boolQuery.filter((QueryBuilder)rangeQuery);
        }
    }

    protected static void setEntityList(BoolQueryBuilder boolQuery, EsFeedbackQuery feedbackQuery) {
        List<String> entityList = feedbackQuery.getEntityList();
        if (entityList != null) {
            for (String entity : entityList) {
                boolQuery.must((QueryBuilder)QueryBuilders.termQuery((String)"entityList.keyword", (String)entity));
            }
        }
    }

    protected static void setClassify(BoolQueryBuilder boolQuery, EsFeedbackQuery feedbackQuery) {
        List<String> classifyList = feedbackQuery.getClassify();
        if (classifyList != null) {
            if (feedbackQuery.getIndexName().equals("1")) {
                boolQuery.must((QueryBuilder)QueryBuilders.termsQuery((String)"classify", classifyList));
            } else {
                boolQuery.must((QueryBuilder)QueryBuilders.termsQuery((String)"classify.keyword", classifyList));
            }
        }
    }

    protected static void setCity(BoolQueryBuilder boolQuery, EsFeedbackQuery feedbackQuery) {
        String city = feedbackQuery.getCity();
        if (StringUtils.isNotBlank((CharSequence)city)) {
            boolQuery.must((QueryBuilder)QueryBuilders.termsQuery((String)"city", (String[])new String[]{city.trim()}));
        }
    }

    protected static void setLevel(BoolQueryBuilder boolQuery, EsFeedbackQuery feedbackQuery) {
        List<String> level = feedbackQuery.getLevel();
        if (level != null && !level.isEmpty()) {
            boolQuery.must((QueryBuilder)QueryBuilders.termsQuery((String)"level", level));
        }
    }

    protected static void setPid(BoolQueryBuilder boolQuery, EsFeedbackQuery feedbackQuery) {
        List<String> pids = feedbackQuery.getPids();
        if (pids != null && !pids.isEmpty()) {
            boolQuery.must((QueryBuilder)QueryBuilders.termsQuery((String)"pids", pids));
        }
    }

    protected static void setIsOriginal(BoolQueryBuilder boolQuery, EsFeedbackQuery feedbackQuery) {
        String isOriginal = feedbackQuery.getIsOriginal();
        if (StringUtils.isNotBlank((CharSequence)isOriginal)) {
            boolQuery.must((QueryBuilder)QueryBuilders.termsQuery((String)"isOriginal", (String[])new String[]{isOriginal}));
        }
    }

    protected static void setWordsNum(BoolQueryBuilder boolQuery, EsFeedbackQuery feedbackQuery) {
        Integer fromWordsNum = feedbackQuery.getFromWordsNum();
        Integer toWordNum = feedbackQuery.getToWordNum();
        if (fromWordsNum != null && toWordNum != null) {
            boolQuery.must((QueryBuilder)QueryBuilders.rangeQuery((String)"description_length").from((Object)fromWordsNum).to((Object)toWordNum));
        }
    }

    private static void setProvince(BoolQueryBuilder boolQuery, EsFeedbackQuery feedbackQuery) {
        List<String> provinceList = feedbackQuery.getProvince();
        if (provinceList != null) {
            BoolQueryBuilder boolQueryBuilder = QueryBuilders.boolQuery();
            for (String province : provinceList) {
                boolQueryBuilder.should((QueryBuilder)QueryBuilders.termsQuery((String)"province", (String[])new String[]{province}));
            }
            boolQuery.must((QueryBuilder)boolQueryBuilder);
        }
    }

    private static void setMunicipality(BoolQueryBuilder boolQuery, EsFeedbackQuery feedbackQuery) {
        List<String> municipalityList = feedbackQuery.getMunicipality();
        if (municipalityList != null) {
            BoolQueryBuilder boolQueryBuilder = QueryBuilders.boolQuery();
            for (String municipality : municipalityList) {
                boolQueryBuilder.should((QueryBuilder)QueryBuilders.termsQuery((String)"city", (String[])new String[]{municipality}));
            }
            boolQuery.must((QueryBuilder)boolQueryBuilder);
        }
    }

    private static void setPrefecture(BoolQueryBuilder boolQuery, EsFeedbackQuery feedbackQuery) {
        List<String> prefectureList = feedbackQuery.getPrefecture();
        if (prefectureList != null) {
            BoolQueryBuilder boolQueryBuilder = QueryBuilders.boolQuery();
            for (String prefecture : prefectureList) {
                boolQueryBuilder.should((QueryBuilder)QueryBuilders.termsQuery((String)"area", (String[])new String[]{prefecture}));
            }
            boolQuery.must((QueryBuilder)boolQueryBuilder);
        }
    }

    private static void setOrganizationEntity(BoolQueryBuilder boolQuery, EsFeedbackQuery feedbackQuery) {
        List<String> organizationEntity = feedbackQuery.getOrganizationEntity();
        if (organizationEntity != null && !organizationEntity.isEmpty()) {
            BoolQueryBuilder nestedBoolQueryBuilder = QueryBuilders.boolQuery();
            nestedBoolQueryBuilder.must((QueryBuilder)QueryBuilders.termsQuery((String)"organizationEntity.entityName.keyword", organizationEntity));
            boolQuery.must((QueryBuilder)QueryBuilders.nestedQuery((String)"organizationEntity.keyword", (QueryBuilder)nestedBoolQueryBuilder, (ScoreMode)ScoreMode.None));
        }
    }

    private static void setPersonEntity(BoolQueryBuilder boolQuery, EsFeedbackQuery feedbackQuery) {
        List<String> personEntity = feedbackQuery.getPersonEntity();
        if (personEntity != null && !personEntity.isEmpty()) {
            BoolQueryBuilder nestedBoolQueryBuilder = QueryBuilders.boolQuery();
            nestedBoolQueryBuilder.must((QueryBuilder)QueryBuilders.termsQuery((String)"personEntity.entityName.keyword", personEntity));
            boolQuery.must((QueryBuilder)QueryBuilders.nestedQuery((String)"personEntity", (QueryBuilder)nestedBoolQueryBuilder, (ScoreMode)ScoreMode.None));
        }
    }

    private static void setRegionEntity(BoolQueryBuilder boolQuery, EsFeedbackQuery feedbackQuery) {
        List<String> regionEntity = feedbackQuery.getRegionEntity();
        if (regionEntity != null && !regionEntity.isEmpty()) {
            BoolQueryBuilder nestedBoolQueryBuilder = QueryBuilders.boolQuery();
            nestedBoolQueryBuilder.must((QueryBuilder)QueryBuilders.termsQuery((String)"regionEntity.entityName.keyword", regionEntity));
            boolQuery.must((QueryBuilder)QueryBuilders.nestedQuery((String)"regionEntity", (QueryBuilder)nestedBoolQueryBuilder, (ScoreMode)ScoreMode.None));
        }
    }

    private static void setSummaryPhrase(BoolQueryBuilder boolQuery, EsFeedbackQuery feedbackQuery) {
        List<String> summaryPhrase = feedbackQuery.getSummaryPhrase();
        if (summaryPhrase != null) {
            boolQuery.must((QueryBuilder)QueryBuilders.termsQuery((String)"summaryPhrase", summaryPhrase));
        }
    }

    private static void setTitleEntity(BoolQueryBuilder boolQuery, EsFeedbackQuery feedbackQuery) {
        List<String> titleEntity = feedbackQuery.getTitleEntity();
        if (titleEntity != null && !titleEntity.isEmpty()) {
            BoolQueryBuilder nestedBoolQueryBuilder = QueryBuilders.boolQuery();
            nestedBoolQueryBuilder.must((QueryBuilder)QueryBuilders.termsQuery((String)"titleEntity.entityName.keyword", titleEntity));
            boolQuery.must((QueryBuilder)QueryBuilders.nestedQuery((String)"titleEntity", (QueryBuilder)nestedBoolQueryBuilder, (ScoreMode)ScoreMode.None));
        }
    }

    private static void setSummaryKeywordList(BoolQueryBuilder boolQuery, EsFeedbackQuery feedbackQuery) {
        List<String> summaryKeywords = feedbackQuery.getSummaryKeywords();
        if (summaryKeywords != null) {
            boolQuery.must((QueryBuilder)QueryBuilders.termsQuery((String)"summaryKeywordList", summaryKeywords));
        }
    }
}

