/*
 * Decompiled with CFR 0.152.
 */
package com.chinamcloud.haihe.es.service;

import com.alibaba.fastjson.JSON;
import com.chinamcloud.haihe.common.bean.NewsInfo;
import com.chinamcloud.haihe.common.i18n.MessageSource;
import com.chinamcloud.haihe.common.utils.MD5;
import com.chinamcloud.haihe.es.dao.EsBaseDao;
import com.chinamcloud.haihe.es.pojo.EsQueryParams;
import com.fasterxml.jackson.core.JsonProcessingException;
import java.util.HashMap;
import javax.annotation.Resource;
import org.apache.commons.lang3.StringUtils;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.elasticsearch.index.query.BoolQueryBuilder;
import org.elasticsearch.index.query.MatchPhraseQueryBuilder;
import org.elasticsearch.index.query.QueryBuilder;
import org.elasticsearch.index.query.QueryBuilders;
import org.springframework.cache.annotation.Cacheable;
import org.springframework.stereotype.Service;

@Service
public class EsDataManipulationService {
    private static final Logger log = LogManager.getLogger(EsDataManipulationService.class);
    @Resource
    private EsBaseDao dao;

    public boolean delete(NewsInfo info) throws Exception {
        log.info("info=" + JSON.toJSONString((Object)info));
        EsQueryParams params = new EsQueryParams(info.getIndex());
        NewsInfo newsInfo = this.selectByUrlMD5(info);
        if (newsInfo == null || !newsInfo.getId().equals(info.getId())) {
            log.error(MessageSource.getMsg("id_error"));
            return false;
        }
        String refererUrl = info.getRefererUrl();
        if (StringUtils.isBlank((CharSequence)refererUrl)) {
            log.error(MessageSource.getMsg("url_error"));
            return false;
        }
        Boolean delete = this.dao.delete(params, MD5.md5(refererUrl));
        return delete;
    }

    public boolean update(NewsInfo info) throws Exception {
        log.info("info=" + JSON.toJSONString((Object)info));
        HashMap<String, Object> data = new HashMap<String, Object>();
        if (info.getEmotionScore() != null) {
            data.put("emotionScore", info.getEmotionScore());
        }
        if (info.getEmotionTendency() != null) {
            data.put("emotionTendency", info.getEmotionTendency());
        }
        if (data.isEmpty()) {
            log.error(MessageSource.getMsg("params_error"));
            return false;
        }
        EsQueryParams params = new EsQueryParams(info.getIndex());
        NewsInfo newsInfo = this.selectByUrlMD5(info);
        if (newsInfo == null || !newsInfo.getId().equals(info.getId())) {
            log.error(MessageSource.getMsg("id_error"));
            return false;
        }
        String refererUrl = info.getRefererUrl();
        if (StringUtils.isBlank((CharSequence)refererUrl)) {
            log.error(MessageSource.getMsg("url_error"));
            return false;
        }
        Boolean update = this.dao.update(params, MD5.md5(refererUrl), data);
        return update;
    }

    @Cacheable(value={"redis#60"}, keyGenerator="firstParamKeyGenerator", unless="#result == null")
    public NewsInfo selectByUrlMD5(NewsInfo info) {
        EsQueryParams params = new EsQueryParams(info.getIndex());
        BoolQueryBuilder query = QueryBuilders.boolQuery();
        MatchPhraseQueryBuilder urlMD5 = null;
        if (!StringUtils.isNotBlank((CharSequence)info.getRefererUrl())) {
            log.error(MessageSource.getMsg("url_error"));
            return null;
        }
        urlMD5 = QueryBuilders.matchPhraseQuery((String)"urlMD5", (Object)MD5.md5(info.getRefererUrl()));
        query.must((QueryBuilder)urlMD5);
        params.setQuery((QueryBuilder)query);
        NewsInfo newsInfo = null;
        try {
            newsInfo = this.dao.selectByMD5url(params);
        }
        catch (JsonProcessingException e) {
            e.printStackTrace();
            log.error(MessageSource.getMsg("query_exception"));
        }
        return newsInfo;
    }

    public boolean copy(NewsInfo info) throws Exception {
        log.info("info=" + JSON.toJSONString((Object)info));
        EsQueryParams params = new EsQueryParams(info.getIndex());
        NewsInfo newsInfo = this.selectByUrlMD5(info);
        if (newsInfo == null || !newsInfo.getId().equals(info.getId())) {
            log.error(MessageSource.getMsg("id_error"));
            return false;
        }
        newsInfo.setRefererUrl(newsInfo.getRefererUrl() + "huaqiyun");
        newsInfo.setUrlMD5(MD5.md5(newsInfo.getRefererUrl()));
        newsInfo.setSubject("\u534e\u6816\u4e91\u6d4b\u8bd5===" + newsInfo.getSubject());
        newsInfo.setDescription(newsInfo.getDescription().replace("\u534e\u6816\u4e91\u6d4b\u8bd5===", ""));
        newsInfo.setId(newsInfo.getId() + 10000000000L);
        Boolean index = this.dao.index(params, newsInfo);
        return index;
    }
}

