/*
 * Decompiled with CFR 0.152.
 */
package com.chinamcloud.haihe.es.utils;

import java.util.Date;
import java.util.function.Function;
import org.apache.commons.lang3.time.DateUtils;

public enum Interval {
    DAY("yyyy-MM-dd", x -> DateUtils.truncate((Date)x, (int)5), (x, interval) -> DateUtils.addDays((Date)x, (int)interval)),
    HOUR("yyyy-MM-dd HH", x -> DateUtils.truncate((Date)x, (int)11), (x, interval) -> DateUtils.addHours((Date)x, (int)interval)),
    MONTH("yyyy-MM", x -> DateUtils.truncate((Date)x, (int)2), (x, interval) -> DateUtils.addMonths((Date)x, (int)interval)),
    YEAR("yyyy", x -> DateUtils.truncate((Date)x, (int)1), (x, interval) -> DateUtils.addMonths((Date)x, (int)interval));

    private final Function<Date, Date> dateFunction;
    private final DateIncFunction incFunction;
    private final String pattern;

    private Interval(String pattern, Function<Date, Date> dateFunction, DateIncFunction incFunction) {
        this.dateFunction = dateFunction;
        this.incFunction = incFunction;
        this.pattern = pattern;
    }

    public String getPattern() {
        return this.pattern;
    }

    public Date inc(Date date, int interval) {
        return this.incFunction.inc(date, interval);
    }

    public Date truncate(Date date) {
        return this.dateFunction.apply(date);
    }

    @FunctionalInterface
    public static interface DateIncFunction {
        public Date inc(Date var1, int var2);
    }
}

