/*
 * Decompiled with CFR 0.152.
 */
package com.chinamcloud.haihe.newservice.analysis.controller;

import com.chinamcloud.haihe.common.annotation.UserLoginToken;
import com.chinamcloud.haihe.common.controller.BaseController;
import com.chinamcloud.haihe.newservice.analysis.bean.AlarmInfoBean;
import com.chinamcloud.haihe.newservice.analysis.service.AlarmInfoService;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"/alarm-info"})
public class AnalysisInfoController
extends BaseController {
    private static final Logger log = LogManager.getLogger(AnalysisInfoController.class);
    @Autowired
    private AlarmInfoService alarmInfoService;

    @UserLoginToken
    @PostMapping(value={"/alarmInfoList"})
    public Object getAlarmInfo(@RequestBody AlarmInfoBean alarmInfoBean) {
        this.exitUserToken(alarmInfoBean);
        return this.alarmInfoService.getAlarmInfoBeanList(alarmInfoBean);
    }

    @UserLoginToken
    @PostMapping(value={"/add"})
    public Object addAlarmInfo(@RequestBody AlarmInfoBean alarmInfoBean) {
        this.exitUserToken(alarmInfoBean);
        return this.alarmInfoService.add(alarmInfoBean);
    }

    @UserLoginToken
    @PostMapping(value={"/update"})
    public Object updateAlarmInfo(@RequestBody AlarmInfoBean alarmInfoBean) {
        this.exitUserToken(alarmInfoBean);
        return this.alarmInfoService.update(alarmInfoBean);
    }

    @UserLoginToken
    @PostMapping(value={"/delete"})
    public Object deleteAlarmInfo(@RequestBody AlarmInfoBean alarmInfoBean) {
        this.exitUserToken(alarmInfoBean);
        return this.alarmInfoService.delete(alarmInfoBean);
    }
}

