/*
 * Decompiled with CFR 0.152.
 */
package com.chinamcloud.haihe.newservice.analysis.controller;

import com.chinamcloud.haihe.common.annotation.UserLoginToken;
import com.chinamcloud.haihe.common.controller.BaseController;
import com.chinamcloud.haihe.newservice.analysis.bean.AlarmInfoBean;
import com.chinamcloud.haihe.newservice.analysis.bean.AlarmReceiveBean;
import com.chinamcloud.haihe.newservice.analysis.service.AlarmReceiveService;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"/alarm-receive"})
public class AnalysisReceiveController
extends BaseController {
    private static final Logger log = LogManager.getLogger(AnalysisReceiveController.class);
    @Autowired
    private AlarmReceiveService alarmReceiveService;

    @UserLoginToken
    @PostMapping(value={"/alarmReceiveList"})
    public Object getAlarmReceive(@RequestBody AlarmInfoBean alarmInfoBean) {
        this.exitUserToken(alarmInfoBean);
        return this.alarmReceiveService.getAlarmReceiveBeanList(alarmInfoBean);
    }

    @UserLoginToken
    @PostMapping(value={"/add"})
    public Object addAlarmReceive(@RequestBody AlarmReceiveBean alarmReceiveBean) {
        this.exitUserToken(alarmReceiveBean);
        return this.alarmReceiveService.add(alarmReceiveBean);
    }

    @UserLoginToken
    @PostMapping(value={"/update"})
    public Object updateAlarmReceive(@RequestBody AlarmReceiveBean alarmReceiveBean) {
        this.exitUserToken(alarmReceiveBean);
        return this.alarmReceiveService.update(alarmReceiveBean);
    }

    @UserLoginToken
    @PostMapping(value={"/delete"})
    public Object deleteAlarmReceive(@RequestBody AlarmReceiveBean alarmReceiveBean) {
        this.exitUserToken(alarmReceiveBean);
        return this.alarmReceiveService.delete(alarmReceiveBean);
    }
}

