/*
 * Decompiled with CFR 0.152.
 */
package com.chinamcloud.haihe.newservice.analysis.controller;

import com.chinamcloud.haihe.common.CodeResult;
import com.chinamcloud.haihe.common.Const;
import com.chinamcloud.haihe.common.Exception.CustomException;
import com.chinamcloud.haihe.common.afterprocessor.ArealDistributionProcessor;
import com.chinamcloud.haihe.common.afterprocessor.HotTopicAfterProcessor;
import com.chinamcloud.haihe.common.afterprocessor.NewDetailAfterProcessor;
import com.chinamcloud.haihe.common.afterprocessor.RepetitionAfterProcessor;
import com.chinamcloud.haihe.common.afterprocessor.TrendProcessor;
import com.chinamcloud.haihe.common.annotation.UserLoginToken;
import com.chinamcloud.haihe.common.controller.BaseController;
import com.chinamcloud.haihe.common.i18n.MessageSource;
import com.chinamcloud.haihe.common.pojo.HotParams;
import com.chinamcloud.haihe.common.utils.DateUtils;
import com.chinamcloud.haihe.common.utils.HotParamsUtils;
import com.chinamcloud.haihe.common.utils.TopicKeywordUtils;
import com.chinamcloud.haihe.configService.service.RegionService;
import com.chinamcloud.haihe.es.agg.EsBuildEventStatisticAgg;
import com.chinamcloud.haihe.es.agg.EsFactAggWithEmotionTendency;
import com.chinamcloud.haihe.es.agg.EsHotTopicAgg;
import com.chinamcloud.haihe.es.agg.EsTermBucketAgg;
import com.chinamcloud.haihe.es.controller.EsExclusiveController;
import com.chinamcloud.haihe.es.controller.EsNewsDataController;
import com.chinamcloud.haihe.es.parser.FacetDataParser;
import com.chinamcloud.haihe.es.parser.SimpleNewsParser;
import com.chinamcloud.haihe.es.pojo.TermAggBucket;
import com.chinamcloud.haihe.es.result.EsFacetResultProcessor;
import com.chinamcloud.haihe.es.result.EsNewsInfoProcessor;
import com.chinamcloud.haihe.es.result.EsTotalScaleByTimeProcessor;
import com.chinamcloud.haihe.es.result.EsTotalScaleProcessor;
import com.chinamcloud.haihe.es.utils.TimeEnum;
import com.chinamcloud.haihe.newservice.analysis.bean.PlanInfoBean;
import com.chinamcloud.haihe.newservice.analysis.bean.SearchSpreadNewsParam;
import com.chinamcloud.haihe.newservice.analysis.bean.SpreadParam;
import com.chinamcloud.haihe.newservice.analysis.mapper.EventInfoMapper;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import org.apache.commons.lang3.StringUtils;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.cache.annotation.Cacheable;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"/spread-service"})
public class SpreadController
extends BaseController {
    private static final Logger log = LogManager.getLogger(SpreadController.class);
    @Autowired
    private EventInfoMapper eventInfoMapper;
    @Autowired
    private RegionService regionService;
    @Autowired
    private EsNewsDataController esNewsDataController;
    @Autowired
    private EsExclusiveController esExclusiveController;

    @UserLoginToken
    @PostMapping(value={"/getLatestNews"}, consumes={"application/json;charset=utf-8"})
    @Cacheable(value={"redis#600"}, keyGenerator="paramKeyGenerator", unless="#result.code == 1")
    public Object getLatestNews(@RequestBody SearchSpreadNewsParam spreadParam, @RequestParam(value="dataType", required=false, defaultValue="list") String dataType) {
        this.exitUserToken(spreadParam);
        HotParams hotParams = this.getHotParamsByPlanInfo(spreadParam, this.getClass().getSimpleName() + "-" + Thread.currentThread().getStackTrace()[1].getMethodName() + dataType);
        HotParamsUtils.setKeyWord(hotParams);
        hotParams.setSortFields((List<String>)new ArrayList<String>(){
            {
                this.add("pubTime desc");
            }
        });
        hotParams.setEsResultProcessor(new EsNewsInfoProcessor());
        hotParams.setParser(new SimpleNewsParser(SimpleNewsParser.TYPE.DETAIL));
        hotParams.setAfterProcessor(new NewDetailAfterProcessor(dataType, hotParams.getPage(), hotParams.getSize()));
        return this.esNewsDataController.getNewsList(hotParams);
    }

    @UserLoginToken
    @PostMapping(value={"/getRepeatedNum"}, consumes={"application/json;charset=utf-8"})
    @Cacheable(value={"redis#600"}, keyGenerator="paramKeyGenerator", unless="#result.code == 1")
    public Object getRepeatedNum(@RequestBody SpreadParam spreadParam) {
        this.exitUserToken(spreadParam);
        HotParams hotParams = this.getHotParamsByPlanInfo(spreadParam, this.getClass().getSimpleName() + "-" + Thread.currentThread().getStackTrace()[1].getMethodName());
        String facetField = hotParams.getFacetField();
        Integer size = spreadParam.getSize();
        hotParams.setFacetLimit(size == null ? 100 : size);
        if ("tb_nickname".equals(facetField)) {
            hotParams.setAgainFacetField("logoUrl");
        }
        hotParams.setFacetMincount(1);
        HotParamsUtils.setKeyWord(hotParams);
        hotParams.setEsResultProcessor(new EsFacetResultProcessor());
        hotParams.setParser(new FacetDataParser());
        hotParams.setIEsBuildAgg(new EsFactAggWithEmotionTendency());
        hotParams.setAfterProcessor(new RepetitionAfterProcessor(spreadParam.getFacetField()));
        return this.esNewsDataController.cluster(hotParams);
    }

    @UserLoginToken
    @PostMapping(value={"/getArealDistribution"}, consumes={"application/json;charset=utf-8"})
    @Cacheable(value={"redis#600"}, keyGenerator="paramKeyGenerator", unless="#result.code == 1 || #result == null")
    public Object getArealDistribution(@RequestBody SpreadParam spreadParam) {
        this.exitUserToken(spreadParam);
        HotParams hotParams = this.getHotParamsByPlanInfo(spreadParam, this.getClass().getSimpleName() + "-" + Thread.currentThread().getStackTrace()[1].getMethodName());
        hotParams.setFacetMincount(1);
        List<String> regionNames = spreadParam.getRegionNames();
        if (regionNames == null) {
            regionNames = new ArrayList<String>(16);
        }
        Map<String, Set<String>> mapList = null;
        mapList = this.regionService.getAllAddr(regionNames, spreadParam.getRegionCode() == null ? "" : spreadParam.getRegionCode().toString(), spreadParam.getRegionType() == null ? "" : spreadParam.getRegionType());
        regionNames.addAll(mapList.keySet());
        if (regionNames.isEmpty()) {
            return CodeResult.failedResultByMsgSource("params_error");
        }
        LinkedList<TermAggBucket> termAggBuckets = new LinkedList<TermAggBucket>();
        for (Map.Entry<String, Set<String>> entry : mapList.entrySet()) {
            termAggBuckets.add(new TermAggBucket(new ArrayList<String>((Collection)entry.getValue()), "description", entry.getKey()));
        }
        HotParamsUtils.setKeyWord(hotParams);
        hotParams.setFacetField("description");
        hotParams.setEsResultProcessor(new EsFacetResultProcessor());
        hotParams.setParser(new FacetDataParser());
        hotParams.setIEsBuildAgg(new EsTermBucketAgg(termAggBuckets));
        hotParams.setAfterProcessor(new ArealDistributionProcessor(regionNames));
        return this.esNewsDataController.cluster(hotParams);
    }

    @UserLoginToken
    @PostMapping(value={"/getTotalScale"}, consumes={"application/json;charset=utf-8"})
    @Cacheable(value={"redis#600"}, keyGenerator="paramKeyGenerator", unless="#result.code == 1")
    public Object getTotalScale(@RequestBody SpreadParam spreadParam) {
        this.exitUserToken(spreadParam);
        HotParams hotParams = this.getHotParamsByPlanInfo(spreadParam, this.getClass().getSimpleName() + "-" + Thread.currentThread().getStackTrace()[1].getMethodName());
        HotParamsUtils.setKeyWord(hotParams);
        hotParams.setFacetMincount(1);
        hotParams.setEsResultProcessor(new EsTotalScaleProcessor());
        hotParams.setIEsBuildAgg(new EsBuildEventStatisticAgg((Map<String, String>)new HashMap<String, String>(){
            private static final long serialVersionUID = 3158383169989428184L;
            {
                this.put("emotion_score", "avg");
                this.put("cluster_id", "cardinality");
                this.put("tb_nickname", "cardinality");
                this.put("url_MD5", "cardinality");
            }
        }));
        return this.esExclusiveController.totalScale(hotParams);
    }

    @UserLoginToken
    @PostMapping(value={"/getPublishingTrend"}, consumes={"application/json;charset=utf-8"})
    @Cacheable(value={"redis#600"}, keyGenerator="paramKeyGenerator", unless="#result.code == 1")
    public Object getPublishingTrend(final @RequestBody SpreadParam spreadParam) {
        String value;
        TimeEnum timeEnum = TimeEnum.getTimeEnum(spreadParam.getTimeType());
        this.exitUserToken(spreadParam);
        HotParams hotParams = this.getHotParamsByPlanInfo(spreadParam, this.getClass().getSimpleName() + "-" + Thread.currentThread().getStackTrace()[1].getMethodName());
        HotParamsUtils.setKeyWord(hotParams);
        hotParams.setFacetMincount(1);
        if (StringUtils.isBlank((CharSequence)spreadParam.getFacetField())) {
            spreadParam.setFacetField("source");
        }
        if (StringUtils.isBlank((CharSequence)(value = Const.TrendMap.get(spreadParam.getFacetField())))) {
            return CodeResult.failedResultByMsgSource("params_error");
        }
        if (hotParams.getDay() == null && (hotParams.getFromDt() == null || hotParams.getToDt() == null)) {
            List<Date> dateList = DateUtils.GetTime(-2, true, "week");
            hotParams.setFromDt(dateList.get(0));
            hotParams.setToDt(dateList.get(1));
        }
        if (hotParams.getDay() != null) {
            Date[] dates = null;
            try {
                dates = DateUtils.computeDatesBackward(Integer.parseInt(hotParams.getDay()), false);
            }
            catch (NumberFormatException e) {
                throw new IllegalArgumentException(MessageSource.getMsg("params_error"));
            }
            hotParams.setFromDt((Date)DateUtils.getTime(dates[0], "date"));
            hotParams.setToDt((Date)DateUtils.getTime(dates[1], "date"));
            hotParams.setDay("");
        }
        hotParams.setEsResultProcessor(new EsTotalScaleByTimeProcessor(timeEnum, hotParams.getFacetField()));
        hotParams.setIEsBuildAgg(new EsBuildEventStatisticAgg((Map<String, String>)new HashMap<String, String>(){
            {
                this.put(spreadParam.getFacetField(), value);
            }
        }, timeEnum));
        hotParams.setAfterProcessor(new TrendProcessor((List<String>)new ArrayList<String>(){
            {
                this.add(spreadParam.getFacetField());
            }
        }));
        return this.esNewsDataController.trend(hotParams);
    }

    @UserLoginToken
    @PostMapping(value={"/getHotTopic"}, consumes={"application/json;charset=utf-8"})
    @Cacheable(value={"redis#600"}, keyGenerator="paramKeyGenerator", unless="#result.code == 1")
    public Object getHotTopic(@RequestBody SearchSpreadNewsParam spreadParam, @RequestParam(value="dataType", required=false, defaultValue="list") String dataType) {
        this.exitUserToken(spreadParam);
        if (spreadParam.getDay() == null && (spreadParam.getFromDt() == null || spreadParam.getToDt() == null)) {
            spreadParam.setDay("30");
        }
        HotParams hotParams = this.getHotParamsByPlanInfo(spreadParam, this.getClass().getSimpleName() + "-" + Thread.currentThread().getStackTrace()[1].getMethodName() + dataType);
        hotParams.setFacetMincount(1);
        HotParamsUtils.setKeyWord(hotParams);
        hotParams.setSortFields((List<String>)new ArrayList<String>(){
            private static final long serialVersionUID = -4368376487164532996L;
            {
                this.add("doc_count desc");
            }
        });
        hotParams.setEsResultProcessor(new EsNewsInfoProcessor());
        hotParams.setParser(new SimpleNewsParser(SimpleNewsParser.TYPE.TOPIC));
        hotParams.setIEsBuildAgg(new EsHotTopicAgg((List<String>)new ArrayList<String>(){
            private static final long serialVersionUID = 3434485790954244805L;
            {
                this.add("hot");
            }
        }));
        hotParams.setAfterProcessor(new HotTopicAfterProcessor(dataType, hotParams.getPage(), hotParams.getSize()));
        return this.esNewsDataController.hotTopic(hotParams);
    }

    @UserLoginToken
    @PostMapping(value={"/searchNews"}, consumes={"application/json;charset=utf-8"})
    @Cacheable(value={"redis#600"}, keyGenerator="firstParamAndMethodNameKeyGenerator", unless="#result.code == 1")
    public Object searchNews(@RequestBody SearchSpreadNewsParam spreadParam) {
        this.exitUserToken(spreadParam);
        HotParams hotParams = this.getHotParamsByPlanInfo(spreadParam, this.getClass().getSimpleName() + "-" + Thread.currentThread().getStackTrace()[1].getMethodName());
        HotParamsUtils.setKeyWord(hotParams);
        Integer size = spreadParam.getSize();
        if (hotParams.getSortFields() == null || hotParams.getSortFields().isEmpty()) {
            hotParams.setSortFields((List<String>)new ArrayList<String>(){
                private static final long serialVersionUID = 3434485790954244805L;
                {
                    this.add("pubTime desc");
                }
            });
        }
        hotParams.setFacetLimit(size == null ? 10 : size);
        hotParams.setEsResultProcessor(new EsNewsInfoProcessor());
        hotParams.setParser(new SimpleNewsParser(SimpleNewsParser.TYPE.DETAIL));
        hotParams.setAfterProcessor(new NewDetailAfterProcessor("page", hotParams.getPage(), hotParams.getSize()));
        return this.esExclusiveController.searchNews(hotParams);
    }

    public HotParams getHotParamsByPlanInfo(SpreadParam planInfo, String key) {
        if (planInfo == null || planInfo.getPlanId() == null && planInfo.getName() == null || planInfo.getUserToken() == null) {
            throw new CustomException("params_error");
        }
        List<PlanInfoBean> planInfoBeanList = this.eventInfoMapper.selectPlanListByPlanId(planInfo);
        if (planInfoBeanList == null || planInfoBeanList.isEmpty()) {
            planInfo.setUserToken("default");
            planInfoBeanList = this.eventInfoMapper.selectPlanListByPlanId(planInfo);
            if (planInfoBeanList == null || planInfoBeanList.isEmpty()) {
                throw new CustomException("the_plan_found_empty");
            }
        }
        String catId = planInfo.getCatId();
        PlanInfoBean planInfoBean = planInfoBeanList.get(0);
        Integer planId = planInfoBean.getPlanId();
        final String keyWords = planInfoBean.getKeyWords();
        final String noKeywords = planInfoBean.getNoKeywords();
        String location = planInfo.getLocation();
        if (StringUtils.isBlank((CharSequence)location)) {
            location = planInfoBean.getLocation();
        }
        Integer size = planInfo.getSize();
        Integer page = planInfo.getPage();
        String facetField = planInfo.getFacetField();
        String emotionTendency = planInfo.getEmotionTendency();
        Date fromDt = planInfo.getFromDt();
        Date toDt = planInfo.getToDt();
        String day = planInfo.getDay();
        Integer facetMincount = planInfo.getFacetMincount();
        HotParams hotParams = new HotParams();
        hotParams.setKey(key);
        if (catId != null) {
            hotParams.setCatId(catId);
        }
        if (planId != null) {
            hotParams.setPlanId(planId);
        }
        if (StringUtils.isNotBlank((CharSequence)keyWords)) {
            hotParams.setKeyWords((List<String>)new ArrayList<String>(){
                private static final long serialVersionUID = 8392188181417381003L;
                {
                    this.add(keyWords);
                }
            });
        }
        if (StringUtils.isNotBlank((CharSequence)noKeywords)) {
            hotParams.setNoKeywords((List<String>)new ArrayList<String>(){
                private static final long serialVersionUID = -4810723894703615514L;
                {
                    this.add(noKeywords);
                }
            });
        }
        if (StringUtils.isNotBlank((CharSequence)location)) {
            if ("title".equals(location)) {
                hotParams.setUseKeyWord("subject");
            }
            if ("content".equals(location)) {
                hotParams.setUseKeyWord("description");
            }
        }
        if (size != null) {
            hotParams.setSize(size);
        }
        if (page != null) {
            hotParams.setPage(page);
        }
        if (StringUtils.isNotBlank((CharSequence)facetField)) {
            hotParams.setFacetField(facetField);
        }
        if (StringUtils.isNotBlank((CharSequence)emotionTendency)) {
            hotParams.setEmotionTendency(emotionTendency);
        }
        if (StringUtils.isNotBlank((CharSequence)day)) {
            hotParams.setDay(day);
        } else {
            if (fromDt != null) {
                hotParams.setFromDt(fromDt);
            }
            if (toDt != null) {
                hotParams.setToDt(toDt);
            }
        }
        if (facetMincount != null) {
            hotParams.setFacetMincount(facetMincount);
        }
        if (planInfo instanceof SearchSpreadNewsParam) {
            String keyWord;
            List<String> collect;
            SearchSpreadNewsParam sPlanInfo = (SearchSpreadNewsParam)planInfo;
            List<String> level = sPlanInfo.getLevel();
            List<String> newsType = sPlanInfo.getNewsType();
            List<String> sortFields = sPlanInfo.getSortFields();
            List<String> subjectKeyword = sPlanInfo.getSubjectKeyword();
            List<String> descriptionKeyword = sPlanInfo.getDescriptionKeyword();
            Boolean duplicate = sPlanInfo.getDuplicate();
            if (level != null) {
                hotParams.setLevel(level);
            }
            if (newsType != null) {
                hotParams.setNewsType(newsType);
            }
            if (sortFields != null) {
                hotParams.setSortFields(sortFields);
            }
            if (subjectKeyword != null && !subjectKeyword.isEmpty()) {
                if ("title".equals(location)) {
                    collect = subjectKeyword.stream().map(x -> {
                        x = x + "," + keyWords;
                        return x;
                    }).collect(Collectors.toList());
                    hotParams.setKeyWords(collect);
                } else {
                    keyWord = TopicKeywordUtils.buildQueryByObjecttoStirng(subjectKeyword);
                    hotParams.setSubject(keyWord);
                }
            }
            if (descriptionKeyword != null && !descriptionKeyword.isEmpty()) {
                if ("content".equals(location)) {
                    collect = descriptionKeyword.stream().map(x -> {
                        x = x + "," + keyWords;
                        return x;
                    }).collect(Collectors.toList());
                    hotParams.setKeyWords(collect);
                } else {
                    keyWord = TopicKeywordUtils.buildQueryByObjecttoStirng(descriptionKeyword);
                    hotParams.setDescription(keyWord);
                }
            }
            if (duplicate != null) {
                hotParams.setDuplicate(duplicate);
            }
        }
        return hotParams;
    }

    public static void main(String[] args) {
        ArrayList<String> list = new ArrayList<String>(){
            {
                this.add("1");
                this.add("2");
                this.add("3");
                this.add("4");
            }
        };
        List collect = list.stream().map(x -> {
            x = x + 9;
            return x;
        }).collect(Collectors.toList());
        System.out.println(collect);
    }
}

