/*
 * Decompiled with CFR 0.152.
 */
package com.chinamcloud.haihe.newservice.basic.controller;

import com.chinamcloud.haihe.common.afterprocessor.RepetitionAfterProcessor;
import com.chinamcloud.haihe.common.bean.FacetResult;
import com.chinamcloud.haihe.common.pojo.HotParams;
import com.chinamcloud.haihe.common.utils.TopicKeywordUtils;
import com.chinamcloud.haihe.es.agg.EsFactAggWithEmotionTendency;
import com.chinamcloud.haihe.es.bean.EsApsFacetField;
import com.chinamcloud.haihe.es.controller.EsNewsDataController;
import com.chinamcloud.haihe.es.parser.FacetDataParser;
import com.chinamcloud.haihe.es.result.EsFacetResult;
import com.chinamcloud.haihe.es.result.EsFacetResultProcessor;
import java.util.List;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.cache.annotation.Cacheable;
import org.springframework.web.bind.annotation.CrossOrigin;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"/hotWord-service"})
@CrossOrigin
public class GlobalHotController {
    private static final Logger log = LogManager.getLogger(GlobalHotController.class);
    @Autowired
    private EsNewsDataController esNewsDataController;

    @PostMapping(value={"/getHotWord"}, consumes={"application/json;charset=utf-8"})
    @Cacheable(value={"redis#600"}, keyGenerator="firstParamAndMethodNameKeyGenerator", unless="#result.code == 1")
    public Object getNewsList(@RequestBody HotParams<List<FacetResult>, EsFacetResult<List<EsApsFacetField>>> params) {
        params.setKey(this.getClass().getSimpleName() + "-" + Thread.currentThread().getStackTrace()[1].getMethodName());
        List<String> keyWords = params.getKeyWords();
        if (keyWords != null && !keyWords.isEmpty()) {
            log.info("Keyword is empty");
            String keyWord = TopicKeywordUtils.buildQueryByObjecttoStirng(keyWords);
            params.setDescription(keyWord);
        }
        params.setEsResultProcessor(new EsFacetResultProcessor());
        params.setParser(new FacetDataParser());
        params.setAfterProcessor(new RepetitionAfterProcessor());
        params.setIEsBuildAgg(new EsFactAggWithEmotionTendency());
        return this.esNewsDataController.cluster(params);
    }
}

