/*
 * Decompiled with CFR 0.152.
 */
package com.chinamcloud.haihe.newservice.basic.controller;

import com.chinamcloud.haihe.backStageManagement.pojo.Site;
import com.chinamcloud.haihe.backStageManagement.pojo.SiteInc;
import com.chinamcloud.haihe.backStageManagement.service.SiteQueryService;
import com.chinamcloud.haihe.common.CodeResult;
import com.chinamcloud.haihe.common.Exception.CustomException;
import com.chinamcloud.haihe.common.afterprocessor.NewDetailAfterProcessor;
import com.chinamcloud.haihe.common.afterprocessor.SimilarArticlesAfterProcessor;
import com.chinamcloud.haihe.common.afterprocessor.TableArticlesAfterProcessor;
import com.chinamcloud.haihe.common.bean.Page;
import com.chinamcloud.haihe.common.pojo.HotParams;
import com.chinamcloud.haihe.common.pojo.SimpleNews;
import com.chinamcloud.haihe.common.pojo.TableNews;
import com.chinamcloud.haihe.common.utils.HotParamsUtils;
import com.chinamcloud.haihe.common.utils.NumberUtils;
import com.chinamcloud.haihe.es.controller.EsExclusiveController;
import com.chinamcloud.haihe.es.controller.EsNewsDataController;
import com.chinamcloud.haihe.es.parser.SimpleNewsParser;
import com.chinamcloud.haihe.es.parser.TableNewsParser;
import com.chinamcloud.haihe.es.result.EsNewsInfoProcessor;
import com.chinamcloud.haihe.es.result.EsPagedResult;
import com.chinamcloud.haihe.es.result.EsSearchResult;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import javax.servlet.http.HttpServletResponse;
import org.apache.commons.lang3.StringUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.cache.annotation.Cacheable;
import org.springframework.validation.BindingResult;
import org.springframework.validation.annotation.Validated;
import org.springframework.web.bind.annotation.CrossOrigin;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"/news-service"})
@CrossOrigin
public class NewsServiceController {
    @Autowired
    private SiteQueryService siteQueryService;
    @Autowired
    private EsNewsDataController esNewsDataController;
    @Autowired
    private EsExclusiveController esExclusiveController;

    @PostMapping(value={"/newslist/{dataType}"}, consumes={"application/json;charset=utf-8"})
    @Cacheable(value={"redis#600"}, keyGenerator="paramKeyGenerator", unless="#result.code == 1")
    public Object getNewsList(@RequestBody @Validated HotParams<Page<SimpleNews>, EsPagedResult<EsSearchResult>> params, @PathVariable String dataType, BindingResult bindResult) {
        if (bindResult.hasErrors()) {
            return CodeResult.failedResultByMsgSource("params_error");
        }
        this.verifyPids(params);
        params.setKey(this.getClass().getSimpleName() + "-" + Thread.currentThread().getStackTrace()[1].getMethodName() + "-" + dataType);
        HotParamsUtils.setKeyWord(params);
        params.setEsResultProcessor(new EsNewsInfoProcessor());
        params.setParser(new SimpleNewsParser(SimpleNewsParser.TYPE.BASE));
        params.setAfterProcessor(new NewDetailAfterProcessor(dataType, params.getPage(), params.getSize()));
        return this.esNewsDataController.getNewsList(params);
    }

    @PostMapping(value={"/newslistAndDetail/{dataType}"}, consumes={"application/json;charset=utf-8"})
    @Cacheable(value={"redis#600"}, keyGenerator="paramKeyGenerator", unless="#result.code == 1")
    public Object getNewsListAndDetail(@RequestBody HotParams<Page<SimpleNews>, EsPagedResult<EsSearchResult>> params, @PathVariable String dataType) {
        this.verifyPids(params);
        params.setKey(this.getClass().getSimpleName() + "-" + Thread.currentThread().getStackTrace()[1].getMethodName() + dataType);
        HotParamsUtils.setKeyWord(params);
        params.setEsResultProcessor(new EsNewsInfoProcessor());
        params.setParser(new SimpleNewsParser(SimpleNewsParser.TYPE.DETAIL));
        params.setAfterProcessor(new NewDetailAfterProcessor(dataType, params.getPage(), params.getSize()));
        return this.esNewsDataController.getNewsList(params);
    }

    @PostMapping(value={"/getNewsListAndKeyWord/{dataType}"}, consumes={"application/json;charset=utf-8"})
    @Cacheable(value={"redis#600"}, keyGenerator="paramKeyGenerator", unless="#result.code == 1")
    public CodeResult<Page<SimpleNews>> getNewsListAndKeyWord(@RequestBody HotParams<Page<SimpleNews>, EsPagedResult<EsSearchResult>> params, @PathVariable String dataType) {
        this.verifyPids(params);
        params.setKey(this.getClass().getSimpleName() + "-" + Thread.currentThread().getStackTrace()[1].getMethodName() + dataType);
        HotParamsUtils.setKeyWord(params);
        params.setEsResultProcessor(new EsNewsInfoProcessor());
        params.setParser(new SimpleNewsParser(SimpleNewsParser.TYPE.ENTITY));
        params.setAfterProcessor(new NewDetailAfterProcessor(dataType, params.getPage(), params.getSize()));
        return this.esNewsDataController.getNewsList(params);
    }

    @PostMapping(value={"/newslistAndSite/{dataType}"}, consumes={"application/json;charset=utf-8"})
    @Cacheable(value={"redis#600"}, keyGenerator="paramKeyGenerator", unless="#result.code == 1")
    public Object newslistAndSite(@RequestBody HotParams<Page<SimpleNews>, EsPagedResult<EsSearchResult>> params, @PathVariable String dataType) {
        this.verifyPids(params);
        params.setKey(this.getClass().getSimpleName() + "-" + Thread.currentThread().getStackTrace()[1].getMethodName() + dataType);
        HotParamsUtils.setKeyWord(params);
        params.setEsResultProcessor(new EsNewsInfoProcessor());
        params.setParser(new SimpleNewsParser(SimpleNewsParser.TYPE.SITE));
        params.setAfterProcessor(new NewDetailAfterProcessor(dataType, params.getPage(), params.getSize()));
        return this.esNewsDataController.getNewsList(params);
    }

    @PostMapping(value={"/getAlikeList/{dataType}"}, consumes={"application/json;charset=utf-8"})
    @Cacheable(value={"redis#600"}, keyGenerator="paramKeyGenerator", unless="#result.code == 1")
    public Object getAlikeList(@RequestBody HotParams<Page<SimpleNews>, EsPagedResult<EsSearchResult>> params, @PathVariable String dataType) {
        params.setKey(this.getClass().getSimpleName() + "-" + Thread.currentThread().getStackTrace()[1].getMethodName() + dataType);
        HotParamsUtils.setKeyWord(params);
        params.setEsResultProcessor(new EsNewsInfoProcessor());
        params.setParser(new SimpleNewsParser(SimpleNewsParser.TYPE.DETAIL));
        params.setAfterProcessor(new SimilarArticlesAfterProcessor());
        return this.esExclusiveController.getAlikeList(params);
    }

    @PostMapping(value={"/getTableNews"}, consumes={"application/json;charset=utf-8"})
    @Cacheable(value={"redis#600"}, keyGenerator="firstParamAndMethodNameKeyGenerator", unless="#result.code == 1")
    public Object getTableNews(@RequestBody HotParams<List<TableNews>, EsPagedResult<EsSearchResult>> params, HttpServletResponse response) {
        this.verifyPids(params);
        HotParamsUtils.setKeyWord(params);
        Integer size = params.getSize();
        if (size > 1000) {
            return CodeResult.failedResultByMsgSource("params_error");
        }
        params.setKey(this.getClass().getSimpleName() + "-" + Thread.currentThread().getStackTrace()[1].getMethodName());
        params.setEsResultProcessor(new EsNewsInfoProcessor());
        params.setParser(new TableNewsParser());
        params.setAfterProcessor(new TableArticlesAfterProcessor());
        return this.esNewsDataController.exportNews(params, response);
    }

    public Boolean setPid(HotParams params) {
        List<String> pids = params.getPids();
        final HashSet<String> sourceIds = new HashSet<String>();
        if (pids != null && !pids.isEmpty()) {
            for (String pid : pids) {
                SiteInc siteInc = new SiteInc();
                siteInc.setPagetype(1);
                siteInc.setPids(pid);
                CodeResult detailsPageSite = (CodeResult)this.siteQueryService.getDetailsPageSite(siteInc);
                List result = (List)detailsPageSite.getResult();
                for (Site site : result) {
                    sourceIds.add(site.getSiteId().toString());
                }
            }
            if (sourceIds.isEmpty()) {
                return false;
            }
            params.setSourceIds((List<String>)new ArrayList<String>(){
                {
                    this.addAll(sourceIds);
                }
            });
        }
        return true;
    }

    public void verifyPids(HotParams params) {
        List<String> pids = params.getPids();
        if (pids == null) {
            return;
        }
        ArrayList<String> pid_list = new ArrayList<String>(pids.size());
        for (String pid : pids) {
            if (StringUtils.isBlank((CharSequence)pid)) continue;
            if (!NumberUtils.isNumeric(pid)) {
                throw new CustomException("params_error");
            }
            pid_list.add(pid);
        }
        params.setPids(pid_list);
    }
}

