/*
 * Decompiled with CFR 0.152.
 */
package com.chinamcloud.haihe.newservice.collect.service;

import com.chinamcloud.haihe.common.CodeResult;
import com.chinamcloud.haihe.common.Const;
import com.chinamcloud.haihe.common.Exception.CustomException;
import com.chinamcloud.haihe.common.i18n.MessageSource;
import com.chinamcloud.haihe.common.pojo.PagerResult;
import com.chinamcloud.haihe.common.utils.CmcStringUtils;
import com.chinamcloud.haihe.common.utils.SimpleSummariserAlgorithm;
import com.chinamcloud.haihe.configService.entity.DataConfig;
import com.chinamcloud.haihe.configService.service.UserDataConfigService;
import com.chinamcloud.haihe.newservice.collect.bean.UserCollectArticle;
import com.chinamcloud.haihe.newservice.collect.bean.UserCollectArticlePageParam;
import com.chinamcloud.haihe.newservice.collect.mapper.UserCollectArticleMapper;
import com.github.pagehelper.PageHelper;
import com.github.pagehelper.PageInfo;
import com.jayway.jsonpath.DocumentContext;
import com.jayway.jsonpath.JsonPath;
import com.jayway.jsonpath.Predicate;
import java.util.Arrays;
import java.util.Date;
import java.util.List;
import org.apache.commons.lang3.StringUtils;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.springframework.beans.BeanUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.dao.DuplicateKeyException;
import org.springframework.stereotype.Service;

@Service
public class UserCollectArticleService {
    private static final Logger log = LogManager.getLogger(UserCollectArticleService.class);
    @Autowired
    private UserCollectArticleMapper mapper;
    @Autowired
    private UserDataConfigService userDataConfigService;

    public CodeResult getCollectArticleList(UserCollectArticlePageParam param) {
        if (StringUtils.isBlank((CharSequence)param.getUserToken())) {
            return CodeResult.failedResultByMsgSource("params_error");
        }
        try {
            if (StringUtils.isNotBlank((CharSequence)param.getSortField()) && Const.CollectArticleMap.containsKey(param.getSortField())) {
                PageHelper.startPage((int)param.getPageNum(), (int)param.getPageSize(), (String)(Const.CollectArticleMap.get(param.getSortField()) + " " + param.getSortOrd()));
            } else {
                PageHelper.startPage((int)param.getPageNum(), (int)param.getPageSize());
            }
            List<UserCollectArticle> userCollectArticles = this.mapper.selectByUserCollectArticle(param);
            if (userCollectArticles == null || userCollectArticles.isEmpty()) {
                log.error(MessageSource.getMsg("data_empty"));
                return new CodeResult<List<UserCollectArticle>>(CodeResult.Code.SUCCESS, userCollectArticles);
            }
            PageInfo pageInfo = new PageInfo(userCollectArticles);
            PagerResult bean = new PagerResult();
            BeanUtils.copyProperties((Object)pageInfo, bean);
            if (bean.getList() != null) {
                for (UserCollectArticle userCollectArticle : bean.getList()) {
                    if (!StringUtils.isNotBlank((CharSequence)userCollectArticle.getKeyword())) continue;
                    userCollectArticle.setKeywords(Arrays.asList((Object[])userCollectArticle.getKeyword().split(",").clone()));
                }
            }
            return new CodeResult(CodeResult.Code.SUCCESS, bean);
        }
        catch (Exception e) {
            return CodeResult.failedResultByMsgSource("failed");
        }
    }

    public CodeResult addCollectArticle(UserCollectArticle userCollectArticle) {
        String value;
        List<String> keywords;
        if (StringUtils.isBlank((CharSequence)userCollectArticle.getUserToken()) || userCollectArticle.getArticleId() == null || StringUtils.isBlank((CharSequence)userCollectArticle.getTitle())) {
            return CodeResult.failedResultByMsgSource("params_error");
        }
        if (userCollectArticle.getCollectionTime() == null) {
            userCollectArticle.setCollectionTime(new Date(System.currentTimeMillis()));
        }
        if ((keywords = userCollectArticle.getKeywords()) != null && !keywords.isEmpty() && StringUtils.isNotBlank((CharSequence)(value = CmcStringUtils.listToString(keywords, ",", 7, 200)))) {
            userCollectArticle.setKeyword(value);
        }
        if (StringUtils.isNotBlank((CharSequence)userCollectArticle.getContent())) {
            String summarise = SimpleSummariserAlgorithm.summarise(SimpleSummariserAlgorithm.cToe(userCollectArticle.getContent().replace("[[+_+]]", "").replace("`n`", "").trim()), 1);
            if (summarise.length() > 55) {
                summarise = summarise.substring(0, Math.min(95, summarise.length())) + "...";
            }
            userCollectArticle.setDigest(summarise);
        }
        this.userCollectClassify(userCollectArticle.getUserToken(), userCollectArticle.getCollectClassify());
        try {
            this.mapper.insertSelective(userCollectArticle);
        }
        catch (DuplicateKeyException e) {
            return CodeResult.failedResultByMsgSource("failed", " \u91cd\u590d\u6536\u85cf");
        }
        return CodeResult.SUCCESSRESULT("success");
    }

    public CodeResult updateCollectArticle(UserCollectArticle userCollectArticle) {
        String value;
        if (StringUtils.isBlank((CharSequence)userCollectArticle.getUserToken()) || userCollectArticle.getArticleId() == null || userCollectArticle.getId() == null) {
            return CodeResult.failedResultByMsgSource("params_error");
        }
        List<String> keywords = userCollectArticle.getKeywords();
        if (keywords != null && !keywords.isEmpty() && StringUtils.isNotBlank((CharSequence)(value = CmcStringUtils.listToString(keywords, ",", 7, 200)))) {
            userCollectArticle.setKeyword(value);
        }
        if (StringUtils.isNotBlank((CharSequence)userCollectArticle.getContent())) {
            String summarise = SimpleSummariserAlgorithm.summarise(SimpleSummariserAlgorithm.cToe(userCollectArticle.getContent()), 1);
            if (summarise.length() > 55) {
                summarise = summarise.substring(0, Math.min(95, summarise.length())) + "...";
            }
            userCollectArticle.setDigest(summarise);
        }
        this.userCollectClassify(userCollectArticle.getUserToken(), userCollectArticle.getCollectClassify());
        try {
            this.mapper.updateByPrimaryKeySelective(userCollectArticle);
        }
        catch (DuplicateKeyException e) {
            return CodeResult.failedResultByMsgSource("failed", "\u66f4\u65b0\u5931\u8d25");
        }
        return CodeResult.SUCCESSRESULT("success");
    }

    public CodeResult deleteCollectArticle(UserCollectArticlePageParam param) {
        if (StringUtils.isBlank((CharSequence)param.getUserToken()) || param.getIds() == null) {
            return CodeResult.failedResultByMsgSource("params_error");
        }
        try {
            this.mapper.deleteByPrimaryKey(param);
        }
        catch (Exception e) {
            return CodeResult.failedResultByMsgSource("delete_failed");
        }
        return CodeResult.SUCCESSRESULT("success");
    }

    public CodeResult moveCollectArticle(UserCollectArticlePageParam param) {
        if (StringUtils.isBlank((CharSequence)param.getUserToken()) || param.getIds() == null || param.getIds().isEmpty()) {
            return CodeResult.failedResultByMsgSource("params_error");
        }
        this.userCollectClassify(param.getUserToken(), param.getCollectClassify());
        try {
            this.mapper.moveCollectArticle(param.getIds(), param.getCollectClassify());
        }
        catch (DuplicateKeyException e) {
            return CodeResult.failedResultByMsgSource("failed", " \u79fb\u52a8\u5931\u8d25");
        }
        return CodeResult.SUCCESSRESULT("success");
    }

    public void userCollectClassify(String userToken, Long classify) {
        DataConfig dataConfig = this.userDataConfigService.selectByPrimaryKey(userToken, "user_collect_classify", "1");
        String data = dataConfig.getData();
        if (StringUtils.isBlank((CharSequence)data)) {
            throw new CustomException("\u6536\u85cf\u5206\u7c7b\u6ca1\u6709\u914d\u7f6e");
        }
        DocumentContext context = JsonPath.parse((String)data);
        List classifyCodes = null;
        try {
            classifyCodes = (List)context.read(JsonPath.compile((String)"$.classify[*].code", (Predicate[])new Predicate[0]));
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        if (classifyCodes != null && !classifyCodes.contains(classify) && classify != 0L) {
            throw new CustomException("\u6ca1\u6709\u5bf9\u5e94\u7684\u5206\u7c7b");
        }
    }
}

