/*
 * Decompiled with CFR 0.152.
 */
package com.chinamcloud.haihe.newservice.topSearch.service;

import com.chinamcloud.haihe.common.CodeResult;
import com.chinamcloud.haihe.common.i18n.MessageSource;
import com.chinamcloud.haihe.common.pojo.PagerResult;
import com.chinamcloud.haihe.common.utils.ToolUtil;
import com.chinamcloud.haihe.newservice.topSearch.bean.TopSearchBean;
import com.chinamcloud.haihe.newservice.topSearch.bean.TopSearchVo;
import com.chinamcloud.haihe.newservice.topSearch.mapper.TopSearchMapper;
import com.github.pagehelper.PageHelper;
import com.github.pagehelper.PageInfo;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.springframework.beans.BeanUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

@Service
public class TopSearchService {
    private static final Logger log = LogManager.getLogger(TopSearchService.class);
    @Autowired
    TopSearchMapper topSearchMapper;

    public CodeResult getTopSearchList(TopSearchVo topSearch) {
        if (topSearch.getType() == null || topSearch.getType().length == 0) {
            Integer[] typeArray = new Integer[]{1};
            topSearch.setType(typeArray);
        }
        if (topSearch.getPageNum() != null && topSearch.getPageSize() != null) {
            List<Integer> integers;
            PageHelper.startPage((int)topSearch.getPageNum(), (int)topSearch.getPageSize());
            List<TopSearchBean> TopSearchList = this.topSearchMapper.getTopSearchList(topSearch);
            if (TopSearchList == null || TopSearchList.isEmpty()) {
                log.error(MessageSource.getMsg("data_empty"));
                return new CodeResult<List<TopSearchBean>>(CodeResult.Code.SUCCESS, TopSearchList);
            }
            PageInfo pageInfo = new PageInfo(TopSearchList);
            PagerResult bean = new PagerResult();
            BeanUtils.copyProperties((Object)pageInfo, bean);
            List<TopSearchBean> list = bean.getList();
            if (list != null && !list.isEmpty() && ((integers = Arrays.asList(topSearch.getType())).contains(74) || integers.contains(75) || integers.contains(76))) {
                list.forEach(x -> {
                    String url = x.getUrl();
                    if (ToolUtil.countStr(url, ".") == 1) {
                        x.setUrl("www." + url);
                    }
                });
            }
            return new CodeResult(CodeResult.Code.SUCCESS, bean);
        }
        List<TopSearchBean> TopSearchList = this.topSearchMapper.getTopSearchList(topSearch);
        ArrayList TopSearchresult = new ArrayList();
        HashSet<Integer> setTmp = new HashSet<Integer>();
        for (TopSearchBean item : TopSearchList) {
            setTmp.add(item.getType());
        }
        Iterator it = setTmp.iterator();
        while (it.hasNext()) {
            int type = (Integer)it.next();
            ArrayList<TopSearchBean> oneTypeTopSearchList = new ArrayList<TopSearchBean>();
            for (TopSearchBean item : TopSearchList) {
                int onetype = item.getType();
                if (type != onetype) continue;
                oneTypeTopSearchList.add(item);
            }
            HashMap<String, Serializable> oneTypeTopSearchresult = new HashMap<String, Serializable>();
            oneTypeTopSearchresult.put("type", Integer.valueOf(type));
            oneTypeTopSearchresult.put("topsearchList", oneTypeTopSearchList);
            if (type == 74 || type == 75 || type == 76) {
                oneTypeTopSearchList.forEach(x -> {
                    String url = x.getUrl();
                    if (ToolUtil.countStr(url, ".") == 1) {
                        x.setUrl("www." + url);
                    }
                });
            }
            TopSearchresult.add(oneTypeTopSearchresult);
        }
        return new CodeResult(CodeResult.Code.SUCCESS, TopSearchresult);
    }

    public int insert(TopSearchBean topSearchBean) {
        int flag = this.topSearchMapper.insert(topSearchBean);
        return flag;
    }

    public List<TopSearchBean> getListByType(Integer type) {
        return this.topSearchMapper.getTopSearchListByType(type);
    }

    @Transactional
    public Boolean delete(List<TopSearchBean> topSearchBeans) {
        for (TopSearchBean topSearchBean : topSearchBeans) {
            this.topSearchMapper.delete(topSearchBean);
        }
        return true;
    }
}

