/*
 * Decompiled with CFR 0.152.
 */
package com.chinamcloud.bigdata.tenant.config;

import java.security.InvalidKeyException;
import java.security.NoSuchAlgorithmException;
import javax.crypto.Mac;
import javax.crypto.spec.SecretKeySpec;

public class HMACSHA1 {
    private static final String HMAC_SHA1 = "HmacSHA1";

    public static String getSignature(String data, String key) throws Exception {
        byte[] rawHmac = HMACSHA1.getSignatureToByte(data, key);
        String hexBytes = HMACSHA1.byte2hex(rawHmac);
        return hexBytes;
    }

    public static byte[] getSignatureToByte(String data, String key) throws NoSuchAlgorithmException, InvalidKeyException {
        byte[] keyBytes = key.getBytes();
        SecretKeySpec signingKey = new SecretKeySpec(keyBytes, HMAC_SHA1);
        Mac mac = Mac.getInstance(HMAC_SHA1);
        mac.init(signingKey);
        return mac.doFinal(data.getBytes());
    }

    private static String byte2hex(byte[] b) {
        String hs = "";
        String stmp = "";
        for (int n = 0; n < b.length; ++n) {
            stmp = Integer.toHexString(b[n] & 0xFF);
            hs = stmp.length() == 1 ? hs + "0" + stmp : hs + stmp;
        }
        return hs;
    }
}

