/*
 * Decompiled with CFR 0.152.
 */
package com.chinamcloud.common.db;

import java.beans.ConstructorProperties;
import java.io.Serializable;

public class DBConnection
implements Serializable {
    private String url;
    private String userName;
    private String password;
    private String driverClassName = "com.mysql.jdbc.Driver";
    private String filters = "stat";
    private int maxActive = 50;
    private int initialSize = 1;
    private int minIdle = 10;
    private Long maxWait = 60000L;
    private Long timeBetweenEvictionRunsMillis = 60000L;
    private Long minEvictableIdleTimeMillis = 300000L;
    private String validationQuery = "SELECT 'x'";
    private boolean testWhileIdle = true;
    private boolean testOnBorrow = false;
    private boolean testOnReturn = false;
    private int maxOpenPreparedStatements = 20;

    public static DBConnectionBuilder builder() {
        return new DBConnectionBuilder();
    }

    public String getUrl() {
        return this.url;
    }

    public String getUserName() {
        return this.userName;
    }

    public String getPassword() {
        return this.password;
    }

    public String getDriverClassName() {
        return this.driverClassName;
    }

    public String getFilters() {
        return this.filters;
    }

    public int getMaxActive() {
        return this.maxActive;
    }

    public int getInitialSize() {
        return this.initialSize;
    }

    public int getMinIdle() {
        return this.minIdle;
    }

    public Long getMaxWait() {
        return this.maxWait;
    }

    public Long getTimeBetweenEvictionRunsMillis() {
        return this.timeBetweenEvictionRunsMillis;
    }

    public Long getMinEvictableIdleTimeMillis() {
        return this.minEvictableIdleTimeMillis;
    }

    public String getValidationQuery() {
        return this.validationQuery;
    }

    public boolean isTestWhileIdle() {
        return this.testWhileIdle;
    }

    public boolean isTestOnBorrow() {
        return this.testOnBorrow;
    }

    public boolean isTestOnReturn() {
        return this.testOnReturn;
    }

    public int getMaxOpenPreparedStatements() {
        return this.maxOpenPreparedStatements;
    }

    public void setUrl(String url) {
        this.url = url;
    }

    public void setUserName(String userName) {
        this.userName = userName;
    }

    public void setPassword(String password) {
        this.password = password;
    }

    public void setDriverClassName(String driverClassName) {
        this.driverClassName = driverClassName;
    }

    public void setFilters(String filters) {
        this.filters = filters;
    }

    public void setMaxActive(int maxActive) {
        this.maxActive = maxActive;
    }

    public void setInitialSize(int initialSize) {
        this.initialSize = initialSize;
    }

    public void setMinIdle(int minIdle) {
        this.minIdle = minIdle;
    }

    public void setMaxWait(Long maxWait) {
        this.maxWait = maxWait;
    }

    public void setTimeBetweenEvictionRunsMillis(Long timeBetweenEvictionRunsMillis) {
        this.timeBetweenEvictionRunsMillis = timeBetweenEvictionRunsMillis;
    }

    public void setMinEvictableIdleTimeMillis(Long minEvictableIdleTimeMillis) {
        this.minEvictableIdleTimeMillis = minEvictableIdleTimeMillis;
    }

    public void setValidationQuery(String validationQuery) {
        this.validationQuery = validationQuery;
    }

    public void setTestWhileIdle(boolean testWhileIdle) {
        this.testWhileIdle = testWhileIdle;
    }

    public void setTestOnBorrow(boolean testOnBorrow) {
        this.testOnBorrow = testOnBorrow;
    }

    public void setTestOnReturn(boolean testOnReturn) {
        this.testOnReturn = testOnReturn;
    }

    public void setMaxOpenPreparedStatements(int maxOpenPreparedStatements) {
        this.maxOpenPreparedStatements = maxOpenPreparedStatements;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof DBConnection)) {
            return false;
        }
        DBConnection other = (DBConnection)o;
        if (!other.canEqual(this)) {
            return false;
        }
        String this$url = this.getUrl();
        String other$url = other.getUrl();
        if (this$url == null ? other$url != null : !this$url.equals(other$url)) {
            return false;
        }
        String this$userName = this.getUserName();
        String other$userName = other.getUserName();
        if (this$userName == null ? other$userName != null : !this$userName.equals(other$userName)) {
            return false;
        }
        String this$password = this.getPassword();
        String other$password = other.getPassword();
        if (this$password == null ? other$password != null : !this$password.equals(other$password)) {
            return false;
        }
        String this$driverClassName = this.getDriverClassName();
        String other$driverClassName = other.getDriverClassName();
        if (this$driverClassName == null ? other$driverClassName != null : !this$driverClassName.equals(other$driverClassName)) {
            return false;
        }
        String this$filters = this.getFilters();
        String other$filters = other.getFilters();
        if (this$filters == null ? other$filters != null : !this$filters.equals(other$filters)) {
            return false;
        }
        if (this.getMaxActive() != other.getMaxActive()) {
            return false;
        }
        if (this.getInitialSize() != other.getInitialSize()) {
            return false;
        }
        if (this.getMinIdle() != other.getMinIdle()) {
            return false;
        }
        Long this$maxWait = this.getMaxWait();
        Long other$maxWait = other.getMaxWait();
        if (this$maxWait == null ? other$maxWait != null : !((Object)this$maxWait).equals(other$maxWait)) {
            return false;
        }
        Long this$timeBetweenEvictionRunsMillis = this.getTimeBetweenEvictionRunsMillis();
        Long other$timeBetweenEvictionRunsMillis = other.getTimeBetweenEvictionRunsMillis();
        if (this$timeBetweenEvictionRunsMillis == null ? other$timeBetweenEvictionRunsMillis != null : !((Object)this$timeBetweenEvictionRunsMillis).equals(other$timeBetweenEvictionRunsMillis)) {
            return false;
        }
        Long this$minEvictableIdleTimeMillis = this.getMinEvictableIdleTimeMillis();
        Long other$minEvictableIdleTimeMillis = other.getMinEvictableIdleTimeMillis();
        if (this$minEvictableIdleTimeMillis == null ? other$minEvictableIdleTimeMillis != null : !((Object)this$minEvictableIdleTimeMillis).equals(other$minEvictableIdleTimeMillis)) {
            return false;
        }
        String this$validationQuery = this.getValidationQuery();
        String other$validationQuery = other.getValidationQuery();
        if (this$validationQuery == null ? other$validationQuery != null : !this$validationQuery.equals(other$validationQuery)) {
            return false;
        }
        if (this.isTestWhileIdle() != other.isTestWhileIdle()) {
            return false;
        }
        if (this.isTestOnBorrow() != other.isTestOnBorrow()) {
            return false;
        }
        if (this.isTestOnReturn() != other.isTestOnReturn()) {
            return false;
        }
        return this.getMaxOpenPreparedStatements() == other.getMaxOpenPreparedStatements();
    }

    protected boolean canEqual(Object other) {
        return other instanceof DBConnection;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        String $url = this.getUrl();
        result = result * 59 + ($url == null ? 43 : $url.hashCode());
        String $userName = this.getUserName();
        result = result * 59 + ($userName == null ? 43 : $userName.hashCode());
        String $password = this.getPassword();
        result = result * 59 + ($password == null ? 43 : $password.hashCode());
        String $driverClassName = this.getDriverClassName();
        result = result * 59 + ($driverClassName == null ? 43 : $driverClassName.hashCode());
        String $filters = this.getFilters();
        result = result * 59 + ($filters == null ? 43 : $filters.hashCode());
        result = result * 59 + this.getMaxActive();
        result = result * 59 + this.getInitialSize();
        result = result * 59 + this.getMinIdle();
        Long $maxWait = this.getMaxWait();
        result = result * 59 + ($maxWait == null ? 43 : ((Object)$maxWait).hashCode());
        Long $timeBetweenEvictionRunsMillis = this.getTimeBetweenEvictionRunsMillis();
        result = result * 59 + ($timeBetweenEvictionRunsMillis == null ? 43 : ((Object)$timeBetweenEvictionRunsMillis).hashCode());
        Long $minEvictableIdleTimeMillis = this.getMinEvictableIdleTimeMillis();
        result = result * 59 + ($minEvictableIdleTimeMillis == null ? 43 : ((Object)$minEvictableIdleTimeMillis).hashCode());
        String $validationQuery = this.getValidationQuery();
        result = result * 59 + ($validationQuery == null ? 43 : $validationQuery.hashCode());
        result = result * 59 + (this.isTestWhileIdle() ? 79 : 97);
        result = result * 59 + (this.isTestOnBorrow() ? 79 : 97);
        result = result * 59 + (this.isTestOnReturn() ? 79 : 97);
        result = result * 59 + this.getMaxOpenPreparedStatements();
        return result;
    }

    public String toString() {
        return "DBConnection(url=" + this.getUrl() + ", userName=" + this.getUserName() + ", password=" + this.getPassword() + ", driverClassName=" + this.getDriverClassName() + ", filters=" + this.getFilters() + ", maxActive=" + this.getMaxActive() + ", initialSize=" + this.getInitialSize() + ", minIdle=" + this.getMinIdle() + ", maxWait=" + this.getMaxWait() + ", timeBetweenEvictionRunsMillis=" + this.getTimeBetweenEvictionRunsMillis() + ", minEvictableIdleTimeMillis=" + this.getMinEvictableIdleTimeMillis() + ", validationQuery=" + this.getValidationQuery() + ", testWhileIdle=" + this.isTestWhileIdle() + ", testOnBorrow=" + this.isTestOnBorrow() + ", testOnReturn=" + this.isTestOnReturn() + ", maxOpenPreparedStatements=" + this.getMaxOpenPreparedStatements() + ")";
    }

    @ConstructorProperties(value={"url", "userName", "password", "driverClassName", "filters", "maxActive", "initialSize", "minIdle", "maxWait", "timeBetweenEvictionRunsMillis", "minEvictableIdleTimeMillis", "validationQuery", "testWhileIdle", "testOnBorrow", "testOnReturn", "maxOpenPreparedStatements"})
    public DBConnection(String url, String userName, String password, String driverClassName, String filters, int maxActive, int initialSize, int minIdle, Long maxWait, Long timeBetweenEvictionRunsMillis, Long minEvictableIdleTimeMillis, String validationQuery, boolean testWhileIdle, boolean testOnBorrow, boolean testOnReturn, int maxOpenPreparedStatements) {
        this.url = url;
        this.userName = userName;
        this.password = password;
        this.driverClassName = driverClassName;
        this.filters = filters;
        this.maxActive = maxActive;
        this.initialSize = initialSize;
        this.minIdle = minIdle;
        this.maxWait = maxWait;
        this.timeBetweenEvictionRunsMillis = timeBetweenEvictionRunsMillis;
        this.minEvictableIdleTimeMillis = minEvictableIdleTimeMillis;
        this.validationQuery = validationQuery;
        this.testWhileIdle = testWhileIdle;
        this.testOnBorrow = testOnBorrow;
        this.testOnReturn = testOnReturn;
        this.maxOpenPreparedStatements = maxOpenPreparedStatements;
    }

    public DBConnection() {
    }

    public static class DBConnectionBuilder {
        private String url;
        private String userName;
        private String password;
        private String driverClassName;
        private String filters;
        private int maxActive;
        private int initialSize;
        private int minIdle;
        private Long maxWait;
        private Long timeBetweenEvictionRunsMillis;
        private Long minEvictableIdleTimeMillis;
        private String validationQuery;
        private boolean testWhileIdle;
        private boolean testOnBorrow;
        private boolean testOnReturn;
        private int maxOpenPreparedStatements;

        DBConnectionBuilder() {
        }

        public DBConnectionBuilder url(String url) {
            this.url = url;
            return this;
        }

        public DBConnectionBuilder userName(String userName) {
            this.userName = userName;
            return this;
        }

        public DBConnectionBuilder password(String password) {
            this.password = password;
            return this;
        }

        public DBConnectionBuilder driverClassName(String driverClassName) {
            this.driverClassName = driverClassName;
            return this;
        }

        public DBConnectionBuilder filters(String filters) {
            this.filters = filters;
            return this;
        }

        public DBConnectionBuilder maxActive(int maxActive) {
            this.maxActive = maxActive;
            return this;
        }

        public DBConnectionBuilder initialSize(int initialSize) {
            this.initialSize = initialSize;
            return this;
        }

        public DBConnectionBuilder minIdle(int minIdle) {
            this.minIdle = minIdle;
            return this;
        }

        public DBConnectionBuilder maxWait(Long maxWait) {
            this.maxWait = maxWait;
            return this;
        }

        public DBConnectionBuilder timeBetweenEvictionRunsMillis(Long timeBetweenEvictionRunsMillis) {
            this.timeBetweenEvictionRunsMillis = timeBetweenEvictionRunsMillis;
            return this;
        }

        public DBConnectionBuilder minEvictableIdleTimeMillis(Long minEvictableIdleTimeMillis) {
            this.minEvictableIdleTimeMillis = minEvictableIdleTimeMillis;
            return this;
        }

        public DBConnectionBuilder validationQuery(String validationQuery) {
            this.validationQuery = validationQuery;
            return this;
        }

        public DBConnectionBuilder testWhileIdle(boolean testWhileIdle) {
            this.testWhileIdle = testWhileIdle;
            return this;
        }

        public DBConnectionBuilder testOnBorrow(boolean testOnBorrow) {
            this.testOnBorrow = testOnBorrow;
            return this;
        }

        public DBConnectionBuilder testOnReturn(boolean testOnReturn) {
            this.testOnReturn = testOnReturn;
            return this;
        }

        public DBConnectionBuilder maxOpenPreparedStatements(int maxOpenPreparedStatements) {
            this.maxOpenPreparedStatements = maxOpenPreparedStatements;
            return this;
        }

        public DBConnection build() {
            return new DBConnection(this.url, this.userName, this.password, this.driverClassName, this.filters, this.maxActive, this.initialSize, this.minIdle, this.maxWait, this.timeBetweenEvictionRunsMillis, this.minEvictableIdleTimeMillis, this.validationQuery, this.testWhileIdle, this.testOnBorrow, this.testOnReturn, this.maxOpenPreparedStatements);
        }

        public String toString() {
            return "DBConnection.DBConnectionBuilder(url=" + this.url + ", userName=" + this.userName + ", password=" + this.password + ", driverClassName=" + this.driverClassName + ", filters=" + this.filters + ", maxActive=" + this.maxActive + ", initialSize=" + this.initialSize + ", minIdle=" + this.minIdle + ", maxWait=" + this.maxWait + ", timeBetweenEvictionRunsMillis=" + this.timeBetweenEvictionRunsMillis + ", minEvictableIdleTimeMillis=" + this.minEvictableIdleTimeMillis + ", validationQuery=" + this.validationQuery + ", testWhileIdle=" + this.testWhileIdle + ", testOnBorrow=" + this.testOnBorrow + ", testOnReturn=" + this.testOnReturn + ", maxOpenPreparedStatements=" + this.maxOpenPreparedStatements + ")";
        }
    }
}

