package com.chinamcloud.common.check;

import com.chinamcloud.common.util.DomainUtil;
import com.chinamcloud.common.util.StringUtil;
import net.sf.json.JSONArray;
import net.sf.json.JSONException;
import net.sf.json.JSONObject;

public class ApiUtil {
	// final static Logger logger = LoggerFactory.getLogger(ApiUtil.class);
	public static String getCallBackResponse(String callback, String message) {
		String result = "";
		if (StringUtil.isNotEmpty(callback)) {
			result = callback + "(" + message + ")";
		} else {
			result = message;
		}
		return result;
	}

	/**
	 * 接口参数检查
	 * @param _ParameterColumns 字段属性
	 * @param data 接受数据
	 * @param result 结果记录
	 * @return
	 */
	public static  boolean checkParamters(ParameterColumn[] _ParameterColumns, JSONObject data, ResultVo result) {
		boolean flag = true;
		try {
			for (ParameterColumn ParameterC : _ParameterColumns) {
				// 首先检查参数的值类型是否正确
				if (data.has(ParameterC.getName())) {
					// 如果当前参数的值为空
					if (StringUtil.isEmpty(data.getString(ParameterC.getName()))) {
						// 当前为空字段为非必须字段
						if (!ParameterC.isNullFlag()) {
							continue;
						} else {
							result.setCodeAndMessage(ApiConstant.CODE_PARAMETER_ERROR, "参数[" + ParameterC.getName()
									+ "]值不能为空");
							throw new RuntimeException();
						}
					}
					if (ParameterC.getType() == ApiConstant.ParameterType_LONG) {
						try {
							data.getLong(ParameterC.getName());
						} catch (Exception e) {
							result.setCodeAndMessage(ApiConstant.CODE_PARAMETER_ERROR, "参数[" + ParameterC.getName()
									+ "]值不是整型");
							throw new RuntimeException();
						}
					} else if (ParameterC.getType() == ApiConstant.ParameterType_BOOLEAN) {
						try {
							data.getBoolean(ParameterC.getName());
						} catch (Exception e) {
							result.setCodeAndMessage(ApiConstant.CODE_PARAMETER_ERROR, "参数[" + ParameterC.getName()
									+ "]值不是boolean类型");
							throw new RuntimeException();
						}
					} else if (ParameterC.getType() == ApiConstant.ParameterType_JSONOBJECT) {
						try {
							JSONObject.fromObject(data.getString(ParameterC.getName()));
						} catch (Exception e) {
							result.setCodeAndMessage(ApiConstant.CODE_PARAMETER_ERROR, "参数[" + ParameterC.getName()
									+ "]值不是jsonobject类型");
							throw new RuntimeException();
						}
					}else if (ParameterC.getType() == ApiConstant.ParameterType_JSONARRAY) {
						try {
							JSONArray.fromObject(data.getString(ParameterC.getName()));
						} catch (Exception e) {
							result.setCodeAndMessage(ApiConstant.CODE_PARAMETER_ERROR, "参数[" + ParameterC.getName()
									+ "]值不是jsonArray类型");
							throw new RuntimeException();
						}
					}
				} else {
					if (ParameterC.isNullFlag()) {
						result.setCodeAndMessage(ApiConstant.CODE_PARAMETER_ERROR, "参数[" + ParameterC.getName()
								+ "]不存在");
						throw new RuntimeException();
					}
					data.put(ParameterC.getName(), "");
				}
			}
		} catch (Exception e) {
			e.printStackTrace();
			flag = false;
		}
		return flag;
	}

	
	public static void main(String s[]) throws JSONException{
		JSONObject json = new JSONObject();
	//	json.put("sourceType", "");
	//	json.put("catalogPath", 22);
		
		ResultVo result = new ResultVo();
		ParameterColumn[] _ParameterColumns= {
				new ParameterColumn("sourceType",ApiConstant.ParameterType_LONG,0,false,null,""),
				new ParameterColumn("catalogPath",ApiConstant.ParameterType_STRING,0,false,null,"")
			
		};
		System.out.println(checkParamters(_ParameterColumns,json,result));
		System.out.println(DomainUtil.domainToJsonObject(result).toString());
		System.out.println(json.toString());
	}
	
}
