package com.chinamcloud.common.check;

import com.chinamcloud.common.util.StringUtil;
import net.sf.json.JSONException;



/**
 * API接口返回处理类
 * @author yangmaohua
 *
 */

public class ResultVo {
	
	/**
	 * 响应状态代码
	 */
	private String code =ApiConstant.CODE_FAILUR;
	
	/**
	 * 响应状态说明
	 */
	private String description =ApiConstant.CODE_FAILUR_MESSAGE;
	
	
	public void setCodeAndMessage(String code,String message){
		if(StringUtil.isEmpty(code)){
			this.code = ApiConstant.CODE_FAILUR;
			this.description = ApiConstant.CODE_FAILUR_MESSAGE;
		}else{
			this.code = code;
			this.description = message;
		}
	}
	
	/**
	 * 资源未找到
	 * @param message
	 */
	public void set404(String message){
		this.code = ApiConstant.CODE_404_ERROR;
		this.description = ApiConstant.CODE_404_ERROR_MESSAGE;
		if(StringUtil.isNotEmpty(message)){
			this.description = message;
		}
		
	}
	
	public void setSuccessMessage(String message){
		this.code = ApiConstant.CODE_SUCCESS;
		this.description = message;
	}
	
	public void setFailueMessage(String message){
		this.code = ApiConstant.CODE_FAILUR;
		this.description = message;
	}
	

	/**
	 * 响应状态数据
	 */
	private Object data;
	
	public String getCode() {
		return code;
	}

	public void setCode(String code) {
		this.code = code;
	}

	public String getDescription() {
		return description;
	}

	public void setDescription(String description) {
		this.description = description;
	}

	public Object getData() {
		return data;
	}

	public void setData(Object data) {
		this.data = data;
	}

	public static void main(String []s) throws JSONException{
		
//			ResultVo re = new ResultVo();
//			String [] ss= {"code"};
//			JSONObject jo = new JSONObject(re,ss );
//			System.out.println(jo.toString());
		//	System.out.println(DomainUtil.domainToJsonObjectNoToLower(re));
			
		}
	
}
