package com.chinamcloud.common.db;

import lombok.AllArgsConstructor;
import lombok.Builder;
import lombok.Data;
import lombok.NoArgsConstructor;

import java.io.Serializable;

@Data
@Builder
@AllArgsConstructor
@NoArgsConstructor
public class DBConnection implements Serializable{
	
	/**
	 * 连接地址
	 */
	private String url;
	
	/**
	 * 用户名
	 */
	private String userName;

	/**
	 * 密码
	 */
	private String password;

	/**
	 * 数据库驱动类
	 */
	private String driverClassName="com.mysql.jdbc.Driver";

	/**
	 * 配置一些过滤器类
	 */
	private String filters="stat";
	/**
	 * 最大的活跃的数量
	 */
	private int maxActive=50;
	/**
	 * 初始化大小
	 */
	private int initialSize=1;
	/**
	 * 最小连接数
	 */
	private int minIdle=10;
	/**
	 * 等待超时时间
	 */
	private Long maxWait=60000l;
	/**
	 * 配置间隔多久才进行一次检测，检测需要关闭的空闲连接，单位是毫秒
	 */
	private Long timeBetweenEvictionRunsMillis=60000l;
	/**
	 * 配置一个连接在池中最小生存的时间，单位是毫秒
	 */
	private Long minEvictableIdleTimeMillis=300000l;
	/**
	 * 用来检测连接是否有效的sql，要求是一个查询语句。如果validationQuery为null，
	 * testOnBorrow、testOnReturn、testWhileIdle都不会其作用。
	 */
	private String validationQuery="SELECT 'x'";
	/**
	 * 建议配置为true，不影响性能，并且保证安全性。申请连接的时候检测，
	 * 如果空闲时间大于timeBetweenEvictionRunsMillis，执行validationQuery检测连接是否有效。
	 */
	private boolean testWhileIdle=true;
	/**
	 * 申请连接时执行validationQuery检测连接是否有效，做了这个配置会降低性能。
	 */
	private boolean testOnBorrow=false;
	/**
	 * 归还连接时执行validationQuery检测连接是否有效，做了这个配置会降低性能
	 */
	private boolean testOnReturn=false;
	/**
	 * 要启用PSCache，必须配置大于0，当大于0时，poolPreparedStatements自动触发修改为true。在Druid中，
	 * 不会存在Oracle下PSCache占用内存过多的问题，可以把这个数值配置大一些，比如说100
	 */
	private int maxOpenPreparedStatements=20;
}
