package com.chinamcloud.common.db;

import com.alibaba.druid.pool.DruidDataSource;
import org.springframework.jdbc.datasource.lookup.AbstractRoutingDataSource;

import java.sql.SQLException;
import java.util.HashMap;
import java.util.Map;

/**
 * 实现动态切库功能
 * Created by HUCX on 2016/11/25.
 */
public class RoutingDataSource extends AbstractRoutingDataSource {
	//存放数据库连接信息（存放格式，key-value）
	public Map<Object, Object> _targetDataSources=new HashMap<Object,Object>();
	//默认数据库连接信息
	public Object _defaultTargetDataSource;

	public Map<Object, Object> get_targetDataSources() {
		return _targetDataSources;
	}

	public void set_targetDataSources(Map<Object, Object> _targetDataSources) {
		this._targetDataSources = _targetDataSources;
	}

	public Object get_defaultTargetDataSource() {
		return _defaultTargetDataSource;
	}

	public void set_defaultTargetDataSource(Object _defaultTargetDataSource) {
		this._defaultTargetDataSource = _defaultTargetDataSource;
	}

	@Override
	protected Object determineCurrentLookupKey() {
		return DataSourceHolder.getDataSource();
	}

	/**
	 * 新增数据库连接（传入DBConnection对象）
	 * @param key  该数据库连接的标示
	 * @param dbconnection   数据库连接信息
	 * @return
	 */
	public boolean createDataSource(String key, DBConnection dbconnection){
		try {
			if (key.equals(DataSourceHolder.getDataSource())) {
				return false;
			} else {
				if (this.get_targetDataSources().keySet().contains(key)) {
					DataSourceHolder.setDataSource(key);
				} else {
					DruidDataSource dataSource = setDruidDataSource(dbconnection);
					this.get_targetDataSources().put(key, dataSource);
					setTargetDataSources(this._targetDataSources);
					afterPropertiesSet();
					DataSourceHolder.setDataSource(key);
				}
				return true;
			}
		}catch (SQLException e){
			e.printStackTrace();

		}
		return false;
	}

	/**
	 * 新增数据库连接（传入DBConnection对象）
	 * @param key 该数据库连接的标示
	 * @param dataSource 数据库连接信息
	 * @return
	 */
	public boolean createDataSource(String key, DruidDataSource dataSource) {
		if (key.equals(DataSourceHolder.getDataSource())) {
            return false;
        } else {
            if (this._targetDataSources.keySet().contains(key)) {
                DataSourceHolder.setDataSource(key);
            } else {
                this._targetDataSources.put(key, dataSource);
                setTargetDataSources(this._targetDataSources);
                afterPropertiesSet();
                DataSourceHolder.setDataSource(key);
            }
            return true;
        }
	}

	/**
	 * 切换到默认数据库
	 * @return
	 */
	public boolean DBConnPoolDefault(String key){
		super.setDefaultTargetDataSource(this._defaultTargetDataSource);
		if(this.createDataSource(key, (DruidDataSource)this._defaultTargetDataSource)){
			this._targetDataSources.put(key, _defaultTargetDataSource);
			setTargetDataSources(this._targetDataSources);
			afterPropertiesSet();
			DataSourceHolder.setDataSource(key);
			return true;
		}
		return false;
	}


	/**
	 * 通过key，来验证所对于的数据源是否已经创建
	 * @param key
	 * @return
	 */
	public boolean checkDataSourse(String key){
		return this._targetDataSources.keySet().contains(key);
	}

	/**
	 * 初始化DruidDataSource数据源
	 * @param dbconnection
	 * @return
	 * @throws SQLException
	 * @throws NullPointerException
	 */
	private DruidDataSource setDruidDataSource(DBConnection dbconnection) throws SQLException, NullPointerException {
		if (dbconnection == null){
			throw new NullPointerException("DBConnection对象不可以为null");
		}
		DruidDataSource dataSource = new DruidDataSource();
		dataSource.setDriverClassName(dbconnection.getDriverClassName());
		dataSource.setUrl(dbconnection.getUrl());
		dataSource.setUsername(dbconnection.getUserName());
		dataSource.setPassword(dbconnection.getPassword());
		//加载公共配置项，从jdbc配置文件中读取
		//同application中jdbc连接池配置一致
		dataSource.setFilters(dbconnection.getFilters());
		dataSource.setMaxActive(dbconnection.getMaxActive());
		dataSource.setInitialSize(dbconnection.getInitialSize());
		dataSource.setMaxWait(dbconnection.getMaxWait());
		dataSource.setMinIdle(dbconnection.getMinIdle());
		dataSource.setTimeBetweenConnectErrorMillis(dbconnection.getTimeBetweenEvictionRunsMillis());
		dataSource.setMinEvictableIdleTimeMillis(dbconnection.getMinEvictableIdleTimeMillis());
		dataSource.setValidationQuery(dbconnection.getValidationQuery());
		dataSource.setTestWhileIdle(dbconnection.isTestWhileIdle());
		dataSource.setTestOnBorrow(dbconnection.isTestOnBorrow());
		dataSource.setTestOnReturn(dbconnection.isTestOnReturn());
		dataSource.setMaxOpenPreparedStatements(dbconnection.getMaxOpenPreparedStatements());
		return dataSource;
	}

}
