package com.chinamcloud.common.network;


import net.sf.json.JSONException;
import net.sf.json.JSONObject;
import org.apache.commons.httpclient.HttpClient;
import org.apache.commons.httpclient.HttpException;
import org.apache.commons.httpclient.HttpStatus;
import org.apache.commons.httpclient.methods.GetMethod;
import org.apache.commons.httpclient.methods.PostMethod;
import org.apache.commons.httpclient.params.HttpMethodParams;
import org.apache.http.HttpEntity;
import org.apache.http.NameValuePair;
import org.apache.http.client.ClientProtocolException;
import org.apache.http.client.entity.UrlEncodedFormEntity;
import org.apache.http.client.methods.CloseableHttpResponse;
import org.apache.http.client.methods.HttpPost;
import org.apache.http.impl.client.CloseableHttpClient;
import org.apache.http.impl.client.HttpClients;
import org.apache.http.message.BasicHeader;
import org.apache.http.util.EntityUtils;
import org.apache.log4j.Logger;

import java.io.BufferedInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.UnsupportedEncodingException;
import java.util.Iterator;
import java.util.List;
import java.util.Map;


public class HttpClientService {
	private static Logger logger = Logger.getLogger(HttpClientService.class);

	/**
	 * 通过HTTP POST方式发送JSON格式参数,日志记录发送过程及结果
	 * 
	 * @param paramJson
	 * @param url
	 * @return
	 * @throws JSONException
	 */
	@SuppressWarnings("rawtypes")
	public static String sendMessageByJSON_POST(JSONObject paramJson, String url) {
		logger.info("发送参数:" + paramJson);
		logger.info("发送地址:" + url);
		String result = "";
		HttpClient client = new HttpClient();
		PostMethod myPost = new PostMethod(url);
		try {
			myPost.getParams().setParameter(HttpMethodParams.HTTP_CONTENT_CHARSET, "utf-8");
			myPost.setContentChunked(true);
			// myPost.addRequestHeader("Accept", "text/plain");
			client.getParams().setSoTimeout(300 * 1000);
			myPost.setRequestHeader("Content-Type", "application/x-www-form-urlencoded;charset=UTF-8");
			// myPost.setRequestEntity(new StringRequestEntity(json, "text/xml",
			// "utf-8"));
			Iterator iterator = paramJson.keys();
			while (iterator.hasNext()) {
				String key = (String) iterator.next();
				String value = paramJson.getString(key);
				myPost.addParameter(key, value);
			}

			// myPost.addParameter(new NameValuePair("parameter", json));//
			// *****
			int statusCode = client.executeMethod(myPost);
			logger.info("报文发送状态值:" + statusCode);
			if (statusCode == HttpStatus.SC_OK) {// 200 OK
				BufferedInputStream bis = new BufferedInputStream(myPost.getResponseBodyAsStream());
				byte[] bytes = new byte[1024];
				ByteArrayOutputStream bos = new ByteArrayOutputStream();
				int count = 0;
				while ((count = bis.read(bytes)) != -1) {
					bos.write(bytes, 0, count);
				}
				byte[] strByte = bos.toByteArray();
				result = new String(strByte, 0, strByte.length, "utf-8");
				bos.close();
				bis.close();
				logger.info("返回结果:" + result);
			}

		} catch (Exception e) {
			logger.info("sendMessageByJSON Exception:" + e.getMessage());
			e.printStackTrace();
		} finally {
			myPost.releaseConnection();
		}
		return result;
	}

	/**
	 * 通过HTTP POST方式发送JSON格式参数,日志不记录发送过程及结果(针对于一些定时调用接口)
	 * 
	 * @param paramJson
	 * @param url
	 * @return
	 * @throws JSONException
	 */
	@SuppressWarnings("rawtypes")
	public static String sendMessageByJSON_POST_NOLOG(JSONObject paramJson, String url) {

		String result = "";
		HttpClient client = new HttpClient();
		PostMethod myPost = new PostMethod(url);
		try {
			myPost.getParams().setParameter(HttpMethodParams.HTTP_CONTENT_CHARSET, "utf-8");
			myPost.setContentChunked(true);
			// myPost.addRequestHeader("Accept", "text/plain");
			client.getParams().setSoTimeout(300 * 1000);
			myPost.setRequestHeader("Content-Type", "application/x-www-form-urlencoded;charset=UTF-8");
			// myPost.setRequestEntity(new StringRequestEntity(json, "text/xml",
			// "utf-8"));
			Iterator iterator = paramJson.keys();
			while (iterator.hasNext()) {
				String key = (String) iterator.next();
				String value = paramJson.getString(key);
				myPost.addParameter(key, value);
			}

			// myPost.addParameter(new NameValuePair("parameter", json));//
			// *****
			int statusCode = client.executeMethod(myPost);

			if (statusCode == HttpStatus.SC_OK) {// 200 OK
				BufferedInputStream bis = new BufferedInputStream(myPost.getResponseBodyAsStream());
				byte[] bytes = new byte[1024];
				ByteArrayOutputStream bos = new ByteArrayOutputStream();
				int count = 0;
				while ((count = bis.read(bytes)) != -1) {
					bos.write(bytes, 0, count);
				}
				byte[] strByte = bos.toByteArray();
				result = new String(strByte, 0, strByte.length, "utf-8");
				bos.close();
				bis.close();
			}

		} catch (Exception e) {
			logger.info("sendMessageByJSON Exception:" + e.getMessage());
			e.printStackTrace();
		} finally {
			myPost.releaseConnection();
		}
		return result;
	}

	/**
	 * 通过http GET 的方式发生请求
	 * 
	 * @param paramJson
	 *            请求参数
	 * @param url
	 *            请求地址
	 * @return
	 * @throws JSONException
	 * @throws Exception
	 */
	public static String sendMessageByJSON_GET(JSONObject paramJson, String url) {
		String result = "";
		// 此处可以在myGet上添加请求参数
		StringBuilder urlSb = new StringBuilder();
		urlSb.append(url).append("?");
		Iterator iterator = paramJson.keys();
		while (iterator.hasNext()) {
			String key = (String) iterator.next();
			String value = paramJson.getString(key);
			urlSb.append(key).append("=").append(value).append("&");
		}

		HttpClient httpClient = new HttpClient();
		// 创建GET方法的实例
		GetMethod myGet = new GetMethod(urlSb.toString());
		try {
			logger.info("发送方式:GET");
			logger.info("发送地址:" + urlSb.toString());
			myGet.getParams().setParameter(HttpMethodParams.HTTP_CONTENT_CHARSET, "utf-8");
			// 执行getMethod
			int statusCode = httpClient.executeMethod(myGet);
			logger.info("报文发送状态值:" + statusCode);

			if (statusCode == HttpStatus.SC_OK) {

				BufferedInputStream bis = new BufferedInputStream(myGet.getResponseBodyAsStream());
				byte[] bytes = new byte[1024];
				ByteArrayOutputStream bos = new ByteArrayOutputStream();
				int count = 0;
				while ((count = bis.read(bytes)) != -1) {
					bos.write(bytes, 0, count);
				}
				byte[] strByte = bos.toByteArray();
				result = new String(strByte, 0, strByte.length, "utf-8");
				bos.close();
				bis.close();
				logger.info("返回结果:" + result);
			} else {
				System.err.println("Method failed: " + myGet.getStatusLine());
			}

		} catch (HttpException e) {
			// 发生致命的异常，可能是协议不对或者返回的内容有问题
			System.out.println("Please check your provided http address!");
			e.printStackTrace();
		} catch (IOException e) {
			// 发生网络异常
			e.printStackTrace();
		} finally {
			// 释放连接
			myGet.releaseConnection();
		}
		return result;
	}

	/**
	 * http POST请求，不带请求头信息
	 * @param url url
	 * @param params 请求体
	 * @return
	 */
	public static String post(String url, List<NameValuePair> params) {
		String result = "";
		// 创建默认的httpClient实例.
		CloseableHttpClient httpclient = HttpClients.createDefault();
		// 创建httppost
		HttpPost httppost = new HttpPost(url);
		// 创建参数队列
		UrlEncodedFormEntity uefEntity;
		try {
			httppost.addHeader(new BasicHeader("Content-Type", "application/json"));
			uefEntity = new UrlEncodedFormEntity(params, "UTF-8");
			httppost.setEntity(uefEntity);
			System.out.println("executing request " + httppost.getURI());
			CloseableHttpResponse response = httpclient.execute(httppost);
			try {
				HttpEntity entity = response.getEntity();
				if (entity != null) {
					result = EntityUtils.toString(entity, "UTF-8");
				}
			} finally {
				response.close();
			}
		} catch (ClientProtocolException e) {
			e.printStackTrace();
		} catch (UnsupportedEncodingException e1) {
			e1.printStackTrace();
		} catch (IOException e) {
			e.printStackTrace();
		} finally {
			// 关闭连接,释放资源
			try {
				httpclient.close();
			} catch (IOException e) {
				e.printStackTrace();
			}
		}
		return result;
	}

	/**
	 * HTTP请求， 带有请求头信息
	 * @param url
	 * @param params 请求体
	 * @param headers 请求头
	 * @return
	 * @throws ClientProtocolException
	 * @throws IOException
	 */
	public static String post(String url, List<NameValuePair> params, Map<String, String> headers) throws ClientProtocolException, IOException {
		String result = "";
		// 创建默认的httpClient实例.
		CloseableHttpClient httpclient = HttpClients.createDefault();
		// 创建httppost
		HttpPost httppost = new HttpPost(url);
		// 创建参数队列
		UrlEncodedFormEntity uefEntity;
		try {
			httppost.addHeader(new BasicHeader("Content-Type", "Application/x-www-form-urlencoded"));
			if(headers != null){
				for (String key : headers.keySet()) {
					httppost.addHeader(new BasicHeader(key, headers.get(key)));
				}
			}
			uefEntity = new UrlEncodedFormEntity(params, "UTF-8");
			httppost.setEntity(uefEntity);
			System.out.println("executing request " + httppost.getURI());
			CloseableHttpResponse response = httpclient.execute(httppost);
			try {
				HttpEntity entity = response.getEntity();
				if (entity != null) {
					result = EntityUtils.toString(entity, "UTF-8");
				}
			} finally {
				response.close();
			}
		} catch (ClientProtocolException e) {
			e.printStackTrace();
		} catch (UnsupportedEncodingException e1) {
			e1.printStackTrace();
		} catch (IOException e) {
			e.printStackTrace();
		}  finally {
			// 关闭连接,释放资源
			try {
				httpclient.close();
			} catch (IOException e) {
				e.printStackTrace();
			}
		}
		return result;
	}
}
