package com.chinamcloud.common.service;

import com.chinamcloud.common.exception.SignCheckException;
import com.chinamcloud.common.util.MD5Util;
import com.chinamcloud.common.util.StringUtil;

import javax.servlet.http.HttpServletRequest;
import java.io.UnsupportedEncodingException;
import java.util.*;


public class ReqSignCheck {

    public static boolean check(HttpServletRequest request, String secret_key) throws SignCheckException {
        try {
            request.setCharacterEncoding("UTF-8");
        } catch (UnsupportedEncodingException e) {
            e.printStackTrace();
            throw new SignCheckException("设置request编码方式为UTF-8出现异常");
        }
        String authorization = request.getHeader("authorization");
        if (StringUtil.isEmpty(authorization)) {
            throw new SignCheckException("签名为空");
        }
        // 0  加密签名  1 时间戳
        String[] sign = authorization.split(";");
        if (2 != sign.length) {
            throw new SignCheckException("签名格式不正确");
        }

        Enumeration<String> enumeration = request.getParameterNames();
        Map<String, String> param = new HashMap<String, String>();
        String t;
        while (enumeration.hasMoreElements()) {
            t = enumeration.nextElement();
            param.put(t, request.getParameter(t));
        }
        List list = Arrays.asList(param.keySet().toArray());
        Collections.sort(list);
        StringBuilder sb = new StringBuilder();
        for (int i = 0; i < list.size(); i++) {
            sb.append(list.get(i) + param.get(list.get(i)));
        }
        //时间戳＋ 参数  ＋　密匙
        sb = new StringBuilder().append(sign[1]).append(sb).append(secret_key);
        System.out.println("签名加密前：" + sb.toString());
        String check = MD5Util.generateMD5(sb.toString());
        System.out.println("签名加密后：" + check);
        System.out.println("请求签名：" + sign[0]);

        if (!check.equals(sign[0])) {
            return false;
        }
        return true;

    }

}
