package com.chinamcloud.common.util;

import java.lang.reflect.Field;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.Date;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;

import net.sf.json.JSONException;
import net.sf.json.JSONObject;

import org.joda.time.DateTime;
/**
 * 处理实体与实体数据交换,该类提供的方法仅限实体类适用
 * 
 * @author Administrator
 * 
 */
public class DomainUtil {

	public static Map<String,String> domainMapping = new HashMap<String, String>();
	static{
		
	//	domainMapping.put(arg0, arg1);
		
		
		
	}
	
	
	public static Map<String, String> getParamsTypeMap(Object model) {
		HashMap<String, String> fieldHashMap = new HashMap<String, String>();
		try {
			Class cls = model.getClass();
			Field[] fieldlist = cls.getDeclaredFields();
			for (int i = 0; i < fieldlist.length; i++) {
				Field fld = fieldlist[i];
				fieldHashMap.put(fld.getName().toLowerCase(), fld.getType().toString());
			}
			Set set = fieldHashMap.entrySet();
			Iterator i = set.iterator();
			while (i.hasNext()) {
				Map.Entry<String, String> entry1 = (Map.Entry<String, String>) i.next();
				System.out.println(entry1.getKey());
				System.out.println(entry1.getValue());

			}
		} catch (Exception e) {
			e.printStackTrace();
		}

		return fieldHashMap;

	}
	
	
	/**
	 * 对已查询出的数据进行组装
	 * @param model 
	 * @param key 属性字段
	 * @param value 属性字段对应的值
	 * @param searchItems 搜索字段信息，用于高亮加成显示
	 */
	public static void setValue(Object model,String key,String value,List<String> itemList,List<String> valueList){
		Field[] field = model.getClass().getDeclaredFields(); // 获取实体类的所有属性，返回Field数组
        try {
            for (int j = 0; j < field.length; j++) { // 遍历所有属性
                String name = field[j].getName(); // 获取属性的名字
                if(!name.toLowerCase().equals(key.toLowerCase()))continue;
                name = name.substring(0, 1).toUpperCase() + name.substring(1); // 将属性的首字符大写，方便构造get，set方法
                String type = field[j].getGenericType().toString(); // 获取属性的类型
                setValues(model,name,key,type,value,itemList,valueList);
            }
        } catch (Exception e) {
            e.printStackTrace();
        } 
	}
	
	private static void setValues(Object tagetDomain, String name,String key, String type, String value,List<String> itemList,List<String> valueList) {
		try {
			Method m =null;
			if (type.equals("class java.lang.Byte")) {
				m = tagetDomain.getClass().getMethod("set" + name, Byte.class);
				m.invoke(tagetDomain, Byte.parseByte(value));
			} else if (type.equals("class java.lang.Short")) {
				m = tagetDomain.getClass().getMethod("set" + name, Short.class);
				m.invoke(tagetDomain, Short.parseShort(value));
			} else if (type.equals("class java.lang.Integer")) {
				m = tagetDomain.getClass().getMethod("set" + name, Integer.class);
				m.invoke(tagetDomain, Integer.parseInt(value));
			} else if (type.equals("class java.lang.Long")) {
				m = tagetDomain.getClass().getMethod("set" + name, Long.class);
				m.invoke(tagetDomain, Long.parseLong(value));
			} else if (type.equals("class java.lang.Float")) {
				m = tagetDomain.getClass().getMethod("set" + name, Float.class);
				m.invoke(tagetDomain, Float.parseFloat(value));
			} else if (type.equals("class java.lang.Double")) {
				m = tagetDomain.getClass().getMethod("set" + name, Double.class);
				m.invoke(tagetDomain, Double.parseDouble(value));
			} else if (type.equals("class java.lang.Boolean")) {
				m = tagetDomain.getClass().getMethod("set" + name, Boolean.class);
				m.invoke(tagetDomain, Boolean.parseBoolean(value));
			} else if (type.equals("class java.util.Date")) {
				m = tagetDomain.getClass().getMethod("set" + name, Date.class);
                Method m1 = tagetDomain.getClass().getMethod("set"+name+"Bak",String.class);
                m1.invoke(tagetDomain,value);
                m.invoke(tagetDomain,DateUtil.parseDateTime(value+""));
            
			}  else if (type.equals("class java.lang.String")){ // 如果type是类类型，则前面包含"class "，后面跟类名
            	if(itemList!=null&&valueList!=null){
            		if(itemList.contains(key)){
                		for(String str :valueList){
                 			if(value.indexOf(str)!=-1){
                 				value =value.replaceAll(str, "<embm>"+str+"</embm>");
                     		}
                 		}
                	}
            	}
            	  m = tagetDomain.getClass().getMethod("set"+name,String.class);
            	 if(StringUtil.isNotEmpty(value)){
            		 m.invoke(tagetDomain, value);
            	 }
            }
			// 如果有需要,可以仿照上面继续进行扩充,再增加对其它类型的判断
		}catch (NoSuchMethodException e) {
			e.printStackTrace();
		} catch (SecurityException e) {
			e.printStackTrace();
		} catch (IllegalAccessException e) {
			e.printStackTrace();
		} catch (IllegalArgumentException e) {
			e.printStackTrace();
		} catch (InvocationTargetException e) {
			e.printStackTrace();
		}catch (Exception e) {
			e.printStackTrace();
		}
	}
	
	
	/**
	 * 将实体属性值转换成Map对象
	 * 
	 * @param domain
	 * @return
	 */
	private static Map<String, Object> getValue(Object domain) {
		Map<String, Object> valueMap = new HashMap<String, Object>();
		try {
			// 获取实体自身属性字段
			Field[] field = domain.getClass().getDeclaredFields();
			// 获取实体继承父类实体字段
			Field[] superField = domain.getClass().getSuperclass().getDeclaredFields();
			try {
				for (int j = 0; j < field.length; j++) { // 遍历所有属性
					String name = field[j].getName(); // 获取属性的名字
					name = name.substring(0, 1).toUpperCase() + name.substring(1); // 将属性的首字符大写，方便构造get，set方法
					Method m = domain.getClass().getMethod("get" + name);
					valueMap.put(name.toLowerCase(), m.invoke(domain));
					// 如果有需要,可以仿照上面继续进行扩充,再增加对其它类型的判断
				}
				for (int j = 0; j < superField.length; j++) { // 遍历所有属性
					String name = superField[j].getName(); // 获取属性的名字
					name = name.substring(0, 1).toUpperCase() + name.substring(1); // 将属性的首字符大写，方便构造get，set方法
					Method m = domain.getClass().getMethod("get" + name);
					valueMap.put(name.toLowerCase(), m.invoke(domain));
					// 如果有需要,可以仿照上面继续进行扩充,再增加对其它类型的判断
				}
			} catch (NoSuchMethodException e) {
				e.printStackTrace();
			} catch (SecurityException e) {
				e.printStackTrace();
			} catch (IllegalAccessException e) {
				e.printStackTrace();
			} catch (IllegalArgumentException e) {
				e.printStackTrace();
			} catch (InvocationTargetException e) {
				e.printStackTrace();
			}

		} catch (Exception e) {
			e.printStackTrace();
		}

		return valueMap;
	}

	public static void setValueByJson(Object tagetDomain,JSONObject params) {
		Map<String, Object> valueMap = new HashMap<String, Object>();
		Iterator it = params.keys();
		try {
			while (it.hasNext()) {
				String sType = String.valueOf(it.next());
				valueMap.put(sType.toLowerCase(), params.get(sType));
			}
		} catch (JSONException e) {
			// TODO Auto-generated catch block
			e.printStackTrace();
		}
		setValueByMap(tagetDomain,valueMap);
	}

	public static void setValueByMap(Object tagetDomain, Map<String, Object> valueMap) {
		Field[] field = tagetDomain.getClass().getDeclaredFields(); // 获取实体类的所有属性，返回Field数组
		// 获取实体继承父类实体字段
		Field[] superField = tagetDomain.getClass().getSuperclass().getDeclaredFields();
		try {
			for (int j = 0; j < field.length; j++) { // 遍历所有属性
				String name = field[j].getName(); // 获取属性的名字
				Object value = valueMap.get(name.toLowerCase());
				if (value == null)
					continue;
				name = name.substring(0, 1).toUpperCase() + name.substring(1); // 将属性的首字符大写，方便构造get，set方法
				String type = field[j].getGenericType().toString(); // 获取属性的类型
				setValue(tagetDomain, name, type, value);
			}
			for (int j = 0; j < superField.length; j++) { // 遍历所有属性
				String name = superField[j].getName(); // 获取属性的名字
				Object value = valueMap.get(name.toLowerCase());
				if (value == null)
					continue;
				name = name.substring(0, 1).toUpperCase() + name.substring(1); // 将属性的首字符大写，方便构造get，set方法
				String type = superField[j].getGenericType().toString(); // 获取属性的类型
				setValue(tagetDomain, name, type, value);
			}
		} catch (SecurityException e) {
			e.printStackTrace();
		} catch (IllegalArgumentException e) {
			e.printStackTrace();
		}
	}

	private static void setValue(Object tagetDomain, String name, String type, Object value) {
		try {
			Method m = tagetDomain.getClass().getMethod("get" + name);
			if (type.equals("class java.lang.Byte")) {
				m = tagetDomain.getClass().getMethod("set" + name, Byte.class);
				m.invoke(tagetDomain, Byte.parseByte(value.toString()));
			} else if (type.equals("class java.lang.Short")) {
				m = tagetDomain.getClass().getMethod("set" + name, Short.class);
				m.invoke(tagetDomain, Short.parseShort(value.toString()));
			} else if (type.equals("class java.lang.Integer")) {
				m = tagetDomain.getClass().getMethod("set" + name, Integer.class);
				m.invoke(tagetDomain, Integer.parseInt(value.toString()));
			} else if (type.equals("class java.lang.Long")) {
				m = tagetDomain.getClass().getMethod("set" + name, Long.class);
				m.invoke(tagetDomain, Long.parseLong(value.toString()));
			} else if (type.equals("class java.lang.Float")) {
				m = tagetDomain.getClass().getMethod("set" + name, Float.class);
				m.invoke(tagetDomain, Float.parseFloat(value.toString()));
			} else if (type.equals("class java.lang.Double")) {
				m = tagetDomain.getClass().getMethod("set" + name, Double.class);
				m.invoke(tagetDomain, Double.parseDouble(value.toString()));
			} else if (type.equals("class java.lang.Boolean")) {
				m = tagetDomain.getClass().getMethod("set" + name, Boolean.class);
				m.invoke(tagetDomain, Boolean.parseBoolean(value.toString()));
			} else if (type.equals("class java.util.Date")) {
				m = tagetDomain.getClass().getMethod("set" + name, Date.class);
				m.invoke(tagetDomain, DateUtil.getDate(value));
			} else if (type.equals("class org.joda.time.DateTime")) {
				m = tagetDomain.getClass().getMethod("set" + name, DateTime.class);
				m.invoke(tagetDomain, DateUtil.getDateTime(value));
			} else {
				m = tagetDomain.getClass().getMethod("set" + name, String.class);
				m.invoke(tagetDomain, value.toString());
			}
			// 如果有需要,可以仿照上面继续进行扩充,再增加对其它类型的判断
		} catch (NoSuchMethodException e) {
			e.printStackTrace();
		} catch (SecurityException e) {
			e.printStackTrace();
		} catch (IllegalAccessException e) {
			e.printStackTrace();
		} catch (IllegalArgumentException e) {
			e.printStackTrace();
		} catch (InvocationTargetException e) {
			e.printStackTrace();
		}catch (Exception e) {
			e.printStackTrace();
		}
	}

	/**
	 * 将一个实体类数据复制到另外一个实体类中(要求对应字段必须吻合,不区分大小写),
	 * 属性字段类型目前仅支持:Byte,Short,Integer,Long
	 * ,Float,Double,Boolean,Date,DateTime,除此之外统一当做String类型处理
	 * 
	 * @param tagetDomain
	 * @param domain
	 */
	public static void setValueByDomain(Object tagetDomain, Object domain) {

		Map<String, Object> valueMap = getValue(domain);
		setValueByMap(tagetDomain, valueMap);

	}

	/**
	 * 将实体数据转换成JSON格式
	 * 
	 * @param domain
	 * @return
	 * @throws JSONException
	 */
	public static JSONObject domainToJsonObject(Object domain) throws JSONException {
		JSONObject item = new JSONObject();
		Field[] field = domain.getClass().getDeclaredFields(); // 获取实体类的所有属性，返回Field数组
		// 获取实体继承父类实体字段
		Field[] superField = domain.getClass().getSuperclass().getDeclaredFields();

		try {
			for (int j = 0; j < superField.length; j++) { // 遍历所有属性
				String value = "";
				String name = superField[j].getName(); // 获取属性的名字
				if("serialVersionUID".equals(name))continue;
				name = name.substring(0, 1).toUpperCase() + name.substring(1); // 将属性的首字符大写，方便构造get，set方法
				String type = superField[j].getGenericType().toString(); // 获取属性的类型
				Method m = domain.getClass().getMethod("get" + name);
				if (type.equals("class java.lang.Byte")) {
					if (m.invoke(domain) != null) {
						value = m.invoke(domain) + "";
					}
					item.put(name.toLowerCase(), value);
				} else if (type.equals("class java.lang.Short")) {
					if (m.invoke(domain) != null) {
						value = m.invoke(domain) + "";
					}
					item.put(name.toLowerCase(), value);
				} else if (type.equals("class java.lang.Integer")) {
					if (m.invoke(domain) != null) {
						value = m.invoke(domain) + "";
					}
					item.put(name.toLowerCase(), value);
				} else if (type.equals("class java.lang.Long")) {
					if (m.invoke(domain) != null) {
						value = m.invoke(domain) + "";
					}
					item.put(name.toLowerCase(), value);
				} else if (type.equals("class java.lang.Float")) {
					if (m.invoke(domain) != null) {
						value = m.invoke(domain) + "";
					}
					item.put(name.toLowerCase(), value);
				} else if (type.equals("class java.lang.Double")) {
					if (m.invoke(domain) != null) {
						value = m.invoke(domain) + "";
					}
					item.put(name.toLowerCase(), value);
				} else if (type.equals("class java.lang.Boolean")) {
					if (m.invoke(domain) != null) {
						value = m.invoke(domain) + "";
					}
					item.put(name.toLowerCase(), value);
				} else if (type.equals("class java.util.Date")) {
					Date date = DateUtil.getDate(m.invoke(domain));
					if (date != null) {
						value = DateUtil.toDateTimeString(date);
						item.put(name.toLowerCase(), value);
					}
				} else if (type.equals("class org.joda.time.DateTime")) {
					Date date = DateUtil.getDate(m.invoke(domain));
					if (date != null) {
						value = DateUtil.toDateTimeString(date);
						item.put(name.toLowerCase(), value);
					}
				} else if (type.equals("class java.lang.Object")) {
					if (m.invoke(domain) != null) {
						item.put(name.toLowerCase(), m.invoke(domain));
					} else {
						item.put(name.toLowerCase(), "");
					}

				} else {
					if (m.invoke(domain) != null) {
						value = m.invoke(domain) + "";
					}
					item.put(name.toLowerCase(), value);
				}

				// 如果有需要,可以仿照上面继续进行扩充,再增加对其它类型的判断
			}

			for (int j = 0; j < field.length; j++) { // 遍历所有属性
				String value = "";
				String name = field[j].getName(); // 获取属性的名字
				if("serialVersionUID".equals(name))continue;
				name = name.substring(0, 1).toUpperCase() + name.substring(1); // 将属性的首字符大写，方便构造get，set方法
				String type = field[j].getGenericType().toString(); // 获取属性的类型
				Method m = domain.getClass().getMethod("get" + name);
				if (type.equals("class java.lang.Byte")) {
					if (m.invoke(domain) != null) {
						value = m.invoke(domain) + "";
					}
					item.put(name.toLowerCase(), value);
				} else if (type.equals("class java.lang.Short")) {
					if (m.invoke(domain) != null) {
						value = m.invoke(domain) + "";
					}
					item.put(name.toLowerCase(), value);
				} else if (type.equals("class java.lang.Integer")) {
					if (m.invoke(domain) != null) {
						value = m.invoke(domain) + "";
					}
					item.put(name.toLowerCase(), value);
				} else if (type.equals("class java.lang.Long")) {
					if (m.invoke(domain) != null) {
						value = m.invoke(domain) + "";
					}
					item.put(name.toLowerCase(), value);
				} else if (type.equals("class java.lang.Float")) {
					if (m.invoke(domain) != null) {
						value = m.invoke(domain) + "";
					}
					item.put(name.toLowerCase(), value);
				} else if (type.equals("class java.lang.Double")) {
					if (m.invoke(domain) != null) {
						value = m.invoke(domain) + "";
					}
					item.put(name.toLowerCase(), value);
				} else if (type.equals("class java.lang.Boolean")) {
					if (m.invoke(domain) != null) {
						value = m.invoke(domain) + "";
					}
					item.put(name.toLowerCase(), value);
				} else if (type.equals("class java.util.Date")) {
					Date date = DateUtil.getDate(m.invoke(domain));
					if (date != null) {
						value = DateUtil.toDateTimeString(date);
						item.put(name.toLowerCase(), value);
					}
				} else if (type.equals("class org.joda.time.DateTime")) {
					Date date = DateUtil.getDate(m.invoke(domain));
					if (date != null) {
						value = DateUtil.toDateTimeString(date);
						item.put(name.toLowerCase(), value);
					}
				} else if (type.equals("class java.lang.Object")) {
					if (m.invoke(domain) != null) {
						item.put(name.toLowerCase(), m.invoke(domain));
					} else {
						item.put(name.toLowerCase(), "");
					}

				} else if (type.equals("class java.lang.String")) {
					if (m.invoke(domain) != null) {
						value = m.invoke(domain) + "";
					}
					item.put(name.toLowerCase(), value);
				} else {
					item.put(name.toLowerCase(), "");
				}

				// 如果有需要,可以仿照上面继续进行扩充,再增加对其它类型的判断
			}
		} catch (NoSuchMethodException e) {
			e.printStackTrace();
		} catch (SecurityException e) {
			e.printStackTrace();
		} catch (IllegalAccessException e) {
			e.printStackTrace();
		} catch (IllegalArgumentException e) {
			e.printStackTrace();
		} catch (InvocationTargetException e) {
			e.printStackTrace();
		}
		
		return item;
	}
	
	/**
	 * 将实体数据转换成JSON格式,不对属性字段做更改
	 * 
	 * @param domain
	 * @return
	 * @throws JSONException
	 */
	public static JSONObject domainToJsonObjectNoToLower(Object domain) throws JSONException {
		JSONObject item = new JSONObject();
		Field[] field = domain.getClass().getDeclaredFields(); // 获取实体类的所有属性，返回Field数组
		// 获取实体继承父类实体字段
		Field[] superField = domain.getClass().getSuperclass().getDeclaredFields();

		try {
			for (int j = 0; j < superField.length; j++) { // 遍历所有属性
				String value = "";
				String name = superField[j].getName(); // 获取属性的名字
				String name1 = superField[j].getName();
				if("serialVersionUID".equals(name))continue;
				name = name.substring(0, 1).toUpperCase() + name.substring(1); // 将属性的首字符大写，方便构造get，set方法
				String type = superField[j].getGenericType().toString(); // 获取属性的类型
				Method m = domain.getClass().getMethod("get" + name);
				if (type.equals("class java.lang.Byte")) {
					if (m.invoke(domain) != null) {
						value = m.invoke(domain) + "";
					}
					item.put(name1, value);
				} else if (type.equals("class java.lang.Short")) {
					if (m.invoke(domain) != null) {
						value = m.invoke(domain) + "";
					}
					item.put(name1, value);
				} else if (type.equals("class java.lang.Integer")) {
					if (m.invoke(domain) != null) {
						value = m.invoke(domain) + "";
					}
					item.put(name1, value);
				} else if (type.equals("class java.lang.Long")) {
					if (m.invoke(domain) != null) {
						value = m.invoke(domain) + "";
					}
					item.put(name1, value);
				} else if (type.equals("class java.lang.Float")) {
					if (m.invoke(domain) != null) {
						value = m.invoke(domain) + "";
					}
					item.put(name1, value);
				} else if (type.equals("class java.lang.Double")) {
					if (m.invoke(domain) != null) {
						value = m.invoke(domain) + "";
					}
					item.put(name1, value);
				} else if (type.equals("class java.lang.Boolean")) {
					if (m.invoke(domain) != null) {
						value = m.invoke(domain) + "";
					}
					item.put(name1, value);
				} else if (type.equals("class java.util.Date")) {
					Date date = DateUtil.getDate(m.invoke(domain));
					if (date != null) {
						value = DateUtil.toDateTimeString(date);
						item.put(name1, value);
					}
				} else if (type.equals("class org.joda.time.DateTime")) {
					Date date = DateUtil.getDate(m.invoke(domain));
					if (date != null) {
						value = DateUtil.toDateTimeString(date);
						item.put(name1, value);
					}
				} else if (type.equals("class java.lang.Object")) {
					if (m.invoke(domain) != null) {
						item.put(name1, m.invoke(domain));
					} else {
						item.put(name1, "");
					}

				} else {
					if (m.invoke(domain) != null) {
						value = m.invoke(domain) + "";
					}
					item.put(name1, value);
				}

				// 如果有需要,可以仿照上面继续进行扩充,再增加对其它类型的判断
			}

			for (int j = 0; j < field.length; j++) { // 遍历所有属性
				String value = "";
				String name = field[j].getName(); // 获取属性的名字
				String name1 = field[j].getName();
				if("serialVersionUID".equals(name))continue;
				name = name.substring(0, 1).toUpperCase() + name.substring(1); // 将属性的首字符大写，方便构造get，set方法
				String type = field[j].getGenericType().toString(); // 获取属性的类型
				Method m = domain.getClass().getMethod("get" + name);
				if (type.equals("class java.lang.Byte")) {
					if (m.invoke(domain) != null) {
						value = m.invoke(domain) + "";
					}
					item.put(name1, value);
				} else if (type.equals("class java.lang.Short")) {
					if (m.invoke(domain) != null) {
						value = m.invoke(domain) + "";
					}
					item.put(name1, value);
				} else if (type.equals("class java.lang.Integer")) {
					if (m.invoke(domain) != null) {
						value = m.invoke(domain) + "";
					}
					item.put(name1, value);
				} else if (type.equals("class java.lang.Long")) {
					if (m.invoke(domain) != null) {
						value = m.invoke(domain) + "";
					}
					item.put(name1, value);
				} else if (type.equals("class java.lang.Float")) {
					if (m.invoke(domain) != null) {
						value = m.invoke(domain) + "";
					}
					item.put(name1, value);
				} else if (type.equals("class java.lang.Double")) {
					if (m.invoke(domain) != null) {
						value = m.invoke(domain) + "";
					}
					item.put(name1, value);
				} else if (type.equals("class java.lang.Boolean")) {
					if (m.invoke(domain) != null) {
						value = m.invoke(domain) + "";
					}
					item.put(name1, value);
				} else if (type.equals("class java.util.Date")) {
					Date date = DateUtil.getDate(m.invoke(domain));
					if (date != null) {
						value = DateUtil.toDateTimeString(date);
						item.put(name1, value);
					}
				} else if (type.equals("class org.joda.time.DateTime")) {
					Date date = DateUtil.getDate(m.invoke(domain));
					if (date != null) {
						value = DateUtil.toDateTimeString(date);
						item.put(name1, value);
					}
				} else if (type.equals("class java.lang.Object")) {
					if (m.invoke(domain) != null) {
						item.put(name1, m.invoke(domain));
					} else {
						item.put(name1, "");
					}

				} else if (type.equals("class java.lang.String")) {
					if (m.invoke(domain) != null) {
						value = m.invoke(domain) + "";
					}
					item.put(name1, value);
				} else {
					item.put(name1, "");
				}

				// 如果有需要,可以仿照上面继续进行扩充,再增加对其它类型的判断
			}
		} catch (NoSuchMethodException e) {
			e.printStackTrace();
		} catch (SecurityException e) {
			e.printStackTrace();
		} catch (IllegalAccessException e) {
			e.printStackTrace();
		} catch (IllegalArgumentException e) {
			e.printStackTrace();
		} catch (InvocationTargetException e) {
			e.printStackTrace();
		}
		
		return item;
	}
	
	/**
	 * 获取实体类的属性字段及类型,属性名称会被转换为小写
	 * @return
	 */
	public static Map<String, String> getPropertsAndTypeByDomain(Object domain) {
		HashMap<String, String> fieldHashMap = new HashMap<String, String>();
		try {
			Field[] fieldlist = domain.getClass().getDeclaredFields(); // 获取实体类的所有属性，返回Field数组
			// 获取实体继承父类实体字段
			Field[] superField = domain.getClass().getSuperclass().getDeclaredFields();
			for (int i = 0; i < fieldlist.length; i++) {
				Field fld = fieldlist[i];
				fieldHashMap.put(fld.getName().toLowerCase(), fld.getType()
						.toString());
			}
			for (int i = 0; i < superField.length; i++) {
				Field fld = superField[i];
				fieldHashMap.put(fld.getName().toLowerCase(), fld.getType()
						.toString());
			}
		} catch (Exception e) {
			e.printStackTrace();
		}
		return fieldHashMap;
	}
	
	/**
	 * 根据属性名称获取该属性真实的值
	 * @return
	 */
	public static String getPropertNameByDomain(Object domain,String PropertName) {
		HashMap<String, String> fieldHashMap = new HashMap<String, String>();
		PropertName = PropertName.toLowerCase();
		String realPropertName =null;
		try {
			Field[] fieldlist = domain.getClass().getDeclaredFields(); // 获取实体类的所有属性，返回Field数组
			// 获取实体继承父类实体字段
			Field[] superField = domain.getClass().getSuperclass().getDeclaredFields();
			for (int i = 0; i < fieldlist.length; i++) {
				Field fld = fieldlist[i];
				if(fld.getName().toLowerCase().equals(PropertName)){
					realPropertName = fld.getName();
					throw new RuntimeException("属性已找到");
				}
			}
			for (int i = 0; i < superField.length; i++) {
				Field fld = superField[i];
				if(fld.getName().toLowerCase().equals(PropertName)){
					realPropertName = fld.getName();
					throw new RuntimeException("属性已找到");
				}
			}

		} catch (Exception e) {
			System.out.println(e.getMessage());
		}
		return realPropertName;
	}
	

}
