package com.chinamcloud.common.util;

import java.text.SimpleDateFormat;
import java.util.Calendar;
import java.util.Date;
import java.util.UUID;

import org.apache.commons.lang3.RandomStringUtils;

/**
 * @author huchaxu huchaxu@chinamcloud.com
 * @date 2015/7/31.
 */
public class StringUtil {

	/**
	 * UTF-8的三个字节的BOM
	 */
	public static final byte[] BOM = new byte[] { (byte) 239, (byte) 187, (byte) 191 };
    /**
     * 随机生成制定长度的字符串
     * @param length
     * @return
     */
    public static String randomString(int length){

        return RandomStringUtils.randomAlphanumeric(length);

    }

	/**
	 * 判断字符串是否为空
	 * @param str
	 * @return
	 */
	public static boolean isEmpty(String str){
    	return str == null || "".equals(str);
    }

	/**
	 * 判断字符串是否为非空
	 * @param str
	 * @return
	 */
	public static boolean isNotEmpty(String str){
    	return !isEmpty(str);
    }

    public static String strNullFormat(String str){
		if(str == null){
			return "";
		}else{
			return str.toString();
		}
	}
    
    public static Long longNullFormat(Long lo){
		if(lo == null){
			return 0l;
		}else{
			return lo;
		}
	}
    
    public static Integer intNullFormat(Integer in){
		if(in == null){
			return 0;
		}else{
			return in;
		}
	}
    
    public static boolean isNum(String str){
		return str.matches("^[-+]?(([0-9]+)([.]([0-9]+))?|([.]([0-9]+))?)$");
	}
    
    /**
     * 比較兩字符串的相識度
     * @param strA
     * @param strB
     * @return
     */
    public static double similarDegree(String strA, String strB){
    	return Similarity.SimilarDegree(strA, strB);
    }
    
    /**
     * 当天开始时间
     * @return
     */
    public static Long getStartTime(){  
        Calendar todayStart = Calendar.getInstance();  
        todayStart.set(Calendar.HOUR_OF_DAY, 0);  
        todayStart.set(Calendar.MINUTE, 0);  
        todayStart.set(Calendar.SECOND, 0);  
        todayStart.set(Calendar.MILLISECOND, 0);  
        return todayStart.getTimeInMillis();  
    }  
     
    /**
     * 当天结束时间
     * @return
     */
    public static Long getEndTime(){  
        Calendar todayEnd = Calendar.getInstance();  
        todayEnd.set(Calendar.HOUR_OF_DAY, 23);  
        todayEnd.set(Calendar.MINUTE, 59);  
        todayEnd.set(Calendar.SECOND, 59);  
        todayEnd.set(Calendar.MILLISECOND, 999);  
        return todayEnd.getTimeInMillis();  
    }
    
    public static String parseNumberToEn(String str) {
		String newStr = "";
		try {
			if (isNotEmpty(str)) {
				String chars = "abcdefghijklmnopqrstuvwxyz";
				for (int i = 0; i < str.length(); i++) {
					if ((str.charAt(i) <= 'Z' && str.charAt(i) >= 'A')
							|| (str.charAt(i) <= 'z' && str.charAt(i) >= 'a')) {
						newStr += str.charAt(i);
					} else {
						newStr += chars.charAt((int) (Math.random() * 26));

					}
				}
			}
		} catch (Exception e) {
			e.printStackTrace();
		}
		return newStr;

	}
    
    /**
	 * 检查字符串中是否全是英文
	 * @param str
	 * @return
	 */
	public static boolean hasAllZimu(String str) {
		Boolean flag = true;
		if (StringUtil.isNotEmpty(str)) {
			for (int i = 0; i < str.length(); i++) {
				if ((str.charAt(i) <= 'Z' && str.charAt(i) >= 'A')
						|| (str.charAt(i) <= 'z' && str.charAt(i) >= 'a')) {
				}else{
					flag = false;
					break;
				}
			}
		}
		return flag;
	}
	
	/**
	 * 将一个字符串中的指定片段全部替换，替换过程中不进行正则处理。<br>
	 * 使用String类的replaceAll时要求片段以正则表达式形式给出，有时较为不便，可以转为采用本方法。
	 */
	public static String replaceEx(String str, String subStr, String reStr) {
		if (str == null) {
			return null;
		}
		if (subStr == null || subStr.equals("") || subStr.length() > str.length() || reStr == null) {
			return str;
		}
		StringBuffer sb = new StringBuffer();
		String tmp = str;
		int index = -1;
		while (true) {
			index = tmp.indexOf(subStr);
			if (index < 0) {
				break;
			} else {
				sb.append(tmp.substring(0, index));
				sb.append(reStr);
				tmp = tmp.substring(index + subStr.length());
			}
		}
		sb.append(tmp);
		return sb.toString();
	}
	
	public static String dateFormat(Long time){
    	Date date = new Date(time);
    	SimpleDateFormat sdf = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");
    	return sdf.format(date);
    }    
	
	public static String toUtf8String(String s){
		StringBuffer sb = new StringBuffer();
		for (int i=0;i<s.length();i++){
			char c = s.charAt(i);
			if (c >= 0 && c <= 255){
				sb.append(c);
			}else{
				byte[] b;
				try {
					b = Character.toString(c).getBytes("utf-8");
				}catch (Exception ex) {
					System.out.println(ex);
					b = new byte[0];
				}
				for (int j = 0; j < b.length; j++) {
					int k = b[j];
					if (k < 0) k += 256;
					sb.append("%" + Integer.toHexString(k).toUpperCase());
				}
			}	
		}
		return sb.toString();
	}

	/**
	 * 获取32位的唯一uuid
	 * @return
	 */
	public static String getUUID(){
  		return UUID.randomUUID().toString().replace("-", "");
  	}
	/**
	 * 替换所有反斜杠
	 * @param str
	 * @return
	 */
	public static String  replaceAllToSlant(String str){
		if(isNotEmpty(str)){
			str=str.replaceAll("\\\\", "/");
			str=str.replaceAll("/+", "/");
		}
		return str;
		
	} 
	
	/**
	 * 替换所有斜杠
	 * @param str
	 * @return
	 */
	public static String  replaceAllToBack_Slant(String str){
		if(isNotEmpty(str)){
			str=str.replaceAll("/", "\\\\");
			str=str.replaceAll("\\\\+", "\\\\");
		}
		return str;
		
	} 
	
	
}
