/*
 * Decompiled with CFR 0.152.
 */
package com.chinamcloud.common.db;

import com.alibaba.druid.pool.DruidDataSource;
import com.chinamcloud.common.db.DBConnection;
import com.chinamcloud.common.db.DataSourceHolder;
import java.sql.SQLException;
import java.util.HashMap;
import java.util.Map;
import org.springframework.jdbc.datasource.lookup.AbstractRoutingDataSource;

public class RoutingDataSource
extends AbstractRoutingDataSource {
    public Map<Object, Object> _targetDataSources = new HashMap<Object, Object>();
    public Object _defaultTargetDataSource;

    public Map<Object, Object> get_targetDataSources() {
        return this._targetDataSources;
    }

    public void set_targetDataSources(Map<Object, Object> _targetDataSources) {
        this._targetDataSources = _targetDataSources;
    }

    public Object get_defaultTargetDataSource() {
        return this._defaultTargetDataSource;
    }

    public void set_defaultTargetDataSource(Object _defaultTargetDataSource) {
        this._defaultTargetDataSource = _defaultTargetDataSource;
    }

    protected Object determineCurrentLookupKey() {
        return DataSourceHolder.getDataSource();
    }

    public boolean createDataSource(String key, DBConnection dbconnection) {
        try {
            if (key.equals(DataSourceHolder.getDataSource())) {
                return false;
            }
            if (this.get_targetDataSources().keySet().contains(key)) {
                DataSourceHolder.setDataSource(key);
            } else {
                DruidDataSource dataSource = this.setDruidDataSource(dbconnection);
                this.get_targetDataSources().put(key, dataSource);
                this.setTargetDataSources(this._targetDataSources);
                this.afterPropertiesSet();
                DataSourceHolder.setDataSource(key);
            }
            return true;
        }
        catch (SQLException e) {
            e.printStackTrace();
            return false;
        }
    }

    public boolean createDataSource(String key, DruidDataSource dataSource) {
        if (key.equals(DataSourceHolder.getDataSource())) {
            return false;
        }
        if (this._targetDataSources.keySet().contains(key)) {
            DataSourceHolder.setDataSource(key);
        } else {
            this._targetDataSources.put(key, dataSource);
            this.setTargetDataSources(this._targetDataSources);
            this.afterPropertiesSet();
            DataSourceHolder.setDataSource(key);
        }
        return true;
    }

    public boolean DBConnPoolDefault(String key) {
        super.setDefaultTargetDataSource(this._defaultTargetDataSource);
        if (this.createDataSource(key, (DruidDataSource)this._defaultTargetDataSource)) {
            this._targetDataSources.put(key, this._defaultTargetDataSource);
            this.setTargetDataSources(this._targetDataSources);
            this.afterPropertiesSet();
            DataSourceHolder.setDataSource(key);
            return true;
        }
        return false;
    }

    public boolean checkDataSourse(String key) {
        return this._targetDataSources.keySet().contains(key);
    }

    private DruidDataSource setDruidDataSource(DBConnection dbconnection) throws SQLException, NullPointerException {
        if (dbconnection == null) {
            throw new NullPointerException("DBConnection\u5bf9\u8c61\u4e0d\u53ef\u4ee5\u4e3anull");
        }
        DruidDataSource dataSource = new DruidDataSource();
        dataSource.setDriverClassName(dbconnection.getDriverClassName());
        dataSource.setUrl(dbconnection.getUrl());
        dataSource.setUsername(dbconnection.getUserName());
        dataSource.setPassword(dbconnection.getPassword());
        dataSource.setFilters(dbconnection.getFilters());
        dataSource.setMaxActive(dbconnection.getMaxActive());
        dataSource.setInitialSize(dbconnection.getInitialSize());
        dataSource.setMaxWait(dbconnection.getMaxWait().longValue());
        dataSource.setMinIdle(dbconnection.getMinIdle());
        dataSource.setTimeBetweenConnectErrorMillis(dbconnection.getTimeBetweenEvictionRunsMillis().longValue());
        dataSource.setMinEvictableIdleTimeMillis(dbconnection.getMinEvictableIdleTimeMillis().longValue());
        dataSource.setValidationQuery(dbconnection.getValidationQuery());
        dataSource.setTestWhileIdle(dbconnection.isTestWhileIdle());
        dataSource.setTestOnBorrow(dbconnection.isTestOnBorrow());
        dataSource.setTestOnReturn(dbconnection.isTestOnReturn());
        dataSource.setMaxOpenPreparedStatements(dbconnection.getMaxOpenPreparedStatements());
        return dataSource;
    }
}

