/*
 * Decompiled with CFR 0.152.
 */
package com.chinamcloud.common.sensitive;

import com.chinamcloud.common.sensitive.SensitiveWordInit;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;

public class SensitivewordFilter {
    private static SensitivewordFilter sensitiveWordFilter;
    private static ConcurrentHashMap<Long, Map> sensitiveWordMap;
    public static int minMatchTYpe;
    public static int maxMatchType;

    private SensitivewordFilter(String wordPath) {
        sensitiveWordMap = SensitiveWordInit.getInstance().getSensitiveWordsMap(wordPath);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static SensitivewordFilter getInstance(String wordPath) {
        if (null != sensitiveWordFilter) return sensitiveWordFilter;
        Class<SensitivewordFilter> clazz = SensitivewordFilter.class;
        synchronized (SensitivewordFilter.class) {
            if (null != sensitiveWordFilter) return sensitiveWordFilter;
            sensitiveWordFilter = new SensitivewordFilter(wordPath);
            // ** MonitorExit[var1_1] (shouldn't be in output)
            return sensitiveWordFilter;
        }
    }

    public boolean isContaintSensitiveWord(String txt, int matchType) {
        Set<String> set = this.getSensitiveWord(txt, matchType);
        return set.size() != 0;
    }

    public Set<String> getSensitiveWord(String txt, int matchType) {
        HashSet<String> sensitiveWordList = new HashSet<String>();
        if (sensitiveWordMap.size() != 0) {
            sensitiveWordList.addAll(this.getSensitiveWordByMap(sensitiveWordMap, txt, matchType));
        }
        return sensitiveWordList;
    }

    private Set<String> getSensitiveWordByMap(Map map, String txt, int matchType) {
        HashSet<String> sensitiveWordList = new HashSet<String>();
        for (int i = 0; i < txt.length(); ++i) {
            int length = this.CheckSensitiveWord(map, txt, i, matchType);
            if (length <= 0) continue;
            sensitiveWordList.add(txt.substring(i, i + length));
            i = i + length - 1;
        }
        return sensitiveWordList;
    }

    public String replaceSensitiveWord(String txt, int matchType, String replaceChar) {
        String resultTxt = txt;
        Set<String> set = this.getSensitiveWord(txt, matchType);
        System.out.println(set.size());
        Iterator<String> iterator = set.iterator();
        String word = null;
        String replaceString = null;
        while (iterator.hasNext()) {
            word = iterator.next();
            replaceString = this.getReplaceChars(replaceChar, word.length());
            resultTxt = resultTxt.replaceAll(word, replaceString);
        }
        return resultTxt;
    }

    private String getReplaceChars(String replaceChar, int length) {
        String resultReplace = replaceChar;
        for (int i = 1; i < length; ++i) {
            resultReplace = resultReplace + replaceChar;
        }
        return resultReplace;
    }

    public int CheckSensitiveWord(Map checkMap, String txt, int beginIndex, int matchType) {
        boolean flag = false;
        int matchFlag = 0;
        char word = '\u0000';
        Map nowMap = checkMap;
        for (int i = beginIndex; i < txt.length() && (nowMap = (Map)nowMap.get(Character.valueOf(word = txt.charAt(i)))) != null; ++i) {
            ++matchFlag;
            if (!"1".equals(nowMap.get("isEnd"))) continue;
            flag = true;
            if (minMatchTYpe == matchType) break;
        }
        if (matchFlag < 2 || !flag) {
            matchFlag = 0;
        }
        return matchFlag;
    }

    static {
        sensitiveWordMap = null;
        minMatchTYpe = 1;
        maxMatchType = 2;
    }
}

