/*
 * Decompiled with CFR 0.152.
 */
package com.chinamcloud.common.util;

import com.chinamcloud.common.util.DateUtil;
import com.chinamcloud.common.util.StringUtil;
import java.lang.reflect.Field;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.Date;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import net.sf.json.JSONException;
import net.sf.json.JSONObject;
import org.joda.time.DateTime;

public class DomainUtil {
    public static Map<String, String> domainMapping = new HashMap<String, String>();

    public static Map<String, String> getParamsTypeMap(Object model) {
        HashMap<String, String> fieldHashMap = new HashMap<String, String>();
        try {
            Class<?> cls = model.getClass();
            Field[] fieldlist = cls.getDeclaredFields();
            for (int i = 0; i < fieldlist.length; ++i) {
                Field fld = fieldlist[i];
                fieldHashMap.put(fld.getName().toLowerCase(), fld.getType().toString());
            }
            Set<Map.Entry<String, String>> set = fieldHashMap.entrySet();
            for (Map.Entry<String, String> entry1 : set) {
                System.out.println(entry1.getKey());
                System.out.println(entry1.getValue());
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return fieldHashMap;
    }

    public static void setValue(Object model, String key, String value, List<String> itemList, List<String> valueList) {
        Field[] field = model.getClass().getDeclaredFields();
        try {
            for (int j = 0; j < field.length; ++j) {
                String name = field[j].getName();
                if (!name.toLowerCase().equals(key.toLowerCase())) continue;
                name = name.substring(0, 1).toUpperCase() + name.substring(1);
                String type = field[j].getGenericType().toString();
                DomainUtil.setValues(model, name, key, type, value, itemList, valueList);
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    private static void setValues(Object tagetDomain, String name, String key, String type, String value, List<String> itemList, List<String> valueList) {
        try {
            Method m = null;
            if (type.equals("class java.lang.Byte")) {
                m = tagetDomain.getClass().getMethod("set" + name, Byte.class);
                m.invoke(tagetDomain, Byte.parseByte(value));
            } else if (type.equals("class java.lang.Short")) {
                m = tagetDomain.getClass().getMethod("set" + name, Short.class);
                m.invoke(tagetDomain, Short.parseShort(value));
            } else if (type.equals("class java.lang.Integer")) {
                m = tagetDomain.getClass().getMethod("set" + name, Integer.class);
                m.invoke(tagetDomain, Integer.parseInt(value));
            } else if (type.equals("class java.lang.Long")) {
                m = tagetDomain.getClass().getMethod("set" + name, Long.class);
                m.invoke(tagetDomain, Long.parseLong(value));
            } else if (type.equals("class java.lang.Float")) {
                m = tagetDomain.getClass().getMethod("set" + name, Float.class);
                m.invoke(tagetDomain, Float.valueOf(Float.parseFloat(value)));
            } else if (type.equals("class java.lang.Double")) {
                m = tagetDomain.getClass().getMethod("set" + name, Double.class);
                m.invoke(tagetDomain, Double.parseDouble(value));
            } else if (type.equals("class java.lang.Boolean")) {
                m = tagetDomain.getClass().getMethod("set" + name, Boolean.class);
                m.invoke(tagetDomain, Boolean.parseBoolean(value));
            } else if (type.equals("class java.util.Date")) {
                m = tagetDomain.getClass().getMethod("set" + name, Date.class);
                Method m1 = tagetDomain.getClass().getMethod("set" + name + "Bak", String.class);
                m1.invoke(tagetDomain, value);
                m.invoke(tagetDomain, DateUtil.parseDateTime(value + ""));
            } else if (type.equals("class java.lang.String")) {
                if (itemList != null && valueList != null && itemList.contains(key)) {
                    for (String str : valueList) {
                        if (value.indexOf(str) == -1) continue;
                        value = value.replaceAll(str, "<embm>" + str + "</embm>");
                    }
                }
                m = tagetDomain.getClass().getMethod("set" + name, String.class);
                if (StringUtil.isNotEmpty(value)) {
                    m.invoke(tagetDomain, value);
                }
            }
        }
        catch (NoSuchMethodException e) {
            e.printStackTrace();
        }
        catch (SecurityException e) {
            e.printStackTrace();
        }
        catch (IllegalAccessException e) {
            e.printStackTrace();
        }
        catch (IllegalArgumentException e) {
            e.printStackTrace();
        }
        catch (InvocationTargetException e) {
            e.printStackTrace();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    private static Map<String, Object> getValue(Object domain) {
        HashMap<String, Object> valueMap = new HashMap<String, Object>();
        try {
            Field[] field = domain.getClass().getDeclaredFields();
            Field[] superField = domain.getClass().getSuperclass().getDeclaredFields();
            try {
                Method m;
                String name;
                int j;
                for (j = 0; j < field.length; ++j) {
                    name = field[j].getName();
                    name = name.substring(0, 1).toUpperCase() + name.substring(1);
                    m = domain.getClass().getMethod("get" + name, new Class[0]);
                    valueMap.put(name.toLowerCase(), m.invoke(domain, new Object[0]));
                }
                for (j = 0; j < superField.length; ++j) {
                    name = superField[j].getName();
                    name = name.substring(0, 1).toUpperCase() + name.substring(1);
                    m = domain.getClass().getMethod("get" + name, new Class[0]);
                    valueMap.put(name.toLowerCase(), m.invoke(domain, new Object[0]));
                }
            }
            catch (NoSuchMethodException e) {
                e.printStackTrace();
            }
            catch (SecurityException e) {
                e.printStackTrace();
            }
            catch (IllegalAccessException e) {
                e.printStackTrace();
            }
            catch (IllegalArgumentException e) {
                e.printStackTrace();
            }
            catch (InvocationTargetException e) {
                e.printStackTrace();
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return valueMap;
    }

    public static void setValueByJson(Object tagetDomain, JSONObject params) {
        HashMap<String, Object> valueMap = new HashMap<String, Object>();
        Iterator it = params.keys();
        try {
            while (it.hasNext()) {
                String sType = String.valueOf(it.next());
                valueMap.put(sType.toLowerCase(), params.get(sType));
            }
        }
        catch (JSONException e) {
            e.printStackTrace();
        }
        DomainUtil.setValueByMap(tagetDomain, valueMap);
    }

    public static void setValueByMap(Object tagetDomain, Map<String, Object> valueMap) {
        Field[] field = tagetDomain.getClass().getDeclaredFields();
        Field[] superField = tagetDomain.getClass().getSuperclass().getDeclaredFields();
        try {
            String type;
            Object value;
            String name;
            int j;
            for (j = 0; j < field.length; ++j) {
                name = field[j].getName();
                value = valueMap.get(name.toLowerCase());
                if (value == null) continue;
                name = name.substring(0, 1).toUpperCase() + name.substring(1);
                type = field[j].getGenericType().toString();
                DomainUtil.setValue(tagetDomain, name, type, value);
            }
            for (j = 0; j < superField.length; ++j) {
                name = superField[j].getName();
                value = valueMap.get(name.toLowerCase());
                if (value == null) continue;
                name = name.substring(0, 1).toUpperCase() + name.substring(1);
                type = superField[j].getGenericType().toString();
                DomainUtil.setValue(tagetDomain, name, type, value);
            }
        }
        catch (SecurityException e) {
            e.printStackTrace();
        }
        catch (IllegalArgumentException e) {
            e.printStackTrace();
        }
    }

    private static void setValue(Object tagetDomain, String name, String type, Object value) {
        try {
            Method m = tagetDomain.getClass().getMethod("get" + name, new Class[0]);
            if (type.equals("class java.lang.Byte")) {
                m = tagetDomain.getClass().getMethod("set" + name, Byte.class);
                m.invoke(tagetDomain, Byte.parseByte(value.toString()));
            } else if (type.equals("class java.lang.Short")) {
                m = tagetDomain.getClass().getMethod("set" + name, Short.class);
                m.invoke(tagetDomain, Short.parseShort(value.toString()));
            } else if (type.equals("class java.lang.Integer")) {
                m = tagetDomain.getClass().getMethod("set" + name, Integer.class);
                m.invoke(tagetDomain, Integer.parseInt(value.toString()));
            } else if (type.equals("class java.lang.Long")) {
                m = tagetDomain.getClass().getMethod("set" + name, Long.class);
                m.invoke(tagetDomain, Long.parseLong(value.toString()));
            } else if (type.equals("class java.lang.Float")) {
                m = tagetDomain.getClass().getMethod("set" + name, Float.class);
                m.invoke(tagetDomain, Float.valueOf(Float.parseFloat(value.toString())));
            } else if (type.equals("class java.lang.Double")) {
                m = tagetDomain.getClass().getMethod("set" + name, Double.class);
                m.invoke(tagetDomain, Double.parseDouble(value.toString()));
            } else if (type.equals("class java.lang.Boolean")) {
                m = tagetDomain.getClass().getMethod("set" + name, Boolean.class);
                m.invoke(tagetDomain, Boolean.parseBoolean(value.toString()));
            } else if (type.equals("class java.util.Date")) {
                m = tagetDomain.getClass().getMethod("set" + name, Date.class);
                m.invoke(tagetDomain, DateUtil.getDate(value));
            } else if (type.equals("class org.joda.time.DateTime")) {
                m = tagetDomain.getClass().getMethod("set" + name, DateTime.class);
                m.invoke(tagetDomain, DateUtil.getDateTime(value));
            } else {
                m = tagetDomain.getClass().getMethod("set" + name, String.class);
                m.invoke(tagetDomain, value.toString());
            }
        }
        catch (NoSuchMethodException e) {
            e.printStackTrace();
        }
        catch (SecurityException e) {
            e.printStackTrace();
        }
        catch (IllegalAccessException e) {
            e.printStackTrace();
        }
        catch (IllegalArgumentException e) {
            e.printStackTrace();
        }
        catch (InvocationTargetException e) {
            e.printStackTrace();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public static void setValueByDomain(Object tagetDomain, Object domain) {
        Map<String, Object> valueMap = DomainUtil.getValue(domain);
        DomainUtil.setValueByMap(tagetDomain, valueMap);
    }

    public static JSONObject domainToJsonObject(Object domain) throws JSONException {
        JSONObject item = new JSONObject();
        Field[] field = domain.getClass().getDeclaredFields();
        Field[] superField = domain.getClass().getSuperclass().getDeclaredFields();
        try {
            Date date;
            Method m;
            String type;
            String name;
            String value;
            int j;
            for (j = 0; j < superField.length; ++j) {
                value = "";
                name = superField[j].getName();
                if ("serialVersionUID".equals(name)) continue;
                name = name.substring(0, 1).toUpperCase() + name.substring(1);
                type = superField[j].getGenericType().toString();
                m = domain.getClass().getMethod("get" + name, new Class[0]);
                if (type.equals("class java.lang.Byte")) {
                    if (m.invoke(domain, new Object[0]) != null) {
                        value = m.invoke(domain, new Object[0]) + "";
                    }
                    item.put((Object)name.toLowerCase(), (Object)value);
                    continue;
                }
                if (type.equals("class java.lang.Short")) {
                    if (m.invoke(domain, new Object[0]) != null) {
                        value = m.invoke(domain, new Object[0]) + "";
                    }
                    item.put((Object)name.toLowerCase(), (Object)value);
                    continue;
                }
                if (type.equals("class java.lang.Integer")) {
                    if (m.invoke(domain, new Object[0]) != null) {
                        value = m.invoke(domain, new Object[0]) + "";
                    }
                    item.put((Object)name.toLowerCase(), (Object)value);
                    continue;
                }
                if (type.equals("class java.lang.Long")) {
                    if (m.invoke(domain, new Object[0]) != null) {
                        value = m.invoke(domain, new Object[0]) + "";
                    }
                    item.put((Object)name.toLowerCase(), (Object)value);
                    continue;
                }
                if (type.equals("class java.lang.Float")) {
                    if (m.invoke(domain, new Object[0]) != null) {
                        value = m.invoke(domain, new Object[0]) + "";
                    }
                    item.put((Object)name.toLowerCase(), (Object)value);
                    continue;
                }
                if (type.equals("class java.lang.Double")) {
                    if (m.invoke(domain, new Object[0]) != null) {
                        value = m.invoke(domain, new Object[0]) + "";
                    }
                    item.put((Object)name.toLowerCase(), (Object)value);
                    continue;
                }
                if (type.equals("class java.lang.Boolean")) {
                    if (m.invoke(domain, new Object[0]) != null) {
                        value = m.invoke(domain, new Object[0]) + "";
                    }
                    item.put((Object)name.toLowerCase(), (Object)value);
                    continue;
                }
                if (type.equals("class java.util.Date")) {
                    date = DateUtil.getDate(m.invoke(domain, new Object[0]));
                    if (date == null) continue;
                    value = DateUtil.toDateTimeString(date);
                    item.put((Object)name.toLowerCase(), (Object)value);
                    continue;
                }
                if (type.equals("class org.joda.time.DateTime")) {
                    date = DateUtil.getDate(m.invoke(domain, new Object[0]));
                    if (date == null) continue;
                    value = DateUtil.toDateTimeString(date);
                    item.put((Object)name.toLowerCase(), (Object)value);
                    continue;
                }
                if (type.equals("class java.lang.Object")) {
                    if (m.invoke(domain, new Object[0]) != null) {
                        item.put((Object)name.toLowerCase(), m.invoke(domain, new Object[0]));
                        continue;
                    }
                    item.put((Object)name.toLowerCase(), (Object)"");
                    continue;
                }
                if (m.invoke(domain, new Object[0]) != null) {
                    value = m.invoke(domain, new Object[0]) + "";
                }
                item.put((Object)name.toLowerCase(), (Object)value);
            }
            for (j = 0; j < field.length; ++j) {
                value = "";
                name = field[j].getName();
                if ("serialVersionUID".equals(name)) continue;
                name = name.substring(0, 1).toUpperCase() + name.substring(1);
                type = field[j].getGenericType().toString();
                m = domain.getClass().getMethod("get" + name, new Class[0]);
                if (type.equals("class java.lang.Byte")) {
                    if (m.invoke(domain, new Object[0]) != null) {
                        value = m.invoke(domain, new Object[0]) + "";
                    }
                    item.put((Object)name.toLowerCase(), (Object)value);
                    continue;
                }
                if (type.equals("class java.lang.Short")) {
                    if (m.invoke(domain, new Object[0]) != null) {
                        value = m.invoke(domain, new Object[0]) + "";
                    }
                    item.put((Object)name.toLowerCase(), (Object)value);
                    continue;
                }
                if (type.equals("class java.lang.Integer")) {
                    if (m.invoke(domain, new Object[0]) != null) {
                        value = m.invoke(domain, new Object[0]) + "";
                    }
                    item.put((Object)name.toLowerCase(), (Object)value);
                    continue;
                }
                if (type.equals("class java.lang.Long")) {
                    if (m.invoke(domain, new Object[0]) != null) {
                        value = m.invoke(domain, new Object[0]) + "";
                    }
                    item.put((Object)name.toLowerCase(), (Object)value);
                    continue;
                }
                if (type.equals("class java.lang.Float")) {
                    if (m.invoke(domain, new Object[0]) != null) {
                        value = m.invoke(domain, new Object[0]) + "";
                    }
                    item.put((Object)name.toLowerCase(), (Object)value);
                    continue;
                }
                if (type.equals("class java.lang.Double")) {
                    if (m.invoke(domain, new Object[0]) != null) {
                        value = m.invoke(domain, new Object[0]) + "";
                    }
                    item.put((Object)name.toLowerCase(), (Object)value);
                    continue;
                }
                if (type.equals("class java.lang.Boolean")) {
                    if (m.invoke(domain, new Object[0]) != null) {
                        value = m.invoke(domain, new Object[0]) + "";
                    }
                    item.put((Object)name.toLowerCase(), (Object)value);
                    continue;
                }
                if (type.equals("class java.util.Date")) {
                    date = DateUtil.getDate(m.invoke(domain, new Object[0]));
                    if (date == null) continue;
                    value = DateUtil.toDateTimeString(date);
                    item.put((Object)name.toLowerCase(), (Object)value);
                    continue;
                }
                if (type.equals("class org.joda.time.DateTime")) {
                    date = DateUtil.getDate(m.invoke(domain, new Object[0]));
                    if (date == null) continue;
                    value = DateUtil.toDateTimeString(date);
                    item.put((Object)name.toLowerCase(), (Object)value);
                    continue;
                }
                if (type.equals("class java.lang.Object")) {
                    if (m.invoke(domain, new Object[0]) != null) {
                        item.put((Object)name.toLowerCase(), m.invoke(domain, new Object[0]));
                        continue;
                    }
                    item.put((Object)name.toLowerCase(), (Object)"");
                    continue;
                }
                if (type.equals("class java.lang.String")) {
                    if (m.invoke(domain, new Object[0]) != null) {
                        value = m.invoke(domain, new Object[0]) + "";
                    }
                    item.put((Object)name.toLowerCase(), (Object)value);
                    continue;
                }
                item.put((Object)name.toLowerCase(), (Object)"");
            }
        }
        catch (NoSuchMethodException e) {
            e.printStackTrace();
        }
        catch (SecurityException e) {
            e.printStackTrace();
        }
        catch (IllegalAccessException e) {
            e.printStackTrace();
        }
        catch (IllegalArgumentException e) {
            e.printStackTrace();
        }
        catch (InvocationTargetException e) {
            e.printStackTrace();
        }
        return item;
    }

    public static JSONObject domainToJsonObjectNoToLower(Object domain) throws JSONException {
        JSONObject item = new JSONObject();
        Field[] field = domain.getClass().getDeclaredFields();
        Field[] superField = domain.getClass().getSuperclass().getDeclaredFields();
        try {
            Date date;
            Method m;
            String type;
            String name1;
            String name;
            String value;
            int j;
            for (j = 0; j < superField.length; ++j) {
                value = "";
                name = superField[j].getName();
                name1 = superField[j].getName();
                if ("serialVersionUID".equals(name)) continue;
                name = name.substring(0, 1).toUpperCase() + name.substring(1);
                type = superField[j].getGenericType().toString();
                m = domain.getClass().getMethod("get" + name, new Class[0]);
                if (type.equals("class java.lang.Byte")) {
                    if (m.invoke(domain, new Object[0]) != null) {
                        value = m.invoke(domain, new Object[0]) + "";
                    }
                    item.put((Object)name1, (Object)value);
                    continue;
                }
                if (type.equals("class java.lang.Short")) {
                    if (m.invoke(domain, new Object[0]) != null) {
                        value = m.invoke(domain, new Object[0]) + "";
                    }
                    item.put((Object)name1, (Object)value);
                    continue;
                }
                if (type.equals("class java.lang.Integer")) {
                    if (m.invoke(domain, new Object[0]) != null) {
                        value = m.invoke(domain, new Object[0]) + "";
                    }
                    item.put((Object)name1, (Object)value);
                    continue;
                }
                if (type.equals("class java.lang.Long")) {
                    if (m.invoke(domain, new Object[0]) != null) {
                        value = m.invoke(domain, new Object[0]) + "";
                    }
                    item.put((Object)name1, (Object)value);
                    continue;
                }
                if (type.equals("class java.lang.Float")) {
                    if (m.invoke(domain, new Object[0]) != null) {
                        value = m.invoke(domain, new Object[0]) + "";
                    }
                    item.put((Object)name1, (Object)value);
                    continue;
                }
                if (type.equals("class java.lang.Double")) {
                    if (m.invoke(domain, new Object[0]) != null) {
                        value = m.invoke(domain, new Object[0]) + "";
                    }
                    item.put((Object)name1, (Object)value);
                    continue;
                }
                if (type.equals("class java.lang.Boolean")) {
                    if (m.invoke(domain, new Object[0]) != null) {
                        value = m.invoke(domain, new Object[0]) + "";
                    }
                    item.put((Object)name1, (Object)value);
                    continue;
                }
                if (type.equals("class java.util.Date")) {
                    date = DateUtil.getDate(m.invoke(domain, new Object[0]));
                    if (date == null) continue;
                    value = DateUtil.toDateTimeString(date);
                    item.put((Object)name1, (Object)value);
                    continue;
                }
                if (type.equals("class org.joda.time.DateTime")) {
                    date = DateUtil.getDate(m.invoke(domain, new Object[0]));
                    if (date == null) continue;
                    value = DateUtil.toDateTimeString(date);
                    item.put((Object)name1, (Object)value);
                    continue;
                }
                if (type.equals("class java.lang.Object")) {
                    if (m.invoke(domain, new Object[0]) != null) {
                        item.put((Object)name1, m.invoke(domain, new Object[0]));
                        continue;
                    }
                    item.put((Object)name1, (Object)"");
                    continue;
                }
                if (m.invoke(domain, new Object[0]) != null) {
                    value = m.invoke(domain, new Object[0]) + "";
                }
                item.put((Object)name1, (Object)value);
            }
            for (j = 0; j < field.length; ++j) {
                value = "";
                name = field[j].getName();
                name1 = field[j].getName();
                if ("serialVersionUID".equals(name)) continue;
                name = name.substring(0, 1).toUpperCase() + name.substring(1);
                type = field[j].getGenericType().toString();
                m = domain.getClass().getMethod("get" + name, new Class[0]);
                if (type.equals("class java.lang.Byte")) {
                    if (m.invoke(domain, new Object[0]) != null) {
                        value = m.invoke(domain, new Object[0]) + "";
                    }
                    item.put((Object)name1, (Object)value);
                    continue;
                }
                if (type.equals("class java.lang.Short")) {
                    if (m.invoke(domain, new Object[0]) != null) {
                        value = m.invoke(domain, new Object[0]) + "";
                    }
                    item.put((Object)name1, (Object)value);
                    continue;
                }
                if (type.equals("class java.lang.Integer")) {
                    if (m.invoke(domain, new Object[0]) != null) {
                        value = m.invoke(domain, new Object[0]) + "";
                    }
                    item.put((Object)name1, (Object)value);
                    continue;
                }
                if (type.equals("class java.lang.Long")) {
                    if (m.invoke(domain, new Object[0]) != null) {
                        value = m.invoke(domain, new Object[0]) + "";
                    }
                    item.put((Object)name1, (Object)value);
                    continue;
                }
                if (type.equals("class java.lang.Float")) {
                    if (m.invoke(domain, new Object[0]) != null) {
                        value = m.invoke(domain, new Object[0]) + "";
                    }
                    item.put((Object)name1, (Object)value);
                    continue;
                }
                if (type.equals("class java.lang.Double")) {
                    if (m.invoke(domain, new Object[0]) != null) {
                        value = m.invoke(domain, new Object[0]) + "";
                    }
                    item.put((Object)name1, (Object)value);
                    continue;
                }
                if (type.equals("class java.lang.Boolean")) {
                    if (m.invoke(domain, new Object[0]) != null) {
                        value = m.invoke(domain, new Object[0]) + "";
                    }
                    item.put((Object)name1, (Object)value);
                    continue;
                }
                if (type.equals("class java.util.Date")) {
                    date = DateUtil.getDate(m.invoke(domain, new Object[0]));
                    if (date == null) continue;
                    value = DateUtil.toDateTimeString(date);
                    item.put((Object)name1, (Object)value);
                    continue;
                }
                if (type.equals("class org.joda.time.DateTime")) {
                    date = DateUtil.getDate(m.invoke(domain, new Object[0]));
                    if (date == null) continue;
                    value = DateUtil.toDateTimeString(date);
                    item.put((Object)name1, (Object)value);
                    continue;
                }
                if (type.equals("class java.lang.Object")) {
                    if (m.invoke(domain, new Object[0]) != null) {
                        item.put((Object)name1, m.invoke(domain, new Object[0]));
                        continue;
                    }
                    item.put((Object)name1, (Object)"");
                    continue;
                }
                if (type.equals("class java.lang.String")) {
                    if (m.invoke(domain, new Object[0]) != null) {
                        value = m.invoke(domain, new Object[0]) + "";
                    }
                    item.put((Object)name1, (Object)value);
                    continue;
                }
                item.put((Object)name1, (Object)"");
            }
        }
        catch (NoSuchMethodException e) {
            e.printStackTrace();
        }
        catch (SecurityException e) {
            e.printStackTrace();
        }
        catch (IllegalAccessException e) {
            e.printStackTrace();
        }
        catch (IllegalArgumentException e) {
            e.printStackTrace();
        }
        catch (InvocationTargetException e) {
            e.printStackTrace();
        }
        return item;
    }

    public static Map<String, String> getPropertsAndTypeByDomain(Object domain) {
        HashMap<String, String> fieldHashMap = new HashMap<String, String>();
        try {
            Field fld;
            int i;
            Field[] fieldlist = domain.getClass().getDeclaredFields();
            Field[] superField = domain.getClass().getSuperclass().getDeclaredFields();
            for (i = 0; i < fieldlist.length; ++i) {
                fld = fieldlist[i];
                fieldHashMap.put(fld.getName().toLowerCase(), fld.getType().toString());
            }
            for (i = 0; i < superField.length; ++i) {
                fld = superField[i];
                fieldHashMap.put(fld.getName().toLowerCase(), fld.getType().toString());
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return fieldHashMap;
    }

    public static String getPropertNameByDomain(Object domain, String PropertName) {
        HashMap fieldHashMap = new HashMap();
        PropertName = PropertName.toLowerCase();
        String realPropertName = null;
        try {
            Field fld;
            int i;
            Field[] fieldlist = domain.getClass().getDeclaredFields();
            Field[] superField = domain.getClass().getSuperclass().getDeclaredFields();
            for (i = 0; i < fieldlist.length; ++i) {
                fld = fieldlist[i];
                if (!fld.getName().toLowerCase().equals(PropertName)) continue;
                realPropertName = fld.getName();
                throw new RuntimeException("\u5c5e\u6027\u5df2\u627e\u5230");
            }
            for (i = 0; i < superField.length; ++i) {
                fld = superField[i];
                if (!fld.getName().toLowerCase().equals(PropertName)) continue;
                realPropertName = fld.getName();
                throw new RuntimeException("\u5c5e\u6027\u5df2\u627e\u5230");
            }
        }
        catch (Exception e) {
            System.out.println(e.getMessage());
        }
        return realPropertName;
    }
}

